/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.xtpdoc.Document;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;

public class ResinDocServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(ResinDocServlet.class.getName());
    private String _contextPath;
    private Config _config;
    private Path _pwd;
    private XMLOutputFactory _outputFactory;
    private String _encoding = "utf-8";
    private boolean _isDisableAction;
    private boolean _isCache = true;

    public void setDocumentEncoding(String encoding) {
        this._encoding = encoding;
    }

    public void setDocContextPath(String contextPath) {
        this._contextPath = contextPath;
    }

    public void setDisableAction(boolean isDisableAction) {
        this._isDisableAction = isDisableAction;
    }

    public boolean isDisableAction() {
        return this._isDisableAction;
    }

    public void setCache(boolean isCache) {
        this._isCache = isCache;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this._config = new Config();
        this._config.setEL(false);
        this._pwd = Vfs.lookup().createRoot();
        if (this._contextPath == null) {
            this._contextPath = config.getServletContext().getServletContextName();
        }
        try {
            this._outputFactory = XMLOutputFactory.newInstance();
        }
        catch (FactoryConfigurationError e) {
            throw new ServletException("Error configuring factory", (Throwable)e);
        }
        if (this._outputFactory == null) {
            throw new ServletException("Error configuring factory");
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletOutputStream os = response.getOutputStream();
        String servletPath = request.getServletPath();
        Path path = Vfs.lookup((String)request.getRealPath(servletPath));
        Document document = new Document(this.getServletContext(), path, this._contextPath, request.getContextPath() + servletPath, this._encoding);
        String ip = request.getLocalAddr();
        boolean cauchoHomeSite = false;
        cauchoHomeSite = "50.19.211.121".equals(ip) ? true : (request.getRequestURL().toString().contains("caucho.com") ? true : System.getProperty("test.pretend.to.be.caucho.site", "nope").equals("true"));
        document.setCauchoSite(cauchoHomeSite);
        document.setDisableAction(this.isDisableAction());
        try {
            response.setContentType("text/html");
            if (this._isCache) {
                response.setHeader("Cache-Control", "max-age=3600");
            }
            XMLStreamWriter xmlOut = this._outputFactory.createXMLStreamWriter((OutputStream)os, this._encoding);
            this._config.configure((Object)document, path);
            if (document.getRedirect() != null) {
                response.sendRedirect(document.getRedirect());
                return;
            }
            document.writeHtml(xmlOut);
            xmlOut.flush();
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            log.log(Level.FINER, e.toString(), e);
            response.sendError(404);
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
            log.warning(e.toString());
            response.sendError(404);
        }
        catch (Exception e) {
            throw new ServletException("Error configuring document", (Throwable)e);
        }
    }
}

