/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.xtpdoc.Document;
import com.caucho.xtpdoc.FormattedText;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class PreFormattedText
extends FormattedText {
    public PreFormattedText(Document document) {
        super(document);
    }

    public void writeHtml(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("pre");
        super.writeHtml(out);
        out.writeEndElement();
    }

    public void writeLaTeX(PrintWriter out) throws IOException {
        super.writeLaTeX(new PrintWriter(new PreFormatFilterWriter(out)));
    }

    public void writeLaTeXEnclosed(PrintWriter out) throws IOException {
        super.writeLaTeXEnclosed(new PrintWriter(new PreFormatFilterWriter(out)));
    }

    public void writeLaTeXTop(PrintWriter out) throws IOException {
        this.writeLaTeX(out);
    }

    private static class PreFormatFilterWriter
    extends FilterWriter {
        public PreFormatFilterWriter(Writer out) {
            super(out);
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            for (int i = off; i < len; ++i) {
                this.filterChar(cbuf[i]);
            }
        }

        public void write(int c) throws IOException {
            this.filterChar(c);
        }

        public void write(String str, int off, int len) throws IOException {
            for (int i = off; i < len; ++i) {
                this.filterChar(str.charAt(i));
            }
        }

        private void filterChar(int ch) throws IOException {
            switch (ch) {
                case 9: 
                case 32: {
                    super.write(92);
                    super.write(32);
                    break;
                }
                case 10: {
                    super.write("\\hspace*{\\fill} \\\\");
                    break;
                }
                default: {
                    super.write(ch);
                }
            }
        }
    }
}

