/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.vfs.Path;
import com.caucho.xtpdoc.Document;
import com.caucho.xtpdoc.NavigationItem;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Navigation {
    private static final Logger log = Logger.getLogger(Navigation.class.getName());
    private Document _document;
    private Navigation _parent;
    private int _depth;
    private Path _rootPath;
    private String _uri;
    private String _section;
    private boolean _threaded;
    private boolean _comment;
    private final ArrayList<NavigationItem> _items = new ArrayList();
    private NavigationItem _docItem;
    private NavigationItem _child;
    private final HashMap<String, NavigationItem> _itemMap = new HashMap();
    private final HashMap<String, NavigationItem> _refMap = new HashMap();

    public Navigation(Document document, String uri, Path path, int depth) {
        this._document = document;
        this._rootPath = path;
        this._uri = uri;
        this._depth = depth;
    }

    public Navigation(Navigation parent, String uri, Path path, int depth) {
        this._parent = parent;
        this._document = parent.getDocument();
        this._rootPath = path;
        this._uri = uri;
        this._depth = depth;
    }

    public Path getRootPath() {
        return this._rootPath;
    }

    public void setChild(NavigationItem child) {
        this._child = child;
    }

    public String getUri() {
        return this._uri;
    }

    public Document getDocument() {
        return this._document;
    }

    public Navigation getParent() {
        return this._parent;
    }

    public void setSection(String section) {
        this._section = section;
    }

    public String getSection() {
        return this._section;
    }

    public void setComment(boolean comment) {
        this._comment = comment;
    }

    public void setThreaded(boolean threaded) {
        this._threaded = threaded;
    }

    public NavigationItem getRoot() {
        if (this._items.size() > 0) {
            return this._items.get(0);
        }
        return null;
    }

    public NavigationItem createItem() {
        return new NavigationItem(this, null, this._depth);
    }

    public void addItem(NavigationItem item) {
        this._items.add(item);
    }

    public void putItem(String uri, NavigationItem item) {
        if (this._child != null && this._child.getUri().equals(uri)) {
            if (item.getParent() != null) {
                this._child.setParent(item.getParent());
            }
            this._itemMap.put(uri, this._child);
            if (this._child.getReference() != null) {
                this._refMap.put(this._child.getReferenceUri(), this._child);
            }
        } else {
            this._itemMap.put(uri, item);
            if (item.getReference() != null) {
                this._refMap.put(item.getReferenceUri(), item);
            }
        }
        if (this._parent != null) {
            this._parent.putItem(uri, item);
        }
    }

    public NavigationItem getItem(String uri) {
        NavigationItem item = this._itemMap.get(uri);
        if (item == null) {
            item = this._refMap.get(uri);
        }
        return item;
    }

    public NavigationItem getItemByReference(String uri) {
        return this._itemMap.get(uri);
    }

    public NavigationItem getRootItem() {
        if (this._items.size() > 0) {
            return this._items.get(0);
        }
        return null;
    }

    public void writeHtml(XMLStreamWriter out) throws XMLStreamException {
        this.writeHtml(out, "", 1, 0, 4);
    }

    public void writeHtml(XMLStreamWriter out, int styleDepth) throws XMLStreamException {
        this.writeHtml(out, "", 1, styleDepth, 4);
    }

    public void writeHtml(XMLStreamWriter out, String path, int depth, int styleDepth, int maxDepth) throws XMLStreamException {
        for (NavigationItem item : this._items) {
            item.writeHtml(out, path, depth, styleDepth, maxDepth);
        }
    }

    protected void initSummary() {
        for (NavigationItem item : this._items) {
            item.initSummary();
        }
    }

    public void writeLeftNav(XMLStreamWriter out) throws XMLStreamException {
        if (this._items.size() > 0) {
            NavigationItem topItem = this._items.get(0);
        }
        for (NavigationItem item : this._items) {
            item.writeLeftNav(out);
        }
    }

    public void writeLaTeX(PrintWriter writer) throws IOException {
    }
}

