/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.LooseHtml;
import com.caucho.xml.QElement;
import com.caucho.xml.QName;
import com.caucho.xml.XmlPrinter;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LooseToStrictHtml {
    private static void renameSections(Node node, int level) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            int thisLevel = level;
            Node child = nodeList.item(i);
            if (child.getNodeType() == 1) {
                Element subElement = (Element)child;
                if (subElement.getTagName().equals("section")) {
                    ((QElement)subElement).setName(new QName("s" + level));
                    thisLevel = level + 1;
                } else if (subElement.getTagName().equals("defun")) {
                    ((QElement)subElement).setName(new QName("s" + level));
                    subElement.setAttribute("type", "defun");
                    thisLevel = level + 1;
                } else if (subElement.getTagName().equals("faq")) {
                    ((QElement)subElement).setName(new QName("s" + level));
                    subElement.setAttribute("type", "faq");
                    thisLevel = level + 1;
                }
            }
            LooseToStrictHtml.renameSections(child, thisLevel);
        }
    }

    private static Element getXTPDocumentElement(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element subElement;
            Node child = nodeList.item(i);
            if (child.getNodeType() == 1 && (subElement = (Element)child).getTagName().equals("document")) {
                return subElement;
            }
            Element subdocument = LooseToStrictHtml.getXTPDocumentElement(child);
            if (subdocument == null) continue;
            return subdocument;
        }
        return null;
    }

    public static Element looseToStrictHtml(Path path) throws IOException, SAXException {
        if (!path.exists()) {
            throw new IOException(path + " does not exist");
        }
        Document document = new LooseHtml().parseDocument(path);
        LooseToStrictHtml.renameSections(document.getDocumentElement(), 1);
        return LooseToStrictHtml.getXTPDocumentElement(document.getDocumentElement());
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("usage: " + LooseToStrictHtml.class.getName() + " <xtp file>");
            System.exit(1);
        }
        Path path = Vfs.lookup((String)args[0]);
        Element xtpDocument = LooseToStrictHtml.looseToStrictHtml(path);
        WriteStream fileOut = path.openWrite();
        XmlPrinter printer = new XmlPrinter((OutputStream)fileOut);
        printer.printXml((Node)xtpDocument);
        fileOut.close();
    }
}

