/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.config.ConfigException;
import com.caucho.xtpdoc.ContentItem;
import com.caucho.xtpdoc.Document;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.imageio.ImageIO;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Figure
implements ContentItem {
    private int _height = -1;
    private int _width = -1;
    private String _source;
    private String _title;
    private Document _document;
    private String _alt;

    public Figure(Document document) {
        this._document = document;
    }

    public Document getDocument() {
        return this._document;
    }

    public void setHeight(int height) {
        this._height = height;
    }

    public void setWidth(int width) {
        this._width = width;
    }

    public void setSrc(String source) {
        this._source = source;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void setAlt(String alt) {
        this._alt = alt;
    }

    public void writeHtml(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("center");
        out.writeEmptyElement("img");
        out.writeAttribute("border", "0");
        if (this._height >= 0) {
            out.writeAttribute("height", Integer.toString(this._height));
        }
        if (this._title != null) {
            out.writeAttribute("title", this._title);
        }
        if (this._alt != null) {
            out.writeAttribute("alt", this._alt);
        }
        if (this._alt == null && this._title != null) {
            out.writeAttribute("alt", this._title);
        }
        if (this._alt != null && this._title == null) {
            out.writeAttribute("title", this._alt);
        }
        if (this._width >= 0) {
            out.writeAttribute("width", Integer.toString(this._width));
        }
        out.writeAttribute("src", this._document.getContextPath() + "/images/" + this._source);
        out.writeEndElement();
    }

    public void writeLaTeXVerbatim(PrintWriter out) throws IOException {
        throw new ConfigException("<figure> not allowed in a verbatim context");
    }

    public void writeLaTeX(PrintWriter out) throws IOException {
        int dot = this._source.lastIndexOf(46);
        String basename = this._source.substring(0, dot);
        int lastSlash = basename.lastIndexOf(47);
        if (lastSlash >= 0) {
            basename = basename.substring(lastSlash + 1);
        }
        out.println();
        out.println();
        out.println("\\noindent");
        out.println("\\epsfig{file=../images/" + basename + ",width=\\linewidth}");
        out.println();
        out.println();
    }

    public void writeLaTeXEnclosed(PrintWriter out) throws IOException {
        this.writeLaTeX(out);
    }

    public void writeLaTeXTop(PrintWriter out) throws IOException {
        this.writeLaTeX(out);
    }

    public void writeAsciiDoc(PrintWriter out) throws IOException {
        int dot = this._source.lastIndexOf(46);
        String baseName = this._source.substring(0, dot);
        out.println();
        out.println();
        String pdfName = baseName + ".pdf";
        boolean isPdf = false;
        if (new File("images/" + pdfName).exists()) {
            out.print("image:images/" + pdfName + "[alt=\"" + this._source + "\"");
            isPdf = true;
        } else {
            out.print("image:images/" + this._source + "[alt=\"" + this._source + "\"");
        }
        if (!isPdf) {
            out.print(",scaledwidth=\"100%\"");
            out.print(",height=\"100%\"");
        }
        out.print(",align=center");
        out.println("]");
    }

    public static int getWidth(String source) {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            File file = new File("images/" + source);
            BufferedImage image = ImageIO.read(file);
            return ((Image)image).getWidth(null);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static int getHeight(String source) {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            File file = new File("images/" + source);
            BufferedImage image = ImageIO.read(file);
            return ((Image)image).getHeight(null);
        }
        catch (Exception e) {
            return -1;
        }
    }
}

