/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.config.ConfigException;
import com.caucho.xtpdoc.Document;
import com.caucho.xtpdoc.LaTeXUtil;
import com.caucho.xtpdoc.VerboseFormattedTextWithAnchors;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Example
extends VerboseFormattedTextWithAnchors {
    private String _title;
    private String _file;
    private String _language;

    public Example(Document document) {
        super(document);
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void setLanguage(String language) {
        this._language = language;
    }

    public void setFile(String file) {
        this._file = file;
    }

    public String getCssClass() {
        return "example";
    }

    public void writeHtml(XMLStreamWriter out) throws XMLStreamException {
        out.writeCharacters("\n");
        out.writeStartElement("div");
        out.writeAttribute("class", this.getCssClass());
        if (this._title != null) {
            out.writeStartElement("div");
            out.writeAttribute("class", "caption");
            out.writeCharacters(this._title);
            out.writeEndElement();
        }
        out.writeStartElement("div");
        out.writeAttribute("class", "example-body");
        out.writeStartElement("pre");
        super.writeHtml(out);
        out.writeEndElement();
        out.writeEndElement();
        out.writeEndElement();
    }

    public void writeLaTeX(PrintWriter out) throws IOException {
        if (this._language != null) {
            out.println("\\lstset{fancyvrb,language=" + this._language + ",");
            out.println("         showstringspaces=false,basicstyle=\\small,");
            out.println("         stringstyle=\\color[gray]{0.6}}");
        }
        out.println("\\begin{center}");
        out.println("\\begin{Verbatim}[frame=single,fontfamily=courier,");
        out.println("                  framerule=1pt,");
        out.println("                  fontsize=\\footnotesize,");
        out.println("                  commandchars=\\\u0001\\\u0002\\\u0003,");
        if (this._title != null && !"".equals(this._title)) {
            out.print("                  labelposition=bottomline,label=\\fbox{");
            out.println(LaTeXUtil.escapeForLaTeX(this._title) + "},");
        }
        out.println("                  samepage=true]");
        super.writeLaTeXVerbatim(out);
        if (this._title != null) {
            out.println();
        }
        out.println();
        out.println("\\end{Verbatim}");
        out.println("\\end{center}");
        if (this._language != null) {
            out.println("\\lstset{fancyvrb=false}");
        }
    }

    public void writeLaTeXVerbatim(PrintWriter out) {
        throw new ConfigException("<example> should not be in a verbatim context");
    }

    public void writeAsciiDoc(PrintWriter out) throws IOException {
        out.println();
        out.println();
        if (this._title != null) {
            out.println("." + this._title);
        }
        if (this._language != null) {
            out.println("[source," + this._language + "]");
        }
        out.println("----");
        super.writeAsciiDoc(out);
        out.println();
        out.println("----");
    }
}

