/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.config.Config;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.xtpdoc.Body;
import com.caucho.xtpdoc.Header;
import com.caucho.xtpdoc.Navigation;
import com.caucho.xtpdoc.NavigationItem;
import com.caucho.xtpdoc.ReferenceDocument;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Document {
    private static Logger log = Logger.getLogger(Document.class.getName());
    private ServletContext _webApp;
    private Header _header;
    private Body _body;
    private Path _documentPath;
    private String _contextPath;
    private String _uri;
    private int _level;
    private Navigation _navigation;
    private NavigationItem _navItem;
    private String _encoding;
    private boolean _hasChildren;
    private boolean _isArticle;
    private boolean _isDisableAction;
    private boolean _isJavascriptEnabled = true;
    private boolean _isCauchoSite = true;
    private String _redirect;
    private ReferenceDocument _referenceDocument;

    Document() {
        this(null, null, null, null, "utf-8");
    }

    public Document(Path documentPath, String contextPath) {
        this(null, documentPath, contextPath, null, "utf-8");
    }

    public Document(ServletContext webApp, Path documentPath, String contextPath, String uri, String encoding) {
        this._webApp = webApp;
        this._documentPath = documentPath;
        this._contextPath = contextPath;
        this._uri = uri;
        this._encoding = encoding;
    }

    public void setCauchoSite(boolean cauchoSite) {
        this._isCauchoSite = cauchoSite;
    }

    public boolean isArticle() {
        return this._isArticle;
    }

    public void setArticle(boolean isArticle) {
        this._isArticle = isArticle;
    }

    public void setDisableAction(boolean isDisable) {
        this._isDisableAction = isDisable;
    }

    public boolean isDisableAction() {
        return this._isDisableAction;
    }

    public boolean isJavascriptEnabled() {
        return this._isJavascriptEnabled;
    }

    public void setJavascriptEnabled(boolean isJavascriptEnabled) {
        this._isJavascriptEnabled = isJavascriptEnabled;
    }

    public Path getRealPath(String uri) {
        if (this._webApp != null) {
            String contextPath = this._webApp.getContextPath();
            if (uri.startsWith(contextPath)) {
                uri = uri.substring(contextPath.length());
            }
            return Vfs.lookup((String)this._webApp.getRealPath(uri));
        }
        return Vfs.lookup((String)("./" + uri));
    }

    NavigationItem getNavigation() {
        if (this._navItem != null) {
            return this._navItem;
        }
        ArrayList<Navigation> navList = new ArrayList<Navigation>();
        String uri = this._uri;
        int p = uri.lastIndexOf(47);
        if (p > 0) {
            uri = uri.substring(0, p + 1);
        }
        ServletContext rootWebApp = this._webApp.getContext("/");
        NavigationItem child = null;
        while (!uri.equals("") && rootWebApp != null) {
            String realPath = rootWebApp.getRealPath(uri);
            Path path = Vfs.lookup((String)realPath);
            Path toc = path.lookup("toc.xml");
            if (toc.canRead()) {
                Config config = new Config();
                config.setEL(false);
                Navigation navigation = new Navigation(this, uri, path, 0);
                navigation.setChild(child);
                try {
                    config.configure((Object)navigation, toc);
                    navList.add(navigation);
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                    navigation = null;
                }
                child = navigation != null ? navigation.getRootItem() : null;
            }
            if ((p = uri.lastIndexOf(47, uri.length() - 2)) < 0) break;
            uri = uri.substring(0, p + 1);
        }
        if (navList.size() > 0) {
            Navigation nav = (Navigation)navList.get(0);
            this._navItem = nav.getItem(this._uri);
        }
        return this._navItem;
    }

    void fillChildNavigation() {
        this.getNavigation();
        if (!this._hasChildren) {
            this._hasChildren = true;
            this.fillChildNavigation(this._navItem);
        }
    }

    void fillChildNavigation(NavigationItem navItem) {
        if (navItem == null) {
            return;
        }
        for (NavigationItem child : navItem.getChildren()) {
            this.fillChildNavigation(child);
        }
        try {
            String uri;
            ServletContext rootWebApp;
            String realPath;
            Path path;
            Path pwd;
            Path toc;
            String link = navItem.getLink();
            if (link.indexOf(47) > 0 && (toc = (pwd = (path = Vfs.lookup((String)(realPath = (rootWebApp = this._webApp.getContext("/")).getRealPath(uri = navItem.getUri())))).getParent()).lookup("toc.xml")).canRead()) {
                Config config = new Config();
                config.setEL(false);
                int p = uri.lastIndexOf(47);
                if (p > 0) {
                    uri = uri.substring(0, p + 1);
                }
                Navigation navigation = new Navigation(this, uri, pwd, 0);
                navigation.setChild(navItem);
                config.configure((Object)navigation, toc);
                if (navigation.getRootItem() != null) {
                    navItem.addChildren(navigation.getRootItem().getChildren());
                }
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    ReferenceDocument getReferenceDocument() {
        if (this._referenceDocument != null) {
            return this._referenceDocument;
        }
        String uri = this._uri;
        ServletContext rootWebApp = this._webApp.getContext("/");
        if (rootWebApp != null) {
            int p;
            while (!uri.equals("") && (p = uri.lastIndexOf(47)) > 0) {
                String realPath = rootWebApp.getRealPath((uri = uri.substring(0, p)) + '/');
                Path path = Vfs.lookup((String)realPath);
                Path ref = path.lookup("reference.xtp");
                if (!ref.canRead()) continue;
                Config config = new Config();
                config.setEL(false);
                try {
                    this._referenceDocument = new ReferenceDocument(this._webApp, ref, this._contextPath, uri + "/reference.xtp", this._encoding);
                    config.configure((Object)this._referenceDocument, ref);
                    break;
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                    this._referenceDocument = null;
                }
            }
        }
        return this._referenceDocument;
    }

    public Path getDocumentPath() {
        return this._documentPath;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getURI() {
        return this._uri;
    }

    public Header getHeader() {
        return this._header;
    }

    public String getName() {
        return "";
    }

    public Header createHeader() {
        this._header = new Header(this);
        return this._header;
    }

    public Body createBody() {
        return new Body(this);
    }

    public void setBody(Body body) {
        this._body = body;
    }

    public Body getBody() {
        return this._body;
    }

    public void setRedirect(String href) {
        this._redirect = href;
    }

    public String getRedirect() {
        return this._redirect;
    }

    public void writeHtml(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartDocument(this._encoding, "1.0");
        out.writeDTD("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        out.writeStartElement("html");
        out.writeDefaultNamespace("http://www.w3.org/1999/xhtml");
        out.writeAttribute("lang", "en");
        if (this._header != null) {
            this._header.setCauchoSite(this._isCauchoSite);
            this._header.writeHtml(out);
        }
        if (this._body != null) {
            this._body.setCauchoSite(this._isCauchoSite);
            this._body.writeHtml(out);
        }
        out.writeEndElement();
    }

    public void writeLeftNav(XMLStreamWriter out) throws XMLStreamException {
        NavigationItem item = this.getNavigation();
        if (item != null) {
            item.writeLeftNav(out);
        }
    }

    public void writeLaTeXTop(PrintWriter out) throws IOException {
        out.println("\\documentclass{article}");
        this._header.writeLaTeXTop(out);
        this._body.writeLaTeXTop(out);
    }

    public void writeLaTeX(PrintWriter out) throws IOException {
        this._header.writeLaTeX(out);
        this._body.writeLaTeX(out);
    }

    public void writeLaTeXEnclosed(PrintWriter out) throws IOException {
        this._header.writeLaTeXEnclosed(out);
        this._body.writeLaTeXEnclosed(out);
    }

    public void writeLaTeXArticle(PrintWriter out) throws IOException {
        this.setArticle(true);
        this._header.writeLaTeXArticle(out);
        this._body.writeLaTeX(out);
    }

    public void writeAsciiDoc(PrintWriter out) throws IOException {
        this._header.writeAsciiDoc(out);
        this._body.writeAsciiDoc(out);
    }

    public String toString() {
        return "Document[" + this._documentPath + "]";
    }
}

