/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.config.types.RawString;
import com.caucho.xtpdoc.Anchor;
import com.caucho.xtpdoc.Document;
import com.caucho.xtpdoc.FormattedText;
import com.caucho.xtpdoc.Text;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefunParents
extends FormattedText
implements Iterable<String> {
    private static final Text COMMA = new Text(",");
    private final HashSet<String> _parents = new HashSet();

    public DefunParents(Document document) {
        super(document);
    }

    @Override
    public void addText(RawString text) {
        String[] parents = text.getValue().split("[ ,]+");
        for (int i = 0; i < parents.length; ++i) {
            String parent = parents[i];
            this._parents.add(parent);
            Anchor anchor = new Anchor(this.getDocument());
            anchor.setConfigTag(parent);
            this.addItem(anchor);
            if (i >= parents.length - 1) continue;
            this.addItem(COMMA);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this._parents.iterator();
    }

    @Override
    public void writeHtml(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("div");
        out.writeAttribute("class", "reference-parents");
        out.writeStartElement("span");
        out.writeAttribute("class", "child-of");
        out.writeCharacters("child of ");
        out.writeEndElement();
        super.writeHtml(out);
        out.writeEndElement();
    }

    @Override
    public void writeLaTeXTop(PrintWriter out) throws IOException {
    }

    @Override
    public void writeLaTeX(PrintWriter out) throws IOException {
        out.print("{\\bf child of }");
        super.writeLaTeX(out);
        out.print("\\\\");
    }

    @Override
    public void writeLaTeXEnclosed(PrintWriter out) throws IOException {
        this.writeLaTeX(out);
    }

    @Override
    public void writeAsciiDoc(PrintWriter out) throws IOException {
    }
}

