/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.xtpdoc.ContainerNode;
import com.caucho.xtpdoc.Defun;
import com.caucho.xtpdoc.Document;
import com.caucho.xtpdoc.Faq;
import com.caucho.xtpdoc.Header;
import com.caucho.xtpdoc.IncludeDefun;
import com.caucho.xtpdoc.Index;
import com.caucho.xtpdoc.Localtoc;
import com.caucho.xtpdoc.Navigation;
import com.caucho.xtpdoc.NavigationItem;
import com.caucho.xtpdoc.ReferenceLegend;
import com.caucho.xtpdoc.S1;
import com.caucho.xtpdoc.Summary;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Body
extends ContainerNode {
    private static Logger log = Logger.getLogger(Body.class.getName());
    private Summary _summary;
    private Navigation _navigation;
    private Index _index;
    private String _class;
    private String _title = "Resin Documentation";
    private boolean _isCauchoSite = true;

    public Body(Document document) {
        super(document);
    }

    private void parseNavigation() {
        NavigationItem item = this.getDocument().getNavigation();
        if (item != null) {
            this._navigation = item.getNavigation();
        }
    }

    public void setCauchoSite(boolean cauchoSite) {
        this._isCauchoSite = cauchoSite;
    }

    public void setClass(String styleClass) {
        this._class = styleClass;
    }

    public Summary createSummary() {
        this._summary = new Summary(this.getDocument());
        this.addItem(this._summary);
        return this._summary;
    }

    public Localtoc createLocaltoc() {
        Localtoc toc = new Localtoc(this.getDocument());
        this.addItem(toc);
        return toc;
    }

    public ReferenceLegend createReferenceLegend() {
        ReferenceLegend legend = new ReferenceLegend();
        this.addItem(legend);
        return legend;
    }

    public Faq createFaq() {
        Faq faq = new Faq(this.getDocument());
        this.addItem(faq);
        return faq;
    }

    public S1 createS1() {
        S1 s1 = new S1(this.getDocument());
        this.addItem(s1);
        return s1;
    }

    public Defun createDefun() {
        Defun defun = new Defun(this.getDocument());
        this.addItem(defun);
        return defun;
    }

    public IncludeDefun createIncludeDefun() {
        IncludeDefun includeDefun = new IncludeDefun(this.getDocument());
        this.addItem(includeDefun);
        return includeDefun;
    }

    public Index createIxx() {
        this._index = new Index(this.getDocument());
        return this._index;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void writeHtml(XMLStreamWriter out) throws XMLStreamException {
        Header header;
        out.writeStartElement("body");
        if (this._class != null) {
            out.writeAttribute("class", this._class);
        }
        NavigationItem item = this.writeHeaderTable(out);
        out.writeStartElement("table");
        out.writeAttribute("width", "98%");
        out.writeAttribute("border", "0");
        out.writeAttribute("cellspacing", "0");
        out.writeAttribute("cellpadding", "0");
        out.writeAttribute("summary", "");
        out.writeStartElement("tr");
        out.writeAttribute("valign", "top");
        out.writeStartElement("td");
        out.writeAttribute("class", "leftnav");
        this.parseNavigation();
        this.getDocument().writeLeftNav(out);
        out.writeEndElement();
        out.writeStartElement("td");
        out.writeAttribute("width", "5%");
        out.writeEntityRef("nbsp");
        out.writeEndElement();
        out.writeStartElement("td");
        out.writeAttribute("width", "85%");
        out.writeStartElement("h1");
        out.writeAttribute("class", "title");
        if (this.getDocument().getHeader() != null) {
            out.writeCharacters(this.getDocument().getHeader().getTitle().toLowerCase(Locale.ENGLISH));
        }
        out.writeEndElement();
        out.writeStartElement("hr");
        out.writeEndElement();
        if (item != null) {
            this.writeThreadNavigation(out, item, false);
        }
        if ((header = this.getDocument().getHeader()) != null && header.getDescription() != null) {
            header.getDescription().writeHtml(out);
        }
        if (header != null && header.getTutorialStartPage() != null && !this.getDocument().isDisableAction()) {
            out.writeStartElement("p");
            out.writeStartElement("a");
            out.writeAttribute("href", header.getTutorialStartPage());
            out.writeCharacters("Demo");
            out.writeEndElement();
            out.writeEndElement();
        }
        if (this._index != null) {
            this._index.writeHtml(out);
        }
        this.writeContent(out);
        if (header != null && header.getTutorialStartPage() != null && !this.getDocument().isDisableAction()) {
            out.writeStartElement("p");
            out.writeStartElement("a");
            out.writeAttribute("href", header.getTutorialStartPage());
            out.writeCharacters("Demo");
            out.writeEndElement();
            out.writeEndElement();
        }
        out.writeStartElement("hr");
        out.writeEndElement();
        if (item != null) {
            this.writeThreadNavigation(out, item, true);
        }
        out.writeStartElement("table");
        out.writeAttribute("border", "0");
        out.writeAttribute("cellspacing", "0");
        out.writeAttribute("width", "100%");
        out.writeStartElement("tr");
        out.writeStartElement("td");
        out.writeStartElement("em");
        out.writeStartElement("small");
        out.writeCharacters("Copyright ");
        out.writeEntityRef("copy");
        out.writeCharacters(" 1998-2012 Caucho Technology, Inc. All rights reserved.");
        out.writeEntityRef("nbsp");
        out.writeCharacters("Resin ");
        out.writeStartElement("sup");
        out.writeStartElement("font");
        out.writeAttribute("size", "-1");
        out.writeEntityRef("#174");
        out.writeEndElement();
        out.writeEndElement();
        out.writeCharacters(" is a registered trademark. Quercus");
        out.writeStartElement("sup");
        out.writeCharacters("tm");
        out.writeEndElement();
        out.writeCharacters(", and Hessian");
        out.writeStartElement("sup");
        out.writeCharacters("tm");
        out.writeEndElement();
        out.writeCharacters(" are trademarks of Caucho Technology.");
        if (this._isCauchoSite) {
            out.writeEmptyElement("br");
            out.writeEmptyElement("br");
            out.writeCharacters("Cloud-optimized Resin Server is a Java EE certified Java Application Server, and Web Server, and Distributed Cache Server (Memcached).");
            out.writeEmptyElement("br");
            out.writeCharacters("Leading companies worldwide with demand for reliability and high performance web applications including SalesForce.com, CNET, DZone and many more are powered by Resin.");
            out.writeEmptyElement("br");
            out.writeEmptyElement("br");
        }
        out.writeEndElement();
        out.writeEndElement();
        out.writeEndElement();
        out.writeEndElement();
        if (this._isCauchoSite) {
            out.writeStartElement("tr");
            out.writeStartElement("td");
            out.writeStartElement("center");
            out.writeStartElement("small");
            this.writeTopLinks(out);
            out.writeEndElement();
            out.writeEndElement();
            out.writeEndElement();
            out.writeEndElement();
        }
        out.writeEndElement();
        out.writeEndElement();
        out.writeEndElement();
        out.writeEndElement();
        out.writeEmptyElement("div");
        out.writeAttribute("id", "popup");
        out.writeEndElement();
    }

    private NavigationItem writeHeaderTable(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("table");
        out.writeAttribute("width", "98%");
        out.writeAttribute("border", "0");
        out.writeAttribute("cellspacing", "0");
        out.writeAttribute("cellpadding", "0");
        out.writeAttribute("summary", "");
        out.writeStartElement("tr");
        out.writeStartElement("td");
        out.writeStartElement("a");
        out.writeAttribute("href", "http://www.caucho.com/");
        out.writeAttribute("title", "Caucho maker of Resin Server | Application Server (Java EE Certified) and Web Server");
        out.writeStartElement("img");
        out.writeAttribute("src", this.getDocument().getContextPath() + "/images/caucho-logo.png");
        out.writeAttribute("alt", "Caucho maker of Resin Server | Application Server (Java EE Certified) and Web Server");
        out.writeAttribute("width", "300");
        out.writeAttribute("height", "50");
        out.writeEndElement();
        out.writeEndElement();
        out.writeEmptyElement("br");
        out.writeEmptyElement("br");
        out.writeEmptyElement("br");
        out.writeStartElement("div");
        out.writeAttribute("class", "breadcrumb");
        NavigationItem item = this.getDocument().getNavigation();
        this.writeBreadcrumb(out, item);
        out.writeEndElement();
        out.writeEndElement();
        out.writeStartElement("td");
        out.writeAttribute("width", "5%");
        out.writeEntityRef("nbsp");
        out.writeEndElement();
        out.writeStartElement("td");
        out.writeAttribute("width", "70%");
        out.writeStartElement("h1");
        out.writeCharacters(this._title);
        out.writeStartElement("td");
        out.writeAttribute("width", "20%");
        this.writeTopLinks(out);
        out.writeEndElement();
        out.writeStartElement("td");
        out.writeAttribute("width", "5%");
        out.writeEntityRef("nbsp");
        out.writeEndElement();
        out.writeStartElement("td");
        out.writeAttribute("width", "10%");
        out.writeAttribute("valign", "bottom");
        out.writeStartElement("a");
        out.writeAttribute("href", "http://www.caucho.com/");
        out.writeAttribute("title", "Resin Server | Application Server (Java EE Certified) and Web Server");
        out.writeStartElement("img");
        out.writeAttribute("src", this.getDocument().getContextPath() + "/images/resin_logo_small.jpg");
        out.writeAttribute("alt", "Resin Server | Application Server (Java EE Certified) and Web Server");
        out.writeEndElement();
        out.writeEndElement();
        out.writeEndElement();
        out.writeEndElement();
        out.writeEndElement();
        return item;
    }

    private void writeTopLinks(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("a");
        out.writeAttribute("href", "http://www.caucho.com/");
        out.writeAttribute("title", "Caucho home, makers of Resin Server, Java Application Server, Web Server and Querus PHP engine.");
        out.writeCharacters("home");
        out.writeEndElement();
        out.writeEntityRef("nbsp");
        out.writeStartElement("a");
        out.writeAttribute("href", "http://www.caucho.com/about/");
        out.writeCharacters("company");
        out.writeEndElement();
        out.writeEntityRef("nbsp");
        out.writeStartElement("a");
        out.writeAttribute("href", "http://blog.caucho.com/");
        out.writeAttribute("title", "Blog to discuss Resin Server, a Java EE certified Java Application Server, Web Server and Querus PHP engine");
        out.writeCharacters("blog");
        out.writeEndElement();
        out.writeEntityRef("nbsp");
        out.writeStartElement("a");
        out.writeAttribute("href", "http://wiki4.caucho.com/");
        out.writeAttribute("title", "Wiki to cookbooks, tutorials for Resin Server (Application Server and Web Server)");
        out.writeCharacters("wiki");
        out.writeEndElement();
        out.writeEntityRef("nbsp");
        out.writeStartElement("a");
        out.writeAttribute("href", "http://www.caucho.com/resin-4.0/");
        out.writeCharacters("docs");
        out.writeEndElement();
        out.writeEntityRef("nbsp");
        out.writeEmptyElement("br");
        out.writeStartElement("a");
        out.writeAttribute("href", "http://www.caucho.com/");
        out.writeAttribute("title", "Resin | Java Application Server | Java EE Certified | Cloud Optimized ");
        out.writeCharacters("app server");
        out.writeEndElement();
        out.writeEntityRef("nbsp");
    }

    protected void writeContent(XMLStreamWriter out) throws XMLStreamException {
        super.writeHtml(out);
    }

    public void writeBreadcrumb(XMLStreamWriter out, NavigationItem item) throws XMLStreamException {
        out.writeCharacters("\n");
        out.writeStartElement("a");
        out.writeAttribute("href", "/");
        out.writeCharacters("home");
        out.writeEndElement();
        this.writeBreadcrumbRec(out, item);
    }

    public void writeBreadcrumbRec(XMLStreamWriter out, NavigationItem item) throws XMLStreamException {
        if (item == null || item.getParent() == null) {
            return;
        }
        this.writeBreadcrumbRec(out, item.getParent());
        out.writeCharacters(" / ");
        out.writeStartElement("a");
        out.writeAttribute("href", item.getLink());
        out.writeCharacters(item.getTitle().toLowerCase(Locale.ENGLISH));
        out.writeEndElement();
    }

    public void writeThreadNavigation(XMLStreamWriter out, NavigationItem item, boolean writeCenter) throws XMLStreamException {
        out.writeCharacters("\n");
        out.writeStartElement("table");
        out.writeAttribute("class", "breadcrumb");
        out.writeAttribute("border", "0");
        out.writeAttribute("cellspacing", "0");
        out.writeAttribute("width", "99%");
        out.writeStartElement("tr");
        out.writeStartElement("td");
        out.writeAttribute("width", "30%");
        out.writeAttribute("align", "left");
        if (item.getPrevious() != null) {
            item.getPrevious().writeLink(out);
        }
        out.writeEndElement();
        out.writeStartElement("td");
        out.writeAttribute("width", "40%");
        out.writeStartElement("center");
        if (item.getParent() != null && writeCenter) {
            item.getParent().writeLink(out);
        }
        out.writeEndElement();
        out.writeEndElement();
        out.writeStartElement("td");
        out.writeAttribute("width", "30%");
        out.writeAttribute("align", "right");
        if (item.getNext() != null) {
            item.getNext().writeLink(out);
        }
        out.writeEndElement();
        out.writeEndElement();
        out.writeEndElement();
    }

    public void writeLaTeXTop(PrintWriter out) throws IOException {
        out.println("\\begin{document}");
        super.writeLaTeXTop(out);
        out.println("\\end{document}");
    }
}

