/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.xtpdoc.Document;
import com.caucho.xtpdoc.FormattedTextWithAnchors;
import com.caucho.xtpdoc.Paragraph;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class BlockQuote
extends FormattedTextWithAnchors {
    private String _title;
    private boolean longQuote = false;

    public BlockQuote(Document document) {
        super(document);
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public Paragraph createP() {
        this.longQuote = true;
        Paragraph paragraph = new Paragraph(this.getDocument());
        this.addItem(paragraph);
        return paragraph;
    }

    public void writeHtml(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("blockquote");
        if (this._title != null) {
            out.writeCharacters(this._title + ": ");
        }
        super.writeHtml(out);
        out.writeEndElement();
    }

    public void writeLaTeX(PrintWriter out) throws IOException {
        if (this.longQuote) {
            out.println("\\begin{quotation}");
        } else {
            out.println("\\begin{quote}");
        }
        if (this._title != null) {
            out.print(this._title + ": ");
        }
        super.writeLaTeX(out);
        if (this.longQuote) {
            out.println("\\end{quotation}");
        } else {
            out.println("\\end{quote}");
        }
    }
}

