/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.config.ConfigException;
import com.caucho.config.types.RawString;
import com.caucho.xtpdoc.Document;
import com.caucho.xtpdoc.FormattedText;
import com.caucho.xtpdoc.ReferenceDocument;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Anchor
extends FormattedText {
    private static final Logger log = Logger.getLogger(Anchor.class.getName());
    private String _configTag;
    private String _javadoc;
    private String _href;

    public Anchor(Document document) {
        super(document);
    }

    public void setJavadoc(String javadoc) {
        if (this._configTag != null || this._href != null) {
            throw new ConfigException("Anchors must have exactly one of href, config-tag, or javadoc attributes");
        }
        this._javadoc = javadoc;
    }

    public void setConfigTag(String configTag) {
        if (this._javadoc != null || this._href != null) {
            throw new ConfigException("Anchors must have exactly one of href, config-tag, or javadoc attributes");
        }
        this._configTag = configTag;
    }

    public void setHref(String href) {
        if (this._configTag != null || this._javadoc != null) {
            throw new ConfigException("Anchors must have exactly one of href, config-tag, or javadoc attributes");
        }
        this._href = href;
    }

    private void setDefaultText(String text) {
        if (this.getItems().isEmpty()) {
            this.addText(new RawString(text));
        }
    }

    @PostConstruct
    public void init() {
        if (this._javadoc == null && this._configTag == null && this._href == null) {
            throw new ConfigException("Anchors must have exactly one of href, config-tag, or javadoc attributes");
        }
    }

    private void writeConfigTagHtml(XMLStreamWriter out) throws XMLStreamException {
        boolean isLinked;
        ReferenceDocument referenceDocument = this.getDocument().getReferenceDocument();
        boolean bl = isLinked = referenceDocument != null && referenceDocument.getURI() != null;
        if (isLinked) {
            out.writeStartElement("a");
            out.writeAttribute("href", referenceDocument.getURI() + '#' + this._configTag);
            if (this.getDocument().isJavascriptEnabled()) {
                out.writeAttribute("onmouseover", "popup.mouseOverHandler(this, '" + this._configTag + "')");
                out.writeAttribute("onmouseout", "popup.mouseOutHandler()");
            }
        }
        this.setDefaultText(this._configTag);
        super.writeHtml(out);
        if (isLinked) {
            out.writeEndElement();
        }
    }

    private void writeJavadocHtml(XMLStreamWriter out) throws XMLStreamException {
        String path = "http://www.caucho.com/resin-javadoc/" + this._javadoc.replace('.', '/');
        int i = path.indexOf(35);
        path = i >= 0 ? path.substring(0, i) + ".html" + path.substring(i + 1) : path + ".html";
        this.setDefaultText(this._javadoc);
        out.writeAttribute("href", path);
    }

    public void writeHtml(XMLStreamWriter out) throws XMLStreamException {
        if (this._configTag != null) {
            this.writeConfigTagHtml(out);
        } else {
            out.writeStartElement("a");
            if (this._javadoc != null) {
                this.writeJavadocHtml(out);
            } else if (this._href.indexOf(124) >= 0) {
                String href = this.getDocument().getContextPath() + '/' + this._href.replace('|', '/');
                out.writeAttribute("href", href);
            } else {
                out.writeAttribute("href", this._href);
            }
            super.writeHtml(out);
            out.writeEndElement();
        }
    }

    public void writeLaTeX(PrintWriter out) throws IOException {
        if (this._configTag != null) {
            this.setDefaultText(this._configTag);
            super.writeLaTeX(out);
        } else if (this._javadoc != null) {
            this.setDefaultText(this._javadoc);
            super.writeLaTeX(out);
        } else if (this._href == null) {
            super.writeLaTeX(out);
        } else if (this._href.startsWith("doc|")) {
            String link = this._href.substring("doc|".length()).replace("|", "/");
            link = link.replace("#", ":");
            out.print("\\hyperlink{" + link + "}{");
            super.writeLaTeX(out);
            out.print("}");
        } else {
            try {
                String documentName;
                URI uri = new URI(this._href);
                if (uri.getScheme() != null) {
                    out.print("\\href{" + this._href + "}");
                    out.print("{");
                    super.writeLaTeX(out);
                    out.print("}");
                    return;
                }
                if (uri.getPath() != null && uri.getPath().length() != 0) {
                    out.print("\\hyperlink{" + uri.getPath());
                    if (uri.getFragment() != null) {
                        out.print(":" + uri.getFragment());
                    }
                    out.print("}{");
                    super.writeLaTeX(out);
                    out.print("}");
                    return;
                }
                if (uri.getFragment() != null && uri.getFragment().length() != 0 && (documentName = this.getDocument().getDocumentPath().getTail()) != null) {
                    out.print("\\hyperlink{" + documentName + ":" + uri.getFragment());
                    out.print("}{");
                    super.writeLaTeX(out);
                    out.print("}");
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            out.print("\\href{" + this._href + "}");
            out.print("{");
            super.writeLaTeX(out);
            out.print("}");
        }
    }

    public void writeAsciiDoc(PrintWriter out) throws IOException {
        if (this._configTag != null) {
            this.setDefaultText(this._configTag);
            super.writeAsciiDoc(out);
        } else if (this._javadoc != null) {
            this.setDefaultText(this._javadoc);
            super.writeAsciiDoc(out);
        } else if (this._href == null) {
            super.writeAsciiDoc(out);
        } else {
            out.print(this._href);
            out.print(" ");
        }
    }
}

