/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.web;

import com.caucho.util.Tree;
import java.util.ArrayList;
import java.util.Iterator;

public class NavItem {
    Tree tree;
    String title;
    String link;
    String description;
    String brief;
    String _product;

    NavItem() {
    }

    void setTree(Tree tree) {
        this.tree = tree;
    }

    Tree getTree() {
        return this.tree;
    }

    public NavItem getParent() {
        if (this.tree == null) {
            return null;
        }
        Tree parent = this.tree.getParent();
        return parent == null ? null : (NavItem)parent.getData();
    }

    public Iterator children() {
        return this.tree.iterator();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getProduct() {
        return this._product;
    }

    public void setProduct(String product) {
        this._product = product;
    }

    public String getBrief() {
        return this.brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public NavItem getPrevious() {
        Tree prevTree = this.tree.getPrevious();
        if (prevTree == null) {
            return null;
        }
        return (NavItem)prevTree.getData();
    }

    public NavItem getPreviousPreorder() {
        Tree prevTree = this.tree.getPreviousPreorder();
        if (prevTree == null) {
            return null;
        }
        return (NavItem)prevTree.getData();
    }

    public NavItem getNext() {
        Tree nextTree = this.tree.getNext();
        if (nextTree == null) {
            return null;
        }
        return (NavItem)nextTree.getData();
    }

    public NavItem getNextPreorder() {
        Tree nextTree = this.tree.getNextPreorder();
        if (nextTree == null) {
            return null;
        }
        return (NavItem)nextTree.getData();
    }

    public ArrayList familyNavigation() {
        ArrayList list = new ArrayList();
        this.familyNavigation(this.tree, list);
        return list;
    }

    private boolean familyNavigation(Tree tree, ArrayList results) {
        if (tree == null) {
            return false;
        }
        boolean hasParent = false;
        if (tree.getParent() != null) {
            hasParent = this.familyNavigation(tree.getParent(), results);
        }
        Iterator iter = tree.iterator();
        boolean hasChild = false;
        while (iter.hasNext()) {
            NavItem child = (NavItem)iter.next();
            if (!hasChild && hasParent) {
                results.add(null);
            }
            hasChild = true;
            results.add(child);
        }
        return hasChild || hasParent;
    }

    public String toString() {
        return "[NavItem title='" + this.title + "' link='" + this.link + "']";
    }
}

