/*
 * Decompiled with CFR 0.152.
 */
package com.maxbill.tool;

import com.alibaba.fastjson.JSON;
import com.maxbill.base.bean.ClientInfo;
import com.maxbill.base.bean.ConfigBean;
import com.maxbill.base.bean.Connect;
import com.maxbill.base.bean.KeyBean;
import com.maxbill.base.bean.RedisInfo;
import com.maxbill.base.bean.ZTreeBean;
import com.maxbill.tool.JsonUtil;
import com.maxbill.tool.KeyUtil;
import com.maxbill.tool.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Tuple;
import redis.clients.util.Slowlog;

public class RedisUtil {
    static Logger log = LoggerFactory.getLogger((String)"RedisUtil");
    private static final int MAX_TOTAL = 50;
    private static final int MAX_IDLE = 10;
    private static final int MAX_WAIT = 3000;
    private static final int TIME_OUT = 3000;
    private static final boolean TEST_ON_BORROW = true;
    private static final boolean TEST_ON_RETURN = true;
    private static JedisPool jedisPool;
    private static ReentrantLock lock;

    private RedisUtil() {
    }

    private static void initJedisPool(Connect connect) {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(50);
        config.setMaxIdle(10);
        config.setMaxWaitMillis(3000L);
        config.setTestOnBorrow(true);
        config.setTestOnReturn(true);
        int port = Integer.valueOf(connect.getRport());
        if ("1".equals(connect.getType())) {
            port = 55555;
        }
        jedisPool = StringUtils.isEmpty((Object)connect.getRpass()) ? new JedisPool((GenericObjectPoolConfig)config, connect.getRhost(), port, 3000) : new JedisPool((GenericObjectPoolConfig)config, connect.getRhost(), port, 3000, connect.getRpass());
    }

    private static void freeJedisPool() {
        if (null != jedisPool && !jedisPool.isClosed()) {
            jedisPool.destroy();
        }
    }

    public static Jedis openJedis(Connect connect) throws Exception {
        log.info("\u6b63\u5728\u5efa\u7acb\u65b0\u8fde\u63a5...");
        RedisUtil.freeJedisPool();
        lock.lock();
        RedisUtil.initJedisPool(connect);
        lock.unlock();
        return jedisPool.getResource();
    }

    public static Jedis getJedis() {
        if (null != jedisPool) {
            return jedisPool.getResource();
        }
        return null;
    }

    public static void closeJedis(Jedis jedis) {
        if (null != jedis) {
            jedis.close();
        }
    }

    public static boolean existsKey(Jedis jedis, int index, String key) {
        jedis.select(index);
        return jedis.exists(key);
    }

    public static String renameKey(Jedis jedis, int index, String oldKey, String newKey) {
        jedis.select(index);
        return jedis.rename(oldKey, newKey);
    }

    public static long retimeKey(Jedis jedis, int index, String key, int time) {
        jedis.select(index);
        return jedis.expire(key, time);
    }

    public static long deleteKey(Jedis jedis, int index, String key) {
        jedis.select(index);
        return jedis.del(key);
    }

    public static String updateStr(Jedis jedis, int index, String key, String val) {
        jedis.select(index);
        return jedis.set(key, val);
    }

    public static String insertStr(Jedis jedis, int index, String key, String val) {
        jedis.select(index);
        return jedis.set(key, val);
    }

    public static long insertSet(Jedis jedis, int index, String key, String val) {
        jedis.select(index);
        return jedis.sadd(key, new String[]{val});
    }

    public static long insertZset(Jedis jedis, int index, String key, String val, double score) {
        jedis.select(index);
        return jedis.zadd(key, score, val);
    }

    public static long insertList(Jedis jedis, int index, String key, String val) {
        jedis.select(index);
        return jedis.rpush(key, new String[]{val});
    }

    public static String updateList(Jedis jedis, int index, String key, int itemIndex, String val) {
        jedis.select(index);
        return jedis.lset(key, (long)itemIndex, val);
    }

    public static long insertHash(Jedis jedis, int index, String key, String mapKey, String mapVal) {
        jedis.select(index);
        return jedis.hset(key, mapKey, mapVal);
    }

    public static long deleteSet(Jedis jedis, int index, String key, String val) {
        jedis.select(index);
        return jedis.srem(key, new String[]{val});
    }

    public static long deleteZset(Jedis jedis, int index, String key, String val) {
        jedis.select(index);
        return jedis.zrem(key, new String[]{val});
    }

    public static long deleteList(Jedis jedis, int index, String key, long keyIndex) {
        jedis.select(index);
        String tempItem = KeyUtil.getUUIDKey();
        jedis.lset(key, keyIndex, tempItem);
        return jedis.lrem(key, 0L, tempItem);
    }

    public static long deleteHash(Jedis jedis, int index, String key, String mapKey) {
        jedis.select(index);
        return jedis.hdel(key, new String[]{mapKey});
    }

    public static void recoveKey(Jedis jedis, int index, String jsonStr) {
        String[] jsons;
        jedis.select(index);
        block14: for (String json : jsons = jsonStr.split("\r\n", -1)) {
            KeyBean keyBean = JsonUtil.parseKeyBeanObject(json);
            if (null == keyBean) continue;
            String key = keyBean.getKey();
            String type = keyBean.getType();
            Object data = keyBean.getData();
            String temp = JSON.toJSONString((Object)data);
            switch (type) {
                case "set": {
                    List sets = (List)JSON.parseObject((String)temp, List.class);
                    for (Iterator setTemp : sets) {
                        jedis.sadd(key, new String[]{setTemp.toString()});
                    }
                    continue block14;
                }
                case "list": {
                    Iterator setTemp;
                    List lists = (List)JSON.parseObject((String)temp, List.class);
                    setTemp = lists.iterator();
                    while (setTemp.hasNext()) {
                        Iterator listTemp = setTemp.next();
                        jedis.lpush(key, new String[]{listTemp.toString()});
                    }
                    continue block14;
                }
                case "zset": {
                    List zsets = (List)JSON.parseObject((String)temp, List.class);
                    for (Object zsetTemp : zsets) {
                        jedis.zadd(key, (double)(zsets.indexOf(zsetTemp) + 1), zsetTemp.toString());
                    }
                    continue block14;
                }
                case "hash": {
                    Map map = (Map)JSON.parseObject((String)temp, Map.class);
                    jedis.hmset(key, map);
                    continue block14;
                }
                case "string": {
                    jedis.set(key, data.toString());
                }
            }
        }
    }

    public static String backupKey(Jedis jedis, int index, String pattern) {
        StringBuilder dataBuffer = new StringBuilder("");
        long startTime = System.currentTimeMillis();
        jedis.select(index);
        if (StringUtils.isEmpty((Object)pattern)) {
            pattern = "*";
        }
        Set keySet = jedis.keys(pattern);
        long endTime = System.currentTimeMillis();
        log.info("getKeyTree\u67e5\u8be2\u8017\u65f6\uff1a" + (endTime - startTime));
        if (null != keySet) {
            for (String key : keySet) {
                KeyBean keyBean = new KeyBean();
                keyBean.setKey(key);
                keyBean.setType(jedis.type(key));
                keyBean.setTtl(jedis.ttl(key));
                switch (keyBean.getType()) {
                    case "set": {
                        keyBean.setData(jedis.smembers(key));
                        break;
                    }
                    case "list": {
                        keyBean.setData(jedis.lrange(key, 0L, -1L));
                        break;
                    }
                    case "zset": {
                        keyBean.setData(jedis.zrange(key, 0L, -1L));
                        break;
                    }
                    case "hash": {
                        keyBean.setData(jedis.hgetAll(key));
                        break;
                    }
                    case "string": {
                        keyBean.setData(jedis.get(key));
                    }
                }
                dataBuffer.append(JSON.toJSONString((Object)keyBean));
                dataBuffer.append("\r\n");
            }
        }
        return dataBuffer.toString();
    }

    public static long dbSize(Jedis jedis, Integer index) {
        if (null != index) {
            jedis.select(index.intValue());
        }
        return jedis.dbSize();
    }

    public static long getKeysCount(Jedis jedis, int index, String pattern) {
        long startTime = System.currentTimeMillis();
        jedis.select(index);
        if (StringUtils.isEmpty((Object)pattern)) {
            pattern = "*";
        }
        Set keySet = jedis.keys(pattern);
        long endTime = System.currentTimeMillis();
        log.info("getKeysCount\u67e5\u8be2\u8017\u65f6\uff1a" + (endTime - startTime));
        return keySet.size();
    }

    public static List<ZTreeBean> getKeyTree(Jedis jedis, int index, String pid, String pattern) {
        ArrayList<ZTreeBean> treeList = new ArrayList<ZTreeBean>();
        long startTime = System.currentTimeMillis();
        jedis.select(index);
        if (StringUtils.isEmpty((Object)pattern)) {
            pattern = "*";
        }
        Set keySet = jedis.keys(pattern);
        long endTime = System.currentTimeMillis();
        log.info("getKeyTree\u67e5\u8be2\u8017\u65f6\uff1a" + (endTime - startTime));
        ZTreeBean zTreeBean = null;
        if (null != keySet) {
            for (String key : keySet) {
                zTreeBean = new ZTreeBean();
                zTreeBean.setId(KeyUtil.getUUIDKey());
                zTreeBean.setPId(pid);
                zTreeBean.setName(key);
                zTreeBean.setParent(false);
                zTreeBean.setIndex(index);
                zTreeBean.setIcon("../image/data-01.png");
                treeList.add(zTreeBean);
            }
        }
        return treeList;
    }

    public static RedisInfo getRedisInfo(Jedis jedis) {
        RedisInfo redisInfo = null;
        Client client = jedis.getClient();
        client.info();
        String info = client.getBulkReply();
        String[] infos = info.split("# ");
        if (null != infos && infos.length > 0) {
            redisInfo = new RedisInfo();
            for (String infoStr : infos) {
                if (infoStr.startsWith("Server")) {
                    redisInfo.setServer(infoStr);
                }
                if (infoStr.startsWith("Clients")) {
                    redisInfo.setClient(infoStr);
                }
                if (infoStr.startsWith("Memory")) {
                    redisInfo.setMemory(infoStr);
                }
                if (infoStr.startsWith("Persistence")) {
                    redisInfo.setPersistence(infoStr);
                }
                if (infoStr.startsWith("Stats")) {
                    redisInfo.setStats(infoStr);
                }
                if (infoStr.startsWith("Replication")) {
                    redisInfo.setReplication(infoStr);
                }
                if (infoStr.startsWith("CPU")) {
                    redisInfo.setCpu(infoStr);
                }
                if (infoStr.startsWith("Cluster")) {
                    redisInfo.setCluster(infoStr);
                }
                if (!infoStr.startsWith("Keyspace")) continue;
                redisInfo.setKeyspace(infoStr);
            }
        }
        return redisInfo;
    }

    public static RedisInfo getRedisInfoList(Jedis jedis) {
        RedisInfo redisInfoBean = RedisUtil.getRedisInfo(jedis);
        RedisInfo redisInfo = null;
        if (null != redisInfoBean) {
            redisInfo = new RedisInfo();
            redisInfo.setServer(RedisUtil.returnServerInfo(redisInfoBean).toString());
            redisInfo.setClient(RedisUtil.returnClientInfo(redisInfoBean).toString());
            redisInfo.setMemory(RedisUtil.returnMemoryInfo(redisInfoBean).toString());
            redisInfo.setPersistence(RedisUtil.returnPersistenceInfo(redisInfoBean).toString());
            redisInfo.setStats(RedisUtil.returnStatsInfo(redisInfoBean).toString());
            redisInfo.setCpu(RedisUtil.returnCpuInfo(redisInfoBean).toString());
            redisInfo.setUsers(RedisUtil.returnUsersInfo(jedis));
        }
        return redisInfo;
    }

    private static StringBuffer returnServerInfo(RedisInfo redisInfo) {
        StringBuffer serverBuf = new StringBuffer("");
        String serverInfo = redisInfo.getServer();
        if (!StringUtils.isEmpty((Object)serverInfo)) {
            String[] server;
            block22: for (String info : server = serverInfo.split("\n")) {
                String key = StringUtil.getKeyString(":", info);
                String value = StringUtil.getValueString(":", info);
                switch (key) {
                    case "redis_version": {
                        serverBuf.append("\u670d\u52a1\u7248\u672c: ").append(value);
                        serverBuf.append("<br/>");
                        continue block22;
                    }
                    case "redis_mode": {
                        serverBuf.append("\u670d\u52a1\u6a21\u5f0f: ").append(value);
                        serverBuf.append("<br/>");
                        continue block22;
                    }
                    case "os": {
                        serverBuf.append("\u7cfb\u7edf\u7248\u672c: ").append(value);
                        serverBuf.append("<br/>");
                        continue block22;
                    }
                    case "arch_bits": {
                        continue block22;
                    }
                    case "multiplexing_api": {
                        continue block22;
                    }
                    case "process_id": {
                        serverBuf.append("\u8fdb\u7a0b\u7f16\u53f7: ").append(value);
                        serverBuf.append("<br/>");
                        continue block22;
                    }
                    case "tcp_port": {
                        serverBuf.append("\u670d\u52a1\u7aef\u53e3: ").append(value);
                        serverBuf.append("<br/>");
                        continue block22;
                    }
                    case "uptime_in_seconds": {
                        serverBuf.append("\u8fd0\u884c\u65f6\u95f4: ").append(value);
                        serverBuf.append("<br/>");
                        continue block22;
                    }
                    case "config_file": {
                        serverBuf.append("\u914d\u7f6e\u6587\u4ef6: ").append(value);
                        serverBuf.append("<br/>");
                    }
                }
            }
        }
        return serverBuf;
    }

    private static StringBuffer returnClientInfo(RedisInfo redisInfo) {
        StringBuffer clientBuf = new StringBuffer("");
        String clientInfo = redisInfo.getClient();
        if (!StringUtils.isEmpty((Object)clientInfo)) {
            String[] client;
            block12: for (String info : client = clientInfo.split("\n")) {
                String key = StringUtil.getKeyString(":", info);
                String value = StringUtil.getValueString(":", info);
                switch (key) {
                    case "connected_clients": {
                        clientBuf.append("\u5f53\u524d\u5df2\u8fde\u63a5\u5ba2\u6237\u7aef\u6570\u91cf: ").append(value);
                        clientBuf.append("<br/>");
                        continue block12;
                    }
                    case "blocked_clients": {
                        clientBuf.append("\u5f53\u524d\u5df2\u963b\u585e\u5ba2\u6237\u7aef\u6570\u91cf: ").append(value);
                        clientBuf.append("<br/>");
                        continue block12;
                    }
                    case "client_longest_output_list": {
                        clientBuf.append("\u5f53\u524d\u8fde\u63a5\u7684\u5ba2\u6237\u7aef\u5f53\u4e2d\uff0c\u6700\u957f\u8f93\u51fa\u5217\u8868: ").append(value);
                        clientBuf.append("<br/>");
                        continue block12;
                    }
                    case "client_biggest_input_buf": {
                        clientBuf.append("\u5f53\u524d\u8fde\u63a5\u7684\u5ba2\u6237\u7aef\u5f53\u4e2d\uff0c\u6700\u5927\u8f93\u5165\u7f13\u5b58: ").append(value);
                        clientBuf.append("<br/>");
                    }
                }
            }
        }
        return clientBuf;
    }

    private static StringBuffer returnMemoryInfo(RedisInfo redisInfo) {
        StringBuffer memoryBuf = new StringBuffer("");
        String memoryInfo = redisInfo.getMemory();
        if (!StringUtils.isEmpty((Object)memoryInfo)) {
            String[] memory;
            block14: for (String info : memory = memoryInfo.split("\n")) {
                String key = StringUtil.getKeyString(":", info);
                String value = StringUtil.getValueString(":", info);
                switch (key) {
                    case "used_memory": {
                        memoryBuf.append("\u5df2\u5360\u7528\u5185\u5b58\u91cf: ").append(value);
                        memoryBuf.append("<br/>");
                        continue block14;
                    }
                    case "used_memory_rss": {
                        memoryBuf.append("\u5206\u914d\u5185\u5b58\u603b\u91cf: ").append(value);
                        memoryBuf.append("<br/>");
                        continue block14;
                    }
                    case "used_memory_peak_human": {
                        memoryBuf.append("\u5185\u5b58\u9ad8\u5cf0\u503c: ").append(value);
                        memoryBuf.append("<br/>");
                        continue block14;
                    }
                    case "mem_fragmentation_ratio": {
                        memoryBuf.append("\u5185\u5b58\u788e\u7247\u7387: ").append(value);
                        memoryBuf.append("<br/>");
                        continue block14;
                    }
                    case "mem_allocator": {
                        memoryBuf.append("\u5185\u5b58\u5206\u914d\u5668: ").append(value);
                        memoryBuf.append("<br/>");
                    }
                }
            }
        }
        return memoryBuf;
    }

    private static StringBuffer returnPersistenceInfo(RedisInfo redisInfo) {
        StringBuffer persistenceBuf = new StringBuffer("");
        String persistenceInfo = redisInfo.getPersistence();
        if (!StringUtils.isEmpty((Object)persistenceInfo)) {
            String[] persistence;
            block24: for (String info : persistence = persistenceInfo.split("\n")) {
                String key = StringUtil.getKeyString(":", info);
                String value = StringUtil.getValueString(":", info);
                switch (key) {
                    case "rdb_bgsave_in_progress": {
                        persistenceBuf.append("\u662f\u5426\u6b63\u5728\u521b\u5efaRDB\u7684\u6587\u4ef6: ").append(value);
                        persistenceBuf.append("<br/>");
                        continue block24;
                    }
                    case "rdb_last_save_time": {
                        persistenceBuf.append("\u6700\u8fd1\u6210\u529f\u521b\u5efaRDB\u65f6\u95f4\u6233: ").append(value);
                        persistenceBuf.append("<br/>");
                        continue block24;
                    }
                    case "rdb_last_bgsave_status": {
                        persistenceBuf.append("\u6700\u8fd1\u521b\u5efaRDB\u6587\u4ef6\u7684\u7ed3\u679c: ").append(value);
                        persistenceBuf.append("<br/>");
                        continue block24;
                    }
                    case "rdb_last_bgsave_time_sec": {
                        persistenceBuf.append("\u6700\u8fd1\u521b\u5efaRDB\u6587\u4ef6\u7684\u8017\u65f6: ").append(value);
                        persistenceBuf.append("<br/>");
                        continue block24;
                    }
                    case "aof_enabled": {
                        persistenceBuf.append("\u670d\u52a1\u662f\u5426\u5df2\u7ecf\u5f00\u542f\u4e86AOF: ").append(value);
                        persistenceBuf.append("<br/>");
                        continue block24;
                    }
                    case "aof_rewrite_in_progress": {
                        persistenceBuf.append("\u662f\u5426\u6b63\u5728\u521b\u5efaAOF\u7684\u6587\u4ef6: ").append(value);
                        persistenceBuf.append("<br/>");
                        continue block24;
                    }
                    case "aof_last_rewrite_time_sec": {
                        persistenceBuf.append("\u6700\u8fd1\u521b\u5efaAOF\u6587\u4ef6\u7684\u8017\u65f6: ").append(value);
                        persistenceBuf.append("<br/>");
                        continue block24;
                    }
                    case "aof_last_bgrewrite_status": {
                        persistenceBuf.append("\u6700\u8fd1\u521b\u5efaAOF\u6587\u4ef6\u7684\u7ed3\u679c: ").append(value);
                        persistenceBuf.append("<br/>");
                        continue block24;
                    }
                    case "aof_current_size": {
                        persistenceBuf.append("\u5f53\u524dAOF\u6587\u4ef6\u8bb0\u5f55\u7684\u5927\u5c0f: ").append(value);
                        persistenceBuf.append("<br/>");
                        continue block24;
                    }
                    case "aof_buffer_length": {
                        persistenceBuf.append("\u5f53\u524dAOF\u6587\u4ef6\u7f13\u51b2\u533a\u5927\u5c0f: ").append(value);
                        persistenceBuf.append("<br/>");
                    }
                }
            }
        }
        return persistenceBuf;
    }

    private static StringBuffer returnStatsInfo(RedisInfo redisInfo) {
        StringBuffer statsBuf = new StringBuffer();
        String statsInfo = redisInfo.getStats();
        if (!StringUtils.isEmpty((Object)statsInfo)) {
            String[] stats;
            block16: for (String info : stats = statsInfo.split("\n")) {
                String key = StringUtil.getKeyString(":", info);
                String value = StringUtil.getValueString(":", info);
                switch (key) {
                    case "total_connections_received": {
                        statsBuf.append("\u5df2\u8fde\u63a5\u5ba2\u6237\u7aef\u603b\u6570: ").append(value);
                        statsBuf.append("<br/>");
                        continue block16;
                    }
                    case "total_commands_processed": {
                        statsBuf.append("\u6267\u884c\u8fc7\u7684\u547d\u4ee4\u603b\u6570: ").append(value);
                        statsBuf.append("<br/>");
                        continue block16;
                    }
                    case "instantaneous_ops_per_sec": {
                        statsBuf.append("\u670d\u52a1\u6bcf\u79d2\u6267\u884c\u6570\u91cf: ").append(value);
                        statsBuf.append("<br/>");
                        continue block16;
                    }
                    case "total_net_input_bytes": {
                        statsBuf.append("\u670d\u52a1\u8f93\u5165\u7f51\u7edc\u6d41\u91cf: ").append(value);
                        statsBuf.append("<br/>");
                        continue block16;
                    }
                    case "total_net_output_bytes": {
                        statsBuf.append("\u670d\u52a1\u8f93\u51fa\u7f51\u7edc\u6d41\u91cf: ").append(value);
                        statsBuf.append("<br/>");
                        continue block16;
                    }
                    case "rejected_connections": {
                        statsBuf.append("\u62d2\u7edd\u8fde\u63a5\u5ba2\u6237\u7aef\u6570: ").append(value);
                        statsBuf.append("<br/>");
                    }
                }
            }
        }
        return statsBuf;
    }

    private static StringBuffer returnCpuInfo(RedisInfo redisInfo) {
        StringBuffer cpuBuf = new StringBuffer();
        String cpuInfo = redisInfo.getCpu();
        if (!StringUtils.isEmpty((Object)cpuInfo)) {
            String[] cpu;
            block12: for (String info : cpu = cpuInfo.split("\n")) {
                String key = StringUtil.getKeyString(":", info);
                String value = StringUtil.getValueString(":", info);
                switch (key) {
                    case "used_cpu_sys": {
                        cpuBuf.append("\u670d\u52a1\u4e3b\u8fdb\u7a0b\u5728\u6838\u5fc3\u6001\u7d2f\u8ba1CPU\u8017\u65f6: ").append(value);
                        cpuBuf.append("<br/>");
                        continue block12;
                    }
                    case "used_cpu_user": {
                        cpuBuf.append("\u670d\u52a1\u4e3b\u8fdb\u7a0b\u5728\u7528\u6237\u6001\u7d2f\u8ba1CPU\u8017\u65f6: ").append(value);
                        cpuBuf.append("<br/>");
                        continue block12;
                    }
                    case "used_cpu_sys_children": {
                        cpuBuf.append("\u670d\u52a1\u540e\u53f0\u8fdb\u7a0b\u5728\u6838\u5fc3\u6001\u7d2f\u8ba1CPU\u8017\u65f6: ").append(value);
                        cpuBuf.append("<br/>");
                        continue block12;
                    }
                    case "used_cpu_user_children": {
                        cpuBuf.append("\u670d\u52a1\u540e\u53f0\u8fdb\u7a0b\u5728\u7528\u6237\u6001\u7d2f\u8ba1CPU\u8017\u65f6: ").append(value);
                        cpuBuf.append("<br/>");
                    }
                }
            }
        }
        return cpuBuf;
    }

    private static List<ClientInfo> returnUsersInfo(Jedis jedis) {
        String[] users;
        ArrayList<ClientInfo> usersList = new ArrayList<ClientInfo>();
        String usersInfo = jedis.clientList();
        if (!StringUtils.isEmpty((Object)usersInfo) && null != (users = usersInfo.split("\n")) && users.length > 0) {
            for (String user : users) {
                String[] items;
                ClientInfo clientInfo = new ClientInfo();
                for (String item : items = user.split(" ")) {
                    if (item.startsWith("id=")) {
                        clientInfo.setId(StringUtil.getValueString("=", item));
                    }
                    if (item.startsWith("addr=")) {
                        clientInfo.setAddr(StringUtil.getValueString("=", item));
                    }
                    if (item.startsWith("age=")) {
                        clientInfo.setAge(StringUtil.getValueString("=", item));
                    }
                    if (!item.startsWith("db=")) continue;
                    clientInfo.setDb(StringUtil.getValueString("=", item));
                }
                usersList.add(clientInfo);
            }
        }
        return usersList;
    }

    public static KeyBean getKeyInfo(Jedis jedis, int index, String key, String order) {
        KeyBean keyBean = new KeyBean();
        jedis.select(index);
        keyBean.setKey(key);
        keyBean.setType(jedis.type(key));
        keyBean.setTtl(jedis.ttl(key));
        switch (keyBean.getType()) {
            case "set": {
                Set set = jedis.smembers(key);
                StringBuilder setBuf = new StringBuilder();
                for (String info : set) {
                    setBuf.append(info).append(",");
                }
                String textSet = setBuf.toString();
                keyBean.setText(textSet.substring(0, textSet.length() - 1));
                keyBean.setJson(JSON.toJSONString((Object)set));
                keyBean.setRaws(keyBean.getText().replace(",", "\r\n"));
                break;
            }
            case "list": {
                List list = jedis.lrange(key, 0L, -1L);
                if (!StringUtils.isEmpty((Object)order) && order.equals("desc")) {
                    Collections.reverse(list);
                }
                StringBuilder listBuf = new StringBuilder();
                for (String info : list) {
                    listBuf.append(info).append(",");
                }
                String textList = listBuf.toString();
                keyBean.setText(textList.substring(0, textList.length() - 1));
                keyBean.setJson(JSON.toJSONString((Object)list));
                keyBean.setRaws(keyBean.getText().replace(",", "\r\n"));
                break;
            }
            case "zset": {
                Set zset = jedis.zrevrangeWithScores(key, 0L, -1L);
                ArrayList zsetList = new ArrayList(zset);
                if (StringUtils.isEmpty((Object)order) || order.equals("asc")) {
                    Collections.reverse(zsetList);
                }
                StringBuilder zsetBuf = new StringBuilder();
                for (Tuple info : zsetList) {
                    zsetBuf.append(info.getElement()).append(",");
                }
                String textZset = zsetBuf.toString();
                keyBean.setText(textZset.substring(0, textZset.length() - 1));
                keyBean.setJson(JSON.toJSONString(zsetList));
                keyBean.setRaws(keyBean.getText().replace(",", "\r\n"));
                break;
            }
            case "hash": {
                Map map = jedis.hgetAll(key);
                StringBuilder mapBuf = new StringBuilder();
                for (Map.Entry entry : map.entrySet()) {
                    mapBuf.append(entry.getKey()).append(":").append(entry.getValue()).append(",");
                }
                String textMap = mapBuf.toString();
                keyBean.setText(textMap.substring(0, textMap.length() - 1));
                keyBean.setJson(JSON.toJSONString((Object)map));
                keyBean.setRaws(keyBean.getText().replace(",", "\r\n"));
                break;
            }
            case "string": {
                keyBean.setText(jedis.get(key));
                try {
                    JSON.parseObject((String)keyBean.getText());
                    keyBean.setJson(keyBean.getText());
                }
                catch (Exception e) {
                    keyBean.setJson(JSON.toJSONString((Object)keyBean.getText()));
                }
                keyBean.setRaws(keyBean.getText());
            }
        }
        keyBean.setSize(keyBean.getText().getBytes().length);
        return keyBean;
    }

    public static List<ConfigBean> getRedisConfig(Jedis jedis) {
        ArrayList<ConfigBean> confList = new ArrayList<ConfigBean>();
        List configList = jedis.configGet("*");
        for (int i = 0; i < configList.size(); ++i) {
            if (i % 2 == 0) continue;
            ConfigBean configBean = new ConfigBean();
            configBean.setKey((String)configList.get(i - 1));
            String value = (String)configList.get(i);
            if (StringUtils.isEmpty((Object)value)) {
                configBean.setValue("");
            } else {
                configBean.setValue(value);
            }
            confList.add(configBean);
        }
        return confList;
    }

    public static void setRedisConfig(Jedis jedis, Map<String, String> confMap) {
        for (String key : confMap.keySet()) {
            jedis.configSet(key, confMap.get(key));
        }
    }

    public static List<Slowlog> getRedisLog(Jedis jedis) {
        List logList = jedis.slowlogGet(100L);
        return logList;
    }

    public static String execRediscommand(Jedis jedis, String command) {
        return jedis.info(command);
    }

    public static void testCase(Jedis jedis) {
        jedis.set("testString1", "testString1");
        jedis.set("testString2", "testString2");
        jedis.del("testList");
        jedis.lpush("testList", new String[]{"list01"});
        jedis.lpush("testList", new String[]{"list02"});
        jedis.lpush("testList", new String[]{"list03"});
        jedis.lpush("testList", new String[]{"list04"});
        jedis.lpush("testList", new String[]{"list05"});
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map01", "map01-value");
        map.put("map02", "map02-value");
        map.put("map03", "map03-value");
        map.put("map04", "map04-value");
        map.put("map05", "map05-value");
        jedis.sadd("testSet", new String[]{"set-value01"});
        jedis.sadd("testSet", new String[]{"set-value02"});
        jedis.sadd("testSet", new String[]{"set-value03"});
        jedis.sadd("testSet", new String[]{"set-value04"});
        jedis.sadd("testSet", new String[]{"set-value05"});
        jedis.zadd("testZset", 1.0, "set-value01");
        jedis.zadd("testZset", 2.0, "set-value02");
        jedis.zadd("testZset", 3.0, "set-value03");
        jedis.zadd("testZset", 4.0, "set-value04");
        jedis.zadd("testZset", 5.0, "set-value05");
    }

    public static void main(String[] args) throws Exception {
        Connect connect = new Connect();
        connect.setRhost("127.0.0.1");
        connect.setRport("6379");
        connect.setRpass("123456");
        connect.setType("0");
        Jedis jedis = RedisUtil.openJedis(connect);
        Client client = jedis.getClient();
        client.exec();
        String info = client.getBulkReply();
        System.out.println("exec finish:" + info);
        jedis.close();
    }

    static {
        lock = new ReentrantLock();
    }
}

