/*
 * Decompiled with CFR 0.152.
 */
package com.maxbill.tool;

import com.maxbill.core.desktop.LogView;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class LogUtil {
    public static String getExceptionAllinformation(Exception e) {
        StackTraceElement[] trace;
        StringBuilder outBuffer = new StringBuilder();
        for (StackTraceElement s : trace = e.getStackTrace()) {
            outBuffer.append(s + "\r\n");
        }
        return outBuffer.toString();
    }

    public static String dealException(Exception e) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream pout = new PrintStream(out);
        e.printStackTrace(pout);
        String info = new String(out.toByteArray());
        pout.close();
        try {
            out.close();
        }
        catch (Exception ex) {
            info = "";
        }
        return info;
    }

    private static String throwableToString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        e.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    public static void setLogMessage(String info) {
        LogView.setLogView(true, info);
    }

    public static void setLogException(Exception e) {
        LogView.setLogView(false, LogUtil.dealException(e));
    }
}

