/*
 * Decompiled with CFR 0.152.
 */
package com.maxbill.tool;

import com.alibaba.fastjson.JSON;
import com.maxbill.base.bean.Connect;
import com.maxbill.base.bean.KeyBean;
import com.maxbill.base.bean.RedisNode;
import com.maxbill.base.bean.Relation;
import com.maxbill.tool.DataUtil;
import com.maxbill.tool.JschUtil;
import com.maxbill.tool.JsonUtil;
import com.maxbill.tool.KeyUtil;
import com.maxbill.tool.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.util.StringUtils;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Tuple;

public class ClusterUtil {
    private static final int MAX_TOTAL = 50;
    private static final int MAX_IDLE = 10;
    private static final int MAX_WAIT = 3000;
    private static final int TIME_OUT = 3000;
    private static final boolean TEST_ON_BORROW = true;
    private static final boolean TEST_ON_RETURN = true;
    private static JedisCluster cluster;

    public static JedisCluster openCulter(Connect connect) throws Exception {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(50);
        config.setMaxIdle(10);
        config.setMaxWaitMillis(3000L);
        config.setTestOnBorrow(true);
        config.setTestOnReturn(true);
        LinkedHashSet<HostAndPort> nodes = new LinkedHashSet<HostAndPort>();
        List<RedisNode> nodeList = ClusterUtil.getClusterNode(connect);
        for (RedisNode node : nodeList) {
            String host = StringUtil.getKeyString(":", node.getAddr());
            String port = StringUtil.getValueString(":", node.getAddr());
            nodes.add(new HostAndPort(host, Integer.valueOf(port).intValue()));
        }
        String pass = connect.getRpass();
        cluster = StringUtils.isEmpty((Object)pass) ? new JedisCluster(nodes, 3000, (GenericObjectPoolConfig)config) : new JedisCluster(nodes, 1000, 1000, 1, pass, (GenericObjectPoolConfig)config);
        return cluster;
    }

    public static void closeCulter() {
        try {
            if (cluster != null) {
                cluster.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JedisCluster getCluster(Connect connect) throws Exception {
        if (null == cluster || cluster.getClusterNodes().size() == 0) {
            return ClusterUtil.openCulter(connect);
        }
        return cluster;
    }

    public static List<RedisNode> getClusterNode(Connect connect) throws Exception {
        String[] nodes;
        ArrayList<RedisNode> nodeList = new ArrayList<RedisNode>();
        Jedis jedis = null;
        jedis = "1".equals(connect.getType()) ? new Jedis(connect.getRhost(), 55555) : new Jedis(connect.getRhost(), Integer.valueOf(connect.getRport()).intValue());
        if (!StringUtils.isEmpty((Object)connect.getRpass())) {
            jedis.auth(connect.getRpass());
        }
        String clusterNodes = jedis.clusterNodes();
        for (String node : nodes = clusterNodes.split("\n")) {
            String[] nodeFileds = node.split(" ");
            RedisNode redisNode = new RedisNode();
            redisNode.setId(nodeFileds[0]);
            redisNode.setAddr(nodeFileds[1]);
            redisNode.setFlag(nodeFileds[2]);
            redisNode.setPid(nodeFileds[3]);
            redisNode.setPing(nodeFileds[4]);
            redisNode.setPong(nodeFileds[5]);
            redisNode.setEpoch(nodeFileds[6]);
            redisNode.setState(nodeFileds[7]);
            if (nodeFileds.length == 9) {
                redisNode.setHash(nodeFileds[8]);
            }
            if (redisNode.getAddr().contains("@")) {
                redisNode.setAddr(redisNode.getAddr().split("@")[0]);
            }
            nodeList.add(redisNode);
        }
        jedis.close();
        return nodeList;
    }

    public static Map<String, RedisNode> getMasterNode(List<RedisNode> nodeList) {
        HashMap<String, RedisNode> nodeMap = new HashMap<String, RedisNode>();
        for (RedisNode node : nodeList) {
            if (!node.getFlag().contains("master")) continue;
            nodeMap.put(node.getAddr(), node);
        }
        return nodeMap;
    }

    public static Jedis getMasterSelf() {
        JedisCluster jedisCluster = DataUtil.getJedisClusterObject();
        if (null != jedisCluster) {
            Connect connect = DataUtil.getCurrentOpenConnect();
            Map clusterNodes = jedisCluster.getClusterNodes();
            for (String nk : clusterNodes.keySet()) {
                if (connect.getType().equals("0") && nk.contains(connect.getRhost())) {
                    return ((JedisPool)clusterNodes.get(nk)).getResource();
                }
                if (!connect.getType().equals("1") || !nk.contains(connect.getShost())) continue;
                return ((JedisPool)clusterNodes.get(nk)).getResource();
            }
        }
        return null;
    }

    public static boolean isCulter(Connect connect) {
        boolean isCulter = false;
        Jedis jedis = null;
        try {
            String[] server;
            String pass = connect.getRpass();
            if ("1".equals(connect.getType())) {
                JschUtil.openSSH(connect);
                jedis = new Jedis(connect.getRhost(), 55555);
            } else {
                jedis = new Jedis(connect.getRhost(), Integer.valueOf(connect.getRport()).intValue());
            }
            if (!StringUtils.isEmpty((Object)pass)) {
                jedis.auth(pass);
            }
            String serverInfo = jedis.info("server");
            for (String info : server = serverInfo.split("\n")) {
                String key = StringUtil.getKeyString(":", info);
                String value = StringUtil.getValueString(":", info);
                if (!key.equals("redis_mode") || !value.equals("cluster\r")) continue;
                isCulter = true;
            }
            if (null != jedis) {
                jedis.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isCulter;
    }

    public static boolean existsKey(JedisCluster jedisCluster, String key) {
        return jedisCluster.exists(key);
    }

    public static void renameKey(JedisCluster jedisCluster, String oldKey, String newKey) {
        String type;
        switch (type = jedisCluster.type(oldKey)) {
            case "set": {
                Set set = jedisCluster.smembers(oldKey);
                for (String temp : set) {
                    jedisCluster.sadd(newKey, new String[]{temp});
                }
                break;
            }
            case "none": {
                break;
            }
            case "list": {
                List list = jedisCluster.lrange(oldKey, 0L, -1L);
                for (String temp : list) {
                    jedisCluster.lpush(newKey, new String[]{temp});
                }
                break;
            }
            case "zset": {
                ArrayList zset = new ArrayList(jedisCluster.zrange(oldKey, 0L, -1L));
                for (String temp : zset) {
                    jedisCluster.zadd(newKey, (double)(zset.indexOf(temp) + 1), temp);
                }
                break;
            }
            case "hash": {
                jedisCluster.hmset(newKey, jedisCluster.hgetAll(oldKey));
                break;
            }
            case "string": {
                String strs = jedisCluster.get(oldKey);
                jedisCluster.set(newKey, strs);
            }
        }
    }

    public static long retimeKey(JedisCluster jedisCluster, String key, int time) {
        return jedisCluster.expire(key, time);
    }

    public static long deleteKey(JedisCluster jedisCluster, String key) {
        return jedisCluster.del(key);
    }

    public static String updateStr(JedisCluster jedisCluster, String key, String val) {
        return jedisCluster.set(key, val);
    }

    public static long insertSet(JedisCluster jedisCluster, String key, String val) {
        return jedisCluster.sadd(key, new String[]{val});
    }

    public static long insertZset(JedisCluster jedisCluster, String key, String val, double score) {
        return jedisCluster.zadd(key, score, val);
    }

    public static long insertList(JedisCluster jedisCluster, String key, String val) {
        return jedisCluster.rpush(key, new String[]{val});
    }

    public static long insertHash(JedisCluster jedisCluster, String key, String mapKey, String mapVal) {
        return jedisCluster.hset(key, mapKey, mapVal);
    }

    public static long deleteSet(JedisCluster jedisCluster, String key, String val) {
        return jedisCluster.srem(key, new String[]{val});
    }

    public static long deleteZset(JedisCluster jedisCluster, String key, String val) {
        return jedisCluster.zrem(key, new String[]{val});
    }

    public static long deleteList(JedisCluster jedisCluster, String key, long keyIndex) {
        String tempItem = KeyUtil.getUUIDKey();
        jedisCluster.lset(key, keyIndex, tempItem);
        return jedisCluster.lrem(key, 0L, tempItem);
    }

    public static String updateList(JedisCluster jedisCluster, String key, int itemIndex, String val) {
        return jedisCluster.lset(key, (long)itemIndex, val);
    }

    public static long deleteHash(JedisCluster jedisCluster, String key, String mapKey) {
        return jedisCluster.hdel(key, new String[]{mapKey});
    }

    public static void recoveKey(JedisCluster jedisCluster, String jsonStr) {
        String[] jsons;
        block14: for (String json : jsons = jsonStr.split("\r\n", -1)) {
            KeyBean keyBean = JsonUtil.parseKeyBeanObject(json);
            if (null == keyBean) continue;
            String keys = keyBean.getKey();
            String type = keyBean.getType();
            String data = JSON.toJSONString((Object)keyBean.getData());
            switch (type) {
                case "set": {
                    List sets = (List)JSON.parseObject((String)data, List.class);
                    for (Iterator setTemp : sets) {
                        jedisCluster.sadd(keys, new String[]{setTemp.toString()});
                    }
                    continue block14;
                }
                case "list": {
                    Iterator setTemp;
                    List lists = (List)JSON.parseObject((String)data, List.class);
                    setTemp = lists.iterator();
                    while (setTemp.hasNext()) {
                        Iterator listTemp = setTemp.next();
                        jedisCluster.lpush(keys, new String[]{listTemp.toString()});
                    }
                    continue block14;
                }
                case "zset": {
                    List zsets = (List)JSON.parseObject((String)data, List.class);
                    for (Object zsetTemp : zsets) {
                        jedisCluster.zadd(keys, (double)(zsets.indexOf(zsetTemp) + 1), zsetTemp.toString());
                    }
                    continue block14;
                }
                case "hash": {
                    Map map = (Map)JSON.parseObject((String)data, Map.class);
                    jedisCluster.hmset(keys, map);
                    continue block14;
                }
                case "string": {
                    jedisCluster.set(keys, keyBean.getData().toString());
                }
            }
        }
    }

    public static String backupKey(Jedis jedis, String pattern) {
        StringBuilder dataBuffer = new StringBuilder("");
        if (StringUtils.isEmpty((Object)pattern)) {
            pattern = "*";
        }
        Object dataObj = null;
        Set keySet = jedis.keys(pattern);
        if (null != keySet) {
            for (String key : keySet) {
                KeyBean keyBean = new KeyBean();
                keyBean.setKey(key);
                keyBean.setType(jedis.type(key));
                keyBean.setTtl(jedis.ttl(key));
                switch (keyBean.getType()) {
                    case "set": {
                        dataObj = jedis.smembers(key);
                        break;
                    }
                    case "list": {
                        dataObj = jedis.lrange(key, 0L, -1L);
                        break;
                    }
                    case "zset": {
                        dataObj = jedis.zrange(key, 0L, -1L);
                        break;
                    }
                    case "hash": {
                        dataObj = jedis.hgetAll(key);
                        break;
                    }
                    case "string": {
                        dataObj = jedis.get(key);
                    }
                }
                keyBean.setData(dataObj);
                dataBuffer.append(JSON.toJSONString((Object)keyBean));
                dataBuffer.append("\r\n");
            }
        }
        return dataBuffer.toString();
    }

    public static KeyBean getKeyInfo(JedisCluster jedisCluster, String key, String order) {
        KeyBean keyBean = new KeyBean();
        keyBean.setKey(key);
        keyBean.setType(jedisCluster.type(key));
        keyBean.setTtl(jedisCluster.ttl(key));
        switch (keyBean.getType()) {
            case "set": {
                Set set = jedisCluster.smembers(key);
                StringBuilder setBuf = new StringBuilder();
                for (String info : set) {
                    setBuf.append(info).append(",");
                }
                String textSet = setBuf.toString();
                keyBean.setText(textSet.substring(0, textSet.length() - 1));
                keyBean.setJson(JSON.toJSONString((Object)set));
                keyBean.setRaws(keyBean.getText().replace(",", "\r\n"));
                break;
            }
            case "none": {
                keyBean.setText("");
                break;
            }
            case "list": {
                List list = jedisCluster.lrange(key, 0L, -1L);
                if (!StringUtils.isEmpty((Object)order) && order.equals("desc")) {
                    Collections.reverse(list);
                }
                StringBuilder listBuf = new StringBuilder();
                for (String info : list) {
                    listBuf.append(info).append(",");
                }
                String textList = listBuf.toString();
                keyBean.setText(textList.substring(0, textList.length() - 1));
                keyBean.setJson(JSON.toJSONString((Object)list));
                keyBean.setRaws(keyBean.getText().replace(",", "\r\n"));
                break;
            }
            case "zset": {
                Set zset = jedisCluster.zrevrangeWithScores(key, 0L, -1L);
                ArrayList zsetList = new ArrayList(zset);
                if (StringUtils.isEmpty((Object)order) || order.equals("asc")) {
                    Collections.reverse(zsetList);
                }
                StringBuilder zsetBuf = new StringBuilder();
                for (Tuple info : zsetList) {
                    zsetBuf.append(info.getElement()).append(",");
                }
                String textZset = zsetBuf.toString();
                keyBean.setText(textZset.substring(0, textZset.length() - 1));
                keyBean.setJson(JSON.toJSONString(zsetList));
                keyBean.setRaws(keyBean.getText().replace(",", "\r\n"));
                break;
            }
            case "hash": {
                Map map = jedisCluster.hgetAll(key);
                StringBuilder mapBuf = new StringBuilder();
                for (Map.Entry entry : map.entrySet()) {
                    mapBuf.append(entry.getKey()).append(":").append(entry.getValue()).append(",");
                }
                String textMap = mapBuf.toString();
                keyBean.setText(textMap.substring(0, textMap.length() - 1));
                keyBean.setJson(JSON.toJSONString((Object)map));
                keyBean.setRaws(keyBean.getText().replace(",", "\r\n"));
                break;
            }
            case "string": {
                keyBean.setText(jedisCluster.get(key));
                try {
                    JSON.parseObject((String)keyBean.getText());
                    keyBean.setJson(keyBean.getText());
                }
                catch (Exception e) {
                    keyBean.setJson(JSON.toJSONString((Object)keyBean.getText()));
                }
                keyBean.setRaws(keyBean.getText());
            }
        }
        keyBean.setSize(keyBean.getText().getBytes().length);
        return keyBean;
    }

    public static List<Relation> getClusterRelation(String info) {
        ArrayList<Relation> relations = new ArrayList<Relation>();
        ArrayList<String> masters = new ArrayList<String>();
        ArrayList<String> slaves = new ArrayList<String>();
        String[] nodes = info.split("\n");
        for (String node : nodes) {
            if (node.contains("master")) {
                masters.add(node);
                continue;
            }
            slaves.add(node);
        }
        for (String master : masters) {
            String[] masterNode = master.split(" ");
            Relation relationMaster = new Relation();
            relationMaster.setNode(masterNode[0]);
            relationMaster.setHost(masterNode[1]);
            relationMaster.setRole("\u4e3b\u8282\u70b9");
            if (masterNode[7].equals("connected")) {
                relationMaster.setFlag("\u5df2\u8fde\u63a5");
            } else {
                relationMaster.setFlag("\u5df2\u65ad\u5f00");
            }
            relationMaster.setSlot(masterNode[8]);
            relations.add(relationMaster);
            for (String slave : slaves) {
                String[] slaveNode = slave.split(" ");
                if (!slaveNode[3].equals(masterNode[0])) continue;
                Relation relationSlave = new Relation();
                relationSlave.setNode(slaveNode[0]);
                relationSlave.setHost(slaveNode[1]);
                relationSlave.setRole("\u4ece\u8282\u70b9");
                if (slaveNode[7].equals("connected")) {
                    relationSlave.setFlag("\u5df2\u8fde\u63a5");
                } else {
                    relationSlave.setFlag("\u5df2\u65ad\u5f00");
                }
                relations.add(relationSlave);
            }
        }
        return relations;
    }

    public static void testClusterData() {
        cluster.set("testString1", "testString1");
        cluster.set("testString2", "testString2");
        cluster.del("testList");
        cluster.lpush("testList", new String[]{"list01"});
        cluster.lpush("testList", new String[]{"list02"});
        cluster.lpush("testList", new String[]{"list03"});
        cluster.lpush("testList", new String[]{"list04"});
        cluster.lpush("testList", new String[]{"list05"});
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map01", "map01-value");
        map.put("map02", "map02-value");
        map.put("map03", "map03-value");
        map.put("map04", "map04-value");
        map.put("map05", "map05-value");
        cluster.hmset("testMap", map);
        cluster.sadd("testSet", new String[]{"set-value01"});
        cluster.sadd("testSet", new String[]{"set-value02"});
        cluster.sadd("testSet", new String[]{"set-value03"});
        cluster.sadd("testSet", new String[]{"set-value04"});
        cluster.sadd("testSet", new String[]{"set-value05"});
        cluster.zadd("testZset", 1.0, "set-value01");
        cluster.zadd("testZset", 2.0, "set-value02");
        cluster.zadd("testZset", 3.0, "set-value03");
        cluster.zadd("testZset", 4.0, "set-value04");
        cluster.zadd("testZset", 5.0, "set-value05");
    }

    public static void main(String[] args) throws Exception {
        Connect connect = new Connect();
        connect.setRport("7001");
        connect.setRhost("127.0.0.1");
        connect.setType("0");
        ClusterUtil.openCulter(connect);
        ClusterUtil.testClusterData();
    }
}

