/*
 * Decompiled with CFR 0.152.
 */
package com.maxbill.core.desktop;

import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class LogView {
    private static Stage logStage;
    private static TextArea logTextArea;

    public static void display() {
        logStage = new Stage();
        logStage.setTitle("RedisPlus");
        logStage.initStyle(StageStyle.TRANSPARENT);
        logStage.initModality(Modality.WINDOW_MODAL);
        logStage.setScene(new Scene((Parent)LogView.getLogMainBox(), 600.0, 600.0));
        logStage.getIcons().add((Object)new Image("/image/app02.png"));
        logStage.setResizable(false);
        logStage.setFullScreen(false);
        logStage.setAlwaysOnTop(false);
        logStage.centerOnScreen();
    }

    private static BorderPane getLogMainBox() {
        BorderPane mainBox = new BorderPane();
        mainBox.setId("log-main-box");
        mainBox.getStylesheets().add((Object)"/style/logview.css");
        mainBox.setTop((Node)LogView.getLogTopsView());
        mainBox.setCenter((Node)LogView.getLogBodyView());
        return mainBox;
    }

    private static GridPane getLogTopsView() {
        GridPane boxView = new GridPane();
        boxView.setId("log-tops-box");
        boxView.setHgap(10.0);
        Label boxTitle = new Label();
        Label boxImage = new Label();
        boxTitle.setText("\u65e5\u5fd7\u4fe1\u606f");
        boxTitle.setTranslateX(-15.0);
        boxImage.setId("log-tops-box-image");
        boxTitle.setId("log-tops-box-title");
        boxImage.setPrefSize(27.0, 23.0);
        boxView.add((Node)boxImage, 0, 0);
        boxView.add((Node)boxTitle, 1, 0);
        boxView.setPadding(new Insets(5.0));
        boxView.setAlignment(Pos.CENTER_LEFT);
        boxImage.setGraphic((Node)new ImageView(new Image("/image/system-log01.png")));
        GridPane.setHgrow((Node)boxTitle, (Priority)Priority.ALWAYS);
        return boxView;
    }

    private static TextArea getLogBodyView() {
        logTextArea = new TextArea();
        logTextArea.setId("log-body-box");
        logTextArea.setWrapText(true);
        logTextArea.setEditable(false);
        return logTextArea;
    }

    public static Stage getLogStage() {
        if (null == logStage) {
            LogView.display();
        }
        return logStage;
    }

    public static void setLogView(boolean isInfo, String info) {
        if (null == logStage) {
            LogView.display();
        }
        if (isInfo) {
            Platform.runLater(() -> logTextArea.appendText(info + "\r\n"));
        } else {
            Platform.runLater(() -> logTextArea.appendText(info));
        }
    }
}

