/*
 * Decompiled with CFR 0.152.
 */
package com.maxbill.core.desktop;

import com.maxbill.MainApplication;
import com.maxbill.base.controller.ConfController;
import com.maxbill.base.controller.ConnectController;
import com.maxbill.base.controller.DataClusterController;
import com.maxbill.base.controller.DataSinglesController;
import com.maxbill.base.controller.InfoClusterController;
import com.maxbill.base.controller.InfoSinglesController;
import com.maxbill.base.controller.OtherController;
import com.maxbill.core.desktop.LogView;
import com.maxbill.core.desktop.TopsMenu;
import com.maxbill.tool.DataUtil;
import com.maxbill.tool.FileUtil;
import com.sun.javafx.webkit.WebConsoleListener;
import java.io.File;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.geometry.Side;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import netscape.javascript.JSObject;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;

public class Desktop
extends Application {
    private double x = 0.0;
    private double y = 0.0;
    private double xOffset = 0.0;
    private double yOffset = 0.0;
    private double width = 0.0;
    private double height = 0.0;
    private double resizeWidth = 5.0;
    private double minWidth = 1000.0;
    private double minHeight = 600.0;
    private boolean isRight;
    private boolean isBottom;
    private boolean isBottomRight;
    private boolean isMax = false;
    private static Stage stage;
    private static WebView webView;
    private static GridPane topsView;
    private static WebEngine webEngine;
    private static BorderPane mainView;
    public static ConfigurableApplicationContext context;
    private static ConfController confController;
    private static OtherController otherController;
    private static ConnectController connectController;
    private static DataSinglesController dataSinglesController;
    private static DataClusterController dataClusterController;
    private static InfoSinglesController infoSinglesController;
    private static InfoClusterController infoClusterController;

    public void start(Stage winStage) {
        winStage.centerOnScreen();
        winStage.setTitle("RedisPlus");
        winStage.setAlwaysOnTop(false);
        winStage.initStyle(StageStyle.TRANSPARENT);
        winStage.getIcons().add((Object)new Image("/image/app02.png"));
        context = SpringApplication.run(MainApplication.class, (String[])new String[0]);
        if (null == context) {
            return;
        }
        this.initWebObject();
        otherController.initSystems();
        mainView = this.getMainView(winStage);
        winStage.setScene(new Scene((Parent)mainView, this.minWidth, this.minHeight));
        winStage.show();
        this.doWinStage(winStage);
        this.doWinRaise(winStage);
        this.doWinState(winStage, mainView);
        stage = winStage;
    }

    private BorderPane getMainView(Stage winStage) {
        BorderPane mainView = new BorderPane();
        mainView.setId("main-view");
        mainView.getStylesheets().add((Object)"/style/desktop.css");
        mainView.setTop((Node)this.getTopsView(winStage));
        mainView.setCenter((Node)this.getBodyView());
        mainView.setBottom((Node)this.getEndsView());
        return mainView;
    }

    private GridPane getTopsView(Stage winStage) {
        topsView = new GridPane();
        topsView.setId("tops-view");
        topsView.setHgap(10.0);
        Label topImage = new Label();
        Label topTitle = new Label();
        Label topItems = new Label();
        Label topAbate = new Label();
        Label topRaise = new Label();
        Label topClose = new Label();
        topTitle.setText("RedisPlus");
        topImage.setId("tops-view-image");
        topTitle.setId("tops-view-title");
        topItems.setId("tops-view-items");
        topAbate.setId("tops-view-abate");
        topRaise.setId("tops-view-raise");
        topClose.setId("tops-view-close");
        topImage.setPrefSize(27.0, 23.0);
        topItems.setPrefSize(27.0, 23.0);
        topAbate.setPrefSize(27.0, 23.0);
        topRaise.setPrefSize(27.0, 23.0);
        topClose.setPrefSize(27.0, 23.0);
        topsView.add((Node)topImage, 0, 0);
        topsView.add((Node)topTitle, 1, 0);
        topsView.add((Node)topItems, 2, 0);
        topsView.add((Node)topAbate, 3, 0);
        topsView.add((Node)topRaise, 4, 0);
        topsView.add((Node)topClose, 5, 0);
        topsView.setPadding(new Insets(5.0));
        topsView.setAlignment(Pos.CENTER_LEFT);
        GridPane.setHgrow((Node)topTitle, (Priority)Priority.ALWAYS);
        String themeColor = otherController.getSetting("theme-color");
        Color backgroundColor = Color.web((String)themeColor, (double)1.0);
        BackgroundFill backgroundFill = new BackgroundFill((Paint)backgroundColor, null, null);
        topsView.setBackground(new Background(new BackgroundFill[]{backgroundFill}));
        topItems.setOnMouseClicked(event -> this.doWinItems(topItems));
        topAbate.setOnMouseClicked(event -> this.doWinAbate(winStage));
        topRaise.setOnMouseClicked(event -> this.doWinRaise(winStage));
        topClose.setOnMouseClicked(event -> this.doWinClose(winStage));
        return topsView;
    }

    private WebView getBodyView() {
        Desktop.webView = new WebView();
        Desktop.webView.setCache(false);
        webEngine = Desktop.webView.getEngine();
        Desktop.webView.setContextMenuEnabled(true);
        webEngine.setJavaScriptEnabled(true);
        Desktop.webView.setFontSmoothingType(FontSmoothingType.GRAY);
        String rootPagePath = "";
        String connectTheme = otherController.getSetting("connect-theme");
        rootPagePath = !StringUtils.isEmpty((Object)connectTheme) && connectTheme.equals("1") ? "/page/connect-quicker.html" : "/page/connect-default.html";
        webEngine.load(Desktop.class.getResource(rootPagePath).toExternalForm());
        String basePath = System.getProperty("user.home");
        String dataPath = basePath + "/.redis_plus/temp";
        FileUtil.existsFile(dataPath);
        webEngine.setUserDataDirectory(new File(dataPath));
        Worker woker = webEngine.getLoadWorker();
        woker.stateProperty().addListener((obs, oldValue, newValue) -> {
            if (newValue == Worker.State.SUCCEEDED) {
                JSObject jsObject = (JSObject)webEngine.executeScript("window");
                jsObject.setMember("confRouter", confController);
                jsObject.setMember("otherRouter", otherController);
                jsObject.setMember("connectRouter", connectController);
                jsObject.setMember("dataSinglesRouter", dataSinglesController);
                jsObject.setMember("dataClusterRouter", dataClusterController);
                jsObject.setMember("infoSinglesRouter", infoSinglesController);
                jsObject.setMember("infoClusterRouter", infoClusterController);
            }
        });
        woker.exceptionProperty().addListener((ov, t0, t1) -> System.out.println("Received Exception: " + t1.getMessage()));
        WebConsoleListener.setDefaultListener((webView, message, lineNumber, sourceId) -> System.out.println("Console: [" + sourceId + ":" + lineNumber + "] " + message));
        return Desktop.webView;
    }

    private GridPane getEndsView() {
        GridPane endsView = new GridPane();
        endsView.setId("ends-view");
        endsView.setHgap(10.0);
        Label endImage = new Label();
        Label endTitle = new Label();
        Label endOther = new Label();
        Label endOrder = new Label();
        Label endDaily = new Label();
        endTitle.setMinWidth(200.0);
        endOrder.setMinWidth(150.0);
        endTitle.setText("\u672a\u8fde\u63a5\u5230\u670d\u52a1");
        endOrder.setText("Version 3.1.0");
        endImage.setId("ends-view-image");
        endTitle.setId("ends-view-title");
        endOther.setId("ends-view-other");
        endOrder.setId("ends-view-order");
        endDaily.setId("ends-view-daily");
        endImage.setPrefSize(27.0, 23.0);
        endTitle.setPrefSize(27.0, 23.0);
        endOther.setPrefSize(27.0, 23.0);
        endOrder.setPrefSize(27.0, 23.0);
        endDaily.setPrefSize(27.0, 23.0);
        endsView.add((Node)endImage, 0, 0);
        endsView.add((Node)endTitle, 1, 0);
        endsView.add((Node)endOther, 2, 0);
        endsView.add((Node)endOrder, 3, 0);
        endsView.add((Node)endDaily, 4, 0);
        endsView.setPadding(new Insets(3.0));
        endsView.setAlignment(Pos.BASELINE_RIGHT);
        endTitle.setTextFill(Paint.valueOf((String)"red"));
        endOrder.setTextFill(Paint.valueOf((String)"#1766A2"));
        endOrder.setAlignment(Pos.CENTER_RIGHT);
        endImage.setGraphic((Node)new ImageView(new Image("/image/connect-no.png")));
        endDaily.setGraphic((Node)new ImageView(new Image("/image/system-log01.png")));
        GridPane.setHgrow((Node)endTitle, (Priority)Priority.ALWAYS);
        endDaily.setOnMouseClicked(event -> {
            Boolean isLogOn = DataUtil.getOutLogWindowStatus();
            DataUtil.setOutLogWindowStatus(isLogOn == false);
            if (isLogOn.booleanValue()) {
                Desktop.setEndsViewDaily("/image/system-log01.png");
                LogView.getLogStage().hide();
            } else {
                Desktop.setEndsViewDaily("/image/system-log02.png");
                LogView.getLogStage().show();
            }
        });
        return endsView;
    }

    private void doWinStage(Stage winStage) {
        winStage.xProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && !this.isMax) {
                this.x = newValue.doubleValue();
            }
        });
        winStage.yProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && !this.isMax) {
                this.y = newValue.doubleValue();
            }
        });
        winStage.widthProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && !this.isMax) {
                this.width = newValue.doubleValue();
            }
        });
        winStage.heightProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && !this.isMax) {
                this.height = newValue.doubleValue();
            }
        });
    }

    private void doWinState(Stage winStage, BorderPane mainView) {
        mainView.setOnMouseMoved(event -> {
            event.consume();
            double tx = event.getSceneX();
            double ty = event.getSceneY();
            double tw = winStage.getWidth();
            double th = winStage.getHeight();
            Cursor cursorType = Cursor.DEFAULT;
            this.isBottom = false;
            this.isBottomRight = false;
            this.isRight = false;
            if (ty >= th - this.resizeWidth) {
                if (!(tx <= this.resizeWidth)) {
                    if (tx >= tw - this.resizeWidth) {
                        this.isBottomRight = true;
                        cursorType = Cursor.SE_RESIZE;
                    } else {
                        this.isBottom = true;
                        cursorType = Cursor.S_RESIZE;
                    }
                }
            } else if (tx >= tw - this.resizeWidth) {
                this.isRight = true;
                cursorType = Cursor.E_RESIZE;
            }
            mainView.setCursor(cursorType);
        });
        mainView.setOnMouseDragged(event -> {
            event.consume();
            if (this.yOffset != 0.0) {
                winStage.setX(event.getScreenX() - this.xOffset);
                if (event.getScreenY() - this.yOffset < 0.0) {
                    winStage.setY(0.0);
                } else {
                    winStage.setY(event.getScreenY() - this.yOffset);
                }
            }
            double tx = event.getSceneX();
            double ty = event.getSceneY();
            double nextX = winStage.getX();
            double nextY = winStage.getY();
            double nextWidth = winStage.getWidth();
            double nextHeight = winStage.getHeight();
            if (this.isRight || this.isBottomRight) {
                nextWidth = tx;
            }
            if (this.isBottomRight || this.isBottom) {
                nextHeight = ty;
            }
            if (nextWidth <= this.minWidth) {
                nextWidth = this.minWidth;
            }
            if (nextHeight <= this.minHeight) {
                nextHeight = this.minHeight;
            }
            winStage.setX(nextX);
            winStage.setY(nextY);
            winStage.setWidth(nextWidth);
            winStage.setHeight(nextHeight);
        });
        mainView.setOnMousePressed(event -> {
            event.consume();
            this.xOffset = event.getSceneX();
            this.yOffset = event.getSceneY() > 46.0 ? 0.0 : event.getSceneY();
        });
    }

    private void doWinItems(Label winItems) {
        TopsMenu.getInstance().show((Node)winItems, Side.BOTTOM, 5.0, 6.0);
    }

    private void doWinAbate(Stage winStage) {
        winStage.setIconified(true);
    }

    private void doWinRaise(Stage winStage) {
        Rectangle2D rectangle2d = Screen.getPrimary().getVisualBounds();
        boolean bl = this.isMax = !this.isMax;
        if (this.isMax) {
            winStage.setX(rectangle2d.getMinX());
            winStage.setY(rectangle2d.getMinY());
            winStage.setWidth(rectangle2d.getWidth());
            winStage.setHeight(rectangle2d.getHeight());
            webView.setPrefSize(rectangle2d.getWidth(), rectangle2d.getHeight());
        } else if (this.x == 0.0 && this.y == 0.0 && this.width == 0.0 && this.height == 0.0) {
            winStage.setWidth(this.minWidth);
            winStage.setHeight(this.minHeight);
            winStage.centerOnScreen();
            webView.setPrefSize(this.minWidth, this.minHeight);
        } else {
            winStage.setX(this.x);
            winStage.setY(this.y);
            winStage.setWidth(this.width);
            winStage.setHeight(this.height);
            webView.setPrefSize(this.width, this.height);
        }
    }

    private void doWinClose(Stage winStage) {
        winStage.close();
        Platform.exit();
        System.exit(0);
    }

    public static void setEndsViewTitle(String msg, String type) {
        Node node = mainView.getBottom();
        Label label = (Label)node.lookup("#ends-view-title");
        label.setText(msg);
        switch (type) {
            case "no": {
                label.setTextFill(Paint.valueOf((String)"red"));
                break;
            }
            case "ok": {
                label.setTextFill(Paint.valueOf((String)"green"));
            }
        }
    }

    public static void setEndsViewImage(String src) {
        Node node = mainView.getBottom();
        Label label = (Label)node.lookup("#ends-view-image");
        label.setGraphic((Node)new ImageView(new Image(src)));
    }

    public static void setEndsViewDaily(String src) {
        Node node = mainView.getBottom();
        Label label = (Label)node.lookup("#ends-view-daily");
        label.setGraphic((Node)new ImageView(new Image(src)));
    }

    public static void setWebViewPage(String url) {
        String utl = Desktop.class.getResource(url).toExternalForm();
        webEngine.load(utl);
    }

    public static Stage getRootStage() {
        return stage;
    }

    public static GridPane getTopsView() {
        return topsView;
    }

    private void initWebObject() {
        confController = (ConfController)context.getBean(ConfController.class);
        otherController = (OtherController)context.getBean(OtherController.class);
        connectController = (ConnectController)context.getBean(ConnectController.class);
        dataSinglesController = (DataSinglesController)context.getBean(DataSinglesController.class);
        dataClusterController = (DataClusterController)context.getBean(DataClusterController.class);
        infoSinglesController = (InfoSinglesController)context.getBean(InfoSinglesController.class);
        infoClusterController = (InfoClusterController)context.getBean(InfoClusterController.class);
    }

    static {
        context = null;
        confController = null;
        otherController = null;
        connectController = null;
        dataSinglesController = null;
        dataClusterController = null;
        infoSinglesController = null;
        infoClusterController = null;
    }
}

