/*
 * Decompiled with CFR 0.152.
 */
package com.maxbill.core.desktop;

import com.maxbill.MainApplication;
import com.maxbill.base.controller.OtherController;
import com.maxbill.core.desktop.Desktop;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.concurrent.Worker;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import netscape.javascript.JSObject;

public class AlertBox {
    public void display(String title) {
        Stage window = new Stage();
        window.setTitle("RedisPlus");
        window.initStyle(StageStyle.TRANSPARENT);
        window.initModality(Modality.APPLICATION_MODAL);
        window.setScene(new Scene((Parent)this.getMainBox(window, title), 600.0, 600.0));
        window.getIcons().add((Object)new Image("/image/app02.png"));
        window.setResizable(false);
        window.setFullScreen(false);
        window.setAlwaysOnTop(false);
        window.centerOnScreen();
        window.show();
    }

    private BorderPane getMainBox(Stage winStage, String title) {
        BorderPane mainBox = new BorderPane();
        mainBox.setId("main-box");
        mainBox.getStylesheets().add((Object)"/style/alertbox.css");
        String imgSrc = "";
        String htmlSrc = "";
        switch (title) {
            case "\u8bbe\u7f6e": {
                imgSrc = "/image/top-menu01.png";
                htmlSrc = "/page/alert-setting.html";
                break;
            }
            case "\u53cd\u9988": {
                imgSrc = "/image/top-menu02.png";
                htmlSrc = "/page/alert-advice.html";
                break;
            }
            case "\u5e2e\u52a9": {
                imgSrc = "/image/top-menu03.png";
                htmlSrc = "/page/alert-help.html";
                break;
            }
            case "\u7248\u672c": {
                imgSrc = "/image/top-menu04.png";
                htmlSrc = "/page/alert-version.html";
                break;
            }
            case "\u5173\u4e8e": {
                imgSrc = "/image/top-menu05.png";
                htmlSrc = "/page/alert-about.html";
            }
        }
        mainBox.setTop((Node)this.getTopsView(winStage, title, imgSrc));
        mainBox.setCenter((Node)this.getBodyView(title, htmlSrc));
        return mainBox;
    }

    private GridPane getTopsView(Stage winStage, String title, String imgSrc) {
        GridPane boxView = new GridPane();
        boxView.setId("tops-box");
        boxView.setHgap(10.0);
        Label boxTitle = new Label();
        Label boxImage = new Label();
        Label boxClose = new Label();
        boxTitle.setText(title);
        boxTitle.setTranslateX(-15.0);
        boxImage.setId("tops-box-image");
        boxTitle.setId("tops-box-title");
        boxClose.setId("tops-box-close");
        boxImage.setPrefSize(27.0, 23.0);
        boxClose.setPrefSize(27.0, 23.0);
        boxView.add((Node)boxImage, 0, 0);
        boxView.add((Node)boxTitle, 1, 0);
        boxView.add((Node)boxClose, 2, 0);
        boxView.setPadding(new Insets(5.0));
        boxView.setAlignment(Pos.CENTER_LEFT);
        boxImage.setGraphic((Node)new ImageView(new Image(imgSrc)));
        GridPane.setHgrow((Node)boxTitle, (Priority)Priority.ALWAYS);
        boxClose.setOnMouseClicked(event -> winStage.close());
        return boxView;
    }

    private VBox getBodyView(String title, String htmlSrc) {
        WebView webView = new WebView();
        webView.setCache(true);
        webView.setContextMenuEnabled(false);
        webView.setFontSmoothingType(FontSmoothingType.GRAY);
        WebEngine webEngine = webView.getEngine();
        webEngine.setJavaScriptEnabled(true);
        String url = Desktop.class.getResource(htmlSrc).toExternalForm();
        webEngine.load(url);
        ReadOnlyObjectProperty woker = webEngine.getLoadWorker().stateProperty();
        woker.addListener((obs, oldValue, newValue) -> {
            if (newValue == Worker.State.SUCCEEDED) {
                JSObject jsObject = (JSObject)webEngine.executeScript("window");
                OtherController otherController = (OtherController)MainApplication.context.getBean(OtherController.class);
                jsObject.setMember("otherRouter", otherController);
            }
        });
        return new VBox(new Node[]{webView});
    }
}

