/*
 * Decompiled with CFR 0.152.
 */
package com.maxbill.base.controller;

import com.maxbill.base.bean.Connect;
import com.maxbill.base.bean.ResultInfo;
import com.maxbill.base.bean.Setting;
import com.maxbill.base.service.DataService;
import com.maxbill.core.desktop.Desktop;
import com.maxbill.tool.DataUtil;
import com.maxbill.tool.KeyUtil;
import com.maxbill.tool.MailUtil;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class OtherController {
    @Autowired
    private DataService dataService;

    public void changeWebview(int pageNo) {
        Connect connect = DataUtil.getCurrentOpenConnect();
        String pageUrl = "";
        switch (pageNo) {
            case 1: {
                String connectTheme = this.getSetting("connect-theme");
                if (!StringUtils.isEmpty((Object)connectTheme) && connectTheme.equals("1")) {
                    pageUrl = "/page/connect-quicker.html";
                    break;
                }
                pageUrl = "/page/connect-default.html";
                break;
            }
            case 2: {
                if (connect.getIsha().equals("0")) {
                    pageUrl = "/page/data-singles.html";
                }
                if (!connect.getIsha().equals("1")) break;
                pageUrl = "/page/data-cluster.html";
                break;
            }
            case 3: {
                if (connect.getIsha().equals("0")) {
                    pageUrl = "/page/info-singles.html";
                }
                if (!connect.getIsha().equals("1")) break;
                pageUrl = "/page/info-cluster.html";
                break;
            }
            case 4: {
                if (connect.getIsha().equals("0")) {
                    pageUrl = "/page/conf-singles.html";
                }
                if (!connect.getIsha().equals("1")) break;
                pageUrl = "/page/conf-cluster.html";
                break;
            }
            case 5: {
                if (connect.getIsha().equals("0")) {
                    pageUrl = "/page/monitor-singles.html";
                }
                if (!connect.getIsha().equals("1")) break;
                pageUrl = "/page/monitor-cluster.html";
            }
        }
        Desktop.setWebViewPage(pageUrl);
    }

    public void initSystems() {
        try {
            int tableCount2;
            int tableCount1 = this.dataService.isExistsTable("T_CONNECT");
            if (tableCount1 == 0) {
                this.dataService.createConnectTable();
            }
            if ((tableCount2 = this.dataService.isExistsTable("T_SETTING")) == 0) {
                this.dataService.createSettingTable();
            }
            Setting setting01 = new Setting();
            setting01.setId(KeyUtil.getUUIDKey());
            setting01.setKeys("theme-color");
            setting01.setVals("#D6D6D7");
            this.dataService.insertSetting(setting01);
            Setting setting02 = new Setting();
            setting02.setId(KeyUtil.getUUIDKey());
            setting02.setKeys("connect-theme");
            setting02.setVals("0");
            this.dataService.insertSetting(setting02);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getSetting(String keys) {
        Setting setting = this.dataService.selectSetting(keys);
        if (null != setting) {
            return setting.getVals();
        }
        return null;
    }

    public String setSetting(String keys, String vals) {
        try {
            Setting setting = new Setting();
            setting.setKeys(keys);
            setting.setVals(vals);
            int flag = this.dataService.updateSetting(setting);
            if (flag == 1) {
                switch (keys) {
                    case "theme-color": {
                        Color backgroundColor = Color.web((String)vals, (double)1.0);
                        BackgroundFill backgroundFill = new BackgroundFill((Paint)backgroundColor, null, null);
                        Desktop.getTopsView().setBackground(new Background(new BackgroundFill[]{backgroundFill}));
                        break;
                    }
                    case "connect-theme": {
                        if (!StringUtils.isEmpty((Object)vals) && vals.equals("1")) {
                            Desktop.setWebViewPage("/page/connect-quicker.html");
                            break;
                        }
                        Desktop.setWebViewPage("/page/connect-default.html");
                    }
                }
                return ResultInfo.getOkByJson("\u4fee\u6539\u8bbe\u7f6e\u9879\u6210\u529f");
            }
            return ResultInfo.getNoByJson("\u4fee\u6539\u8bbe\u7f6e\u9879\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResultInfo.exception(e);
        }
    }

    public String sendMail(String mailAddr, String mailText) {
        try {
            boolean sendFlag = MailUtil.sendMail(mailAddr, mailText);
            if (sendFlag) {
                return ResultInfo.getOkByJson("\u53d1\u9001\u90ae\u4ef6\u6210\u529f");
            }
            return ResultInfo.getNoByJson("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25");
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }
}

