/*
 * Decompiled with CFR 0.152.
 */
package com.maxbill.base.controller;

import com.alibaba.fastjson.JSON;
import com.maxbill.base.bean.RedisInfo;
import com.maxbill.base.bean.ResultInfo;
import com.maxbill.tool.DataUtil;
import com.maxbill.tool.RedisUtil;
import com.maxbill.tool.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.util.Slowlog;

@Component
public class InfoSinglesController {
    public String getBaseInfo() {
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                return ResultInfo.getOkByJson(RedisUtil.getRedisInfoList(jedis));
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String getLogsInfo() {
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                List<Slowlog> logs = RedisUtil.getRedisLog(jedis);
                Collections.reverse(logs);
                return ResultInfo.getOkByJson(logs);
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String getMemInfo() {
        HashMap<String, Number> resultMap = new HashMap<String, Number>();
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                RedisInfo redisInfo = RedisUtil.getRedisInfo(jedis);
                String[] memory = redisInfo.getMemory().split("\n");
                String val01 = StringUtil.getValueString(":", memory[1]).replace("\r", "");
                String val02 = StringUtil.getValueString(":", memory[4]).replace("\r", "");
                resultMap.put("val01", Float.valueOf((float)Math.round(Float.valueOf(val01).floatValue() / 1048576.0f * 100.0f) / 100.0f));
                resultMap.put("val02", Float.valueOf((float)Math.round(Float.valueOf(val02).floatValue() / 1048576.0f * 100.0f) / 100.0f));
            } else {
                resultMap.put("val01", 0);
                resultMap.put("val02", 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            resultMap.put("val01", 0);
            resultMap.put("val02", 0);
        }
        return JSON.toJSONString(resultMap);
    }

    public String getCpuInfo() {
        HashMap<String, Number> resultMap = new HashMap<String, Number>();
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                RedisInfo redisInfo = RedisUtil.getRedisInfo(jedis);
                String[] cpu = redisInfo.getCpu().split("\n");
                String val01 = StringUtil.getValueString(":", cpu[1]).replace("\r", "");
                String val02 = StringUtil.getValueString(":", cpu[2]).replace("\r", "");
                resultMap.put("val01", Float.valueOf(val01));
                resultMap.put("val02", Float.valueOf(val02));
            } else {
                resultMap.put("val01", 0);
                resultMap.put("val02", 0);
            }
        }
        catch (Exception e) {
            resultMap.put("val01", 0);
            resultMap.put("val02", 0);
        }
        return JSON.toJSONString(resultMap);
    }

    public String getKeyInfo() {
        Long[] keys = new Long[16];
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                for (int i = 0; i < 16; ++i) {
                    keys[i] = RedisUtil.dbSize(jedis, i);
                }
            } else {
                for (int i = 0; i < 16; ++i) {
                    keys[i] = 0L;
                }
            }
        }
        catch (Exception e) {
            for (int i = 0; i < 16; ++i) {
                keys[i] = 0L;
            }
        }
        return JSON.toJSONString((Object)keys);
    }

    public String getNetInfo() {
        HashMap<String, Number> resultMap = new HashMap<String, Number>();
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                RedisInfo redisInfo = RedisUtil.getRedisInfo(jedis);
                String[] stats = redisInfo.getStats().split("\n");
                String val01 = StringUtil.getValueString(":", stats[6]).replace("\r", "");
                String val02 = StringUtil.getValueString(":", stats[7]).replace("\r", "");
                resultMap.put("val01", Float.valueOf(val01));
                resultMap.put("val02", Float.valueOf(val02));
            } else {
                resultMap.put("val01", 0);
                resultMap.put("val02", 0);
            }
        }
        catch (Exception e) {
            resultMap.put("val01", 0);
            resultMap.put("val02", 0);
        }
        return JSON.toJSONString(resultMap);
    }
}

