/*
 * Decompiled with CFR 0.152.
 */
package com.maxbill.base.controller;

import com.alibaba.fastjson.JSON;
import com.maxbill.base.bean.RedisInfo;
import com.maxbill.base.bean.RedisNode;
import com.maxbill.base.bean.ResultInfo;
import com.maxbill.tool.ClusterUtil;
import com.maxbill.tool.DataUtil;
import com.maxbill.tool.RedisUtil;
import com.maxbill.tool.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;

@Component
public class InfoClusterController {
    public String getBaseInfo() {
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                RedisInfo redisInfo = RedisUtil.getRedisInfoList(jedis);
                return ResultInfo.getOkByJson(redisInfo);
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String getNodeInfo() {
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                return ResultInfo.getOkByJson(ClusterUtil.getClusterRelation(jedis.clusterNodes()));
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String getMemInfo() {
        HashMap<String, Number> resultMap = new HashMap<String, Number>();
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                RedisInfo redisInfo = RedisUtil.getRedisInfo(jedis);
                String[] memory = redisInfo.getMemory().split("\n");
                String value01 = StringUtil.getValueString(":", memory[1]).replace("\r", "");
                String value02 = StringUtil.getValueString(":", memory[4]).replace("\r", "");
                resultMap.put("value01", Float.valueOf((float)Math.round(Float.valueOf(value01).floatValue() / 1048576.0f * 100.0f) / 100.0f));
                resultMap.put("value02", Float.valueOf((float)Math.round(Float.valueOf(value02).floatValue() / 1048576.0f * 100.0f) / 100.0f));
            } else {
                resultMap.put("value01", 0);
                resultMap.put("value02", 0);
            }
        }
        catch (Exception e) {
            resultMap.put("value01", 0);
            resultMap.put("value02", 0);
        }
        return JSON.toJSONString(resultMap);
    }

    public String getCpuInfo() {
        HashMap<String, Number> resultMap = new HashMap<String, Number>();
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                RedisInfo redisInfo = RedisUtil.getRedisInfo(jedis);
                String[] cpu = redisInfo.getCpu().split("\n");
                String value01 = StringUtil.getValueString(":", cpu[1]).replace("\r", "");
                String value02 = StringUtil.getValueString(":", cpu[2]).replace("\r", "");
                resultMap.put("value01", Float.valueOf(value01));
                resultMap.put("value02", Float.valueOf(value02));
            } else {
                resultMap.put("value01", 0);
                resultMap.put("value02", 0);
            }
        }
        catch (Exception e) {
            resultMap.put("value01", 0);
            resultMap.put("value02", 0);
        }
        return JSON.toJSONString(resultMap);
    }

    public String getKeyInfo() {
        HashMap<String, List> resultMap = new HashMap<String, List>();
        ArrayList<String> xdata = new ArrayList<String>();
        ArrayList<Long> ydata = new ArrayList<Long>();
        try {
            JedisCluster cluster = DataUtil.getJedisClusterObject();
            if (null != cluster) {
                List<RedisNode> nodeList = ClusterUtil.getClusterNode(DataUtil.getCurrentOpenConnect());
                Map<String, RedisNode> masterNode = ClusterUtil.getMasterNode(nodeList);
                Map clusterNodes = cluster.getClusterNodes();
                for (String nk : clusterNodes.keySet()) {
                    if (!masterNode.keySet().contains(nk)) continue;
                    Jedis jedis = ((JedisPool)clusterNodes.get(nk)).getResource();
                    xdata.add(nk.split(":")[1]);
                    ydata.add(jedis.dbSize());
                    jedis.close();
                }
                resultMap.put("xdata", xdata);
                resultMap.put("ydata", ydata);
            } else {
                resultMap.put("xdata", Collections.EMPTY_LIST);
                resultMap.put("ydata", Collections.EMPTY_LIST);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            resultMap.put("xdata", Collections.EMPTY_LIST);
            resultMap.put("ydata", Collections.EMPTY_LIST);
        }
        return JSON.toJSONString(resultMap);
    }

    public String getNetInfo() {
        HashMap<String, Number> resultMap = new HashMap<String, Number>();
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                RedisInfo redisInfo = RedisUtil.getRedisInfo(jedis);
                String[] stats = redisInfo.getStats().split("\n");
                String value01 = StringUtil.getValueString(":", stats[6]).replace("\r", "");
                String value02 = StringUtil.getValueString(":", stats[7]).replace("\r", "");
                resultMap.put("value01", Float.valueOf(value01));
                resultMap.put("value02", Float.valueOf(value02));
            } else {
                resultMap.put("value01", 0);
                resultMap.put("value02", 0);
            }
        }
        catch (Exception e) {
            resultMap.put("value01", 0);
            resultMap.put("value02", 0);
        }
        return JSON.toJSONString(resultMap);
    }
}

