/*
 * Decompiled with CFR 0.152.
 */
package com.maxbill.base.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.maxbill.base.bean.ResultInfo;
import com.maxbill.base.bean.ZTreeBean;
import com.maxbill.core.desktop.Desktop;
import com.maxbill.tool.DataUtil;
import com.maxbill.tool.DateUtil;
import com.maxbill.tool.FileUtil;
import com.maxbill.tool.KeyUtil;
import com.maxbill.tool.RedisUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;

@Component
public class DataSinglesController {
    public String treeInit() {
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                ArrayList<ZTreeBean> treeList = new ArrayList<ZTreeBean>();
                String role = jedis.info("server");
                for (int i = 0; i < 16; ++i) {
                    long dbSize = 0L;
                    if (i > 0 && role.contains("redis_mode:cluster")) break;
                    dbSize = role.contains("redis_mode:cluster") ? RedisUtil.dbSize(jedis, null) : RedisUtil.dbSize(jedis, i);
                    ZTreeBean zTreeBean = new ZTreeBean();
                    zTreeBean.setId(KeyUtil.getUUIDKey());
                    zTreeBean.setName("DB" + i + " (" + dbSize + ")");
                    zTreeBean.setPattern("");
                    zTreeBean.setParent(true);
                    zTreeBean.setCount(dbSize);
                    zTreeBean.setPage(1);
                    zTreeBean.setIndex(i);
                    treeList.add(zTreeBean);
                }
                return ResultInfo.getOkByJson(treeList);
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String likeInit(int index, String pattern) {
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                long keysCount = RedisUtil.getKeysCount(jedis, index, pattern);
                ZTreeBean ztreeBean = new ZTreeBean();
                ztreeBean.setId(KeyUtil.getUUIDKey());
                ztreeBean.setName("DB" + index + " (" + keysCount + ")");
                ztreeBean.setParent(true);
                ztreeBean.setCount(keysCount);
                ztreeBean.setPage(1);
                ztreeBean.setPattern(pattern);
                ztreeBean.setIndex(index);
                return ResultInfo.getOkByJson(ztreeBean);
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String treeData(String id, int index, int page, String pattern) {
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                List<ZTreeBean> treeList = RedisUtil.getKeyTree(jedis, index, id, pattern);
                int startIndex = (page - 1) * 50;
                int endIndex = page * 50;
                long count = RedisUtil.getKeysCount(jedis, index, pattern);
                if ((long)endIndex > count) {
                    endIndex = (int)count;
                }
                treeList = treeList.subList(startIndex, endIndex);
                return ResultInfo.getOkByJson(treeList);
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String keysData(int index, String keys, String order) {
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                if (RedisUtil.existsKey(jedis, index, keys)) {
                    return ResultInfo.getOkByJson(RedisUtil.getKeyInfo(jedis, index, keys, order));
                }
                return ResultInfo.getNoByJson("\u8be5KEY\u4e0d\u5b58\u5728");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String renameKey(int index, String oldKey, String newKey) {
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                if (RedisUtil.existsKey(jedis, index, oldKey)) {
                    if (!RedisUtil.existsKey(jedis, index, newKey)) {
                        RedisUtil.renameKey(jedis, index, oldKey, newKey);
                        return ResultInfo.getOkByJson("\u91cd\u547d\u540dKEY\u6210\u529f");
                    }
                    return ResultInfo.getNoByJson("\u8be5KEY\u5df2\u5b58\u5728");
                }
                return ResultInfo.getNoByJson("\u8be5KEY\u4e0d\u5b58\u5728");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String retimeKey(int index, String key, int time) {
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                if (RedisUtil.existsKey(jedis, index, key)) {
                    RedisUtil.retimeKey(jedis, index, key, time);
                    return ResultInfo.getOkByJson("\u8bbe\u7f6eTTL\u6210\u529f");
                }
                return ResultInfo.getNoByJson("\u8be5KEY\u4e0d\u5b58\u5728");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String deleteKey(int index, String key) {
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                if (RedisUtil.existsKey(jedis, index, key)) {
                    RedisUtil.deleteKey(jedis, index, key);
                    return ResultInfo.getOkByJson("\u5220\u9664KEY\u6210\u529f");
                }
                return ResultInfo.getNoByJson("\u8be5KEY\u4e0d\u5b58\u5728");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String updateStr(int index, String key, String val) {
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                if (RedisUtil.existsKey(jedis, index, key)) {
                    RedisUtil.updateStr(jedis, index, key, val);
                    return ResultInfo.getOkByJson("\u4fee\u6539\u6570\u636e\u6210\u529f");
                }
                return ResultInfo.getNoByJson("\u8be5KEY\u4e0d\u5b58\u5728");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String insertVal(int type, int index, String key, String val, double score) {
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                if (RedisUtil.existsKey(jedis, index, key)) {
                    switch (type) {
                        case 1: {
                            RedisUtil.insertSet(jedis, index, key, val);
                            break;
                        }
                        case 2: {
                            RedisUtil.insertZset(jedis, index, key, val, score);
                            break;
                        }
                        case 3: {
                            RedisUtil.insertList(jedis, index, key, val);
                            break;
                        }
                        case 4: {
                            String[] valArray = val.split(":");
                            String mapKey = valArray[0];
                            String mapVal = valArray[1];
                            RedisUtil.insertHash(jedis, index, key, mapKey, mapVal);
                        }
                    }
                    return ResultInfo.getOkByJson("\u6dfb\u52a0\u6570\u636e\u6210\u529f");
                }
                return ResultInfo.getNoByJson("\u8be5KEY\u4e0d\u5b58\u5728");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String deleteVal(int type, int index, String key, String val) {
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                if (RedisUtil.existsKey(jedis, index, key)) {
                    switch (type) {
                        case 1: {
                            RedisUtil.deleteSet(jedis, index, key, val);
                            break;
                        }
                        case 2: {
                            RedisUtil.deleteZset(jedis, index, key, val);
                            break;
                        }
                        case 3: {
                            long keyIndex = Long.parseLong(val);
                            RedisUtil.deleteList(jedis, index, key, keyIndex);
                            break;
                        }
                        case 4: {
                            String mapKey = val;
                            RedisUtil.deleteHash(jedis, index, key, mapKey);
                        }
                    }
                    return ResultInfo.getOkByJson("\u5220\u9664\u6570\u636e\u6210\u529f");
                }
                return ResultInfo.getNoByJson("\u8be5KEY\u4e0d\u5b58\u5728");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String updateVal(String json) {
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                JSONObject data = JSON.parseObject((String)json);
                Integer type = data.getInteger("type");
                Integer index = data.getInteger("index");
                String key = data.getString("key");
                if (RedisUtil.existsKey(jedis, index, key)) {
                    switch (type) {
                        case 1: {
                            String oldVal = data.getString("oldVal");
                            String newVal = data.getString("newVal");
                            RedisUtil.deleteSet(jedis, index, key, oldVal);
                            RedisUtil.insertSet(jedis, index, key, newVal);
                            break;
                        }
                        case 2: {
                            String oldZval = data.getString("oldVal");
                            String newZval = data.getString("newVal");
                            Integer score = data.getInteger("score");
                            RedisUtil.deleteZset(jedis, index, key, oldZval);
                            RedisUtil.insertZset(jedis, index, key, newZval, score.intValue());
                            break;
                        }
                        case 3: {
                            Integer itemIndex = data.getInteger("itemIndex");
                            String val = data.getString("val");
                            RedisUtil.updateList(jedis, index, key, itemIndex, val);
                            break;
                        }
                        case 4: {
                            String oldMapKey = data.getString("oldKey");
                            String newMapKey = data.getString("newKey");
                            String newMapVal = data.getString("newVal");
                            RedisUtil.deleteHash(jedis, index, key, oldMapKey);
                            RedisUtil.insertHash(jedis, index, key, newMapKey, newMapVal);
                        }
                    }
                    return ResultInfo.getOkByJson("\u4fee\u6539\u6570\u636e\u6210\u529f");
                }
                return ResultInfo.getNoByJson("\u8be5KEY\u4e0d\u5b58\u5728");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String insertKey(int type, int index, String key, String val, int time, double score) {
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                switch (type) {
                    case 1: {
                        RedisUtil.insertSet(jedis, index, key, val);
                        break;
                    }
                    case 2: {
                        RedisUtil.insertZset(jedis, index, key, val, score);
                        break;
                    }
                    case 3: {
                        RedisUtil.insertList(jedis, index, key, val);
                        break;
                    }
                    case 4: {
                        String[] valArray = val.split(":");
                        String mapKey = valArray[0];
                        String mapVal = valArray[1];
                        RedisUtil.insertHash(jedis, index, key, mapKey, mapVal);
                        break;
                    }
                    case 5: {
                        RedisUtil.insertStr(jedis, index, key, val);
                    }
                }
                if (time != -1) {
                    RedisUtil.retimeKey(jedis, index, key, time);
                }
                return ResultInfo.getOkByJson("\u65b0\u589e\u6570\u636e\u6210\u529f");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String removeKey(int index) {
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                jedis.select(index);
                jedis.flushDB();
                return ResultInfo.getOkByJson("\u6e05\u7a7a\u6570\u636e\u6210\u529f");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String backupKey(int index, String pattern) {
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                String baseUrl = System.getProperty("user.home");
                String fileName = "redisplus-dbdata-" + DateUtil.formatDate(new Date(), "yyyy-MM-dd-HH:mm:ss") + ".bak";
                String filePath = baseUrl + "/" + fileName;
                boolean flag = FileUtil.writeStringToFile(filePath, RedisUtil.backupKey(jedis, index, pattern));
                if (flag) {
                    return ResultInfo.getOkByJson("\u6570\u636e\u6210\u529f\u5bfc\u51fa\u81f3\u5f53\u524d\u7528\u6237\u76ee\u5f55\u4e2d");
                }
                return ResultInfo.getNoByJson("\u5bfc\u51fa\u6570\u636e\u5931\u8d25");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String recoveKey(int index) {
        try {
            Jedis jedis = DataUtil.getCurrentJedisObject();
            if (null != jedis) {
                FileChooser fileChooser = new FileChooser();
                File file = fileChooser.showOpenDialog((Window)Desktop.getRootStage());
                if (null != file) {
                    RedisUtil.recoveKey(jedis, index, FileUtil.readFileToString(file.toString()));
                    return ResultInfo.getOkByJson("\u8fd8\u539f\u6570\u636e\u6210\u529f");
                }
                return ResultInfo.getNoByJson("\u53d6\u6d88\u8fd8\u539f\u64cd\u4f5c");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }
}

