/*
 * Decompiled with CFR 0.152.
 */
package com.maxbill.base.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.maxbill.base.bean.RedisNode;
import com.maxbill.base.bean.ResultInfo;
import com.maxbill.base.bean.ZTreeBean;
import com.maxbill.core.desktop.Desktop;
import com.maxbill.tool.ClusterUtil;
import com.maxbill.tool.DataUtil;
import com.maxbill.tool.DateUtil;
import com.maxbill.tool.FileUtil;
import com.maxbill.tool.KeyUtil;
import com.maxbill.tool.RedisUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;

@Component
public class DataClusterController {
    public String nodeInfo() {
        try {
            List<RedisNode> nodeList = ClusterUtil.getClusterNode(DataUtil.getCurrentOpenConnect());
            if (null != nodeList) {
                return ResultInfo.getOkByJson(nodeList);
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String treeInit() {
        try {
            JedisCluster cluster = ClusterUtil.openCulter(DataUtil.getCurrentOpenConnect());
            if (null != cluster) {
                List<RedisNode> nodeList = ClusterUtil.getClusterNode(DataUtil.getCurrentOpenConnect());
                Map<String, RedisNode> masterNode = ClusterUtil.getMasterNode(nodeList);
                Map clusterNodes = cluster.getClusterNodes();
                long total = 0L;
                for (String nk : clusterNodes.keySet()) {
                    if (!masterNode.keySet().contains(nk)) continue;
                    Jedis jedis = ((JedisPool)clusterNodes.get(nk)).getResource();
                    total += jedis.dbSize().longValue();
                }
                ZTreeBean ztreeBean = new ZTreeBean();
                ztreeBean.setId(KeyUtil.getUUIDKey());
                ztreeBean.setName("\u5168\u90e8\u96c6\u7fa4\u8282\u70b9\u7684KEY(" + total + ")");
                ztreeBean.setPattern("");
                ztreeBean.setParent(true);
                ztreeBean.setCount(total);
                ztreeBean.setPage(1);
                ztreeBean.setIndex(0);
                return ResultInfo.getOkByJson(ztreeBean);
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String likeInit(String pattern) {
        try {
            JedisCluster cluster = ClusterUtil.openCulter(DataUtil.getCurrentOpenConnect());
            if (null != cluster) {
                if (StringUtils.isEmpty((Object)pattern)) {
                    pattern = "*";
                }
                List<RedisNode> nodeList = ClusterUtil.getClusterNode(DataUtil.getCurrentOpenConnect());
                Map<String, RedisNode> masterNode = ClusterUtil.getMasterNode(nodeList);
                Map clusterNodes = cluster.getClusterNodes();
                long total = 0L;
                for (String nk : clusterNodes.keySet()) {
                    if (!masterNode.keySet().contains(nk)) continue;
                    Jedis jedis = ((JedisPool)clusterNodes.get(nk)).getResource();
                    total += (long)jedis.keys(pattern).size();
                    RedisUtil.closeJedis(jedis);
                }
                ZTreeBean ztreeBean = new ZTreeBean();
                ztreeBean.setId(KeyUtil.getUUIDKey());
                ztreeBean.setName("\u5168\u90e8\u96c6\u7fa4\u8282\u70b9\u7684KEY(" + total + ")");
                ztreeBean.setPattern(pattern);
                ztreeBean.setParent(true);
                ztreeBean.setCount(total);
                ztreeBean.setPage(1);
                ztreeBean.setIndex(0);
                return ResultInfo.getOkByJson(ztreeBean);
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String treeData(String id, int page, String pattern) {
        try {
            JedisCluster cluster = DataUtil.getJedisClusterObject();
            if (null != cluster) {
                if (StringUtils.isEmpty((Object)pattern)) {
                    pattern = "*";
                }
                List<RedisNode> nodeList = ClusterUtil.getClusterNode(DataUtil.getCurrentOpenConnect());
                Map<String, RedisNode> masterNode = ClusterUtil.getMasterNode(nodeList);
                Map clusterNodes = cluster.getClusterNodes();
                ArrayList<ZTreeBean> treeList = new ArrayList<ZTreeBean>();
                List keyList = new ArrayList();
                long count = 0L;
                for (String nk : clusterNodes.keySet()) {
                    if (!masterNode.keySet().contains(nk)) continue;
                    Jedis jedis = ((JedisPool)clusterNodes.get(nk)).getResource();
                    keyList.addAll(jedis.keys(pattern));
                    count += (long)jedis.keys(pattern).size();
                    RedisUtil.closeJedis(jedis);
                }
                int startIndex = (page - 1) * 50;
                int endIndex = page * 50;
                if ((long)endIndex > count) {
                    endIndex = (int)count;
                }
                if (!(keyList = keyList.subList(startIndex, endIndex)).isEmpty()) {
                    for (String key : keyList) {
                        ZTreeBean zTreeBean = new ZTreeBean();
                        zTreeBean.setId(KeyUtil.getUUIDKey());
                        zTreeBean.setPId(id);
                        zTreeBean.setName(key);
                        zTreeBean.setParent(false);
                        zTreeBean.setIcon("../image/data-01.png");
                        treeList.add(zTreeBean);
                    }
                }
                return ResultInfo.getOkByJson(treeList);
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String keysData(String key, String order) {
        try {
            JedisCluster cluster = DataUtil.getJedisClusterObject();
            if (null != cluster) {
                if (ClusterUtil.existsKey(cluster, key)) {
                    return ResultInfo.getOkByJson(ClusterUtil.getKeyInfo(cluster, key, order));
                }
                return ResultInfo.getNoByJson("\u8be5key\u4e0d\u5b58\u5728");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String renameKey(String oldKey, String newKey) {
        try {
            JedisCluster cluster = DataUtil.getJedisClusterObject();
            if (null != cluster) {
                if (ClusterUtil.existsKey(cluster, oldKey)) {
                    if (!ClusterUtil.existsKey(cluster, newKey)) {
                        ClusterUtil.renameKey(cluster, oldKey, newKey);
                        return ResultInfo.getOkByJson("\u91cd\u547d\u540dKEY\u6210\u529f");
                    }
                    return ResultInfo.getNoByJson("\u8be5KEY\u5df2\u5b58\u5728");
                }
                return ResultInfo.getNoByJson("\u8be5KEY\u4e0d\u5b58\u5728");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String retimeKey(String key, int time) {
        try {
            JedisCluster cluster = DataUtil.getJedisClusterObject();
            if (null != cluster) {
                if (ClusterUtil.existsKey(cluster, key)) {
                    ClusterUtil.retimeKey(cluster, key, time);
                    return ResultInfo.getOkByJson("\u8bbe\u7f6eKEY\u5931\u6548\u65f6\u95f4\u6210\u529f");
                }
                return ResultInfo.getNoByJson("\u8be5KEY\u4e0d\u5b58\u5728");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String deleteKey(String key) {
        try {
            JedisCluster cluster = DataUtil.getJedisClusterObject();
            if (null != cluster) {
                if (ClusterUtil.existsKey(cluster, key)) {
                    ClusterUtil.deleteKey(cluster, key);
                    return ResultInfo.getOkByJson("\u5220\u9664KEY\u6210\u529f");
                }
                return ResultInfo.getNoByJson("\u8be5KEY\u4e0d\u5b58\u5728");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String updateStr(String key, String val) {
        try {
            JedisCluster cluster = DataUtil.getJedisClusterObject();
            if (null != cluster) {
                if (ClusterUtil.existsKey(cluster, key)) {
                    ClusterUtil.updateStr(cluster, key, val);
                    return ResultInfo.getOkByJson("\u4fee\u6539\u6570\u636e\u6210\u529f");
                }
                return ResultInfo.getNoByJson("\u8be5KEY\u4e0d\u5b58\u5728");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String insertVal(int type, String key, String val, double score) {
        try {
            JedisCluster cluster = DataUtil.getJedisClusterObject();
            if (null != cluster) {
                if (ClusterUtil.existsKey(cluster, key)) {
                    switch (type) {
                        case 1: {
                            ClusterUtil.insertSet(cluster, key, val);
                            break;
                        }
                        case 2: {
                            ClusterUtil.insertZset(cluster, key, val, score);
                            break;
                        }
                        case 3: {
                            ClusterUtil.insertList(cluster, key, val);
                            break;
                        }
                        case 4: {
                            String[] valArray = val.split(":");
                            String mapKey = valArray[0];
                            String mapVal = valArray[1];
                            ClusterUtil.insertHash(cluster, key, mapKey, mapVal);
                        }
                    }
                    return ResultInfo.getOkByJson("\u6dfb\u52a0\u6570\u636e\u6210\u529f");
                }
                return ResultInfo.getNoByJson("\u8be5KEY\u4e0d\u5b58\u5728");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String deleteVal(int type, String key, String val) {
        try {
            JedisCluster cluster = DataUtil.getJedisClusterObject();
            if (null != cluster) {
                if (ClusterUtil.existsKey(cluster, key)) {
                    switch (type) {
                        case 1: {
                            ClusterUtil.deleteSet(cluster, key, val);
                            break;
                        }
                        case 2: {
                            ClusterUtil.deleteZset(cluster, key, val);
                            break;
                        }
                        case 3: {
                            long keyIndex = Long.parseLong(val);
                            ClusterUtil.deleteList(cluster, key, keyIndex);
                            break;
                        }
                        case 4: {
                            String mapKey = val;
                            ClusterUtil.deleteHash(cluster, key, mapKey);
                        }
                    }
                    return ResultInfo.getOkByJson("\u5220\u9664\u6570\u636e\u6210\u529f");
                }
                return ResultInfo.getNoByJson("\u8be5KEY\u4e0d\u5b58\u5728");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String updateVal(String json) {
        try {
            JedisCluster cluster = DataUtil.getJedisClusterObject();
            if (null != cluster) {
                JSONObject data = JSON.parseObject((String)json);
                Integer type = data.getInteger("type");
                String key = data.getString("key");
                if (ClusterUtil.existsKey(cluster, key)) {
                    switch (type) {
                        case 1: {
                            String oldVal = data.getString("oldVal");
                            String newVal = data.getString("newVal");
                            ClusterUtil.deleteSet(cluster, key, oldVal);
                            ClusterUtil.insertSet(cluster, key, newVal);
                            break;
                        }
                        case 2: {
                            String oldZval = data.getString("oldVal");
                            String newZval = data.getString("newVal");
                            Integer score = data.getInteger("score");
                            ClusterUtil.deleteZset(cluster, key, oldZval);
                            ClusterUtil.insertZset(cluster, key, newZval, score.intValue());
                            break;
                        }
                        case 3: {
                            Integer itemIndex = data.getInteger("itemIndex");
                            String val = data.getString("val");
                            ClusterUtil.updateList(cluster, key, itemIndex, val);
                            break;
                        }
                        case 4: {
                            String oldMapKey = data.getString("oldKey");
                            String newMapKey = data.getString("newKey");
                            String newMapVal = data.getString("newVal");
                            ClusterUtil.deleteHash(cluster, key, oldMapKey);
                            ClusterUtil.insertHash(cluster, key, newMapKey, newMapVal);
                        }
                    }
                    return ResultInfo.getOkByJson("\u4fee\u6539\u6570\u636e\u6210\u529f");
                }
                return ResultInfo.getNoByJson("\u8be5KEY\u4e0d\u5b58\u5728");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String insertKey(int type, String key, String val, int time, double score) {
        try {
            JedisCluster cluster = DataUtil.getJedisClusterObject();
            if (null != cluster) {
                switch (type) {
                    case 1: {
                        ClusterUtil.insertSet(cluster, key, val);
                        break;
                    }
                    case 2: {
                        ClusterUtil.insertZset(cluster, key, val, score);
                        break;
                    }
                    case 3: {
                        ClusterUtil.insertList(cluster, key, val);
                        break;
                    }
                    case 4: {
                        String[] valArray = val.split(":");
                        String mapKey = valArray[0];
                        String mapVal = valArray[1];
                        ClusterUtil.insertHash(cluster, key, mapKey, mapVal);
                        break;
                    }
                    case 5: {
                        cluster.set(key, val);
                    }
                }
                if (time != -1) {
                    ClusterUtil.retimeKey(cluster, key, time);
                }
                return ResultInfo.getOkByJson("\u65b0\u589e\u6570\u636e\u6210\u529f");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String removeKey() {
        try {
            JedisCluster cluster = DataUtil.getJedisClusterObject();
            if (null != cluster) {
                List<RedisNode> nodeList = ClusterUtil.getClusterNode(DataUtil.getCurrentOpenConnect());
                Map<String, RedisNode> masterNode = ClusterUtil.getMasterNode(nodeList);
                Map clusterNodes = cluster.getClusterNodes();
                for (String nk : clusterNodes.keySet()) {
                    if (!masterNode.keySet().contains(nk)) continue;
                    Jedis jedis = ((JedisPool)clusterNodes.get(nk)).getResource();
                    jedis.flushDB();
                    jedis.close();
                }
                return ResultInfo.getOkByJson("\u6e05\u7a7a\u6570\u636e\u6210\u529f");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String backupKey(String pattern) {
        try {
            JedisCluster cluster = DataUtil.getJedisClusterObject();
            if (null != cluster) {
                List<RedisNode> nodeList = ClusterUtil.getClusterNode(DataUtil.getCurrentOpenConnect());
                Map<String, RedisNode> masterNode = ClusterUtil.getMasterNode(nodeList);
                Map clusterNodes = cluster.getClusterNodes();
                StringBuffer dataBuffer = new StringBuffer("");
                String baseUrl = System.getProperty("user.home");
                String fileName = "redisplus-dbdata-" + DateUtil.formatDate(new Date(), "yyyy-MM-dd-HH:mm:ss") + ".bak";
                String filePath = baseUrl + "/" + fileName;
                for (String nk : clusterNodes.keySet()) {
                    if (!masterNode.keySet().contains(nk)) continue;
                    Jedis jedis = ((JedisPool)clusterNodes.get(nk)).getResource();
                    dataBuffer.append(ClusterUtil.backupKey(jedis, pattern));
                    jedis.close();
                }
                boolean expFlag = FileUtil.writeStringToFile(filePath, dataBuffer.toString());
                if (expFlag) {
                    return ResultInfo.getOkByJson("\u5404\u4e2a\u8282\u70b9\u6570\u636e\u6210\u529f\u5bfc\u51fa\u81f3\u5f53\u524d\u7528\u6237\u76ee\u5f55\u4e2d");
                }
                return ResultInfo.getNoByJson("\u5bfc\u51fa\u6570\u636e\u5931\u8d25");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String recoveKey() {
        try {
            JedisCluster cluster = DataUtil.getJedisClusterObject();
            if (null != cluster) {
                FileChooser fileChooser = new FileChooser();
                File file = fileChooser.showOpenDialog((Window)Desktop.getRootStage());
                if (null != file) {
                    ClusterUtil.recoveKey(cluster, FileUtil.readFileToString(file.toString()));
                    return ResultInfo.getOkByJson("\u8fd8\u539f\u6570\u636e\u6210\u529f");
                }
                return ResultInfo.getNoByJson("\u53d6\u6d88\u8fd8\u539f\u64cd\u4f5c");
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }
}

