/*
 * Decompiled with CFR 0.152.
 */
package com.maxbill.base.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.maxbill.base.bean.Connect;
import com.maxbill.base.bean.ResultInfo;
import com.maxbill.base.service.DataService;
import com.maxbill.core.desktop.Desktop;
import com.maxbill.core.desktop.LogView;
import com.maxbill.tool.ClusterUtil;
import com.maxbill.tool.DataUtil;
import com.maxbill.tool.DateUtil;
import com.maxbill.tool.FileUtil;
import com.maxbill.tool.JschUtil;
import com.maxbill.tool.LogUtil;
import com.maxbill.tool.RedisUtil;
import com.maxbill.tool.TelnetUtil;
import java.io.File;
import java.util.Date;
import java.util.List;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;

@Component
public class ConnectController {
    @Autowired
    private DataService dataService;

    public String selectConnect() {
        LogView.setLogView(true, "\u67e5\u8be2\u8fde\u63a5\u6570\u636e\u4e2d...");
        return JSON.toJSONString(this.dataService.selectConnect());
    }

    public String insertConnect(String json) {
        try {
            int insFlag = this.dataService.insertConnect(this.parsedConnect(json));
            if (insFlag == 1) {
                return ResultInfo.getOkByJson("\u65b0\u589e\u8fde\u63a5\u6210\u529f");
            }
            return ResultInfo.getNoByJson("\u65b0\u589e\u8fde\u63a5\u5931\u8d25");
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String updateConnect(String json) {
        try {
            int updFlag = this.dataService.updateConnect(this.parsedConnect(json));
            if (updFlag == 1) {
                return ResultInfo.getOkByJson("\u4fee\u6539\u8fde\u63a5\u6210\u529f");
            }
            return ResultInfo.getNoByJson("\u4fee\u6539\u8fde\u63a5\u5931\u8d25");
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String deleteConnect(String id) {
        try {
            int delFlag = this.dataService.deleteConnectById(id);
            if (delFlag == 1) {
                return ResultInfo.getOkByJson("\u5220\u9664\u8fde\u63a5\u6210\u529f");
            }
            return ResultInfo.getNoByJson("\u5220\u9664\u8fde\u63a5\u5931\u8d25");
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String querysConnect(String id) {
        return JSON.toJSONString((Object)this.dataService.selectConnectById(id));
    }

    public String createConnect(Boolean toData, String id) {
        try {
            JedisCluster oldCluster;
            Connect connect = this.dataService.selectConnectById(id);
            if ("1".equals(connect.getType())) {
                JschUtil.openSSH(connect);
            }
            if (connect.getIsha().equals("0")) {
                Jedis jedis = RedisUtil.openJedis(connect);
                if (null != jedis) {
                    JedisCluster oldCluster2;
                    Jedis oldJedis = DataUtil.getCurrentJedisObject();
                    if (null != oldJedis && oldJedis.isConnected()) {
                        oldJedis.close();
                    }
                    if (null != (oldCluster2 = DataUtil.getJedisClusterObject())) {
                        oldCluster2.close();
                    }
                    DataUtil.setConfig("currentOpenConnect", connect);
                    DataUtil.setConfig("currentJedisObject", jedis);
                    Desktop.setEndsViewTitle("\u5df2\u6210\u529f\u8fde\u63a5\u5230\uff1a" + connect.getText(), "ok");
                    Desktop.setEndsViewImage("/image/connect-ok.png");
                    if (toData.booleanValue()) {
                        Desktop.setWebViewPage("/page/data-singles.html");
                    }
                    return ResultInfo.getOkByJson("\u6253\u5f00\u8fde\u63a5\u6210\u529f");
                }
                return ResultInfo.getNoByJson("\u6253\u5f00\u8fde\u63a5\u5931\u8d25");
            }
            JedisCluster cluster = ClusterUtil.openCulter(connect);
            if (null == cluster || cluster.getClusterNodes().size() == 0) {
                return ResultInfo.getNoByJson("\u6253\u5f00\u8fde\u63a5\u5931\u8d25");
            }
            Jedis oldJedis = DataUtil.getCurrentJedisObject();
            if (null != oldJedis && oldJedis.isConnected()) {
                oldJedis.close();
            }
            if (null != (oldCluster = DataUtil.getJedisClusterObject())) {
                oldCluster.close();
            }
            DataUtil.setConfig("currentOpenConnect", connect);
            DataUtil.setConfig("jedisClusterObject", cluster);
            DataUtil.setConfig("currentJedisObject", ClusterUtil.getMasterSelf());
            Desktop.setEndsViewTitle("\u5df2\u6210\u529f\u8fde\u63a5\u5230\uff1a" + connect.getText(), "ok");
            Desktop.setEndsViewImage("/image/connect-ok.png");
            if (toData.booleanValue()) {
                Desktop.setWebViewPage("/page/data-cluster.html");
            }
            return ResultInfo.getOkByJson("\u6253\u5f00\u8fde\u63a5\u6210\u529f");
        }
        catch (Exception e) {
            LogUtil.setLogException(e);
            String msg = e.getMessage();
            if (msg.contains("connect failed")) {
                return ResultInfo.getNoByJson("\u7f51\u7edc\u4e0d\u53ef\u8fbe");
            }
            if (msg.contains("invalid password")) {
                return ResultInfo.getNoByJson("\u5bc6\u7801\u4e0d\u6b63\u786e");
            }
            if (msg.contains("connect timed out")) {
                return ResultInfo.getNoByJson("\u8bf7\u6c42\u670d\u52a1\u8d85\u65f6");
            }
            if (msg.contains("Connection refused")) {
                return ResultInfo.getNoByJson("\u670d\u52a1\u62d2\u7edd\u8fde\u63a5");
            }
            if (msg.contains("Authentication required")) {
                return ResultInfo.getNoByJson("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (msg.contains("Could not get a resource")) {
                return ResultInfo.getNoByJson("\u8bf7\u68c0\u67e5\u670d\u52a1\u72b6\u6001");
            }
            if (msg.contains("socket is not established")) {
                return ResultInfo.getNoByJson("\u6253\u5f00SSH\u8fde\u63a5\u8d85\u65f6");
            }
            return ResultInfo.getNoByJson("\u6253\u5f00\u8fde\u63a5\u5931\u8d25");
        }
    }

    public String disconConnect(String id) {
        try {
            Connect connect = DataUtil.getCurrentOpenConnect();
            if (connect.getIsha().equals("0")) {
                Jedis jedis = RedisUtil.openJedis(connect);
                if (null != jedis) {
                    RedisUtil.closeJedis(jedis);
                    DataUtil.clearConfig();
                }
            } else {
                ClusterUtil.closeCulter();
                DataUtil.clearConfig();
            }
            Desktop.setEndsViewTitle("\u672a\u8fde\u63a5\u5230\u670d\u52a1", "no");
            Desktop.setEndsViewImage("/image/connect-no.png");
            return ResultInfo.getOkByJson("\u5173\u95ed\u8fde\u63a5\u6210\u529f");
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public Integer isopenConnect(String id) {
        Connect connect = DataUtil.getCurrentOpenConnect();
        if (null != connect) {
            if (!StringUtils.isEmpty((Object)id) && !connect.getId().equals(id)) {
                return 0;
            }
            if (connect.getIsha().equals("0")) {
                Jedis jedis = DataUtil.getCurrentJedisObject();
                if (null != jedis) {
                    return 1;
                }
                return 0;
            }
            JedisCluster jedisCluster = DataUtil.getJedisClusterObject();
            if (null != jedisCluster) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public String pickedConnect() {
        return JSON.toJSONString((Object)DataUtil.getCurrentOpenConnect());
    }

    public String detectConnect(Integer type, String data) {
        try {
            Connect connect = type == 0 ? this.dataService.selectConnectById(data) : this.parsedConnect(data);
            String host = connect.getRhost();
            String port = connect.getRport();
            Jedis jedis = new Jedis(host, Integer.parseInt(port), 3000);
            jedis.connect();
            if (!jedis.isConnected()) {
                return ResultInfo.getNoByJson("\u670d\u52a1\u4e0d\u53ef\u7528");
            }
            if (!StringUtils.isEmpty((Object)connect.getRpass())) {
                jedis.auth(connect.getRpass());
            }
            jedis.ping();
            jedis.disconnect();
            jedis.close();
            return ResultInfo.getOkByJson("\u8fde\u63a5\u6210\u529f");
        }
        catch (Exception e) {
            LogUtil.setLogException(e);
            String msg = e.getMessage();
            if (msg.contains("connect failed")) {
                return ResultInfo.getNoByJson("\u7f51\u7edc\u4e0d\u53ef\u8fbe");
            }
            if (msg.contains("invalid password")) {
                return ResultInfo.getNoByJson("\u5bc6\u7801\u4e0d\u6b63\u786e");
            }
            if (msg.contains("connect timed out")) {
                return ResultInfo.getNoByJson("\u8bf7\u6c42\u670d\u52a1\u8d85\u65f6");
            }
            if (msg.contains("Connection refused")) {
                return ResultInfo.getNoByJson("\u670d\u52a1\u62d2\u7edd\u8fde\u63a5");
            }
            if (msg.contains("Authentication required")) {
                return ResultInfo.getNoByJson("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return ResultInfo.getNoByJson("\u670d\u52a1\u4e0d\u53ef\u7528");
        }
    }

    public String backupConnect() {
        try {
            String baseUrl = System.getProperty("user.home");
            String fileName = "redisplus-connect-" + DateUtil.formatDate(new Date(), "yyyy-MM-dd-HH:mm:ss") + ".bak";
            String filePath = baseUrl + "/" + fileName;
            List<Connect> connectList = this.dataService.selectConnect();
            if (null == connectList || connectList.isEmpty()) {
                return ResultInfo.getNoByJson("\u6682\u65e0\u9700\u8981\u5907\u7684\u4efd\u6570\u636e");
            }
            StringBuilder dataBuffer = new StringBuilder("");
            for (Connect connect : connectList) {
                dataBuffer.append(JSON.toJSONString((Object)connect));
                dataBuffer.append("\r\n");
            }
            boolean flag = FileUtil.writeStringToFile(filePath, dataBuffer.toString());
            if (flag) {
                return ResultInfo.getOkByJson("\u6570\u636e\u6210\u529f\u5907\u4efd\u81f3\u5f53\u524d\u7528\u6237\u76ee\u5f55\u4e2d");
            }
            return ResultInfo.getNoByJson("\u5907\u4efd\u6570\u636e\u5931\u8d25");
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String recoveConnect() {
        try {
            FileChooser fileChooser = new FileChooser();
            File file = fileChooser.showOpenDialog((Window)Desktop.getRootStage());
            if (null != file) {
                String[] jsons;
                for (String json : jsons = FileUtil.readFileToString(file.toString()).split("\r\n", -1)) {
                    Connect connect = (Connect)JSON.parseObject((String)json, Connect.class);
                    if (null == connect) continue;
                    this.dataService.insertConnect(connect);
                }
                return ResultInfo.getOkByJson("\u8fd8\u539f\u6570\u636e\u6210\u529f");
            }
            return ResultInfo.getNoByJson("\u53d6\u6d88\u8fd8\u539f\u64cd\u4f5c");
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    public String cmdwinConnect(String cmd) {
        try {
            Connect connect = DataUtil.getCurrentOpenConnect();
            if (null != connect) {
                return TelnetUtil.sendCommand(connect, cmd);
            }
            return ResultInfo.disconnect();
        }
        catch (Exception e) {
            return ResultInfo.exception(e);
        }
    }

    private Connect parsedConnect(String json) {
        JSONObject data = JSON.parseObject((String)json);
        Connect connect = new Connect();
        String id = data.getString("id");
        if (!StringUtils.isEmpty((Object)id)) {
            connect.setId(id);
        }
        connect.setText(data.getString("text"));
        connect.setType(data.getString("type"));
        connect.setIsha(data.getString("isha"));
        connect.setRhost(data.getString("rhost"));
        connect.setRport(data.getString("rport"));
        connect.setRpass(data.getString("rpass"));
        connect.setShost(data.getString("shost"));
        connect.setSport(data.getString("sport"));
        connect.setSname(data.getString("sname"));
        connect.setSpass(data.getString("spass"));
        return connect;
    }
}

