<?PHP

/*******************************************************************************

   RedCrab Interface for BCMath Arbitrary Precision Mathematics
   Requirements : PHP 4.0.4 or heighter
   
   Contents

    add(a,b)      : Add two arbitrary precision numbers

    sub(a,b)      : Subtract one arbitrary precision number from another

    mul(a,b)      : Multiply two arbitrary precision number

    div(a,b)      : Divide two arbitrary precision numbers

    mod(a,b)      : Get modulus of an arbitrary precision number

    powxy(x,y)    : Raise an arbitrary precision number to another

    powmod(x,y,m) : Raise an arbitrary precision number to another,
                    reduced by a specified modulus

    sqrt          : Get the square root of an arbitrary precision number

    comp          : Compare two arbitrary precision numbers

    compc         : "c is used to set the number of digits after the decimal
                    place which will be used in the comparison

    scale         : Set default scale parameter for all bc math functions

 ******************************************************************************/
 
function add($a,$b)
{
  echo bcadd($a,$b);
}

function sub($a,$b)
{
  echo bcsub($a,$b);
}

function mul($a,$b)
{
  echo bcmul($a,$b);
}

function div($a,$b)
{
  echo bcdiv($a,$b);
}

function mod($a,$b)
{
  echo bcmod($a,$b);
}

function powxy($a,$b)
{
  echo bcpow($a,$b);
}

function powmod($a,$b,$m)
{
  echo bcpowmod($a,$b,$m);
}

function sqrtx($a)
{
  echo bcsqrt($a);
}

function comp($a,$b)
{
  echo bccomp($a,$b);
}

function compc($a,$b,$c)
{
  echo bccomp($a,$b,$c);
}

function scale($a)
{
  echo bcscale($a);
}



$f = $_POST["func"];
$a = floatval($_POST["arg1"]);

if (isset($_POST["arg3"]))
{
  $m = floatval($_POST["arg3"]);
  $b = floatval($_POST["arg2"]);
  $f($a,$b,$m);
}
else if (isset($_POST["arg2"]))
{
  $b = floatval($_POST["arg2"]);
  $f($a,$b);
}
else
{
  $f($a);
}

?>