/////////////////////////////////////////////////////////////////////////////////////////////////////////////
float4x4 World;
float4x4 LightView;
float4x4 LightProjection;
static const float SHADOW_EPSILON = 0.0005f;
float g_fAlpha;
float FrameDivide;
int FrameX;
int FrameY;
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
struct VertexOutShadow
{
    float4 Pos      : POSITION;
    float2 depth    : TEXCOORD0;
    float2 texuv    : TEXCOORD1;
};
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
texture g_MeshTexture;
sampler MeshTextureSampler = sampler_state
{
    Texture = <g_MeshTexture>;
    MinFilter = NONE;
    MagFilter = NONE;
    AddressU = WRAP;
    AddressV = WRAP;
};
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
VertexOutShadow ShadowMapVertexShader(float3 posL : POSITION0,
			        float2 tex : TEXCOORD0)
{
    VertexOutShadow Vert = (VertexOutShadow)0;
    float4x4 Transform;
    Transform = mul(LightView, LightProjection);
    Transform = mul(World,Transform);
    Vert.Pos = mul(float4(posL,1.0f), Transform);
    Vert.depth = Vert.Pos.zw;
    tex.x /= FrameDivide;
    tex.y /= FrameDivide;
    tex.x += (1/FrameDivide) * FrameX;
    tex.y += (1/FrameDivide) * FrameY;
    Vert.texuv = tex;   
    return Vert;
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
float4 ShadowMapPixelShader(float2 depth : TEXCOORD0,
			    float2 texuv : TEXCOORD1) : COLOR
{
    float FD = (depth.x / depth.y);
    float alpha = tex2D(MeshTextureSampler,texuv).a;
    return float4(FD,FD,FD,alpha);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
technique ShadowMap
{
     pass P0
     {
        VertexShader = compile vs_2_0 ShadowMapVertexShader();
        PixelShader = compile ps_2_0 ShadowMapPixelShader();
	AlphaTestEnable = true;
	AlphaRef = 100;
	AlphaFunc = GreaterEqual;
     }
}