int SCREENWIDTH;
int SCREENHEIGHT;

float g_fBlurAmount;
float g_fBlack;
float g_fRed;
float g_fGreen;
float g_fBlue;
float3 g_LightColor;
float3 g_ShadowColor;

texture g_Output;
sampler OutputSampler = sampler_state
{
    Texture = <g_Output>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = CLAMP;
    AddressV = CLAMP;
};
texture g_Pixel;
sampler PixelSampler = sampler_state
{
    Texture = <g_Pixel>;
    MinFilter = NONE;
    MagFilter = NONE;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

texture g_Menu;
sampler MenuSampler = sampler_state
{
    Texture = <g_Menu>;
    MinFilter = NONE;
    MagFilter = NONE;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

texture g_Input;
sampler InputSampler = sampler_state
{
    Texture = <g_Input>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

// ########################################################################################################## 
float4 OutputPS(float2 Tex : TEXCOORD0 ) : COLOR
{ 
	//BLUR PASS 1
	float xT = ((1.0/SCREENWIDTH)) * g_fBlurAmount;
	float yT = ((1.0/SCREENHEIGHT)) * g_fBlurAmount;
	float3 Color = tex2D(OutputSampler, Tex);
	Color += tex2D(OutputSampler, Tex + float2(xT,0));
	Color += tex2D(OutputSampler, Tex + float2(-xT,0));
	Color += tex2D(OutputSampler, Tex + float2(0,yT));
	Color += tex2D(OutputSampler, Tex + float2(0,-yT));
	Color /= 5;	
	Color.rgb *= 1-g_fRed;
	Color.rgb *= 1-g_fGreen;
	Color.rgb *= 1-g_fBlue;
	Color.r += g_fRed;
	Color.g += g_fGreen;
	Color.b += g_fBlue;
	Color *= g_fBlack;
	
	return float4(Color,1);
}
technique Output{ pass P0 { PixelShader = compile ps_2_0 OutputPS(); } }

// ########################################################################################################## 
float4 ThreeDPS(float2 Tex : TEXCOORD0 ) : COLOR
{
	return tex2D(PixelSampler, Tex);
}
technique ThreeD
{
	pass P0 
	{ 
		PixelShader = compile ps_2_0 ThreeDPS();
		AlphaTestEnable = true;
		AlphaRef = 100;
		AlphaFunc = GreaterEqual;
	}
}

// ########################################################################################################## 
float4 XYBlurPS(float2 Tex : TEXCOORD0 ) : COLOR
{ 
	float texelx = 1 / (SCREENWIDTH);
	float texely = 1 / (SCREENHEIGHT);
	float3 Color = tex2D(InputSampler,Tex);
	Color += tex2D(InputSampler,Tex + float2(texelx,0));
	Color += tex2D(InputSampler,Tex + float2(-texelx,0));
	Color += tex2D(InputSampler,Tex + float2(0,texely));
	Color += tex2D(InputSampler,Tex + float2(0,-texely));
	Color /= 5;
	return float4(Color,1);
}
technique XBlur { pass P0 { PixelShader = compile ps_2_0 XYBlurPS(); } }
