float4x4 World;
float4x4 View;
float4x4 Projection;

float4x4 LightView;
float4x4 LightProjection;

//*************************
float3 EyePos;
float3 LightPos;
float3 AmbientColor;

int Screen_Height;
int Image_Width;

//*************************
float g_fCamZoomMod;
texture g_MeshTexture;

static const float SHADOW_EPSILON = 0.00002f;

struct PointOut
{
   float4 Pos : POSITION0;
   float3 TexUV : TEXCOORD0; //d3d fills in for points
   float4 projtex : TEXCOORD1;
   float  distance : TEXCOORD2;
   float size : PSIZE;
};

struct OutputVS
{
   float4 Pos : POSITION0;
   float Rotation : TEXCOORD1;
   float4 color : COLOR0;
   float size   : PSIZE;
   float4 projtex : TEXCOORD2;
};
texture g_ShadowMap;
sampler ShadowMapSampler = sampler_state
{
    Texture = <g_ShadowMap>;
    MinFilter = POINT;
    MagFilter = POINT;
    MipFilter = POINT;
    AddressU = CLAMP;
    AddressV = CLAMP;
};
sampler MeshTextureSampler = sampler_state
{
    Texture = <g_MeshTexture>;
    MinFilter = POINT;
    MagFilter = POINT;
    MipFilter = POINT;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

//************************************************************************ START TEXTURE VS
//************************************************************************ START TEXTURE VS
OutputVS ParticleVS(float4 Pos : POSITION, float size : TEXCOORD0,  float rotation : TEXCOORD1, float4 color : COLOR0)
{
	OutputVS Point = (OutputVS)0;
	
	float4x4 Transform;
	
	Pos = mul(Pos, World);

	Transform = mul(LightView, LightProjection);

	Point.projtex = mul(Pos, Transform);		

	Transform = mul(View, Projection);

	Point.Pos = mul(Pos, Transform);

	Point.Rotation = rotation;

	float d = distance(Pos,EyePos);

	//Point.size = size * (Screen_Height / (Image_Width)) / d;
	Point.size = (size * Screen_Height) / d;
	
	Point.color = color;

	return Point;
}

//***************************
float4 ParticlePS( float4 color : COLOR0,
		 float2 texuv : TEXCOORD0,
		 float rotation : TEXCOORD1,
		 float4 ProjTex : TEXCOORD2) : COLOR
{		
	// shadow projection //
	float2 ShadowTexC = 0.5 * (ProjTex.xy / ProjTex.w) + float2( 0.5, 0.5 );
	ShadowTexC.y = 1.0f - ShadowTexC.y;
   	float s0 = (tex2D(ShadowMapSampler, ShadowTexC.xy).r + SHADOW_EPSILON < (ProjTex.z / ProjTex.w)) ? 0.0f : 1.0f;		
	s0 += 0.5f;
	s0 = min(s0,1.0f);
	float c = cos(rotation);
	float s = sin(rotation);
	float2x2 rotationMatrix = float2x2(c, -s, s, c);
	float2 textureCoordinate = texuv - 0.5;
	textureCoordinate = mul(textureCoordinate, rotationMatrix);
	float4 texColor = tex2D(MeshTextureSampler, textureCoordinate + 0.5);
	texColor.rgb *= color.rgb;
	texColor.rgb *= s0;
	texColor.a *= color.a;
	return float4(texColor);
}
//***************************
float4 ParticleNoRotatePS( float4 color : COLOR0,
		 float2 texuv : TEXCOORD0,
		 float rotation : TEXCOORD1,
		 float4 ProjTex : TEXCOORD2) : COLOR
{		
	// shadow projection //
	float2 ShadowTexC = 0.5 * (ProjTex.xy / ProjTex.w) + float2( 0.5, 0.5 );
	ShadowTexC.y = 1.0f - ShadowTexC.y;
   	float s0 = (tex2D(ShadowMapSampler, ShadowTexC.xy).r + SHADOW_EPSILON < (ProjTex.z / ProjTex.w)) ? 0.0f : 1.0f;		
	s0 += 0.5f;
	s0 = min(s0,1.0f);
	float2 textureCoordinate = texuv - 0.5;
	float4 texColor = tex2D(MeshTextureSampler, textureCoordinate + 0.5);
	texColor.rgb *= color.rgb;
	texColor.rgb *= s0;
	texColor *= color.a;
	return float4(texColor);
}
//***************************
float4 FullColorPS( float4 color : COLOR0,
		 float2 texuv : TEXCOORD0,
		 float rotation : TEXCOORD1,
		 float4 ProjTex : TEXCOORD2) : COLOR
{		
	float4 texColor = tex2D(MeshTextureSampler, texuv);
	texColor.rgb *= color.rgb;
	texColor *= color.a;
	return float4(texColor);
}
//************************************************************************
//************************************************************************

technique ParticleTechnique
{
    pass P0 // MISSILE SMOKE
    {
	VertexShader = compile vs_2_0 ParticleVS();
	PixelShader = compile ps_2_0 ParticleNoRotatePS();
	PointSpriteEnable = True;
	AlphaBlendEnable = True;  
	ZWriteEnable = FALSE;
	SrcBlend = SrcAlpha;
	DestBlend = InvSrcAlpha;
    }
    pass P1 // DARK SMOKE
    {
	VertexShader = compile vs_2_0 ParticleVS();
	PixelShader = compile ps_2_0 ParticleNoRotatePS();
	PointSpriteEnable = true;
	AlphaBlendEnable=True;  
	ZWriteEnable = FALSE;
	SrcBlend = SrcAlpha;
	DestBlend = InvSrcAlpha;
    }
    pass P2 // FULL COLOR
    {
	VertexShader = compile vs_2_0 ParticleVS();
	PixelShader = compile ps_2_0 FullColorPS();
	PointSpriteEnable = true;
	AlphaBlendEnable=True;  
	ZWriteEnable = FALSE;
	SrcBlend = ONE;
	DestBlend = InvSrcAlpha;
    }
}


//AlphaTestEnable = true;
//AlphaRef = 200;
//AlphaFunc = GreaterEqual;
//ZWriteEnable = true;	
//AlphaTestEnable = false;
//SrcBlend = One;
//DestBlend = One;
//VertexShader = compile vs_2_0 GrassVS();
//PixelShader = compile ps_2_0 GrassPS();
//PointSpriteEnable = true;
//AlphaBlendEnable=True;  
//AlphaTestEnable = true;
//AlphaRef = 200;
//AlphaFunc = GreaterEqual;
//PointScaleEnable = true;
//PointScale_A = 0;
//PointScale_B = 0;
//PointScale_C = 1;
//PointSize_Min= 4.0f;
//PointSize = 500.0f;
//PointSize_Max = 9999.0f;
