﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Admin/SiteMenu.Master" AutoEventWireup="true"
    CodeBehind="DelayMyCustomer.aspx.cs" Inherits="Crm25175.DelayMyCustomer" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
    <link rel="stylesheet" href="../assets/css/jquery-ui-1.10.3.full.min.css" />
    <script type="text/javascript">
        //后台调用,区分提示信息底色
        //Danger,Info
        function ChangeMsgClass(MsgType) {
            if (MsgType == "Danger") {
                DivMsg.className = 'alert alert-danger';
            }
            else {
                DivMsg.className = 'alert alert-info';
            }
        }
    </script>
    <link rel="stylesheet" href="../assets/css/datepicker.css" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <div class="breadcrumbs" id="breadcrumbs">
        <script type="text/javascript">
            try { ace.settings.check('breadcrumbs', 'fixed') } catch (e) { }
        </script>
        <ul class="breadcrumb">
            <li><i class="<%=PageIcon %>"></i>延期申请 </li>
        </ul>
    </div>
    <div class="page-content">
        <div class="row col-xs-12">
            <div id="DivMsg" class="alert alert-info">
                <i class="icon-hand-right"></i>
                <asp:Label ID="LabMsg" runat="server" Text=" "></asp:Label>
                <button class="close" data-dismiss="alert">
                    <i class="icon-remove"></i>
                </button>
            </div>
        </div>
        <div class="page-header">
            <div class="col-xs-12 widget-box">
                <asp:Button ID="BtMenuList" runat="server" OnClick="BtMenuList_Click" Text="数据列表"
                    CssClass="btn btn-info btn-sm" />
                <asp:Button ID="BtMenuTrans" runat="server" OnClick="BtMenuTrans_Click" Text="客户延期"
                    CssClass="btn btn-primary btn-sm" />
                <asp:Button ID="BtMenuTransAll" runat="server" OnClick="BtMenuTransAll_Click" Text="延期所有"
                    CssClass="btn btn-danger btn-sm" />
                <asp:TextBox runat="server" ID="TxtStartDate" CssClass="date-picker input-small"
                    data-rel="tooltip" title="跟进开始日期" data-date-format="yyyy-mm-dd" placeholder="跟进日期" />
                <asp:TextBox runat="server" ID="TxtEndDate" CssClass="date-picker input-small" data-rel="tooltip"
                    title="跟进结束日期" data-date-format="yyyy-mm-dd" placeholder="跟进日期" />
                <asp:DropDownList ID="DDLCustomerType" runat="server" data-rel="tooltip" title="客户类别">
                </asp:DropDownList>
                <asp:DropDownList ID="DDLDecorateProgress" runat="server" data-rel="tooltip" title="装修进度">
                </asp:DropDownList>
                <asp:DropDownList ID="DDLFollowStage" runat="server" data-rel="tooltip" title="跟进阶段">
                </asp:DropDownList>
                <asp:TextBox runat="server" ID="TxtCustPhone_Find" placeholder="电话" CssClass="input-mini"
                    data-rel="tooltip" title="客户电话"></asp:TextBox>
                <asp:Button ID="BtSearch" runat="server" CssClass="btn btn-success btn-sm hidden"
                    Text="查找" OnClick="BtSearch_Click" />
                <span data-rel="tooltip" title="根据所有条件查询"><a href="#" data-action="reload"><i class="icon-search nav-search-icon green bigger-140"
                    id="idsearch"></i></a></span>
            </div>
        </div>
        <div id="dialog-submit" class="hide">
            <div class="alert alert-success bigger-110">
                所选客户提交延期申请。
            </div>
            <div class="space-6">
            </div>
            <p class="bigger-110 bolder center grey">
                <i class="icon-hand-right blue bigger-120"></i>确定提交吗?
            </p>
        </div>
        <!-- #dialog-confirm -->
        <asp:Panel runat="server" Visible="false" ID="PanelTransAll">
            <div id="dialog-edit" class="row">
                <div class="col-xs-12">
                    <div class="col-xs-12 center">
                        <div class="space-6">
                        </div>
                        <div class="col-xs-10 col-sm-push-1 alert-danger">
                            申请将我所有客户的周期都延期一次</div>
                    </div>
                    <div class="col-xs-6">
                        <div class="space-6">
                        </div>
                        <div class="row">
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    申请延期</div>
                                <div class="profile-info-value">
                                    <asp:TextBox ID="TxtDelayDays_P" runat="server"></asp:TextBox>
                                    (天)
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xs-6">
                        <div class="space-6">
                        </div>
                        <div class="row">
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    延期的客户数</div>
                                <div class="profile-info-value">
                                    <div class="input-group">
                                        <asp:Label ID="LabCustCount" runat="server" />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xs-12">
                        <div class="row">
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    延期说明</div>
                                <div class="profile-info-value">
                                    <asp:TextBox ID="TxtCustomerTransName_P" runat="server" TextMode="MultiLine" CssClass="col-xs-11"></asp:TextBox>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xs-12 hidden">
                        <asp:GridView ID="GridView3" runat="server" CssClass="table table-striped table-bordered table-hover"
                            AutoGenerateColumns="True" DataKeyNames="CustomerID" AllowPaging="False">
                            <Columns>
                            </Columns>
                        </asp:GridView>
                    </div>
                    <div class="form-group col-xs-12 center">
                        <div class="space-6">
                        </div>
                        <asp:Button ID="BT_Trans_P" runat="server" Text="延期申请" OnClick="BT_Trans_P_Click"
                            CssClass="btn btn-info icon-ok bigger-110 hidden " />
                        <button class="btn btn-info" type="button" id="BtTransP">
                            <i class="icon-ok bigger-110"></i>延期申请
                        </button>
                        <button id="Button4" type="reset" value="取消" class="btn">
                            <i class="icon-undo bigger-110"></i>Reset
                        </button>
                        <button id="Button5" type="reset" value="返回" class="btn" onclick="javascript:history.go(-1)">
                            <i class="icon-backward bigger-110"></i>Back
                        </button>
                    </div>
                </div>
            </div>
            <!-- #dialog-message -->
        </asp:Panel>
        <asp:Panel runat="server" Visible="false" ID="PanelTrans">
            <div class="row" id="DivAdd">
                <div class="col-xs-12">
                    <div class="col-xs-12 center">
                        <div class="space-6">
                        </div>
                        <div class="col-xs-10 col-sm-push-1 alert-success">
                            延期后,当前周期=原周期+延期天数,跟进后当前周期恢复为原周期</div>
                    </div>
                    <div class="col-xs-6">
                        <div class="space-6">
                        </div>
                        <div class="row">
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    申请延期</div>
                                <div class="profile-info-value">
                                    <asp:TextBox ID="TxtDelayDays" runat="server"></asp:TextBox>
                                    (天)
                                </div>
                            </div>
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                </div>
                                <div class="profile-info-value">
                                    <div class="input-group">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xs-12">
                        <div class="row">
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    延期说明</div>
                                <div class="profile-info-value">
                                    <asp:TextBox ID="TxtCustomerTransName_C" runat="server" TextMode="MultiLine" CssClass="col-xs-11"></asp:TextBox>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xs-12">
                        <div class="space-6">
                        </div>
                        <asp:GridView ID="GridView2" runat="server" CssClass="table table-striped table-bordered table-hover"
                            AutoGenerateColumns="False" DataKeyNames="CustomerID" AllowPaging="False">
                            <Columns>
                                <asp:BoundField DataField="CustomerName" HeaderText="客户" ReadOnly="True" />
                                <asp:BoundField DataField="CustomerFrom" HeaderText="来源" ReadOnly="True" />
                                <asp:BoundField DataField="CustomerType" HeaderText="类型" ReadOnly="True" />
                                <asp:BoundField DataField="CustomerProduct" HeaderText="意向产品" ReadOnly="True" />
                                <asp:BoundField DataField="CustomerProgress" HeaderText="装修进度" ReadOnly="True" />
                                <asp:BoundField DataField="CustomerFollowStage" HeaderText="更新阶段" ReadOnly="True" />
                            </Columns>
                        </asp:GridView>
                    </div>
                    <div class="form-group col-xs-12 center">
                        <div class="space-6">
                        </div>
                        <asp:Button ID="BT_Trans_C" runat="server" Text="延期申请" class="icon-ok" CssClass="btn btn-info icon-ok btn-sm hidden"
                            OnClick="BT_Trans_C_Click" />
                        <button class="btn btn-info bigger-110" type="button" id="BtTransC">
                            <i class="icon-ok"></i>延期申请
                        </button>
                        <button id="Reset1" type="reset" value="取消" class="btn bigger-110">
                            <i class="icon-undo"></i>Reset
                        </button>
                        <%--<Button id="Button2" type="reset" value="返回"  class="btn" onclick="javascript:history.go(-1)"><i class="icon-backward bigger-110"></i>
					        Back
                        </Button>--%>
                    </div>
                </div>
            </div>
        </asp:Panel>
        <asp:Panel runat="server" Visible="false" ID="PanelData">
            <div class="row">
                <div class="col-xs-12">
                    <div class="table-responsive">
                        <asp:GridView ID="GridView1" runat="server" CssClass="table table-striped table-bordered table-hover"
                            AutoGenerateColumns="False" DataKeyNames="CustomerID" AllowPaging="True" OnPageIndexChanging="GridView1_PageIndexChanging"
                            OnRowCommand="GridView1_RowCommand">
                            <Columns>
                                <asp:TemplateField HeaderText="选取">
                                    <HeaderTemplate>
                                        <asp:CheckBox ID="CheckBoxTitle" runat="server" CssClass="ace" />
                                    </HeaderTemplate>
                                    <ItemTemplate>
                                        <asp:CheckBox ID="CheckSelect" runat="server" />
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:BoundField DataField="CustName" HeaderText="客户" ReadOnly="True" />
                                <asp:BoundField DataField="FromName" HeaderText="来源" ReadOnly="True" />
                                <asp:BoundField DataField="TypeName" HeaderText="类型" ReadOnly="True" />
                                <asp:BoundField DataField="ProductName" HeaderText="意向产品" ReadOnly="True" />
                                <asp:BoundField DataField="CustPhone" HeaderText="电话" ReadOnly="True" />
                                <asp:BoundField DataField="CustQQ" HeaderText="QQ/微信" ReadOnly="True" />
                                <asp:BoundField DataField="CreateDate" HeaderText="登记" ReadOnly="True" />
                                <asp:BoundField DataField="DecorateProgressName" HeaderText="装修进度" ReadOnly="True" />
                                <asp:BoundField DataField="FollowStageName" HeaderText="跟进阶段" ReadOnly="True" />
                                <asp:BoundField DataField="LastFollowDate" HeaderText="最后跟进" ReadOnly="True" />
                                <asp:BoundField DataField="ExpirationDate" HeaderText="到期" ReadOnly="True" />
                                <asp:BoundField DataField="ExpHour" HeaderText="超时" ReadOnly="True" />
                                <asp:TemplateField HeaderText="操作">
                                    <ItemTemplate>
                                        <asp:Button class=" btn btn-xs btn-success smaller-80 " Text="View" ID="ButtonView"
                                            runat="server" CommandName="ViewUI" CommandArgument='<%# Bind("CustomerID")%>'>
                                        </asp:Button>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <%-- <asp:TemplateField HeaderText="新供应商默认">
                                    <ItemTemplate>
                                        <asp:Button ID="Btn_SetSupplier" runat="server" Text='IsSupplierDef' CommandName="EditUI" CommandArgument='RoleName'
                                        CssClass="btn btn-success btn-xs"  />
                                    </ItemTemplate>
                                </asp:TemplateField>--%>
                            </Columns>
                            <PagerSettings Mode="NumericFirstLast" />
                            <HeaderStyle Wrap="False" />
                            <RowStyle Wrap="False" />
                        </asp:GridView>
                    </div>
                    <!-- /.table-responsive -->
                </div>
                <!-- /span -->
            </div>
        </asp:Panel>
    </div>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceHolder_Footer" runat="server">
    <script type="text/javascript" src="../assets/js/jquery-2.0.3.min.js"></script>
    <script type="text/javascript">
        window.jQuery || document.write("<script src='../assets/js/jquery-2.0.3.min.js'>" + "<" + "/script>");
    </script>
    <script type="text/javascript">
        if ("ontouchend" in document) document.write("<script src='../assets/js/jquery.mobile.custom.min.js'>" + "<" + "/script>");
    </script>
    <script type="text/javascript" src="../assets/js/bootstrap.min.js"></script>
    <script type="text/javascript" src="../assets/js/typeahead-bs2.min.js"></script>
    <!-- page specific plugin scripts -->
    <!--插件bootstrap-datepicker.min.js必须在jquery-ui-1.10.3.full.min.js之后,否则日期格式、年的选中等会部分失效-->
    <script type="text/javascript" src="../assets/js/jquery-ui-1.10.3.full.min.js"></script>
    <script type="text/javascript" src="../assets/js/date-time/bootstrap-datepicker.min.js"></script>
    <script type="text/javascript" src="../assets/js/jquery.ui.touch-punch.min.js"></script>
    <!-- ace scripts -->
    <script type="text/javascript" src="../assets/js/ace-elements.min.js"></script>
    <script type="text/javascript" src="../assets/js/ace.min.js"></script>
    <script type="text/javascript">

        jQuery(function ($) {
            //全选确认框
            $('table th input:checkbox').on('click', function () {
                var that = this;
                $(this).closest('table').find('tr > td:first-child input:checkbox')
	            .each(function () {
	                this.checked = that.checked;
	                $(this).closest('tr').toggleClass('selected');
	            });
            });


            //查询
            $("#idsearch").on('click', function (e) {
                document.getElementById('<%=BtSearch.ClientID %>').click();
            });

            //对话框全局
            $.widget("ui.dialog", $.extend({}, $.ui.dialog.prototype, {
                _title: function (title) {
                    var $title = this.options.title || '&nbsp;'
                    if (("title_html" in this.options) && this.options.title_html == true)
                        title.html($title);
                    else title.text($title);
                }
            }));

            //延期
            $("#BtTransC").on('click', function (e) {
                e.preventDefault();
                $("#dialog-submit").removeClass('hide').dialog(
                {
                    resizable: false,
                    modal: true,
                    title: "<div class='widget-header'><h4 class='smaller'><i class='icon-ok blue'></i>延期</h4></div>",
                    title_html: true,
                    buttons: [
						{
						    html: "<i class='icon-ok bigger-110'></i>&nbsp; 确定",
						    "class": "btn btn-success btn-xs",
						    click: function () {
						        document.getElementById('<%=BT_Trans_C.ClientID %>').click();
						    }
						}
						,
						{
						    html: "<i class='icon-remove bigger-110'></i>&nbsp; 取消",
						    "class": "btn btn-xs",
						    click: function () {
						        $(this).dialog("close");
						    }
						}]
                });
            });

            //延期
            $("#BtTransP").on('click', function (e) {
                e.preventDefault();
                $("#dialog-submit").removeClass('hide').dialog(
                {
                    resizable: false,
                    modal: true,
                    title: "<div class='widget-header'><h4 class='smaller'><i class='icon-ok blue'></i>延期</h4></div>",
                    title_html: true,
                    buttons: [
						{
						    html: "<i class='icon-ok bigger-110'></i>&nbsp; 确定",
						    "class": "btn btn-success btn-xs",
						    click: function () {
						        document.getElementById('<%=BT_Trans_P.ClientID %>').click();
						    }
						}
						,
						{
						    html: "<i class='icon-remove bigger-110'></i>&nbsp; 取消",
						    "class": "btn btn-xs",
						    click: function () {
						        $(this).dialog("close");
						    }
						}]
                });
            });
            $('[data-rel=tooltip]').tooltip();
            //日期
            $('.date-picker').datepicker({ autoclose: true }).next().on(ace.click_event, function () {
                $(this).focus();
            });
        });
    </script>
</asp:Content>
