﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Admin/SiteMenu.Master" AutoEventWireup="true"
    CodeBehind="CustomerFollow.aspx.cs" Inherits="Crm25175.CustomerFollow" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
    <link rel="stylesheet" href="../assets/css/jquery-ui-1.10.3.full.min.css" />
    <script type="text/javascript">
        //后台调用,区分提示信息底色
        //Danger,Info
        function ChangeMsgClass(MsgType) {
            if (MsgType == "Danger") {
                DivMsg.className = 'alert alert-danger';
            }
            else {
                DivMsg.className = 'alert alert-info';
            }
        }
    </script>
    <link rel="stylesheet" href="../assets/css/datepicker.css" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <div class="breadcrumbs" id="breadcrumbs">
        <script type="text/javascript">
            try { ace.settings.check('breadcrumbs', 'fixed') } catch (e) { }
        </script>
        <ul class="breadcrumb">
            <li><i class="<%=PageIcon %>"></i>联系跟进 </li>
        </ul>
    </div>
    <div class="page-content">
        <div class="row col-xs-12">
            <div id="DivMsg" class="alert alert-info">
                <i class="icon-hand-right"></i>
                <asp:Label ID="LabMsg" runat="server" Text=" "></asp:Label>
                <button class="close" data-dismiss="alert">
                    <i class="icon-remove"></i>
                </button>
            </div>
        </div>
        <div class="page-header">
            <div class="col-xs-12 widget-box">
                <asp:Button ID="BtMenuList" runat="server" OnClick="BtMenuList_Click" Text="数据列表"
                    CssClass="btn btn-info btn-sm" />
                <asp:TextBox runat="server" ID="TxtStartDate" CssClass="date-picker input-small"
                    data-rel="tooltip" title="跟进开始日期" data-date-format="yyyy-mm-dd" placeholder="跟进日期" />
                <asp:TextBox runat="server" ID="TxtEndDate" CssClass="date-picker input-small" data-rel="tooltip"
                    title="跟进结束日期" data-date-format="yyyy-mm-dd" placeholder="跟进日期" />
                <asp:DropDownList ID="DDLCustomerType" runat="server" data-rel="tooltip" title="客户类别">
                </asp:DropDownList>
                <asp:DropDownList ID="DDLDecorateProgress" runat="server" data-rel="tooltip" title="装修进度">
                </asp:DropDownList>
                <asp:DropDownList ID="DDLFollowStage" runat="server" data-rel="tooltip" title="跟进阶段">
                </asp:DropDownList>
                <asp:TextBox runat="server" ID="TxtCustPhone_Find" placeholder="电话" CssClass="input-mini"
                    data-rel="tooltip" title="客户电话"></asp:TextBox>
                <asp:Button ID="BtSearch" runat="server" CssClass="btn btn-success btn-sm hidden"
                    Text="查找" OnClick="BtSearch_Click" />
                <span data-rel="tooltip" title="根据所有条件查询"><a href="#" data-action="reload"><i class="icon-search nav-search-icon green bigger-140"
                    id="idsearch"></i></a></span>
            </div>
        </div>
        <div id="dialog-del" class="hide">
            <div class="alert alert-success bigger-110">
                当前跟进资料将被保存。
            </div>
            <div class="space-6">
            </div>
            <p class="bigger-110 bolder center grey">
                <i class="icon-hand-right blue bigger-120"></i>确定保存吗?
            </p>
        </div>
        <!-- #dialog-confirm -->
        <div id="dialog-safe" class="hide">
            <div class="alert alert-danger bigger-110">
                封存该客户。封存后的客户将无法进行修改、跟进操作，仅管理员可进行取消封存操作。
            </div>
            <div class="space-6">
            </div>
            <p class="bigger-110 bolder center grey">
                <i class="icon-hand-right blue bigger-120"></i>确定封存吗?
            </p>
        </div>
        <!-- #dialog-confirm -->
        <asp:Panel runat="server" Visible="false" ID="PanelTrack">
            <div class="row" id="DivAdd">
                <div class="col-xs-12">
                    <div class="col-xs-12 center">
                        <div class="space-6">
                        </div>
                        <div class="col-xs-12 infobox-blue3 alert-info">
                            联系跟进</div>
                    </div>
                    <div class="col-xs-12 page-header">
                        <div class="space-2">
                        </div>
                        <div class="col-xs-4">
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    客户</div>
                                <div class="profile-info-value">
                                    <asp:Label ID="LabCustName" runat="server" />
                                    <asp:Label ID="LabCustomerID" runat="server" CssClass="hidden" />
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-4">
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    电话</div>
                                <div class="profile-info-value">
                                    <asp:Label ID="LabCustPhone" runat="server" />
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-4">
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    QQ/微信</div>
                                <div class="profile-info-value">
                                    <asp:Label ID="LabCustQQ" runat="server" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xs-6">
                        <div class="space-2">
                        </div>
                        <div class="row">
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    跟进方式</div>
                                <div class="profile-info-value">
                                    <asp:DropDownList ID="DDLCustomerFollowType_Add" runat="server">
                                    </asp:DropDownList>
                                </div>
                            </div>
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    装修进度</div>
                                <div class="profile-info-value">
                                    <asp:DropDownList ID="DDLDecorateProgress_Add" runat="server">
                                    </asp:DropDownList>
                                </div>
                            </div>
                            <%--<div class="profile-info-row">
					            <div class="profile-info-name">装修建材</div>
					            <div class="profile-info-value">
						            <div class="input-group">                                    
                                        <asp:DropDownList ID="DDLHouseMaterial_Add" runat="server">
                                        </asp:DropDownList>
                                    </div>
					            </div>
				            </div>--%>
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    客户类型</div>
                                <div class="profile-info-value">
                                    <asp:DropDownList ID="DDLTypeID_Add" runat="server">
                                    </asp:DropDownList>
                                </div>
                            </div>
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    备注</div>
                                <div class="profile-info-value">
                                    <asp:DropDownList ID="DDLFollowMark_Add" runat="server">
                                    </asp:DropDownList>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xs-6">
                        <div class="space-2">
                        </div>
                        <div class="row">
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    户型</div>
                                <div class="profile-info-value">
                                    <asp:DropDownList ID="DDLHouseModel_Add" runat="server">
                                    </asp:DropDownList>
                                </div>
                            </div>
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    房屋性质</div>
                                <div class="profile-info-value">
                                    <asp:DropDownList ID="DDLHouseProperty_Add" runat="server">
                                    </asp:DropDownList>
                                </div>
                            </div>
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    跟进阶段</div>
                                <div class="profile-info-value">
                                    <div class="input-group">
                                        <asp:DropDownList ID="DDLFollowStage_Add" runat="server">
                                        </asp:DropDownList>
                                    </div>
                                </div>
                            </div>
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    成交金额</div>
                                <div class="profile-info-value">
                                    <div class="input-group">
                                        <asp:TextBox ID="TxtAmount_Add" runat="server" CssClass="input-small"></asp:TextBox>
                                        (元)
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xs-12">
                        <div class="row">
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    其他内容</div>
                                <div class="profile-info-value">
                                    <asp:TextBox ID="TxtCFOther_Add" runat="server" TextMode="MultiLine" CssClass="col-xs-12"></asp:TextBox>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group col-xs-12 center">
                        <div class="space-6">
                        </div>
                        <asp:Button ID="BT_Add" runat="server" Text="保存" class="icon-ok" CssClass="btn btn-info icon-ok hidden"
                            OnClick="BT_Add_Click" />
                        <button class="btn btn-info bigger-110" type="button" id="BtAdd">
                            <i class="icon-ok"></i>保存
                        </button>
                        <button id="Reset1" type="reset" value="取消" class="btn bigger-110">
                            <i class="icon-undo"></i>Reset
                        </button>
                        <%--<Button id="Button5" type="reset" value="返回"  class="btn" onclick="javascript:history.go(-1)"><i class="icon-backward bigger-110"></i>
					        Back
                        </Button>--%>
                    </div>
                    <div class="col-xs-12">
                        <asp:GridView ID="GridView2" runat="server" CssClass="table table-striped table-bordered table-hover"
                            AutoGenerateColumns="False" AllowPaging="True"  OnPageIndexChanging="GridView2_PageIndexChanging">
                            <Columns>
                                <asp:BoundField DataField="CFTranType" HeaderText="类别" ReadOnly="True" />
                                <asp:BoundField DataField="CFDate" HeaderText="时间" ReadOnly="True" />
                                <asp:BoundField DataField="UserNameFollow" HeaderText="操作员" ReadOnly="True" />
                                <asp:BoundField DataField="FollTypeName" HeaderText="跟进方式" ReadOnly="True" />
                                <asp:BoundField DataField="HouseModelName" HeaderText="房屋类型" ReadOnly="True" />
                                <asp:BoundField DataField="HousePropertyName" HeaderText="房屋性质" ReadOnly="True" />
                                <asp:BoundField DataField="DecorateProgressName" HeaderText="装修进度" ReadOnly="True" />
                                <asp:BoundField DataField="FollowStageName" HeaderText="跟进阶段" ReadOnly="True" />
                                <asp:BoundField DataField="TypeName" HeaderText="客户类型" ReadOnly="True" />
                            </Columns>
                            <PagerSettings Mode="NumericFirstLast" />
                        </asp:GridView>
                    </div>
                    <div class="col-xs-12 center">
                        <div class="space-6">
                        </div>
                        <div class="col-xs-12 infobox-red alert-warning">
                            封存客户</div>
                    </div>
                    <div class="form-group col-xs-12">
                        <div class="page-header">
                        </div>
                        <div class="row">
                            <div class="col-xs-2">
                            </div>
                            <div class="col-xs-8">
                                <div class="profile-info-row">
                                    <div class="profile-info-name">
                                        <span class="text-danger">封存原因</span></div>
                                    <div class="profile-info-value">
                                        <asp:TextBox ID="TxtCFOther_keep" runat="server" TextMode="MultiLine" CssClass="col-xs-12"></asp:TextBox>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-2">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-2">
                            </div>
                            <div class="col-xs-8">
                                <div class="profile-info-row">
                                    <div class="profile-info-name">
                                        <span class="text-danger">封存客户类型</span></div>
                                    <div class="profile-info-value">
                                        <asp:DropDownList ID="DDLCustType_Safekeep" runat="server">
                                        </asp:DropDownList>
                                        <asp:Button ID="BtSafekeep" runat="server" Text="封存" CssClass="btn btn-info icon-lock hidden"
                                            OnClick="BtSafekeep_Click" />
                                        <button class="btn btn-danger bigger-110" type="button" id="BtSafekeeping">
                                            <i class="icon-lock"></i>封存客户
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-2">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </asp:Panel>
        <asp:Panel runat="server" Visible="false" ID="PanelData">
            <div class="row">
                <div class="col-xs-12">
                    <div class="table-responsive">
                        <asp:GridView ID="GridView1" runat="server" CssClass="table table-striped table-bordered table-hover"
                            AutoGenerateColumns="False" DataKeyNames="CustomerID" AllowPaging="True" OnPageIndexChanging="GridView1_PageIndexChanging"
                            OnRowCommand="GridView1_RowCommand" OnRowDataBound="GridView1_RowDataBound">
                            <Columns>
                                <asp:BoundField DataField="CustName" HeaderText="客户" ReadOnly="True" />
                                <asp:BoundField DataField="FromName" HeaderText="来源" ReadOnly="True" />
                                <asp:BoundField DataField="TypeName" HeaderText="类型" ReadOnly="True" />
                                <asp:BoundField DataField="ProductName" HeaderText="意向产品" ReadOnly="True" />
                                <asp:BoundField DataField="CustPhone" HeaderText="电话" ReadOnly="True" />
                                <asp:BoundField DataField="CustQQ" HeaderText="QQ/微信" ReadOnly="True" />
                                <asp:BoundField DataField="CreateDate" HeaderText="登记" ReadOnly="True" />
                                <asp:BoundField DataField="DecorateProgressName" HeaderText="装修进度" ReadOnly="True" />
                                <asp:BoundField DataField="FollowStageName" HeaderText="跟进阶段" ReadOnly="True" />
                                <asp:BoundField DataField="LastFollowDate" HeaderText="最后跟进" ReadOnly="True" />
                                <asp:BoundField DataField="ExpirationDate" HeaderText="到期" ReadOnly="True" />
                                <asp:BoundField DataField="ExpHour" HeaderText="超时" ReadOnly="True" />
                                <asp:BoundField DataField="DelayDays" HeaderText="延期" ReadOnly="True">
                                    <HeaderStyle CssClass="hidden" />
                                    <ItemStyle CssClass="hidden" />
                                </asp:BoundField>
                                <asp:TemplateField HeaderText="操作">
                                    <ItemTemplate>
                                        <asp:Button class=" btn btn-xs btn-success smaller-80 " Text="View" ID="ButtonView"
                                            runat="server" CommandName="ViewUI" CommandArgument='<%# Bind("CustomerID")%>'>
                                        </asp:Button>
                                        <asp:Button class=" btn btn-xs btn-pink smaller-80 " Text="Track" ID="ButtonTrack"
                                            runat="server" CommandName="TrackUI" CommandArgument='<%# Bind("CustomerID")%>'>
                                        </asp:Button>
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                            <PagerSettings Mode="NumericFirstLast" />
                            <HeaderStyle Wrap="False" />
                            <RowStyle Wrap="False" />
                        </asp:GridView>
                    </div>
                    <!-- /.table-responsive -->
                </div>
                <!-- /span -->
            </div>
        </asp:Panel>
    </div>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceHolder_Footer" runat="server">
    <script type="text/javascript" src="../assets/js/jquery-2.0.3.min.js"></script>
    <script type="text/javascript">
        window.jQuery || document.write("<script src='../assets/js/jquery-2.0.3.min.js'>" + "<" + "/script>");
    </script>
    <script type="text/javascript">
        if ("ontouchend" in document) document.write("<script src='../assets/js/jquery.mobile.custom.min.js'>" + "<" + "/script>");
    </script>
    <script type="text/javascript" src="../assets/js/bootstrap.min.js"></script>
    <script type="text/javascript" src="../assets/js/typeahead-bs2.min.js"></script>
    <!-- page specific plugin scripts -->
    <!--插件bootstrap-datepicker.min.js必须在jquery-ui-1.10.3.full.min.js之后,否则日期格式、年的选中等会部分失效-->
    <script type="text/javascript" src="../assets/js/jquery-ui-1.10.3.full.min.js"></script>
    <script type="text/javascript" src="../assets/js/date-time/bootstrap-datepicker.min.js"></script>
    <script type="text/javascript" src="../assets/js/jquery.ui.touch-punch.min.js"></script>
    <!-- ace scripts -->
    <script type="text/javascript" src="../assets/js/ace-elements.min.js"></script>
    <script type="text/javascript" src="../assets/js/ace.min.js"></script>
    <script type="text/javascript" src="../assets/js/bootbox.min_25175.js"></script>
    <script type="text/javascript">

        jQuery(function ($) {

            //日期
            $('.date-picker').datepicker({ autoclose: true }).next().on(ace.click_event, function () {
                $(this).focus();
            });

            //查询
            $("#idsearch").on('click', function (e) {
                document.getElementById('<%=BtSearch.ClientID %>').click();
            });

            //对话框全局
            $.widget("ui.dialog", $.extend({}, $.ui.dialog.prototype, {
                _title: function (title) {
                    var $title = this.options.title || '&nbsp;'
                    if (("title_html" in this.options) && this.options.title_html == true)
                        title.html($title);
                    else title.text($title);
                }
            }));

            //保存
            $("#BtAdd").on('click', function (e) {
                //            $(document.getElementById('<%=BT_Add.ClientID %>')).on('click', function (e) {
                e.preventDefault();
                $("#dialog-del").removeClass('hide').dialog(
                {
                    resizable: false,
                    modal: true,
                    title: "<div class='widget-header'><h4 class='smaller'><i class='icon-save blue'></i>保存</h4></div>",
                    title_html: true,
                    buttons: [
						{
						    html: "<i class='icon-ok bigger-110'></i>&nbsp; 确定",
						    "class": "btn btn-success btn-xs",
						    click: function () {
						        document.getElementById('<%=BT_Add.ClientID %>').click();
						    }
						}
						,
						{
						    html: "<i class='icon-remove bigger-110'></i>&nbsp; 取消",
						    "class": "btn btn-xs",
						    click: function () {
						        $(this).dialog("close");
						    }
						}]
                });
            });



            //封存
            $("#BtSafekeeping").on('click', function (e) {
                e.preventDefault();
                $("#dialog-safe").removeClass('hide').dialog(
                {
                    resizable: false,
                    modal: true,
                    title: "<div class='widget-header'><h4 class='smaller'><i class='icon-save red'> 封存</i></h4></div>",
                    title_html: true,
                    buttons: [
						{
						    html: "<i class='icon-lock bigger-110'></i>&nbsp; 封存",
						    "class": "btn btn-danger btn-xs",
						    click: function () {
						        document.getElementById('<%=BtSafekeep.ClientID %>').click();
						    }
						}
						,
						{
						    html: "<i class='icon-remove bigger-110'></i>&nbsp; 取消",
						    "class": "btn btn-xs",
						    click: function () {
						        $(this).dialog("close");
						    }
						}]
                });
            });
            $('[data-rel=tooltip]').tooltip();
        });
    </script>
</asp:Content>
