﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Admin/SiteMenu.Master" AutoEventWireup="true" CodeBehind="ApplyCustomer.aspx.cs" Inherits="Crm25175.ApplyCustomer" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
    <link rel="stylesheet" href="../assets/css/jquery-ui-1.10.3.full.min.css" />

    <script type="text/javascript">
        //后台调用,区分提示信息底色
        //Danger,Info
        function ChangeMsgClass(MsgType) {
            if (MsgType == "Danger") 
            {
                DivMsg.className = 'alert alert-danger';
            }
            else 
            {
                DivMsg.className = 'alert alert-info';
            }
        }
    </script>
    <link rel="stylesheet" href="../assets/css/datepicker.css" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

    <div class="breadcrumbs" id="breadcrumbs">
		<script type="text/javascript">
			try { ace.settings.check('breadcrumbs', 'fixed') } catch (e) { }
		</script>
		<ul class="breadcrumb">
			<li>
				<i class="<%=PageIcon %>"></i>
                客戶接收
			</li>
		</ul>
	</div>

    <div class="page-content">
        <div class="row col-xs-12">
            <div id="DivMsg" class="alert alert-info">
                <i class="icon-hand-right"></i>
                <asp:Label ID="LabMsg" runat="server" Text=" "></asp:Label>
			    <button class="close" data-dismiss="alert">
                <i class="icon-remove"></i>
                </button>
            </div>
        </div>

        <div class="page-header">
            <div class="col-xs-12 widget-box">
                转交日期
                <span>
                    <asp:TextBox runat="server" ID="TxtDateStart" placeholder="转交开始" CssClass="input-small date-picker" data-date-format="yyyy-mm-dd"></asp:TextBox> ~
                </span>
                <span>
                    <asp:TextBox runat="server" ID="TxtDateEnd" placeholder="转交结束" CssClass="input-small date-picker" data-date-format="yyyy-mm-dd"></asp:TextBox>
                </span>
                <asp:Button ID="BtSearch" runat="server"  CssClass="btn btn-success btn-sm hidden" 
                    Text="查找" onclick="BtSearch_Click" />
				<span >
					<a href="#" data-action="reload"><i class="icon-search nav-search-icon green bigger-140" id="idsearch" title="查找"></i></a>
				</span>
                
            </div>
        </div>		

        <div id="dialog-submit" class="hide">
			<div class="alert alert-success bigger-110">
				接收当前列表允收值为"Y"的客户，允收值为"N"的已取消不会接收。
			</div>
			<div class="space-6"></div>
			<p class="bigger-110 bolder center grey">
				<i class="icon-hand-right blue bigger-120"></i>
				确定接收吗?
			</p>
		</div><!-- #dialog-confirm -->	

        <asp:Panel runat="server" Visible="false" ID="PanelOpen">
            <div class="row" id="DivAdd">
                
                    <div class="col-xs-4">
                        <div class="space-6"></div>
                        <div class="row">				    
				            <div class="profile-info-row">
					            <div class="profile-info-name">转交人员</div>
					            <div class="profile-info-value">
                                    <asp:Label ID="LabUserName" runat="server">
                                    </asp:Label>
                                    <asp:Label ID="LabCustomerTransID" runat="server" CssClass="hidden"/>
                                    <asp:Label ID="LabRowIndexID" runat="server" CssClass="hidden"/>
                                </div>
				            </div>
                        </div>
				    </div>
                    <div class="col-xs-4">
                        <div class="space-6"></div>
                        <div class="row">	
                            <div class="profile-info-row">
					            <div class="profile-info-name">转交时间</div>
					            <div class="profile-info-value">
						            <asp:Label ID="LabCreateDate" runat="server">
                                    </asp:Label>
					            </div>
				            </div>
			            </div>
                    </div>
                    <div class="col-xs-4">
                        <div class="space-6"></div>
                        <div class="row">	
                            <div class="profile-info-row">
					            <div class="profile-info-name">接收时间</div>
					            <div class="profile-info-value">
						            <asp:Label ID="LabChangeDate" runat="server">
                                    </asp:Label>
					            </div>
				            </div>
			            </div>
                    </div>

                    <div class="col-xs-12">
                        <div class="row">				    
				            <div class="profile-info-row">
					            <div class="profile-info-name">转交说明</div>
					            <div class="profile-info-value">
                                    <asp:Label ID="LabCustomerTransName" runat="server" CssClass="col-xs-11"></asp:Label>
					            </div>
				            </div>
			            </div>
                    </div>

                    <div class="col-xs-12">
                        <div class="space-6"></div>
                        <asp:GridView ID="GridView2" runat="server" 
                            CssClass="table table-striped table-bordered table-hover" 
                            AutoGenerateColumns="False" DataKeyNames="ID" AllowPaging="False"
                            OnRowCommand="GridView1_RowCommand"  >
                            <Columns>
                                <asp:BoundField DataField="CustomerID" HeaderText="客户ID" ReadOnly="True"> 
                                <HeaderStyle CssClass="hidden" />
                                <ItemStyle CssClass="hidden" />
                                </asp:BoundField>                                
                                <asp:BoundField DataField="CustName" HeaderText="客户" ReadOnly="True"/> 
                                <asp:BoundField DataField="FromName" HeaderText="来源" ReadOnly="True"/> 
                                <asp:BoundField DataField="TypeName" HeaderText="类型" ReadOnly="True"/> 
                                <asp:BoundField DataField="ProductName" HeaderText="意向产品" ReadOnly="True"/> 
                                <asp:BoundField DataField="State" HeaderText="允收" ReadOnly="True"/> 
                                <asp:TemplateField HeaderText="查看">
                                    <ItemTemplate>
                                        <asp:Button class=" btn btn-xs btn-success smaller-80 " Text="View" id="ButtonView" runat="server" CommandName="ViewUI" CommandArgument='<%# Bind("CustomerID")%>'>
										</asp:Button>
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                        </asp:GridView>
                    </div>

				    <div class="form-group col-xs-12 center">
                        <div class="space-6"></div>
                        <div class="col-xs-3">
                        </div>
                        <div class="col-xs-3">
                        <asp:Panel runat="server" Visible="true" ID="PanelApply">
                            <asp:Button ID="BT_Apply" runat="server" Text="接收该批客户" class="icon-ok" OnClick="BT_Apply_Click"
                                    CssClass="btn btn-info icon-ok btn-sm hidden"  />
                            <button class="btn btn-info bigger-110" type="button" id="BtApply">
						        <i class="icon-ok"></i>
						        接收该批客户
					        </button>
                        </asp:Panel>
                        </div>
                        <div class="col-xs-3">
                        <Button id="Button2" type="reset" value="返回"  class="btn" onclick="javascript:history.go(-1)"><i class="icon-backward bigger-110"></i>
					        Back
                        </Button>
                        </div>
                        <div class="col-xs-3">
                        </div>
                    </div>
                
                
                
            </div>
        </asp:Panel>

        <asp:Panel runat="server" Visible="false" ID="PanelData">
            <div class="row">
	            <div class="col-xs-12">
		            <div class="table-responsive">
                        <asp:GridView ID="GridView1" runat="server" 
                            CssClass="table table-striped table-bordered table-hover" 
                            AutoGenerateColumns="False" DataKeyNames="CustomerTransID" AllowPaging="True" 
                            OnPageIndexChanging="GridView1_PageIndexChanging" 
                            OnRowCommand="GridView1_RowCommand" >
                            <Columns>
                                <asp:BoundField DataField="UserName" HeaderText="申请人" ReadOnly="True"/> 
                                <asp:BoundField DataField="CreateDate" HeaderText="申请时间" ReadOnly="True"/>
                                <asp:BoundField DataField="CheckState" HeaderText="已接收" ReadOnly="True"/> 
                                <asp:BoundField DataField="ChangeDate" HeaderText="接收时间" ReadOnly="True"/> 
                                <asp:TemplateField HeaderText="转交说明">
                                    <ItemTemplate>
                                        <asp:TextBox ID="TxtCustomerTransName" runat="server" TextMode="MultiLine" Text='<%# Bind("CustomerTransName") %>' CssClass="col-xs-12" Enabled="false"></asp:TextBox>
                                    </ItemTemplate>
                                    <ItemStyle CssClass="col-xs-5" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="操作">
                                    <ItemTemplate>
                                        <asp:Button class=" btn btn-xs btn-success smaller-80 " Text="Open" id="ButtonOpen" runat="server" CommandName="OpenUI" CommandArgument='<%# Bind("CustomerTransID")%>'>
										</asp:Button>
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                            <PagerSettings Mode="NumericFirstLast" />
                            <HeaderStyle Wrap="False" />
                            <RowStyle Wrap="False" />
                        </asp:GridView>
		            </div><!-- /.table-responsive -->
	            </div><!-- /span -->
            </div>
        </asp:Panel>
    </div>
    
</asp:Content>

<asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceHolder_Footer" runat="server">

    <script type="text/javascript" src="../assets/js/jquery-2.0.3.min.js"></script>

	<script type="text/javascript">
		window.jQuery || document.write("<script src='../assets/js/jquery-2.0.3.min.js'>" + "<" + "/script>");
	</script>

	<script type="text/javascript">
		if ("ontouchend" in document) document.write("<script src='../assets/js/jquery.mobile.custom.min.js'>" + "<" + "/script>");
	</script>
	<script type="text/javascript" src="../assets/js/bootstrap.min.js"></script>
	<script type="text/javascript" src="../assets/js/typeahead-bs2.min.js"></script>

	<!-- page specific plugin scripts -->
    <!--插件bootstrap-datepicker.min.js必须在jquery-ui-1.10.3.full.min.js之后,否则日期格式、年的选中等会部分失效-->
    <script type="text/javascript" src="../assets/js/jquery-ui-1.10.3.full.min.js"></script>
    <script type="text/javascript" src="../assets/js/date-time/bootstrap-datepicker.min.js"></script>
	<script type="text/javascript" src="../assets/js/jquery.ui.touch-punch.min.js"></script>
	<!-- ace scripts -->

	<script type="text/javascript" src="../assets/js/ace-elements.min.js"></script>
	<script type="text/javascript" src="../assets/js/ace.min.js"></script>
    <script type="text/javascript" src="../assets/js/bootbox.min_25175.js"></script>

    <script type="text/javascript">

        jQuery(function ($) {
            //日期
            $('.date-picker').datepicker({ autoclose: true }).next().on(ace.click_event, function () {
                $(this).prev().focus();
            });

            //查询
            $("#idsearch").on('click', function (e) {
                document.getElementById('<%=BtSearch.ClientID %>').click();
            });

            //对话框全局
            $.widget("ui.dialog", $.extend({}, $.ui.dialog.prototype, {
                _title: function (title) {
                    var $title = this.options.title || '&nbsp;'
                    if (("title_html" in this.options) && this.options.title_html == true)
                        title.html($title);
                    else title.text($title);
                }
            }));

            //接收
            $("#BtApply").on('click', function (e) {
                e.preventDefault();
                $("#dialog-submit").removeClass('hide').dialog(
                {
                    resizable: false,
                    modal: true,
                    title: "<div class='widget-header'><h4 class='smaller'><i class='icon-ok blue'></i>接收</h4></div>",
                    title_html: true,
                    buttons: [
						{
						    html: "<i class='icon-ok bigger-110'></i>&nbsp; 确定",
						    "class": "btn btn-success btn-xs",
						    click: function () {
						        document.getElementById('<%=BT_Apply.ClientID %>').click();
						    }
						}
						,
						{
						    html: "<i class='icon-remove bigger-110'></i>&nbsp; 取消",
						    "class": "btn btn-xs",
						    click: function () {
						        $(this).dialog("close");
						    }
						}]
                });
            });
        });
    </script>
    

</asp:Content>
