﻿<%@ Page Title="" Language="C#" EnableEventValidation="false" MasterPageFile="~/Admin/SiteMenu.Master"
    AutoEventWireup="true" CodeBehind="AllCustomer.aspx.cs" Inherits="Crm25175.AllCustomer" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
    <link rel="stylesheet" href="../assets/css/jquery-ui-1.10.3.full.min.css" />
    <script type="text/javascript">
        //后台调用,区分提示信息底色
        //Danger,Info
        function ChangeMsgClass(MsgType) {
            if (MsgType == "Danger") {
                DivMsg.className = 'alert alert-danger';
            }
            else {
                DivMsg.className = 'alert alert-info';
            }
        }
    </script>
    <link rel="stylesheet" href="../assets/css/datepicker.css" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <div class="breadcrumbs" id="breadcrumbs">
        <script type="text/javascript">
            try { ace.settings.check('breadcrumbs', 'fixed') } catch (e) { }
        </script>
        <ul class="breadcrumb">
            <li><i class="<%=PageIcon %>"></i>全部客戶 </li>
        </ul>
    </div>
    <div class="page-content">
        <div class="row col-xs-12">
            <div id="DivMsg" class="alert alert-info">
                <i class="icon-hand-right"></i>
                <asp:Label ID="LabMsg" runat="server" Text=" "></asp:Label>
                <button class="close" data-dismiss="alert">
                    <i class="icon-remove"></i>
                </button>
            </div>
        </div>
        <div class="page-header">
            <div class="col-xs-12 widget-box">
                <asp:Button ID="BtMenuList" runat="server" OnClick="BtMenuList_Click" Text="数据列表"
                    CssClass="btn btn-info btn-sm" />
                <asp:Button ID="BtMenuEdit" runat="server" OnClick="BtMenuEdit_Click" Text="改周期"
                    CssClass="btn btn-warning btn-sm hide" />
                <asp:Button ID="BtEditDay" runat="server" Text="改周期" Visible="false" CssClass="btn btn-warning btn-sm"
                    data-rel="tooltip" title="修改客户周期状态" />
                <asp:Button ID="BtMenuDel" runat="server" OnClick="BtMenuDel_Click" Text="删除" CssClass="btn btn-info btn-sm hidden" />
                <asp:Button ID="BtDel" runat="server" Text="删除" Visible="false" CssClass="btn btn-danger btn-sm"
                    data-rel="tooltip" title="删除客户" />
                <asp:Button ID="BtExport" runat="server" Text="导出" Visible="false" CssClass="btn btn-success btn-sm"
                    OnClick="BtExport_Click" />
                <asp:TextBox runat="server" ID="TxtStartDate" CssClass="date-picker input-small"
                    data-rel="tooltip" title="登记开始日期" data-date-format="yyyy-mm-dd" placeholder="登记日期" />
                <asp:TextBox runat="server" ID="TxtEndDate" CssClass="date-picker input-small" data-rel="tooltip"
                    title="登记结束日期" data-date-format="yyyy-mm-dd" placeholder="登记日期" />
                <asp:DropDownList ID="DDLCustomerSel" runat="server" data-rel="tooltip" title="客户状态">
                    <asp:ListItem Value="ALL">-全部-</asp:ListItem>
                    <asp:ListItem Value="COM">公共客户</asp:ListItem>
                    <asp:ListItem Value="PRI">非公共客户</asp:ListItem>
                </asp:DropDownList>
                <asp:DropDownList ID="DDLCustomerType" runat="server" data-rel="tooltip" title="客户类别">
                </asp:DropDownList>
                <asp:DropDownList ID="DDLDecorateProgress" runat="server" data-rel="tooltip" title="装修进度">
                </asp:DropDownList>
                <asp:DropDownList ID="DDLFollowStage" runat="server" data-rel="tooltip" title="跟进阶段">
                </asp:DropDownList>
                <asp:DropDownList ID="DDLUserID" runat="server" data-rel="tooltip" title="客户归属">
                </asp:DropDownList>
                <asp:DropDownList ID="DDLIsDayStart" runat="server" data-rel="tooltip" title="周期状态">
                    <asp:ListItem Value="ALL">-全部-</asp:ListItem>
                    <asp:ListItem Value="N">停止</asp:ListItem>
                    <asp:ListItem Value="Y">正常</asp:ListItem>
                </asp:DropDownList>
                <asp:TextBox runat="server" ID="TxtCustPhone_Find" placeholder="电话" CssClass="input-mini"
                    data-rel="tooltip" title="客户电话"></asp:TextBox>
                <asp:Button ID="BtSearch" runat="server" CssClass="btn btn-success btn-sm hidden"
                    Text="查找" OnClick="BtSearch_Click" />
                <span data-rel="tooltip" title="根据所有条件查询"><a href="#" data-action="reload"><i class="icon-search nav-search-icon green bigger-140"
                    id="idsearch"></i></a></span>
            </div>
        </div>
        <asp:Panel runat="server" Visible="false" ID="PanelEdit">
            <div id="div-edit" class="row">
                <div class="col-xs-12">
                    <div class="col-xs-12 center">
                        <div class="space-6">
                        </div>
                        <div class="alert-info">
                            基础信息</div>
                    </div>
                    <div class="col-xs-12 center">
                        <div class="col-xs-6 col-sm-offset-3 center alert-warning">
                            <asp:Label runat="server" ID="LabCustHours" />
                        </div>
                    </div>
                    <div class="col-xs-6">
                        <div class="row">
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    客户姓名</div>
                                <div class="profile-info-value row">
                                    <asp:TextBox ID="TxtCustName_Edit" runat="server"></asp:TextBox>
                                    <asp:TextBox ID="TxtCustID_Edit" runat="server" CssClass="hidden"></asp:TextBox>
                                </div>
                            </div>
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    客户来源</div>
                                <div class="profile-info-value">
                                    <asp:DropDownList ID="DDLCustFromID_Edit" runat="server">
                                    </asp:DropDownList>
                                </div>
                            </div>
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    意向产品</div>
                                <div class="profile-info-value">
                                    <asp:DropDownList ID="DDLCustProductID_Edit" runat="server">
                                    </asp:DropDownList>
                                </div>
                            </div>
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    QQ/微信</div>
                                <div class="profile-info-value">
                                    <asp:TextBox ID="TxtCustQQ_Edit" runat="server"></asp:TextBox>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xs-6">
                        <div class="row">
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    生日</div>
                                <div class="profile-info-value">
                                    <asp:TextBox runat="server" ID="TxtCustBirth_Edit" CssClass=" date-picker" data-date-format="yyyy-mm-dd" />
                                    <span><i class="icon-calendar bigger-110"></i></span>
                                </div>
                            </div>
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    客户类型</div>
                                <div class="profile-info-value">
                                    <asp:DropDownList ID="DDLCustTypeID_Edit" runat="server">
                                    </asp:DropDownList>
                                </div>
                            </div>
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    联系电话</div>
                                <div class="profile-info-value">
                                    <div class="input-group">
                                        <asp:TextBox runat="server" ID="TxtCustPhone_Edit" />
                                    </div>
                                </div>
                            </div>
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    客户归属</div>
                                <div class="profile-info-value">
                                    <asp:DropDownList ID="DDLUserID_Edit" runat="server">
                                    </asp:DropDownList>
                                    <asp:TextBox runat="server" ID="TxtUserID_Edit" CssClass="hidden" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xs-12">
                        <div class="row">
                            <div class="profile-info-row">
                                <div class="profile-info-name">
                                    客户地址</div>
                                <div class="profile-info-value">
                                    <asp:TextBox ID="TxtCustAddress_Edit" runat="server" CssClass="col-xs-12"></asp:TextBox>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group col-xs-12 center">
                        <div class="space-6">
                        </div>
                        <asp:Button ID="BT_Edit" runat="server" Text="修改" OnClick="BT_Edit_Click" CssClass="btn btn-info icon-ok bigger-110 hidden " />
                        <button class="btn btn-info" type="button" id="BtEdit">
                            <i class="icon-ok bigger-110"></i>修改
                        </button>
                        <button id="Button4" type="reset" value="取消" class="btn">
                            <i class="icon-undo bigger-110"></i>Reset
                        </button>
                        <%--<Button id="Button5" type="reset" value="返回"  class="btn" onclick="javascript:history.go(-1)"><i class="icon-backward bigger-110"></i>
					        Back
                        </Button>--%>
                    </div>
                </div>
            </div>
            <!-- #dialog-message -->
        </asp:Panel>
        <div id="dialog-del" class="hide">
            <div class="alert alert-warning bigger-110">
                当前勾选的数据将被删除。
            </div>
            <div class="space-6">
            </div>
            <p class="bigger-110 bolder center grey">
                <i class="icon-hand-right blue bigger-120"></i>确定删除吗?
            </p>
        </div>
        <!-- #dialog-confirm -->
        <div id="dialog-add" class="hide">
            <div class="alert alert-success bigger-110">
                当前客户基础信息将被保存(修改信息不会影响到期日期，若更改客户归属则周期重置)。
            </div>
            <div class="space-6">
            </div>
            <p class="bigger-110 bolder center grey">
                <i class="icon-hand-right blue bigger-120"></i>确定保存吗?
            </p>
        </div>
        <!-- #dialog-edit -->
        <div id="dialog-edit" class="hide">
            <div class="alert alert-warning bigger-110">
                当前勾选客户的周期状态将被修改，已停止的将被启动，已启动的将被停止。
            </div>
            <div class="space-6">
            </div>
            <p class="bigger-110 bolder center grey">
                <i class="icon-hand-right blue bigger-120"></i>确定修改周期状态吗?
            </p>
        </div>
        <!-- #dialog-confirm -->
        <asp:Panel runat="server" Visible="false" ID="PanelData">
            <div class="row">
                <div class="col-xs-12">
                    <div class="table-responsive">
                        <asp:GridView ID="GridView1" runat="server" CssClass="table table-striped table-bordered table-hover"
                            AutoGenerateColumns="False" DataKeyNames="CustomerID" OnRowDataBound="GridView1_RowDataBound"
                            AllowPaging="True" OnPageIndexChanging="GridView1_PageIndexChanging" OnRowCommand="GridView1_RowCommand">
                            <Columns>
                                <asp:TemplateField HeaderText="选取">
                                    <HeaderTemplate>
                                        <asp:CheckBox ID="CheckBoxTitle" runat="server" CssClass="ace" />
                                    </HeaderTemplate>
                                    <ItemTemplate>
                                        <asp:CheckBox ID="CheckSelect" runat="server" />
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:BoundField DataField="CustName" HeaderText="客户" ReadOnly="True" />
                                <asp:BoundField DataField="FromName" HeaderText="来源" ReadOnly="True" />
                                <asp:BoundField DataField="TypeName" HeaderText="类型" ReadOnly="True" />
                                <asp:BoundField DataField="ProductName" HeaderText="意向产品" ReadOnly="True" />
                                <asp:BoundField DataField="CreateDate" HeaderText="登记" ReadOnly="True" />
                                <asp:BoundField DataField="DecorateProgressName" HeaderText="装修进度" ReadOnly="True" />
                                <asp:BoundField DataField="FollowStageName" HeaderText="跟进阶段" ReadOnly="True" />
                                <asp:BoundField DataField="LastFollowDate" HeaderText="最后跟进" ReadOnly="True" />
                                <asp:BoundField DataField="ExpirationDate" HeaderText="到期" ReadOnly="True" />
                                <asp:BoundField DataField="ExpHour" HeaderText="超时" ReadOnly="True" />
                                <asp:BoundField DataField="IsDayStart" HeaderText="周期" ReadOnly="True" />
                                <asp:TemplateField HeaderText="操作">
                                    <ItemTemplate>
                                        <asp:Button class=" btn btn-xs btn-success smaller-80 " Text="View" ID="ButtonView"
                                            runat="server" CommandName="ViewUI" CommandArgument='<%# Bind("CustomerID")%>'>
                                        </asp:Button>
                                        <asp:Button class=" btn btn-xs btn-info smaller-80 " Text="Edit" ID="ButtonEdit"
                                            runat="server" CommandName="EditUI" CommandArgument='<%# Bind("CustomerID")%>'>
                                        </asp:Button>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:BoundField DataField="DelayDays" HeaderText="延期" ReadOnly="True">
                                    <HeaderStyle CssClass="hidden" />
                                    <ItemStyle CssClass="hidden" />
                                </asp:BoundField>
                            </Columns>
                            <PagerSettings Mode="NumericFirstLast" />
                            <HeaderStyle Wrap="False" />
                            <RowStyle Wrap="False" />
                        </asp:GridView>
                        <asp:GridView ID="GridView2" runat="server" CssClass="table table-striped table-bordered table-hover"
                            AutoGenerateColumns="False" DataKeyNames="CustomerID">
                            <Columns>
                                <asp:BoundField DataField="CustName" HeaderText="客户姓名" ReadOnly="True" />
                                <asp:BoundField DataField="CustPhone" HeaderText="电话" ReadOnly="True" />
                                <asp:BoundField DataField="CustQQ" HeaderText="QQ/微信" ReadOnly="True" />
                                <asp:BoundField DataField="CustAddress" HeaderText="地址" ReadOnly="True" />
                                <asp:BoundField DataField="CreateDate" HeaderText="登记时间" ReadOnly="True" />
                                <asp:BoundField DataField="TypeName" HeaderText="客户类型" ReadOnly="True" />
                                <asp:BoundField DataField="CustBirth" HeaderText="生日" ReadOnly="True" />
                            </Columns>
                            <HeaderStyle Wrap="False" />
                            <RowStyle Wrap="False" />
                        </asp:GridView>
                    </div>
                    <!-- /.table-responsive -->
                </div>
                <!-- /span -->
            </div>
        </asp:Panel>
    </div>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceHolder_Footer" runat="server">
    <script type="text/javascript" src="../assets/js/jquery-2.0.3.min.js"></script>
    <script type="text/javascript">
        window.jQuery || document.write("<script src='../assets/js/jquery-2.0.3.min.js'>" + "<" + "/script>");
    </script>
    <script type="text/javascript">
        if ("ontouchend" in document) document.write("<script src='../assets/js/jquery.mobile.custom.min.js'>" + "<" + "/script>");
    </script>
    <script type="text/javascript" src="../assets/js/bootstrap.min.js"></script>
    <script type="text/javascript" src="../assets/js/typeahead-bs2.min.js"></script>
    <!-- page specific plugin scripts -->
    <!--插件bootstrap-datepicker.min.js必须在jquery-ui-1.10.3.full.min.js之后,否则日期格式、年的选中等会部分失效-->
    <script type="text/javascript" src="../assets/js/jquery-ui-1.10.3.full.min.js"></script>
    <script type="text/javascript" src="../assets/js/date-time/bootstrap-datepicker.min.js"></script>
    <script type="text/javascript" src="../assets/js/jquery.ui.touch-punch.min.js"></script>
    <!-- ace scripts -->
    <script type="text/javascript" src="../assets/js/ace-elements.min.js"></script>
    <script type="text/javascript" src="../assets/js/ace.min.js"></script>
    <script type="text/javascript" src="../assets/js/bootbox.min_25175.js"></script>
    <script type="text/javascript">

        jQuery(function ($) {
            //全选确认框
            $('table th input:checkbox').on('click', function () {
                var that = this;
                $(this).closest('table').find('tr > td:first-child input:checkbox')
	            .each(function () {
	                this.checked = that.checked;
	                $(this).closest('tr').toggleClass('selected');
	            });
            });


            //对话框全局
            $.widget("ui.dialog", $.extend({}, $.ui.dialog.prototype, {
                _title: function (title) {
                    var $title = this.options.title || '&nbsp;'
                    if (("title_html" in this.options) && this.options.title_html == true)
                        title.html($title);
                    else title.text($title);
                }
            }));

            //删除
            //            $("#id-btn-dialog-del").on('click', function (e) {
            $(document.getElementById('<%=BtDel.ClientID %>')).on('click', function (e) {
                e.preventDefault();
                $("#dialog-del").removeClass('hide').dialog(
                {
                    resizable: false,
                    modal: true,
                    title: "<div class='widget-header'><h4 class='smaller'><i class='icon-warning-sign red'></i>删除</h4></div>",
                    title_html: true,
                    buttons: [
						{
						    html: "<i class='icon-trash bigger-110'></i>&nbsp; 确定",
						    "class": "btn btn-danger btn-xs",
						    click: function () {
						        document.getElementById('<%=BtMenuDel.ClientID %>').click();
						    }
						}
						,
						{
						    html: "<i class='icon-remove bigger-110'></i>&nbsp; 取消",
						    "class": "btn btn-xs",
						    click: function () {
						        $(this).dialog("close");
						    }
						}]
                });
            });

            //保存
            $("#BtEdit").on('click', function (e) {
                e.preventDefault();
                $("#dialog-add").removeClass('hide').dialog(
                            {
                                resizable: false,
                                modal: true,
                                title: "<div class='widget-header'><h4 class='smaller'><i class='icon-save blue'></i>保存</h4></div>",
                                title_html: true,
                                buttons: [
						            {
						                html: "<i class='icon-ok bigger-110'></i>&nbsp; 确定",
						                "class": "btn btn-success btn-xs",
						                click: function () {
						                    document.getElementById('<%=BT_Edit.ClientID %>').click();
						                }
						            }
						            ,
						            {
						                html: "<i class='icon-remove bigger-110'></i>&nbsp; 取消",
						                "class": "btn btn-xs",
						                click: function () {
						                    $(this).dialog("close");
						                }
						            }]
                            });
            });

            //修改
            $("#ContentPlaceHolder1_BtEditDay").on('click', function (e) {
                e.preventDefault();
                $("#dialog-edit").removeClass('hide').dialog(
                            {
                                resizable: false,
                                modal: true,
                                title: "<div class='widget-header'><h4 class='smaller'><i class='icon-save blue'></i>修改</h4></div>",
                                title_html: true,
                                buttons: [
						            {
						                html: "<i class='icon-ok bigger-110'></i>&nbsp; 确定",
						                "class": "btn btn-success btn-xs",
						                click: function () {
						                    document.getElementById('<%=BtMenuEdit.ClientID %>').click();
						                }
						            }
						            ,
						            {
						                html: "<i class='icon-remove bigger-110'></i>&nbsp; 取消",
						                "class": "btn btn-xs",
						                click: function () {
						                    $(this).dialog("close");
						                }
						            }]
                            });
            });

            //日期
            $('.date-picker').datepicker({ autoclose: true }).next().on(ace.click_event, function () {
                $(this).focus();
            });

            //查询
            $("#idsearch").on('click', function (e) {
                document.getElementById('<%=BtSearch.ClientID %>').click();
            });

            $('[data-rel=tooltip]').tooltip();

        });
    </script>
</asp:Content>
