set addressVar to "%@"
set ccAddressVar to "%@"
set senderVar to "%@"
set subjectVar to "%@"
set contentVar to "%@"
set attachmentVar to (POSIX file "%@") as alias
set saveAsDrafts to (("%@" as integer) as boolean)
set singleJob to (("%@" as integer) as boolean)

--Go through contentVar and replace carriage returns (ascii 13)
--with the html <br> string
--This is used when the message is html formatted.
set fixedContentVar to ""
repeat with char in characters of contentVar
	set char_code to ASCII number of char
	if (char_code = 13) then
		set fixedContentVar to fixedContentVar & "<br>"
	else
		set fixedContentVar to fixedContentVar & char
	end if
end repeat

--Split up the to and cc addresses
set toAddressList to my splitAddresses(addressvar)
if length of ccaddressvar > 0 then
	set ccAddressList to my splitAddresses(ccaddressvar)
else
	set ccAddressList to {}
end if



tell application "Microsoft Entourage"
	set recipientList to {}
	repeat with anAddress in toAddressList
		set end of recipientList to {address:{display name:"", address:anAddress}, recipient type:to recipient}
	end repeat
	repeat with anAddress in ccAddressList
		set end of recipientList to {address:{display name:"", address:anAddress}, recipient type:cc recipient}
	end repeat
	
	
	--Use senderVar to determine which account to use
	if (length of sendervar) > 0 then
		set allEmailAccounts to (get IMAP accounts) & (get POP accounts) & (get Exchange accounts) & (get Hotmail accounts)
		set senderAccount to null
		set i to 1
		repeat while ((i is less than or equal to (count of allEmailAccounts)) and (senderAccount = null))
			set anAccount to item i of allEmailAccounts
			if (get email address of anAccount) = sendervar then
				set senderAccount to anAccount
			end if
			set i to i + 1
		end repeat
		if senderAccount = null then
			set senderAccount to default mail account
		end if
	else
		set senderAccount to default mail account
	end if
	
	set newMessage to make new outgoing message with properties {recipient:recipientList, subject:subjectvar, account:senderAccount, attachment:attachmentVar}
	
	--If the message is html, put in the html version of the content.
	--otherwise, put in just the content
	if (has html of newMessage) then
		set content of newMessage to fixedContentVar
	else
		set content of newMessage to contentVar
	end if

	if saveAsDrafts = false then
    	send newMessage
	else
    	if singleJob then
        	open newMessage
        	activate
	    end if
	end if
end tell

--Splits the addresses by commas
on splitAddresses(str)
	set tid to AppleScript's text item delimiters
	set newTID to ","
	
	try
		set AppleScript's text item delimiters to newTID
		set partsList to text items of str
		set AppleScript's text item delimiters to tid
	on error s number n
		set AppleScript's text item delimiters to tid
		error s number n
	end try
	
	return stripSpaces(partsList)
end splitAddresses

--strips spaces from before or after the address.
on stripSpaces(strList)
	set tid to AppleScript's text item delimiters
	set newTID to " "
	set partsList to {}
	
	try
		set AppleScript's text item delimiters to newTID
		repeat with str in strList
			repeat with shortString in text items of str
				if length of shortString > 0 then
					set end of partsList to (shortString as string)
				end if
			end repeat
			--set partsList to partsList & text items of str
		end repeat
		set AppleScript's text item delimiters to tid
	on error s number n
		set AppleScript's text item delimiters to tid
		error s number n
	end try
	
	return partsList
end stripSpaces