/*
 * Decompiled with CFR 0.152.
 */
package lee.study.down.mvc.controller;

import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.ssl.SslContext;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import lee.study.down.boot.AbstractHttpDownBootstrap;
import lee.study.down.constant.HttpDownConstant;
import lee.study.down.content.ContentManager;
import lee.study.down.content.DownContent;
import lee.study.down.dispatch.HttpDownCallback;
import lee.study.down.exception.BootstrapException;
import lee.study.down.gui.HttpDownApplication;
import lee.study.down.io.BdyZip;
import lee.study.down.model.ConfigInfo;
import lee.study.down.model.DirInfo;
import lee.study.down.model.HttpDownInfo;
import lee.study.down.model.HttpRequestInfo;
import lee.study.down.model.ResultInfo;
import lee.study.down.model.TaskInfo;
import lee.study.down.model.UnzipInfo;
import lee.study.down.model.UpdateInfo;
import lee.study.down.mvc.form.BuildTaskForm;
import lee.study.down.mvc.form.ConfigForm;
import lee.study.down.mvc.form.DirForm;
import lee.study.down.mvc.form.NewTaskForm;
import lee.study.down.mvc.form.UnzipForm;
import lee.study.down.update.GithubUpdateService;
import lee.study.down.update.UpdateService;
import lee.study.down.util.FileUtil;
import lee.study.down.util.HttpDownUtil;
import lee.study.down.util.OsUtil;
import lee.study.proxyee.proxy.ProxyConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api"})
public class HttpDownController {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpDownController.class);
    @Value(value="${app.version}")
    private float version;
    public static volatile AbstractHttpDownBootstrap updateBootstrap;
    private static volatile UpdateInfo updateInfo;
    private static final UpdateService updateService;

    @RequestMapping(value={"/getTask"})
    public ResultInfo getTask(@RequestParam String id) throws Exception {
        ResultInfo resultInfo = new ResultInfo();
        HttpDownInfo httpDownInfo = ContentManager.DOWN.getDownInfo(id);
        if (httpDownInfo != null) {
            TaskInfo taskInfo = httpDownInfo.getTaskInfo();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("task", NewTaskForm.parse((HttpDownInfo)httpDownInfo));
            List sameTasks = ContentManager.DOWN.getDownInfos().stream().filter(downInfo -> 0 != downInfo.getTaskInfo().getStatus() && 7 != downInfo.getTaskInfo().getStatus() && downInfo.getTaskInfo().getTotalSize() == taskInfo.getTotalSize()).collect(Collectors.toList());
            data.put("sameTasks", NewTaskForm.parse(sameTasks));
            resultInfo.setData(data);
        }
        return resultInfo;
    }

    @RequestMapping(value={"/getStartTasks"})
    public ResultInfo getStartTasks() throws Exception {
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.setData((Object)DownContent.setUrl((List)ContentManager.DOWN.getStartTasks()));
        return resultInfo;
    }

    @RequestMapping(value={"/startTask"})
    public ResultInfo startTask(@RequestBody NewTaskForm taskForm) throws Exception {
        return HttpDownController.commonStartTask((NewTaskForm)taskForm);
    }

    @RequestMapping(value={"/getChildDirList"})
    public ResultInfo getChildDirList(@RequestBody(required=false) DirForm body) {
        File[] files;
        ResultInfo resultInfo = new ResultInfo();
        LinkedList<DirInfo> data = new LinkedList<DirInfo>();
        resultInfo.setData(data);
        if (body == null || StringUtils.isEmpty((Object)body.getPath())) {
            files = OsUtil.isMac() ? new File("/Users").listFiles(file -> file.isDirectory() && file.getName().indexOf(".") != 0) : File.listRoots();
        } else {
            File file2 = new File(body.getPath());
            if (file2.exists() && file2.isDirectory()) {
                files = file2.listFiles();
            } else {
                resultInfo.setStatus(ResultInfo.ResultStatus.BAD.getCode()).setMsg("\u8def\u5f84\u4e0d\u5b58\u5728");
                return resultInfo;
            }
        }
        if (files != null && files.length > 0) {
            boolean isFileList = "file".equals(body.getModel());
            for (File tempFile : files) {
                if (tempFile.isFile()) {
                    if (!isFileList) continue;
                    data.add(new DirInfo(StringUtils.isEmpty((Object)tempFile.getName()) ? tempFile.getAbsolutePath() : tempFile.getName(), tempFile.getAbsolutePath(), true));
                    continue;
                }
                if (!tempFile.isDirectory() || tempFile.getParent() != null && tempFile.isHidden() || !OsUtil.isWindows() && tempFile.getName().indexOf(".") == 0) continue;
                DirInfo dirInfo = new DirInfo(StringUtils.isEmpty((Object)tempFile.getName()) ? tempFile.getAbsolutePath() : tempFile.getName(), tempFile.getAbsolutePath(), tempFile.listFiles() == null ? true : Arrays.stream(tempFile.listFiles()).noneMatch(file -> file != null && (file.isDirectory() || isFileList) && !file.isHidden()));
                data.add(dirInfo);
            }
        }
        return resultInfo;
    }

    @RequestMapping(value={"/pauseTask"})
    public ResultInfo pauseTask(@RequestParam String id) throws Exception {
        ResultInfo resultInfo = new ResultInfo();
        AbstractHttpDownBootstrap bootstrap = DownContent.getBoot((String)id);
        if (bootstrap == null) {
            resultInfo.setStatus(ResultInfo.ResultStatus.BAD.getCode()).setMsg("\u4efb\u52a1\u4e0d\u5b58\u5728");
        } else {
            bootstrap.pauseDown();
        }
        return resultInfo;
    }

    @RequestMapping(value={"/pauseAllTask"})
    public ResultInfo pauseAllTask(@RequestBody List<String> taskIds) throws Exception {
        ResultInfo resultInfo = new ResultInfo();
        if (taskIds != null && taskIds.size() > 0) {
            for (String taskId : taskIds) {
                AbstractHttpDownBootstrap bootstrap = DownContent.getBoot((String)taskId);
                if (bootstrap == null) continue;
                bootstrap.pauseDown();
            }
        }
        return resultInfo;
    }

    @RequestMapping(value={"/continueTask"})
    public ResultInfo continueTask(@RequestParam String id) throws Exception {
        ResultInfo resultInfo = new ResultInfo();
        AbstractHttpDownBootstrap bootstrap = DownContent.getBoot((String)id);
        if (bootstrap == null) {
            resultInfo.setStatus(ResultInfo.ResultStatus.BAD.getCode()).setMsg("\u4efb\u52a1\u4e0d\u5b58\u5728");
        } else {
            bootstrap.continueDown();
        }
        return resultInfo;
    }

    @RequestMapping(value={"/continueAllTask"})
    public ResultInfo continueAllTask(@RequestBody List<String> taskIds) throws Exception {
        ResultInfo resultInfo = new ResultInfo();
        if (taskIds != null && taskIds.size() > 0) {
            for (String taskId : taskIds) {
                AbstractHttpDownBootstrap bootstrap = DownContent.getBoot((String)taskId);
                if (bootstrap == null) continue;
                bootstrap.continueDown();
            }
        }
        return resultInfo;
    }

    @RequestMapping(value={"/deleteTask"})
    public ResultInfo deleteTask(@RequestParam String id, @RequestParam boolean delFile) throws Exception {
        ResultInfo resultInfo = new ResultInfo();
        AbstractHttpDownBootstrap bootstrap = DownContent.getBoot((String)id);
        if (bootstrap == null) {
            resultInfo.setStatus(ResultInfo.ResultStatus.BAD.getCode()).setMsg("\u4efb\u52a1\u4e0d\u5b58\u5728");
        } else {
            bootstrap.delete(delFile);
        }
        return resultInfo;
    }

    @RequestMapping(value={"/deleteAllTask"})
    public ResultInfo deleteAllTask(@RequestBody List<String> taskIds, @RequestParam boolean delFile) throws Exception {
        ResultInfo resultInfo = new ResultInfo();
        if (taskIds != null && taskIds.size() > 0) {
            for (String taskId : taskIds) {
                AbstractHttpDownBootstrap bootstrap = DownContent.getBoot((String)taskId);
                if (bootstrap == null) continue;
                bootstrap.delete(delFile);
            }
        }
        return resultInfo;
    }

    @RequestMapping(value={"/bdyUnzip"})
    public ResultInfo bdyUnzip(@RequestParam String id, @RequestParam boolean ignore, @RequestBody UnzipForm unzipForm) throws IOException {
        ResultInfo resultInfo = new ResultInfo();
        File file = new File(unzipForm.getFilePath());
        if (file.exists() && file.isFile()) {
            if (!unzipForm.getFilePath().equalsIgnoreCase(unzipForm.getToPath())) {
                if (ignore || BdyZip.isBdyZip((String)unzipForm.getFilePath())) {
                    UnzipInfo unzipInfo = new UnzipInfo().setId(id);
                    if (!FileUtil.exists((String)unzipForm.getToPath())) {
                        FileUtil.createDirSmart((String)unzipForm.getToPath());
                    }
                    if (!FileUtil.canWrite((String)unzipForm.getToPath())) {
                        resultInfo.setStatus(ResultInfo.ResultStatus.BAD.getCode()).setMsg("\u65e0\u6743\u8bbf\u95ee\u89e3\u538b\u8def\u5f84\uff0c\u8bf7\u4fee\u6539\u8def\u5f84\u6216\u5f00\u653e\u76ee\u5f55\u5199\u5165\u6743\u9650");
                        return resultInfo;
                    }
                    new Thread(() -> {
                        try {
                            BdyZip.unzip((String)unzipForm.getFilePath(), (String)unzipForm.getToPath(), (BdyZip.BdyUnzipCallback)new /* Unavailable Anonymous Inner Class!! */);
                        }
                        catch (Exception e) {
                            LOGGER.error("unzip error:", (Throwable)e);
                        }
                    }).start();
                } else {
                    resultInfo.setStatus(ResultInfo.ResultStatus.BAD.getCode());
                    resultInfo.setMsg("\u89e3\u538b\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4e3a\u767e\u5ea6\u4e91\u6279\u91cf\u4e0b\u8f7dzip\u6587\u4ef6");
                }
            } else {
                resultInfo.setStatus(ResultInfo.ResultStatus.BAD.getCode());
                resultInfo.setMsg("\u89e3\u538b\u5931\u8d25\uff0c\u6587\u4ef6\u8def\u5f84\u4e0e\u89e3\u538b\u8def\u5f84\u76f8\u540c");
            }
        } else {
            resultInfo.setStatus(ResultInfo.ResultStatus.BAD.getCode());
            resultInfo.setMsg("\u89e3\u538b\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        return resultInfo;
    }

    @RequestMapping(value={"/getConfigInfo"})
    public ResultInfo getConfigInfo() {
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.setData((Object)ContentManager.CONFIG.get());
        return resultInfo;
    }

    @RequestMapping(value={"/setConfigInfo"})
    public ResultInfo setConfigInfo(@RequestBody ConfigForm configForm) {
        ResultInfo resultInfo = new ResultInfo();
        int beforePort = ContentManager.CONFIG.get().getProxyPort();
        boolean beforeSecProxyEnable = ContentManager.CONFIG.get().isSecProxyEnable();
        ProxyConfig beforeSecProxyConfig = ContentManager.CONFIG.get().getSecProxyConfig();
        if (!configForm.isSecProxyEnable()) {
            configForm.setSecProxyConfig(null);
        }
        ConfigInfo configInfo = configForm.convert();
        ContentManager.CONFIG.set(configInfo);
        ContentManager.CONFIG.save();
        if (beforePort != configInfo.getProxyPort() || beforeSecProxyEnable != configInfo.isSecProxyEnable() || configInfo.isSecProxyEnable() && !configInfo.getSecProxyConfig().equals((Object)beforeSecProxyConfig)) {
            new Thread(() -> {
                HttpDownApplication.getProxyServer().close();
                HttpDownApplication.getProxyServer().setProxyConfig(configInfo.getSecProxyConfig());
                HttpDownApplication.getProxyServer().start(configInfo.getProxyPort());
            }).start();
        }
        return resultInfo;
    }

    @RequestMapping(value={"/getVersion"})
    public ResultInfo getVersion() {
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.setData((Object)Float.valueOf(this.version));
        return resultInfo;
    }

    @RequestMapping(value={"/checkUpdate"})
    public ResultInfo checkUpdate() throws Exception {
        ResultInfo resultInfo = new ResultInfo();
        updateInfo = updateService.check(this.version);
        if (updateInfo == null) {
            resultInfo.setStatus(ResultInfo.ResultStatus.BAD.getCode()).setMsg("\u5df2\u7ecf\u662f\u6700\u65b0\u7248\u672c");
            return resultInfo;
        }
        resultInfo.setData((Object)updateInfo);
        return resultInfo;
    }

    @RequestMapping(value={"/doUpdate"})
    public ResultInfo doUpdate() throws Exception {
        ResultInfo resultInfo = new ResultInfo();
        if (updateInfo == null) {
            resultInfo.setStatus(ResultInfo.ResultStatus.BAD.getCode()).setMsg("\u6ca1\u6709\u53ef\u7528\u7248\u672c\u8fdb\u884c\u66f4\u65b0");
            return resultInfo;
        }
        if (updateBootstrap != null) {
            updateBootstrap.close();
            updateBootstrap = null;
        }
        try {
            updateBootstrap = updateService.update(updateInfo, (HttpDownCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (TimeoutException e) {
            resultInfo.setStatus(ResultInfo.ResultStatus.BAD.getCode()).setMsg("\u68c0\u6d4b\u66f4\u65b0\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5");
            return resultInfo;
        }
        return resultInfo;
    }

    @RequestMapping(value={"/restart"})
    public ResultInfo restart() throws Exception {
        ResultInfo resultInfo = new ResultInfo();
        System.out.println("proxyee-down-update");
        return resultInfo;
    }

    @RequestMapping(value={"/buildTask"})
    public ResultInfo buildTask(@RequestBody BuildTaskForm form) throws Exception {
        return HttpDownController.commonBuildTask((BuildTaskForm)form);
    }

    @RequestMapping(value={"/getNewTask"})
    public ResultInfo getNewTask() throws Exception {
        ResultInfo resultInfo = new ResultInfo();
        TaskInfo taskInfo = ContentManager.DOWN.getWaitTask();
        if (taskInfo != null) {
            resultInfo.setData((Object)taskInfo.getId());
        }
        return resultInfo;
    }

    @RequestMapping(value={"/delNewTask"})
    public ResultInfo delNewTask(@RequestParam String id) throws Exception {
        ResultInfo resultInfo = new ResultInfo();
        ContentManager.DOWN.removeBoot(id);
        return resultInfo;
    }

    @RequestMapping(value={"/open"})
    public ResultInfo open(@RequestParam String url) throws Exception {
        ResultInfo resultInfo = new ResultInfo();
        if (ContentManager.CONFIG.get().getUiModel() == 1) {
            OsUtil.openBrowse((String)url);
        }
        resultInfo.setData((Object)ContentManager.CONFIG.get().getUiModel());
        return resultInfo;
    }

    @RequestMapping(value={"/openTaskDir"})
    public ResultInfo openTaskDir(@RequestParam String id) throws Exception {
        ResultInfo resultInfo = new ResultInfo();
        TaskInfo taskInfo = ContentManager.DOWN.getTaskInfo(id);
        if (taskInfo != null) {
            if (FileUtil.exists((String)taskInfo.getFilePath())) {
                Desktop.getDesktop().open(new File(taskInfo.getFilePath()));
            } else {
                resultInfo.setStatus(ResultInfo.ResultStatus.BAD.getCode()).setMsg("\u76ee\u5f55\u4e0d\u5b58\u5728");
            }
        } else {
            resultInfo.setStatus(ResultInfo.ResultStatus.BAD.getCode()).setMsg("\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        return resultInfo;
    }

    public static ResultInfo commonBuildTask(BuildTaskForm form) throws Exception {
        ResultInfo resultInfo = new ResultInfo();
        LinkedHashMap<String, String> heads = new LinkedHashMap<String, String>();
        if (form.getHeads() != null) {
            for (Map head : form.getHeads()) {
                String key = (String)head.get("key");
                String value = (String)head.get("value");
                if (StringUtils.isEmpty(head.get("key")) || StringUtils.isEmpty(head.get("value"))) continue;
                heads.put(key, value);
            }
        }
        try {
            HttpRequestInfo requestInfo = HttpDownUtil.buildGetRequest((String)form.getUrl(), heads, (String)form.getBody());
            TaskInfo taskInfo = HttpDownUtil.getTaskInfo((HttpRequest)requestInfo, null, (ProxyConfig)ContentManager.CONFIG.get().getSecProxyConfig(), (SslContext)HttpDownConstant.clientSslContext, (NioEventLoopGroup)HttpDownConstant.clientLoopGroup);
            HttpDownInfo httpDownInfo = new HttpDownInfo(taskInfo, (HttpRequest)requestInfo, ContentManager.CONFIG.get().getSecProxyConfig());
            ContentManager.DOWN.putBoot(httpDownInfo);
            resultInfo.setData((Object)taskInfo.getId());
        }
        catch (MalformedURLException e) {
            resultInfo.setStatus(ResultInfo.ResultStatus.BAD.getCode()).setMsg("\u94fe\u63a5\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        catch (TimeoutException e) {
            resultInfo.setStatus(ResultInfo.ResultStatus.BAD.getCode()).setMsg("\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5");
        }
        catch (Exception e) {
            throw new RuntimeException("buildTask error:" + form.toString(), e);
        }
        return resultInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultInfo commonStartTask(NewTaskForm taskForm) throws Exception {
        ResultInfo resultInfo = new ResultInfo();
        AbstractHttpDownBootstrap bootstrap = DownContent.getBoot((String)taskForm.getId());
        HttpDownInfo httpDownInfo = bootstrap.getHttpDownInfo();
        if (!StringUtils.isEmpty((Object)taskForm.getOldId())) {
            AbstractHttpDownBootstrap oldBootstrap = DownContent.getBoot((String)taskForm.getOldId());
            if (oldBootstrap == null) {
                resultInfo.setStatus(ResultInfo.ResultStatus.BAD.getCode()).setMsg("\u4efb\u52a1\u4e0d\u5b58\u5728");
                return resultInfo;
            }
            oldBootstrap.pauseDown();
            oldBootstrap.getHttpDownInfo().setRequest(httpDownInfo.getRequest());
            oldBootstrap.getHttpDownInfo().setProxyConfig(httpDownInfo.getProxyConfig());
            HashMap<String, Boolean> attr = oldBootstrap.getHttpDownInfo().getAttrs();
            if (attr == null) {
                attr = new HashMap<String, Boolean>();
                oldBootstrap.getHttpDownInfo().setAttrs(attr);
            }
            attr.put("isUnzip", taskForm.isUnzip());
            attr.put("unzipPath", (Boolean)((Object)taskForm.getUnzipPath()));
            ContentManager.DOWN.removeBoot(taskForm.getId());
            ContentManager.DOWN.save();
            oldBootstrap.continueDown();
        } else {
            TaskInfo taskInfo;
            if (StringUtils.isEmpty((Object)taskForm.getFileName())) {
                resultInfo.setStatus(ResultInfo.ResultStatus.BAD.getCode()).setMsg("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                return resultInfo;
            }
            if (StringUtils.isEmpty((Object)taskForm.getFilePath())) {
                resultInfo.setStatus(ResultInfo.ResultStatus.BAD.getCode()).setMsg("\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
                return resultInfo;
            }
            HttpDownController.buildDefaultValues((NewTaskForm)taskForm);
            TaskInfo taskInfo2 = taskInfo = httpDownInfo.getTaskInfo();
            synchronized (taskInfo2) {
                if (taskInfo.getStatus() != 0) {
                    resultInfo.setStatus(ResultInfo.ResultStatus.BAD.getCode()).setMsg("\u4efb\u52a1\u5df2\u6dfb\u52a0\u81f3\u4e0b\u8f7d\u5217\u8868");
                }
                taskInfo.setFileName(taskForm.getFileName());
                taskInfo.setFilePath(taskForm.getFilePath());
                HashMap<String, Boolean> attr = httpDownInfo.getAttrs();
                if (attr == null) {
                    attr = new HashMap<String, Boolean>();
                    httpDownInfo.setAttrs(attr);
                }
                attr.put("isUnzip", taskForm.isUnzip());
                attr.put("unzipPath", (Boolean)((Object)taskForm.getUnzipPath()));
                if (taskInfo.isSupportRange()) {
                    taskInfo.setConnections(taskForm.getConnections());
                } else {
                    taskInfo.setConnections(1);
                }
                try {
                    bootstrap.startDown();
                }
                catch (BootstrapException e) {
                    resultInfo.setStatus(ResultInfo.ResultStatus.BAD.getCode()).setMsg(e.getMessage());
                    return resultInfo;
                }
                String lastPath = ContentManager.CONFIG.get().getLastPath();
                if (!taskForm.getFilePath().equalsIgnoreCase(lastPath)) {
                    ContentManager.CONFIG.get().setLastPath(taskForm.getFilePath());
                    ContentManager.CONFIG.save();
                }
            }
        }
        return resultInfo;
    }

    private static void buildDefaultValues(NewTaskForm taskForm) {
        if (taskForm.getConnections() <= 0) {
            taskForm.setConnections(ContentManager.CONFIG.get().getConnections());
        }
        if (taskForm.isUnzip() && StringUtils.isEmpty((Object)taskForm.getUnzipPath())) {
            int index = taskForm.getFileName().lastIndexOf(".");
            if (index != -1) {
                taskForm.setUnzipPath(taskForm.getFilePath() + File.separator + taskForm.getFileName().substring(0, index));
            } else {
                taskForm.setUnzipPath(taskForm.getFilePath() + File.separator + taskForm.getFileName() + "_unzip");
            }
        }
    }

    static /* synthetic */ UpdateInfo access$000() {
        return updateInfo;
    }

    static {
        updateService = new GithubUpdateService();
    }
}

