/*
 * Decompiled with CFR 0.152.
 */
package lee.study.down.content;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lee.study.down.boot.TimeoutCheckTask;
import lee.study.down.constant.HttpDownConstant;
import lee.study.down.model.ConfigInfo;
import lee.study.down.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigContent {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigContent.class);
    private static ConfigInfo configContent;

    public void set(ConfigInfo configInfo) {
        configContent = configInfo;
        TimeoutCheckTask.setTimeout((int)configInfo.getTimeout());
    }

    public ConfigInfo get() {
        return configContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        ConfigInfo configInfo = configContent;
        synchronized (configInfo) {
            try (FileOutputStream outputStream = new FileOutputStream(HttpDownConstant.CONFIG_PATH);){
                JSON.writeJSONString((OutputStream)outputStream, (Object)configContent, (SerializerFeature[])new SerializerFeature[0]);
            }
            catch (IOException e) {
                LOGGER.error("\u5199\u5165\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
    }

    public void init() {
        if (FileUtil.exists((String)HttpDownConstant.CONFIG_PATH)) {
            try (FileInputStream inputStream = new FileInputStream(HttpDownConstant.CONFIG_PATH);){
                this.set((ConfigInfo)JSON.parseObject((InputStream)inputStream, ConfigInfo.class, (Feature[])new Feature[0]));
            }
            catch (Exception e) {
                if (!(e instanceof FileNotFoundException)) {
                    try {
                        FileUtil.deleteIfExists((String)HttpDownConstant.CONFIG_PATH);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                LOGGER.error("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        if (configContent == null || configContent.getProxyPort() == 0) {
            this.set(new ConfigInfo());
            this.save();
        }
    }
}

