﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.m_login, ims.web" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html>
<html id="m_login">
<head runat="server">
    <title>登录<%= ims.Sys.OrgName + ims.Sys.SysName %></title>
    <meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1,shrink-to-fit=no"><meta http-equiv="x-ua-compatible" content="ie=edge">
    <link rel="stylesheet" href="App_Themes/mobile.css">
    <link rel="icon" href="images/logo.png">
</head>
<body>
    <form id="form1" runat="server">
        <asp:ScriptManager ID="sm" runat="server" OnAsyncPostBackError="AsyncError" />
        <div class="container" id="loginArea">
            <div id="title"><%= ims.Sys.OrgName + ims.Sys.SysName %></div>
            <fieldset class="form-group">
			    <div class="input-group input-group-lg">
				    <span class="input-group-addon"><span class="fa-user"></span></span>
				    <input type="text" id="tbUser" runat="server" class="form-control" placeholder="用户名" autocomplete="off" />
			    </div>
		    </fieldset>
            <fieldset class="form-group">
			    <div class="input-group input-group-lg">
				    <span class="input-group-addon"><span class="fa-lock"></span></span>
				    <input type="password" id="tbPassword" runat="server" class="form-control" placeholder="密码" autocomplete="off" />
			    </div>
		    </fieldset>
            <fieldset class="form-group" runat="server" id="vcodeArea">
			    <div class="input-group input-group-lg">
				    <span class="input-group-addon"><span class="fa-right-hand"></span></span>
				    <input type="text" id="tbVcode" runat="server" class="form-control" placeholder="验证码" /><span class="input-group-addon" id="addonVcode" onclick="$f('imgVcode').src='vcode.aspx?time='+new Date().getTime();" title="验证码。点击刷新"><img id="imgVcode" src="vcode.aspx" /></span>
			    </div>
		    </fieldset>
            <table id="options">
                <tr>
                    <td class="small vtop middle"><label><input type="checkbox" id="remb" runat="server" /> 下次自动登录</label></td>
                    <td class="small vtop right"><a href="#" runat="server" onclick="return ShowPop('pop_popup');" id="forgetPwd">忘记密码？</a></td>
                </tr>
            </table>
            <div class="small" runat="server" id="toOrderVerify"><a href="orderVerify.aspx">我不想登录，希望直接提交订单</a></div>
            <asp:Button class="btn btn-lg btn-primary btn-block mtop_s" runat="server" id="btnLogin" OnClick="toLogin" Text="登 录"></asp:Button>
            <div class="center mtop_n small"><a runat="server" href="reg.aspx" id="aReg">注册新用户<i class="fa-angle-double-right"></i></a></div>
        </div>
        <asp:Button ID="resetPwdRecovery" runat="server" OnClick="ResetPwdRecovery" CausesValidation="false" CssClass="hide" />
        <ims:Mpop runat="server" ID="pop" Title="找回密码" ShowCancelButton="false" ShowOkButton="false" Width="25rem" OnClientCanel="$('#resetPwdRecovery').click();" ShowProgress="false">
        <ContentTemplate>
            <asp:Wizard ID="PwdRecovery" runat="server" DisplaySideBar="False" OnNextButtonClick="nextStep" Width="100%">
                <WizardSteps>
                    <asp:WizardStep ID="WizardStep1" runat="server">
                        <table class="mytable pwdrec mtop_n">
                            <tr>
                                <td style="width:4.5rem">用户名：</td>
                                <td><asp:TextBox ID="tbUserName" runat="server" CssClass="form-control" autocomplete="off"></asp:TextBox></td>
                            </tr>
                        </table>
                    </asp:WizardStep>
                    <asp:WizardStep ID="WizardStep2" runat="server">
                        <div class="alert alert-info" role="alert">要接收您的密码，请回答下列问题</div>
                        <table class="mytable pwdrec">
                            <tr>
                                <td style="width:3rem">问题：</td>
                                <td ID="question" runat="server"></td>
                            </tr>
                            <tr>
                                <td><div class="mtop_s">答案：</div></td>
                                <td><asp:TextBox ID="tbAnswer" runat="server" CssClass="form-control mtop_s" autocomplete="off"></asp:TextBox></td>
                            </tr>
                        </table>
                   </asp:WizardStep>
                    <asp:WizardStep ID="WizardStep3" runat="server">
                        <div class="alert alert-success" id="_msg" runat="server">密码已发送到您的邮箱。</div>
                    </asp:WizardStep>
                </WizardSteps>
                <StartNavigationTemplate>
                    <div class=" mtop_l right">
                        <asp:Button ID="btnStartNext" runat="server" CommandName="MoveNext" CssClass="btn btn-primary" CausesValidation="false" Text="下一步" />
                    </div>
                </StartNavigationTemplate>
                <NavigationButtonStyle CssClass="btn" />
                <StepNavigationTemplate>
                    <div class="mtop_l right">
                    <asp:Button ID="btnPrev" runat="server" CausesValidation="False" CommandName="MovePrevious" CssClass="btn btn-primary" Text="上一步" />
                    <asp:Button ID="btnNext" runat="server" CommandName="MoveNext" CssClass="btn btn-primary" CausesValidation="False" Text="下一步" />
                    </div>
                </StepNavigationTemplate>
                <NavigationStyle HorizontalAlign="Center" />
                <FinishNavigationTemplate>
                    <div class="right mtop_n">
                        <input type="button" value="确定" class="btn btn-primary" onclick="HideDialog();" />
                     </div>
               </FinishNavigationTemplate>
            </asp:Wizard>
        </ContentTemplate>
        </ims:Mpop>

        <ims:Mpop runat="server" ID="pwd" Title="您的密码是初始密码，请修改…" Width="22rem" ShowCancelButton="false" OnOkClick="ChangePwd" OnOkClientClick="return preChgPwd();" HideOnOkClientClick="false" ShowCloseButton="true" ShowProgress="true">
        <ContentTemplate>
            <table id="chgpwd">
                <tr><td class="right" style="width:6.5rem">　　新密码：</td><td><asp:TextBox runat="server" onkeydown="return pwdKeydown();" CssClass="form-control" TextMode="Password" ID="tbNew"></asp:TextBox></td></tr>
                <tr><td class="right">确认新密码：</td><td><asp:TextBox runat="server" onkeydown="return enterTo('pwd_btnChange');" CssClass="form-control" TextMode="Password" ID="tbVerify"></asp:TextBox></td></tr>
            </table>
        </ContentTemplate>
        </ims:Mpop>

    <script src="js/base.js"></script><script src="js/m_login.js"></script>
    </form>
</body>
</html>
