/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

public final class FillLayout
extends Layout {
    public int type = 256;
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int spacing = 0;

    public FillLayout() {
    }

    public FillLayout(int n2) {
        this.type = n2;
    }

    protected Point computeSize(Composite composite, int n2, int n3, boolean bl2) {
        Control[] controlArray = composite.getChildren();
        int n4 = controlArray.length;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            Control control = controlArray[n7];
            int n8 = n2;
            int n9 = n3;
            if (n4 > 0) {
                if (this.type == 256 && n2 != -1) {
                    n8 = Math.max(0, (n2 - (n4 - 1) * this.spacing) / n4);
                }
                if (this.type == 512 && n3 != -1) {
                    n9 = Math.max(0, (n3 - (n4 - 1) * this.spacing) / n4);
                }
            }
            Point point = this.computeChildSize(control, n8, n9, bl2);
            n5 = Math.max(n5, point.x);
            n6 = Math.max(n6, point.y);
            ++n7;
        }
        n7 = 0;
        int n10 = 0;
        if (this.type == 256) {
            n7 = n4 * n5;
            if (n4 != 0) {
                n7 += (n4 - 1) * this.spacing;
            }
            n10 = n6;
        } else {
            n7 = n5;
            n10 = n4 * n6;
            if (n4 != 0) {
                n10 += (n4 - 1) * this.spacing;
            }
        }
        n7 += this.marginWidth * 2;
        n10 += this.marginHeight * 2;
        if (n2 != -1) {
            n7 = n2;
        }
        if (n3 != -1) {
            n10 = n3;
        }
        return new Point(n7, n10);
    }

    Point computeChildSize(Control control, int n2, int n3, boolean bl2) {
        FillData fillData = (FillData)control.getLayoutData();
        if (fillData == null) {
            fillData = new FillData();
            control.setLayoutData(fillData);
        }
        Point point = null;
        if (n2 == -1 && n3 == -1) {
            point = fillData.computeSize(control, n2, n3, bl2);
        } else {
            int n4;
            int n5;
            if (control instanceof Scrollable) {
                Rectangle rectangle = ((Scrollable)control).computeTrim(0, 0, 0, 0);
                n5 = rectangle.width;
                n4 = rectangle.height;
            } else {
                n5 = n4 = control.getBorderWidth() * 2;
            }
            int n6 = n2 == -1 ? n2 : Math.max(0, n2 - n5);
            int n7 = n3 == -1 ? n3 : Math.max(0, n3 - n4);
            point = fillData.computeSize(control, n6, n7, bl2);
        }
        return point;
    }

    protected boolean flushCache(Control control) {
        Object object = control.getLayoutData();
        if (object != null) {
            ((FillData)object).flushCache();
        }
        return true;
    }

    String getName() {
        String string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return string;
        }
        return string.substring(n2 + 1, string.length());
    }

    protected void layout(Composite composite, boolean bl2) {
        Rectangle rectangle = composite.getClientArea();
        Control[] controlArray = composite.getChildren();
        int n2 = controlArray.length;
        if (n2 == 0) {
            return;
        }
        int n3 = rectangle.width - this.marginWidth * 2;
        int n4 = rectangle.height - this.marginHeight * 2;
        if (this.type == 256) {
            int n5 = rectangle.x + this.marginWidth;
            int n6 = (n3 -= (n2 - 1) * this.spacing) % n2;
            int n7 = rectangle.y + this.marginHeight;
            int n8 = n3 / n2;
            int n9 = 0;
            while (n9 < n2) {
                Control control = controlArray[n9];
                int n10 = n8;
                if (n9 == 0) {
                    n10 += n6 / 2;
                } else if (n9 == n2 - 1) {
                    n10 += (n6 + 1) / 2;
                }
                control.setBounds(n5, n7, n10, n4);
                n5 += n10 + this.spacing;
                ++n9;
            }
        } else {
            int n11 = rectangle.x + this.marginWidth;
            int n12 = (n4 -= (n2 - 1) * this.spacing) / n2;
            int n13 = rectangle.y + this.marginHeight;
            int n14 = n4 % n2;
            int n15 = 0;
            while (n15 < n2) {
                Control control = controlArray[n15];
                int n16 = n12;
                if (n15 == 0) {
                    n16 += n14 / 2;
                } else if (n15 == n2 - 1) {
                    n16 += (n14 + 1) / 2;
                }
                control.setBounds(n11, n13, n3, n16);
                n13 += n16 + this.spacing;
                ++n15;
            }
        }
    }

    public String toString() {
        String string = String.valueOf(this.getName()) + " {";
        string = String.valueOf(string) + "type=" + (this.type == 512 ? "SWT.VERTICAL" : "SWT.HORIZONTAL") + " ";
        if (this.marginWidth != 0) {
            string = String.valueOf(string) + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string = String.valueOf(string) + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.spacing != 0) {
            string = String.valueOf(string) + "spacing=" + this.spacing + " ";
        }
        string = string.trim();
        string = String.valueOf(string) + "}";
        return string;
    }
}

