/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.internal.image.PngLzBlockReader;

public class PngDecodingDataStream
extends InputStream {
    InputStream stream;
    byte currentByte;
    int nextBitIndex;
    PngLzBlockReader lzBlockReader;
    int adlerValue;
    static final int PRIME = 65521;
    static final int MAX_BIT = 7;

    PngDecodingDataStream(InputStream inputStream) throws IOException {
        this.stream = inputStream;
        this.nextBitIndex = 8;
        this.adlerValue = 1;
        this.lzBlockReader = new PngLzBlockReader(this);
        this.readCompressedDataHeader();
        this.lzBlockReader.readNextBlockHeader();
    }

    void assertImageDataAtEnd() throws IOException {
        this.lzBlockReader.assertCompressedDataAtEnd();
    }

    public void close() throws IOException {
        this.assertImageDataAtEnd();
        this.checkAdler();
    }

    int getNextIdatBits(int n2) throws IOException {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 |= this.getNextIdatBit() << i2;
        }
        return n3;
    }

    int getNextIdatBit() throws IOException {
        if (this.nextBitIndex > 7) {
            this.currentByte = this.getNextIdatByte();
            this.nextBitIndex = 0;
        }
        return (this.currentByte & 1 << this.nextBitIndex) >> this.nextBitIndex++;
    }

    byte getNextIdatByte() throws IOException {
        byte by2 = (byte)this.stream.read();
        this.nextBitIndex = 8;
        return by2;
    }

    void updateAdler(byte by2) {
        int n2 = this.adlerValue & 0xFFFF;
        int n3 = this.adlerValue >> 16 & 0xFFFF;
        int n4 = by2 & 0xFF;
        n2 = (n2 + n4) % 65521;
        n3 = (n2 + n3) % 65521;
        this.adlerValue = n3 << 16 | n2;
    }

    public int read() throws IOException {
        byte by2 = this.lzBlockReader.getNextByte();
        this.updateAdler(by2);
        return by2 & 0xFF;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = this.read();
            if (n4 == -1) {
                return i2;
            }
            byArray[n2 + i2] = (byte)n4;
        }
        return n3;
    }

    void error() {
        System.out.println("*** PngDecoding Error! --KEmulator ***");
    }

    private void readCompressedDataHeader() throws IOException {
        int n2;
        int n3;
        byte by2;
        byte by3 = this.getNextIdatByte();
        int n4 = (by3 & 0xFF) << 8 | (by2 = this.getNextIdatByte()) & 0xFF;
        if (n4 % 31 != 0) {
            this.error();
        }
        if ((n3 = by3 & 0xF) != 8) {
            this.error();
        }
        if ((n2 = (by3 & 0xF0) >> 4) > 7) {
            this.error();
        }
        int n5 = 1 << n2 + 8;
        this.lzBlockReader.setWindowSize(n5);
        int n6 = by2 & 0x20;
        if (n6 != 0) {
            this.error();
        }
    }

    void checkAdler() throws IOException {
        int n2 = (this.getNextIdatByte() & 0xFF) << 24 | (this.getNextIdatByte() & 0xFF) << 16 | (this.getNextIdatByte() & 0xFF) << 8 | this.getNextIdatByte() & 0xFF;
        if (n2 != this.adlerValue) {
            this.error();
        }
    }
}

