/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;

public final class PaletteData {
    public boolean isDirect;
    public RGB[] colors;
    public int redMask;
    public int greenMask;
    public int blueMask;
    public int redShift;
    public int greenShift;
    public int blueShift;

    public PaletteData(RGB[] rGBArray) {
        if (rGBArray == null) {
            SWT.error(4);
        }
        this.colors = rGBArray;
        this.isDirect = false;
    }

    public PaletteData(int n2, int n3, int n4) {
        this.redMask = n2;
        this.greenMask = n3;
        this.blueMask = n4;
        this.isDirect = true;
        this.redShift = this.shiftForMask(n2);
        this.greenShift = this.shiftForMask(n3);
        this.blueShift = this.shiftForMask(n4);
    }

    public int getPixel(RGB rGB) {
        if (rGB == null) {
            SWT.error(4);
        }
        if (this.isDirect) {
            int n2 = 0;
            n2 |= (this.redShift < 0 ? rGB.red << -this.redShift : rGB.red >>> this.redShift) & this.redMask;
            n2 |= (this.greenShift < 0 ? rGB.green << -this.greenShift : rGB.green >>> this.greenShift) & this.greenMask;
            return n2 |= (this.blueShift < 0 ? rGB.blue << -this.blueShift : rGB.blue >>> this.blueShift) & this.blueMask;
        }
        int n3 = 0;
        while (n3 < this.colors.length) {
            if (this.colors[n3].equals(rGB)) {
                return n3;
            }
            ++n3;
        }
        SWT.error(5);
        return 0;
    }

    public RGB getRGB(int n2) {
        if (this.isDirect) {
            int n3 = n2 & this.redMask;
            n3 = this.redShift < 0 ? n3 >>> -this.redShift : n3 << this.redShift;
            int n4 = n2 & this.greenMask;
            n4 = this.greenShift < 0 ? n4 >>> -this.greenShift : n4 << this.greenShift;
            int n5 = n2 & this.blueMask;
            n5 = this.blueShift < 0 ? n5 >>> -this.blueShift : n5 << this.blueShift;
            return new RGB(n3, n4, n5);
        }
        if (n2 < 0 || n2 >= this.colors.length) {
            SWT.error(5);
        }
        return this.colors[n2];
    }

    public RGB[] getRGBs() {
        return this.colors;
    }

    int shiftForMask(int n2) {
        int n3 = 31;
        while (n3 >= 0) {
            if ((n2 >> n3 & 1) != 0) {
                return 7 - n3;
            }
            --n3;
        }
        return 32;
    }
}

