/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.OS;

public final class Cursor
extends Resource {
    public int handle;
    boolean isIcon;
    static final byte[] HAND_SOURCE;
    static final byte[] HAND_MASK;

    static {
        byte[] byArray = new byte[128];
        byArray[0] = -7;
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -16;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -16;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -16;
        byArray[13] = -1;
        byArray[14] = -1;
        byArray[15] = -1;
        byArray[16] = -16;
        byArray[17] = 63;
        byArray[18] = -1;
        byArray[19] = -1;
        byArray[20] = -16;
        byArray[21] = 7;
        byArray[22] = -1;
        byArray[23] = -1;
        byArray[24] = -16;
        byArray[25] = 3;
        byArray[26] = -1;
        byArray[27] = -1;
        byArray[28] = -16;
        byArray[30] = -1;
        byArray[31] = -1;
        byArray[32] = 16;
        byArray[34] = 127;
        byArray[35] = -1;
        byArray[38] = 127;
        byArray[39] = -1;
        byArray[40] = -128;
        byArray[42] = 127;
        byArray[43] = -1;
        byArray[44] = -64;
        byArray[46] = 127;
        byArray[47] = -1;
        byArray[48] = -32;
        byArray[50] = 127;
        byArray[51] = -1;
        byArray[52] = -16;
        byArray[54] = 127;
        byArray[55] = -1;
        byArray[56] = -8;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -4;
        byArray[61] = 1;
        byArray[62] = -1;
        byArray[63] = -1;
        byArray[64] = -1;
        byArray[65] = -1;
        byArray[66] = -1;
        byArray[67] = -1;
        byArray[68] = -1;
        byArray[69] = -1;
        byArray[70] = -1;
        byArray[71] = -1;
        byArray[72] = -1;
        byArray[73] = -1;
        byArray[74] = -1;
        byArray[75] = -1;
        byArray[76] = -1;
        byArray[77] = -1;
        byArray[78] = -1;
        byArray[79] = -1;
        byArray[80] = -1;
        byArray[81] = -1;
        byArray[82] = -1;
        byArray[83] = -1;
        byArray[84] = -1;
        byArray[85] = -1;
        byArray[86] = -1;
        byArray[87] = -1;
        byArray[88] = -1;
        byArray[89] = -1;
        byArray[90] = -1;
        byArray[91] = -1;
        byArray[92] = -1;
        byArray[93] = -1;
        byArray[94] = -1;
        byArray[95] = -1;
        byArray[96] = -1;
        byArray[97] = -1;
        byArray[98] = -1;
        byArray[99] = -1;
        byArray[100] = -1;
        byArray[101] = -1;
        byArray[102] = -1;
        byArray[103] = -1;
        byArray[104] = -1;
        byArray[105] = -1;
        byArray[106] = -1;
        byArray[107] = -1;
        byArray[108] = -1;
        byArray[109] = -1;
        byArray[110] = -1;
        byArray[111] = -1;
        byArray[112] = -1;
        byArray[113] = -1;
        byArray[114] = -1;
        byArray[115] = -1;
        byArray[116] = -1;
        byArray[117] = -1;
        byArray[118] = -1;
        byArray[119] = -1;
        byArray[120] = -1;
        byArray[121] = -1;
        byArray[122] = -1;
        byArray[123] = -1;
        byArray[124] = -1;
        byArray[125] = -1;
        byArray[126] = -1;
        byArray[127] = -1;
        HAND_SOURCE = byArray;
        byte[] byArray2 = new byte[128];
        byArray2[4] = 6;
        byArray2[8] = 6;
        byArray2[12] = 6;
        byArray2[16] = 6;
        byArray2[20] = 6;
        byArray2[21] = -64;
        byArray2[24] = 6;
        byArray2[25] = -40;
        byArray2[28] = 6;
        byArray2[29] = -40;
        byArray2[32] = 7;
        byArray2[33] = -37;
        byArray2[36] = 103;
        byArray2[37] = -5;
        byArray2[40] = 63;
        byArray2[41] = -1;
        byArray2[44] = 31;
        byArray2[45] = -1;
        byArray2[48] = 15;
        byArray2[49] = -1;
        byArray2[52] = 7;
        byArray2[53] = -1;
        byArray2[56] = 3;
        byArray2[57] = -2;
        HAND_MASK = byArray2;
    }

    Cursor() {
    }

    public Cursor(Device device, int n2) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        int n3 = 0;
        switch (n2) {
            case 21: {
                n3 = 32649;
                break;
            }
            case 0: {
                n3 = 32512;
                break;
            }
            case 1: {
                n3 = 32514;
                break;
            }
            case 2: {
                n3 = 32515;
                break;
            }
            case 3: {
                n3 = 32650;
                break;
            }
            case 4: {
                n3 = 32651;
                break;
            }
            case 5: {
                n3 = 32646;
                break;
            }
            case 6: {
                n3 = 32643;
                break;
            }
            case 7: {
                n3 = 32645;
                break;
            }
            case 8: {
                n3 = 32642;
                break;
            }
            case 9: {
                n3 = 32644;
                break;
            }
            case 10: {
                n3 = 32645;
                break;
            }
            case 11: {
                n3 = 32645;
                break;
            }
            case 12: {
                n3 = 32644;
                break;
            }
            case 13: {
                n3 = 32644;
                break;
            }
            case 14: {
                n3 = 32643;
                break;
            }
            case 15: {
                n3 = 32642;
                break;
            }
            case 16: {
                n3 = 32643;
                break;
            }
            case 17: {
                n3 = 32642;
                break;
            }
            case 18: {
                n3 = 32516;
                break;
            }
            case 19: {
                n3 = 32513;
                break;
            }
            case 20: {
                n3 = 32648;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.handle = OS.LoadCursor(0, n3);
        if (this.handle == 0 && n2 == 21) {
            int n4 = OS.GetSystemMetrics(13);
            int n5 = OS.GetSystemMetrics(14);
            if (n4 == 32 && n5 == 32) {
                int n6 = OS.GetModuleHandle(null);
                if (OS.IsWinCE) {
                    SWT.error(20);
                }
                this.handle = OS.CreateCursor(n6, 5, 0, 32, 32, HAND_SOURCE, HAND_MASK);
            }
        }
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Cursor(Device device, ImageData imageData, ImageData imageData2, int n2, int n3) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            if (imageData.getTransparencyType() != 2) {
                SWT.error(4);
            }
            imageData2 = imageData.getTransparencyMask();
        }
        if (imageData2.width != imageData.width || imageData2.height != imageData.height) {
            SWT.error(5);
        }
        if (n2 >= imageData.width || n2 < 0 || n3 >= imageData.height || n3 < 0) {
            SWT.error(5);
        }
        imageData2 = ImageData.convertMask(imageData2);
        imageData = ImageData.convertMask(imageData);
        byte[] byArray = ImageData.convertPad(imageData.data, imageData.width, imageData.height, imageData.depth, imageData.scanlinePad, 2);
        byte[] byArray2 = ImageData.convertPad(imageData2.data, imageData2.width, imageData2.height, imageData2.depth, imageData2.scanlinePad, 2);
        int n4 = OS.GetModuleHandle(null);
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        this.handle = OS.CreateCursor(n4, n2, n3, imageData.width, imageData.height, byArray, byArray2);
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Cursor(Device device, ImageData imageData, int n2, int n3) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (imageData == null) {
            SWT.error(4);
        }
        if (n2 >= imageData.width || n2 < 0 || n3 >= imageData.height || n3 < 0) {
            SWT.error(5);
        }
        ImageData imageData2 = imageData.getTransparencyMask();
        int[] nArray = Image.init(device, null, imageData, imageData2);
        int n4 = nArray[0];
        int n5 = nArray[1];
        ICONINFO iCONINFO = new ICONINFO();
        iCONINFO.fIcon = false;
        iCONINFO.hbmColor = n4;
        iCONINFO.hbmMask = n5;
        iCONINFO.xHotspot = n2;
        iCONINFO.yHotspot = n3;
        this.handle = OS.CreateIconIndirect(iCONINFO);
        if (this.handle == 0) {
            SWT.error(2);
        }
        OS.DeleteObject(n4);
        OS.DeleteObject(n5);
        this.isIcon = true;
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        if (this.isIcon) {
            OS.DestroyIcon(this.handle);
        } else if (!OS.IsWinCE) {
            OS.DestroyCursor(this.handle);
        }
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && this.handle == cursor.handle;
    }

    public int hashCode() {
        return this.handle;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + this.handle + "}";
    }

    public static Cursor win32_new(Device device, int n2) {
        if (device == null) {
            device = Device.getDevice();
        }
        Cursor cursor = new Cursor();
        cursor.handle = n2;
        cursor.device = device;
        return cursor;
    }
}

