/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.LVHITTESTINFO;
import org.eclipse.swt.internal.win32.LVITEM;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableDropTargetEffect
extends DropTargetEffect {
    static final int SCROLL_HYSTERESIS = 200;
    int scrollIndex = -1;
    long scrollBeginTime;
    TableItem dropHighlight;

    public TableDropTargetEffect(Table table) {
        super(table);
    }

    int checkEffect(int n2) {
        if ((n2 & 1) != 0) {
            n2 = n2 & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((n2 & 2) != 0) {
            n2 &= 0xFFFFFFFB;
        }
        return n2;
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        this.scrollBeginTime = 0L;
        this.scrollIndex = -1;
        this.dropHighlight = null;
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
        Table table = (Table)this.control;
        int n2 = table.handle;
        if (this.dropHighlight != null) {
            LVITEM lVITEM = new LVITEM();
            lVITEM.stateMask = 8;
            OS.SendMessage(n2, 4139, -1, lVITEM);
            this.dropHighlight = null;
        }
        this.scrollBeginTime = 0L;
        this.scrollIndex = -1;
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        Table table = (Table)this.getControl();
        int n2 = this.checkEffect(dropTargetEvent.feedback);
        int n3 = table.handle;
        Point point = new Point(dropTargetEvent.x, dropTargetEvent.y);
        point = table.toControl(point);
        LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
        lVHITTESTINFO.x = point.x;
        lVHITTESTINFO.y = point.y;
        OS.SendMessage(n3, 4114, 0, lVHITTESTINFO);
        if ((n2 & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollIndex = -1;
        } else if (lVHITTESTINFO.iItem != -1 && this.scrollIndex == lVHITTESTINFO.iItem && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                int n4 = Math.max(0, OS.SendMessage(n3, 4135, 0, 0));
                int n5 = OS.SendMessage(n3, 4100, 0, 0);
                int n6 = this.scrollIndex - 1 < n4 ? Math.max(0, this.scrollIndex - 1) : Math.min(n5 - 1, this.scrollIndex + 1);
                boolean bl2 = true;
                if (lVHITTESTINFO.iItem == n4) {
                    bl2 = lVHITTESTINFO.iItem != n6;
                } else {
                    RECT rECT = new RECT();
                    rECT.left = 0;
                    if (OS.SendMessage(n3, 4110, lVHITTESTINFO.iItem, rECT) != 0) {
                        RECT rECT2 = new RECT();
                        OS.GetClientRect(n3, rECT2);
                        POINT pOINT = new POINT();
                        pOINT.x = rECT.left;
                        pOINT.y = rECT.top;
                        if (OS.PtInRect(rECT2, pOINT)) {
                            pOINT.y = rECT.bottom;
                            if (OS.PtInRect(rECT2, pOINT)) {
                                bl2 = false;
                            }
                        }
                    }
                }
                if (bl2) {
                    OS.SendMessage(n3, 4115, n6, 0);
                    table.redraw();
                }
                this.scrollBeginTime = 0L;
                this.scrollIndex = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 200L;
            this.scrollIndex = lVHITTESTINFO.iItem;
        }
        if (lVHITTESTINFO.iItem != -1 && (n2 & 1) != 0) {
            TableItem tableItem = table.getItem(lVHITTESTINFO.iItem);
            if (this.dropHighlight != tableItem) {
                LVITEM lVITEM = new LVITEM();
                lVITEM.stateMask = 8;
                OS.SendMessage(n3, 4139, -1, lVITEM);
                lVITEM.state = 8;
                OS.SendMessage(n3, 4139, lVHITTESTINFO.iItem, lVITEM);
                this.dropHighlight = tableItem;
            }
        } else if (this.dropHighlight != null) {
            LVITEM lVITEM = new LVITEM();
            lVITEM.stateMask = 8;
            OS.SendMessage(n3, 4139, -1, lVITEM);
            this.dropHighlight = null;
        }
    }
}

