/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.DROPFILES;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;

public class FileTransfer
extends ByteArrayTransfer {
    private static FileTransfer _instance = new FileTransfer();
    private static final String CF_HDROP = "CF_HDROP ";
    private static final int CF_HDROPID = 15;
    private static final String CF_HDROP_SEPARATOR = "\u0000";

    private FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String[] stringArray = (String[])object;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringBuffer.append(stringArray[n2]);
            stringBuffer.append(CF_HDROP_SEPARATOR);
            ++n2;
        }
        TCHAR tCHAR = new TCHAR(0, stringBuffer.toString(), true);
        DROPFILES dROPFILES = new DROPFILES();
        dROPFILES.pFiles = DROPFILES.sizeof;
        dROPFILES.pt_y = 0;
        dROPFILES.pt_x = 0;
        dROPFILES.fNC = 0;
        dROPFILES.fWide = OS.IsUnicode ? 1 : 0;
        int n3 = tCHAR.length() * TCHAR.sizeof;
        int n4 = OS.GlobalAlloc(64, DROPFILES.sizeof + n3);
        OS.MoveMemory(n4, dROPFILES, DROPFILES.sizeof);
        OS.MoveMemory(n4 + DROPFILES.sizeof, tCHAR, n3);
        transferData.stgmedium = new STGMEDIUM();
        transferData.stgmedium.tymed = 1;
        transferData.stgmedium.unionField = n4;
        transferData.stgmedium.pUnkForRelease = 0;
        transferData.result = 0;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pIDataObject == 0) {
            return null;
        }
        IDataObject iDataObject = new IDataObject(transferData.pIDataObject);
        iDataObject.AddRef();
        FORMATETC fORMATETC = new FORMATETC();
        fORMATETC.cfFormat = 15;
        fORMATETC.ptd = 0;
        fORMATETC.dwAspect = 1;
        fORMATETC.lindex = -1;
        fORMATETC.tymed = 1;
        STGMEDIUM sTGMEDIUM = new STGMEDIUM();
        sTGMEDIUM.tymed = 1;
        transferData.result = iDataObject.GetData(fORMATETC, sTGMEDIUM);
        iDataObject.Release();
        if (transferData.result != 0) {
            return null;
        }
        int n2 = OS.DragQueryFile(sTGMEDIUM.unionField, -1, null, 0);
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = OS.DragQueryFile(sTGMEDIUM.unionField, n3, null, 0) + 1;
            TCHAR tCHAR = new TCHAR(0, n4);
            OS.DragQueryFile(sTGMEDIUM.unionField, n3, tCHAR, n4);
            stringArray[n3] = tCHAR.toString(0, tCHAR.strlen());
            ++n3;
        }
        OS.DragFinish(sTGMEDIUM.unionField);
        return stringArray;
    }

    protected int[] getTypeIds() {
        return new int[]{15};
    }

    protected String[] getTypeNames() {
        return new String[]{CF_HDROP};
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] stringArray = (String[])object;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] == null || stringArray[n2].length() == 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkFile(object);
    }
}

