/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.DefaultContent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.MovementListener;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextDropTargetEffect;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.StyledTextListener;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.custom.StyledTextRenderer;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class StyledText
extends Canvas {
    static final char TAB = '\t';
    static final String PlatformLineDelimiter = System.getProperty("line.separator");
    static final int BIDI_CARET_WIDTH = 3;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int V_SCROLL_RATE = 50;
    static final int H_SCROLL_RATE = 10;
    static final int ExtendedModify = 3000;
    static final int LineGetBackground = 3001;
    static final int LineGetStyle = 3002;
    static final int TextChanging = 3003;
    static final int TextSet = 3004;
    static final int VerifyKey = 3005;
    static final int TextChanged = 3006;
    static final int LineGetSegments = 3007;
    static final int PaintObject = 3008;
    static final int WordNext = 3009;
    static final int WordPrevious = 3010;
    static final int PREVIOUS_OFFSET_TRAILING = 0;
    static final int OFFSET_LEADING = 1;
    Color selectionBackground;
    Color selectionForeground;
    StyledTextContent content;
    StyledTextRenderer renderer;
    Listener listener;
    TextChangeListener textChangeListener;
    int verticalScrollOffset = 0;
    int horizontalScrollOffset = 0;
    int topIndex = 0;
    int topIndexY;
    int clientAreaHeight = 0;
    int clientAreaWidth = 0;
    int tabLength = 4;
    int leftMargin;
    int topMargin;
    int rightMargin;
    int bottomMargin;
    int columnX;
    int caretOffset = 0;
    int caretAlignment;
    Point selection = new Point(0, 0);
    Point clipboardSelection;
    int selectionAnchor;
    Point doubleClickSelection;
    boolean editable = true;
    boolean wordWrap = false;
    boolean doubleClickEnabled = true;
    boolean overwrite = false;
    int textLimit = -1;
    Hashtable keyActionMap = new Hashtable();
    Color background = null;
    Color foreground = null;
    Clipboard clipboard;
    int clickCount;
    int autoScrollDirection = 0;
    int autoScrollDistance = 0;
    int lastTextChangeStart;
    int lastTextChangeNewLineCount;
    int lastTextChangeNewCharCount;
    int lastTextChangeReplaceLineCount;
    int lastTextChangeReplaceCharCount;
    int lastLineBottom;
    boolean isMirrored;
    boolean bidiColoring = false;
    Image leftCaretBitmap = null;
    Image rightCaretBitmap = null;
    int caretDirection = 0;
    Caret defaultCaret = null;
    boolean updateCaretDirection = true;
    boolean fixedLineHeight;
    boolean dragDetect = true;
    int alignment;
    boolean justify;
    int indent;
    int lineSpacing;
    static final boolean IS_CARBON;
    static final boolean IS_GTK;
    static final boolean IS_MOTIF;

    static {
        String string = SWT.getPlatform();
        IS_CARBON = "carbon".equals(string);
        IS_GTK = "gtk".equals(string);
        IS_MOTIF = "motif".equals(string);
    }

    public StyledText(Composite composite, int n2) {
        super(composite, StyledText.checkStyle(n2));
        super.setForeground(this.getForeground());
        super.setDragDetect(false);
        Display display = this.getDisplay();
        this.isMirrored = (super.getStyle() & 0x8000000) != 0;
        this.fixedLineHeight = true;
        if ((n2 & 8) != 0) {
            this.setEditable(false);
        }
        this.rightMargin = this.isBidiCaret() ? 2 : 0;
        this.leftMargin = this.rightMargin;
        if ((n2 & 4) != 0 && (n2 & 0x800) != 0) {
            this.bottomMargin = 2;
            this.rightMargin = 2;
            this.topMargin = 2;
            this.leftMargin = 2;
        }
        this.alignment = n2 & 0x1024000;
        if (this.alignment == 0) {
            this.alignment = 16384;
        }
        this.clipboard = new Clipboard(display);
        this.installDefaultContent();
        this.renderer = new StyledTextRenderer(this.getDisplay(), this);
        this.renderer.setContent(this.content);
        this.renderer.setFont(this.getFont(), this.tabLength);
        this.defaultCaret = new Caret(this, 0);
        if ((n2 & 0x40) != 0) {
            this.setWordWrap(true);
        }
        if (this.isBidiCaret()) {
            this.createCaretBitmaps();
            Runnable runnable = new Runnable(){

                public void run() {
                    int n2;
                    int n3 = n2 = BidiUtil.getKeyboardLanguage() == 1 ? 131072 : 16384;
                    if (n2 == StyledText.this.caretDirection) {
                        return;
                    }
                    if (StyledText.this.getCaret() != StyledText.this.defaultCaret) {
                        return;
                    }
                    Point point = StyledText.this.getPointAtOffset(StyledText.this.caretOffset);
                    StyledText.this.setCaretLocation(point, n2);
                }
            };
            BidiUtil.addLanguageListener(this.handle, runnable);
        }
        this.setCaret(this.defaultCaret);
        this.calculateScrollBars();
        this.createKeyBindings();
        this.setCursor(display.getSystemCursor(19));
        this.installListeners();
        this.initializeAccessible();
        this.setData("DEFAULT_DROP_TARGET_EFFECT", new StyledTextDropTargetEffect(this));
    }

    public void addExtendedModifyListener(ExtendedModifyListener extendedModifyListener) {
        this.checkWidget();
        if (extendedModifyListener == null) {
            SWT.error(4);
        }
        StyledTextListener styledTextListener = new StyledTextListener(extendedModifyListener);
        this.addListener(3000, styledTextListener);
    }

    public void addBidiSegmentListener(BidiSegmentListener bidiSegmentListener) {
        this.checkWidget();
        if (bidiSegmentListener == null) {
            SWT.error(4);
        }
        this.addListener(3007, new StyledTextListener(bidiSegmentListener));
    }

    public void addLineBackgroundListener(LineBackgroundListener lineBackgroundListener) {
        this.checkWidget();
        if (lineBackgroundListener == null) {
            SWT.error(4);
        }
        if (!this.isListening(3001)) {
            this.renderer.clearLineBackground(0, this.content.getLineCount());
        }
        this.addListener(3001, new StyledTextListener(lineBackgroundListener));
    }

    public void addLineStyleListener(LineStyleListener lineStyleListener) {
        this.checkWidget();
        if (lineStyleListener == null) {
            SWT.error(4);
        }
        if (!this.isListening(3002)) {
            this.setStyleRanges(0, 0, null, null, true);
            this.renderer.clearLineStyle(0, this.content.getLineCount());
        }
        this.addListener(3002, new StyledTextListener(lineStyleListener));
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error(4);
        }
        this.addListener(24, new TypedListener(modifyListener));
    }

    public void addPaintObjectListener(PaintObjectListener paintObjectListener) {
        this.checkWidget();
        if (paintObjectListener == null) {
            SWT.error(4);
        }
        this.addListener(3008, new StyledTextListener(paintObjectListener));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.addListener(13, new TypedListener(selectionListener));
    }

    public void addVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        this.checkWidget();
        if (verifyKeyListener == null) {
            SWT.error(4);
        }
        this.addListener(3005, new StyledTextListener(verifyKeyListener));
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            SWT.error(4);
        }
        this.addListener(25, new TypedListener(verifyListener));
    }

    public void addWordMovementListener(MovementListener movementListener) {
        this.checkWidget();
        if (this.listener == null) {
            SWT.error(4);
        }
        this.addListener(3009, new StyledTextListener(movementListener));
        this.addListener(3010, new StyledTextListener(movementListener));
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        int n2 = Math.max(this.getCharCount(), 0);
        this.replaceTextRange(n2, 0, string);
    }

    void calculateScrollBars() {
        ScrollBar scrollBar = this.getHorizontalBar();
        ScrollBar scrollBar2 = this.getVerticalBar();
        this.setScrollBars(true);
        if (scrollBar2 != null) {
            scrollBar2.setIncrement(this.getVerticalIncrement());
        }
        if (scrollBar != null) {
            scrollBar.setIncrement(this.getHorizontalIncrement());
        }
    }

    void calculateTopIndex(int n2) {
        int n3 = this.topIndex;
        int n4 = this.topIndexY;
        if (this.isFixedLineHeight()) {
            int n5 = this.getVerticalIncrement();
            if (n5 == 0) {
                return;
            }
            this.topIndex = Compatibility.ceil(this.getVerticalScrollOffset(), n5);
            if (this.topIndex > 0) {
                if (this.clientAreaHeight > 0) {
                    int n6;
                    int n7 = this.getVerticalScrollOffset() + this.clientAreaHeight;
                    int n8 = n7 - (n6 = this.topIndex * n5);
                    if (n8 < n5) {
                        --this.topIndex;
                    }
                } else if (this.topIndex >= this.content.getLineCount()) {
                    this.topIndex = this.content.getLineCount() - 1;
                }
            }
        } else if (n2 >= 0) {
            n2 -= this.topIndexY;
            int n9 = this.topIndex;
            int n10 = this.content.getLineCount();
            while (n9 < n10) {
                if (n2 <= 0) break;
                n2 -= this.renderer.getLineHeight(n9++);
            }
            if (n9 < n10 && -n2 + this.renderer.getLineHeight(n9) <= this.clientAreaHeight - this.topMargin - this.bottomMargin) {
                this.topIndex = n9;
                this.topIndexY = -n2;
            } else {
                this.topIndex = n9 - 1;
                this.topIndexY = -this.renderer.getLineHeight(this.topIndex) - n2;
            }
        } else {
            n2 -= this.topIndexY;
            int n11 = this.topIndex;
            while (n11 > 0) {
                int n12 = this.renderer.getLineHeight(n11 - 1);
                if (n2 + n12 > 0) break;
                n2 += n12;
                --n11;
            }
            if (n11 == 0 || -n2 + this.renderer.getLineHeight(n11) <= this.clientAreaHeight - this.topMargin - this.bottomMargin) {
                this.topIndex = n11;
                this.topIndexY = -n2;
            } else {
                this.topIndex = n11 - 1;
                this.topIndexY = -this.renderer.getLineHeight(this.topIndex) - n2;
            }
        }
        if (this.topIndex != n3 || n4 != this.topIndexY) {
            this.renderer.calculateClientArea();
            this.setScrollBars(false);
        }
    }

    static int checkStyle(int n2) {
        if ((n2 & 4) != 0) {
            n2 &= 0xFFFFFCBD;
        } else if (((n2 |= 2) & 0x40) != 0) {
            n2 &= 0xFFFFFEFF;
        }
        return n2 |= 0x20140000;
    }

    void claimBottomFreeSpace() {
        int n2 = this.clientAreaHeight - this.topMargin - this.bottomMargin;
        if (this.isFixedLineHeight()) {
            int n3 = this.renderer.getLineHeight();
            int n4 = Math.max(0, this.content.getLineCount() * n3 - n2);
            if (n4 < this.getVerticalScrollOffset()) {
                this.scrollVertical(n4 - this.getVerticalScrollOffset(), true);
            }
        } else {
            int n5 = this.getPartialBottomIndex();
            int n6 = this.getLinePixel(n5 + 1);
            if (n2 > n6) {
                this.scrollVertical(-this.getAvailableHeightAbove(n2 - n6), true);
            }
        }
    }

    void claimRightFreeSpace() {
        int n2 = Math.max(0, this.renderer.getWidth() - (this.clientAreaWidth - this.leftMargin - this.rightMargin));
        if (n2 < this.horizontalScrollOffset) {
            this.scrollHorizontal(n2 - this.horizontalScrollOffset, true);
        }
    }

    void clearSelection(boolean bl2) {
        int n2 = this.selection.x;
        int n3 = this.selection.y;
        this.resetSelection();
        if (n3 - n2 > 0) {
            int n4 = this.content.getCharCount();
            int n5 = Math.min(n2, n4);
            int n6 = Math.min(n3, n4);
            if (n6 - n5 > 0) {
                this.internalRedrawRange(n5, n6 - n5);
            }
            if (bl2) {
                this.sendSelectionEvent();
            }
        }
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        int n4;
        this.checkWidget();
        int n5 = (this.getStyle() & 4) != 0 ? 1 : this.content.getLineCount();
        int n6 = 0;
        int n7 = 0;
        if (n2 == -1 || n3 == -1) {
            Display display = this.getDisplay();
            n4 = display.getClientArea().height;
            int n8 = 0;
            while (n8 < n5) {
                TextLayout textLayout = this.renderer.getTextLayout(n8);
                if (this.wordWrap) {
                    textLayout.setWidth(n2 == 0 ? 1 : n2);
                }
                Rectangle rectangle = textLayout.getBounds();
                n6 = Math.max(n6, rectangle.width);
                this.renderer.disposeTextLayout(textLayout);
                if (this.isFixedLineHeight() && (n7 += rectangle.height) > n4) break;
                ++n8;
            }
            if (this.isFixedLineHeight()) {
                n7 = n5 * this.renderer.getLineHeight();
            }
        }
        if (n6 == 0) {
            n6 = 64;
        }
        if (n7 == 0) {
            n7 = 64;
        }
        if (n2 != -1) {
            n6 = n2;
        }
        if (n3 != -1) {
            n7 = n3;
        }
        int n9 = this.leftMargin + this.rightMargin + this.getCaretWidth();
        n4 = this.topMargin + this.bottomMargin;
        Rectangle rectangle = this.computeTrim(0, 0, n6 + n9, n7 + n4);
        return new Point(rectangle.width, rectangle.height);
    }

    public void copy() {
        this.checkWidget();
        this.copy(1);
    }

    public void copy(int n2) {
        block4: {
            this.checkWidget();
            if (n2 != 1 && n2 != 2) {
                return;
            }
            int n3 = this.selection.y - this.selection.x;
            if (n3 > 0) {
                try {
                    this.setClipboardContent(this.selection.x, n3, n2);
                }
                catch (SWTError sWTError) {
                    if (sWTError.code == 2002) break block4;
                    throw sWTError;
                }
            }
        }
    }

    public int getAlignment() {
        this.checkWidget();
        return this.alignment;
    }

    int getAvailableHeightAbove(int n2) {
        int n3 = this.verticalScrollOffset;
        if (n3 == -1) {
            int n4 = this.topIndex - 1;
            n3 = -this.topIndexY;
            if (this.topIndexY > 0) {
                n3 += this.renderer.getLineHeight(n4--);
            }
            while (n2 > n3 && n4 >= 0) {
                n3 += this.renderer.getLineHeight(n4--);
            }
        }
        return Math.min(n2, n3);
    }

    int getAvailableHeightBellow(int n2) {
        int n3 = this.getPartialBottomIndex();
        int n4 = this.getLinePixel(n3);
        int n5 = this.renderer.getLineHeight(n3);
        int n6 = 0;
        int n7 = this.clientAreaHeight - this.topMargin - this.bottomMargin;
        if (n4 + n5 > n7) {
            n6 = n5 - (n7 - n4);
        }
        int n8 = n3 + 1;
        int n9 = this.content.getLineCount();
        while (n2 > n6 && n8 < n9) {
            n6 += this.renderer.getLineHeight(n8++);
        }
        return Math.min(n2, n6);
    }

    String getModelDelimitedText(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        StringBuffer stringBuffer = new StringBuffer(n2);
        String string2 = this.getLineDelimiter();
        while (n5 < n2) {
            if (n3 != -1) {
                n3 = string.indexOf(13, n5);
            }
            if (n4 != -1) {
                n4 = string.indexOf(10, n5);
            }
            if (n4 == -1 && n3 == -1) break;
            if (n3 < n4 && n3 != -1 || n4 == -1) {
                stringBuffer.append(string.substring(n5, n3));
                n5 = n4 == n3 + 1 ? n4 + 1 : n3 + 1;
            } else {
                stringBuffer.append(string.substring(n5, n4));
                n5 = n4 + 1;
            }
            if (this.isSingleLine()) break;
            stringBuffer.append(string2);
        }
        if (!(n5 >= n2 || this.isSingleLine() && stringBuffer.length() != 0)) {
            stringBuffer.append(string.substring(n5));
        }
        return stringBuffer.toString();
    }

    boolean checkDragDetect(Event event) {
        if (!this.isListening(29)) {
            return false;
        }
        if (IS_MOTIF ? event.button != 2 : event.button != 1) {
            return false;
        }
        if (this.selection.x == this.selection.y) {
            return false;
        }
        int n2 = this.getOffsetAtPoint(event.x, event.y);
        if (n2 > this.selection.x && n2 < this.selection.y) {
            return this.dragDetect(event);
        }
        return false;
    }

    void createKeyBindings() {
        int n2 = this.isMirrored() ? 0x1000003 : 0x1000004;
        int n3 = this.isMirrored() ? 0x1000004 : 0x1000003;
        this.setKeyBinding(0x1000001, 0x1000001);
        this.setKeyBinding(0x1000002, 0x1000002);
        if (IS_CARBON) {
            this.setKeyBinding(n3 | SWT.MOD1, 0x1000007);
            this.setKeyBinding(n2 | SWT.MOD1, 0x1000008);
            this.setKeyBinding(0x1000007, 17039367);
            this.setKeyBinding(0x1000008, 17039368);
            this.setKeyBinding(0x1000001 | SWT.MOD1, 17039367);
            this.setKeyBinding(0x1000002 | SWT.MOD1, 17039368);
            this.setKeyBinding(n2 | SWT.MOD3, 0x1040004);
            this.setKeyBinding(n3 | SWT.MOD3, 17039363);
        } else {
            this.setKeyBinding(0x1000007, 0x1000007);
            this.setKeyBinding(0x1000008, 0x1000008);
            this.setKeyBinding(0x1000007 | SWT.MOD1, 17039367);
            this.setKeyBinding(0x1000008 | SWT.MOD1, 17039368);
            this.setKeyBinding(n2 | SWT.MOD1, 0x1040004);
            this.setKeyBinding(n3 | SWT.MOD1, 17039363);
        }
        this.setKeyBinding(0x1000005, 0x1000005);
        this.setKeyBinding(0x1000006, 0x1000006);
        this.setKeyBinding(0x1000005 | SWT.MOD1, 17039365);
        this.setKeyBinding(0x1000006 | SWT.MOD1, 17039366);
        this.setKeyBinding(n2, 0x1000004);
        this.setKeyBinding(n3, 0x1000003);
        this.setKeyBinding(0x1000001 | SWT.MOD2, 0x1020001);
        this.setKeyBinding(0x1000002 | SWT.MOD2, 0x1020002);
        if (IS_CARBON) {
            this.setKeyBinding(n3 | SWT.MOD1 | SWT.MOD2, 16908295);
            this.setKeyBinding(n2 | SWT.MOD1 | SWT.MOD2, 16908296);
            this.setKeyBinding(0x1000007 | SWT.MOD2, 17170439);
            this.setKeyBinding(0x1000008 | SWT.MOD2, 17170440);
            this.setKeyBinding(0x1000001 | SWT.MOD1 | SWT.MOD2, 17170439);
            this.setKeyBinding(0x1000002 | SWT.MOD1 | SWT.MOD2, 17170440);
            this.setKeyBinding(n2 | SWT.MOD2 | SWT.MOD3, 17170436);
            this.setKeyBinding(n3 | SWT.MOD2 | SWT.MOD3, 17170435);
        } else {
            this.setKeyBinding(0x1000007 | SWT.MOD2, 16908295);
            this.setKeyBinding(0x1000008 | SWT.MOD2, 16908296);
            this.setKeyBinding(0x1000007 | SWT.MOD1 | SWT.MOD2, 17170439);
            this.setKeyBinding(0x1000008 | SWT.MOD1 | SWT.MOD2, 17170440);
            this.setKeyBinding(n2 | SWT.MOD1 | SWT.MOD2, 17170436);
            this.setKeyBinding(n3 | SWT.MOD1 | SWT.MOD2, 17170435);
        }
        this.setKeyBinding(0x1000005 | SWT.MOD2, 16908293);
        this.setKeyBinding(0x1000006 | SWT.MOD2, 16908294);
        this.setKeyBinding(0x1000005 | SWT.MOD1 | SWT.MOD2, 17170437);
        this.setKeyBinding(0x1000006 | SWT.MOD1 | SWT.MOD2, 0x1060006);
        this.setKeyBinding(n2 | SWT.MOD2, 16908292);
        this.setKeyBinding(n3 | SWT.MOD2, 16908291);
        this.setKeyBinding(0x58 | SWT.MOD1, 131199);
        this.setKeyBinding(0x43 | SWT.MOD1, 17039369);
        this.setKeyBinding(0x56 | SWT.MOD1, 16908297);
        if (IS_CARBON) {
            this.setKeyBinding(0x7F | SWT.MOD2, 127);
            this.setKeyBinding(8 | SWT.MOD3, 262152);
            this.setKeyBinding(0x7F | SWT.MOD3, 262271);
        } else {
            this.setKeyBinding(0x7F | SWT.MOD2, 131199);
            this.setKeyBinding(0x1000009 | SWT.MOD1, 17039369);
            this.setKeyBinding(0x1000009 | SWT.MOD2, 16908297);
        }
        this.setKeyBinding(8 | SWT.MOD2, 8);
        this.setKeyBinding(8, 8);
        this.setKeyBinding(127, 127);
        this.setKeyBinding(8 | SWT.MOD1, 262152);
        this.setKeyBinding(0x7F | SWT.MOD1, 262271);
        this.setKeyBinding(0x1000009, 0x1000009);
    }

    void createCaretBitmaps() {
        int n2 = 3;
        Display display = this.getDisplay();
        if (this.leftCaretBitmap != null) {
            if (this.defaultCaret != null && this.leftCaretBitmap.equals(this.defaultCaret.getImage())) {
                this.defaultCaret.setImage(null);
            }
            this.leftCaretBitmap.dispose();
        }
        int n3 = this.renderer.getLineHeight();
        this.leftCaretBitmap = new Image((Device)display, n2, n3);
        GC gC = new GC(this.leftCaretBitmap);
        gC.setBackground(display.getSystemColor(2));
        gC.fillRectangle(0, 0, n2, n3);
        gC.setForeground(display.getSystemColor(1));
        gC.drawLine(0, 0, 0, n3);
        gC.drawLine(0, 0, n2 - 1, 0);
        gC.drawLine(0, 1, 1, 1);
        gC.dispose();
        if (this.rightCaretBitmap != null) {
            if (this.defaultCaret != null && this.rightCaretBitmap.equals(this.defaultCaret.getImage())) {
                this.defaultCaret.setImage(null);
            }
            this.rightCaretBitmap.dispose();
        }
        this.rightCaretBitmap = new Image((Device)display, n2, n3);
        gC = new GC(this.rightCaretBitmap);
        gC.setBackground(display.getSystemColor(2));
        gC.fillRectangle(0, 0, n2, n3);
        gC.setForeground(display.getSystemColor(1));
        gC.drawLine(n2 - 1, 0, n2 - 1, n3);
        gC.drawLine(0, 0, n2 - 1, 0);
        gC.drawLine(n2 - 1, 1, 1, 1);
        gC.dispose();
    }

    public void cut() {
        this.checkWidget();
        int n2 = this.selection.y - this.selection.x;
        if (n2 > 0) {
            try {
                this.setClipboardContent(this.selection.x, n2, 1);
            }
            catch (SWTError sWTError) {
                if (sWTError.code != 2002) {
                    throw sWTError;
                }
                return;
            }
            this.doDelete();
        }
    }

    void doAutoScroll(Event event) {
        if (event.y > this.clientAreaHeight) {
            this.doAutoScroll(1024, event.y - this.clientAreaHeight);
        } else if (event.y < 0) {
            this.doAutoScroll(128, -event.y);
        } else if (event.x < this.leftMargin && !this.wordWrap) {
            this.doAutoScroll(0x1000003, this.leftMargin - event.x);
        } else if (event.x > this.clientAreaWidth - this.leftMargin - this.rightMargin && !this.wordWrap) {
            this.doAutoScroll(0x1000004, event.x - (this.clientAreaWidth - this.leftMargin - this.rightMargin));
        } else {
            this.endAutoScroll();
        }
    }

    void doAutoScroll(int n2, int n3) {
        this.autoScrollDistance = n3;
        if (this.autoScrollDirection == n2) {
            return;
        }
        Runnable runnable = null;
        final Display display = this.getDisplay();
        if (n2 == 128) {
            runnable = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 128) {
                        StyledText.this.doSelectionPageUp(StyledText.this.autoScrollDistance);
                        display.timerExec(50, this);
                    }
                }
            };
            this.autoScrollDirection = n2;
            display.timerExec(50, runnable);
        } else if (n2 == 1024) {
            runnable = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 1024) {
                        StyledText.this.doSelectionPageDown(StyledText.this.autoScrollDistance);
                        display.timerExec(50, this);
                    }
                }
            };
            this.autoScrollDirection = n2;
            display.timerExec(50, runnable);
        } else if (n2 == 0x1000004) {
            runnable = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 0x1000004) {
                        StyledText.this.doVisualNext();
                        StyledText.this.setMouseWordSelectionAnchor();
                        StyledText.this.doMouseSelection();
                        display.timerExec(10, this);
                    }
                }
            };
            this.autoScrollDirection = n2;
            display.timerExec(10, runnable);
        } else if (n2 == 0x1000003) {
            runnable = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 0x1000003) {
                        StyledText.this.doVisualPrevious();
                        StyledText.this.setMouseWordSelectionAnchor();
                        StyledText.this.doMouseSelection();
                        display.timerExec(10, this);
                    }
                }
            };
            this.autoScrollDirection = n2;
            display.timerExec(10, runnable);
        }
    }

    void doBackspace() {
        Event event = new Event();
        event.text = "";
        if (this.selection.x != this.selection.y) {
            event.start = this.selection.x;
            event.end = this.selection.y;
            this.sendKeyEvent(event);
        } else if (this.caretOffset > 0) {
            int n2 = this.content.getLineAtOffset(this.caretOffset);
            int n3 = this.content.getOffsetAtLine(n2);
            if (this.caretOffset == n3) {
                n3 = this.content.getOffsetAtLine(n2 - 1);
                event.start = n3 + this.content.getLine(n2 - 1).length();
                event.end = this.caretOffset;
            } else {
                TextLayout textLayout = this.renderer.getTextLayout(n2);
                int n4 = textLayout.getPreviousOffset(this.caretOffset - n3, 1);
                this.renderer.disposeTextLayout(textLayout);
                event.start = n4 + n3;
                event.end = this.caretOffset;
            }
            this.sendKeyEvent(event);
        }
    }

    void doContent(char c2) {
        if (this.textLimit > 0 && this.content.getCharCount() - (this.selection.y - this.selection.x) >= this.textLimit) {
            return;
        }
        Event event = new Event();
        event.start = this.selection.x;
        event.end = this.selection.y;
        if (c2 == '\r' || c2 == '\n') {
            if (!this.isSingleLine()) {
                event.text = this.getLineDelimiter();
            }
        } else if (this.selection.x == this.selection.y && this.overwrite && c2 != '\t') {
            String string;
            int n2 = this.content.getLineAtOffset(event.end);
            int n3 = this.content.getOffsetAtLine(n2);
            if (event.end < n3 + (string = this.content.getLine(n2)).length()) {
                ++event.end;
            }
            event.text = new String(new char[]{c2});
        } else {
            event.text = new String(new char[]{c2});
        }
        if (event.text != null) {
            this.sendKeyEvent(event);
        }
    }

    void doContentEnd() {
        if (this.isSingleLine()) {
            this.doLineEnd();
        } else {
            int n2 = this.content.getCharCount();
            if (this.caretOffset < n2) {
                this.caretOffset = n2;
                this.showCaret();
            }
        }
    }

    void doContentStart() {
        if (this.caretOffset > 0) {
            this.caretOffset = 0;
            this.showCaret();
        }
    }

    void doCursorPrevious() {
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.x;
            this.caretAlignment = 1;
            this.showCaret();
        } else {
            this.doSelectionCursorPrevious();
        }
    }

    void doCursorNext() {
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.y;
            this.caretAlignment = 0;
            this.showCaret();
        } else {
            this.doSelectionCursorNext();
        }
    }

    void doDelete() {
        Event event = new Event();
        event.text = "";
        if (this.selection.x != this.selection.y) {
            event.start = this.selection.x;
            event.end = this.selection.y;
            this.sendKeyEvent(event);
        } else if (this.caretOffset < this.content.getCharCount()) {
            int n2;
            int n3 = this.content.getLineAtOffset(this.caretOffset);
            int n4 = this.content.getOffsetAtLine(n3);
            if (this.caretOffset == n4 + (n2 = this.content.getLine(n3).length())) {
                event.start = this.caretOffset;
                event.end = this.content.getOffsetAtLine(n3 + 1);
            } else {
                event.start = this.caretOffset;
                event.end = this.getClusterNext(this.caretOffset, n3);
            }
            this.sendKeyEvent(event);
        }
    }

    void doDeleteWordNext() {
        if (this.selection.x != this.selection.y) {
            this.doDelete();
        } else {
            Event event = new Event();
            event.text = "";
            event.start = this.caretOffset;
            event.end = this.getWordNext(this.caretOffset, 4);
            this.sendKeyEvent(event);
        }
    }

    void doDeleteWordPrevious() {
        if (this.selection.x != this.selection.y) {
            this.doBackspace();
        } else {
            Event event = new Event();
            event.text = "";
            event.start = this.getWordPrevious(this.caretOffset, 4);
            event.end = this.caretOffset;
            this.sendKeyEvent(event);
        }
    }

    void doLineDown(boolean bl2) {
        int n2;
        int n3;
        int n4 = this.getCaretLine();
        int n5 = this.content.getLineCount();
        int n6 = 0;
        boolean bl3 = false;
        if (this.wordWrap) {
            int n7;
            n3 = this.content.getOffsetAtLine(n4);
            n2 = this.caretOffset - n3;
            TextLayout textLayout = this.renderer.getTextLayout(n4);
            int n8 = this.getVisualLineIndex(textLayout, n2);
            if (n8 == (n7 = textLayout.getLineCount()) - 1) {
                bl3 = n4 == n5 - 1;
                ++n4;
            } else {
                n6 = textLayout.getLineBounds((int)(n8 + 1)).y;
            }
            this.renderer.disposeTextLayout(textLayout);
        } else {
            bl3 = n4 == n5 - 1;
            ++n4;
        }
        if (bl3) {
            if (bl2) {
                this.caretOffset = this.content.getCharCount();
            }
        } else {
            this.caretOffset = this.getOffsetAtPoint(this.columnX, n6, n4);
        }
        n3 = this.columnX;
        n2 = this.horizontalScrollOffset;
        if (bl2) {
            this.setMouseWordSelectionAnchor();
            this.doSelection(0x1000004);
        }
        this.showCaret();
        int n9 = n2 - this.horizontalScrollOffset;
        this.columnX = n3 + n9;
    }

    void doLineEnd() {
        int n2;
        int n3 = this.getCaretLine();
        int n4 = this.content.getOffsetAtLine(n3);
        if (this.wordWrap) {
            TextLayout textLayout = this.renderer.getTextLayout(n3);
            int n5 = this.caretOffset - n4;
            int n6 = this.getVisualLineIndex(textLayout, n5);
            int[] nArray = textLayout.getLineOffsets();
            n2 = n4 + nArray[n6 + 1];
            this.renderer.disposeTextLayout(textLayout);
        } else {
            int n7 = this.content.getLine(n3).length();
            n2 = n4 + n7;
        }
        if (this.caretOffset < n2) {
            this.caretOffset = n2;
            this.caretAlignment = 0;
            this.showCaret();
        }
    }

    void doLineStart() {
        int n2 = this.getCaretLine();
        int n3 = this.content.getOffsetAtLine(n2);
        if (this.wordWrap) {
            TextLayout textLayout = this.renderer.getTextLayout(n2);
            int n4 = this.caretOffset - n3;
            int n5 = this.getVisualLineIndex(textLayout, n4);
            int[] nArray = textLayout.getLineOffsets();
            n3 += nArray[n5];
            this.renderer.disposeTextLayout(textLayout);
        }
        if (this.caretOffset > n3) {
            this.caretOffset = n3;
            this.caretAlignment = 1;
            this.showCaret();
        }
    }

    void doLineUp(boolean bl2) {
        int n2;
        int n3;
        int n4 = this.getCaretLine();
        int n5 = 0;
        boolean bl3 = false;
        if (this.wordWrap) {
            n3 = this.content.getOffsetAtLine(n4);
            n2 = this.caretOffset - n3;
            TextLayout textLayout = this.renderer.getTextLayout(n4);
            int n6 = this.getVisualLineIndex(textLayout, n2);
            if (n6 == 0) {
                boolean bl4 = bl3 = n4 == 0;
                if (!bl3) {
                    n5 = this.renderer.getLineHeight(--n4) - 1;
                }
            } else {
                n5 = textLayout.getLineBounds((int)(n6 - 1)).y;
            }
            this.renderer.disposeTextLayout(textLayout);
        } else {
            bl3 = n4 == 0;
            --n4;
        }
        if (bl3) {
            if (bl2) {
                this.caretOffset = 0;
            }
        } else {
            this.caretOffset = this.getOffsetAtPoint(this.columnX, n5, n4);
        }
        n3 = this.columnX;
        n2 = this.horizontalScrollOffset;
        if (bl2) {
            this.setMouseWordSelectionAnchor();
        }
        this.showCaret();
        if (bl2) {
            this.doSelection(0x1000003);
        }
        int n7 = n2 - this.horizontalScrollOffset;
        this.columnX = n3 + n7;
    }

    void doMouseLocationChange(int n2, int n3, boolean bl2) {
        int n4 = this.getLineIndex(n3);
        this.updateCaretDirection = true;
        if (n4 < 0 || this.isSingleLine() && n4 > 0) {
            return;
        }
        int n5 = this.caretAlignment;
        int n6 = this.getOffsetAtPoint(n2, n3);
        if (this.clickCount > 1) {
            n6 = this.doMouseWordSelect(n2, n6, n4);
        }
        int n7 = this.content.getLineAtOffset(n6);
        if (n3 >= 0 && n3 < this.clientAreaHeight && (n2 >= 0 && n2 < this.clientAreaWidth || this.wordWrap || n7 != this.content.getLineAtOffset(this.caretOffset)) && (n6 != this.caretOffset || this.caretAlignment != n5)) {
            this.caretOffset = n6;
            if (bl2) {
                this.doMouseSelection();
            }
            this.showCaret();
        }
        if (!bl2) {
            this.caretOffset = n6;
            this.clearSelection(true);
        }
    }

    void doMouseSelection() {
        if (this.caretOffset <= this.selection.x || this.caretOffset > this.selection.x && this.caretOffset < this.selection.y && this.selectionAnchor == this.selection.x) {
            this.doSelection(0x1000003);
        } else {
            this.doSelection(0x1000004);
        }
    }

    int doMouseWordSelect(int n2, int n3, int n4) {
        if (n3 < this.selectionAnchor && this.selectionAnchor == this.selection.x) {
            this.selectionAnchor = this.doubleClickSelection.y;
        } else if (n3 > this.selectionAnchor && this.selectionAnchor == this.selection.y) {
            this.selectionAnchor = this.doubleClickSelection.x;
        }
        if (n2 >= 0 && n2 < this.clientAreaWidth) {
            boolean bl2;
            boolean bl3 = bl2 = (this.clickCount & 1) == 0;
            if (this.caretOffset == this.selection.x) {
                n3 = bl2 ? this.getWordPrevious(n3, 16) : this.content.getOffsetAtLine(n4);
            } else if (bl2) {
                n3 = this.getWordNext(n3, 8);
            } else {
                int n5 = this.content.getCharCount();
                if (n4 + 1 < this.content.getLineCount()) {
                    n5 = this.content.getOffsetAtLine(n4 + 1);
                }
                n3 = n5;
            }
        }
        return n3;
    }

    void doPageDown(boolean bl2, int n2) {
        int n3;
        if (this.isSingleLine()) {
            return;
        }
        int n4 = this.columnX;
        int n5 = this.horizontalScrollOffset;
        if (this.isFixedLineHeight()) {
            n3 = this.content.getLineCount();
            int n6 = this.getCaretLine();
            if (n6 < n3 - 1) {
                int n7 = this.renderer.getLineHeight();
                int n8 = (n2 == -1 ? this.clientAreaHeight : n2) / n7;
                int n9 = Math.min(n3 - n6 - 1, n8);
                n9 = Math.max(1, n9);
                this.caretOffset = this.getOffsetAtPoint(this.columnX, this.getLinePixel(n6 + n9));
                if (bl2) {
                    this.doSelection(0x1000004);
                }
                int n10 = n3 * this.getVerticalIncrement();
                int n11 = this.clientAreaHeight;
                int n12 = this.getVerticalScrollOffset();
                int n13 = n12 + n9 * this.getVerticalIncrement();
                if (n13 + n11 > n10) {
                    n13 = n10 - n11;
                }
                if (n13 > n12) {
                    this.scrollVertical(n13 - n12, true);
                }
            }
        } else {
            Rectangle rectangle;
            int n14;
            int n15;
            TextLayout textLayout;
            int n16;
            int n17;
            int n18;
            n3 = this.content.getLineCount();
            int n19 = this.getCaretLine();
            if (n2 == -1) {
                n18 = this.getPartialBottomIndex();
                n17 = this.getLinePixel(n18);
                n16 = this.renderer.getLineHeight(n18);
                n2 = n17;
                if (n17 + n16 <= this.clientAreaHeight) {
                    n2 += n16;
                } else if (this.wordWrap) {
                    textLayout = this.renderer.getTextLayout(n18);
                    n15 = this.clientAreaHeight - n17;
                    n14 = 0;
                    while (n14 < textLayout.getLineCount()) {
                        rectangle = textLayout.getLineBounds(n14);
                        if (rectangle.contains(rectangle.x, n15)) {
                            n2 += rectangle.y;
                            break;
                        }
                        ++n14;
                    }
                    this.renderer.disposeTextLayout(textLayout);
                }
            } else {
                n18 = this.getLineIndex(n2);
                n17 = this.getLinePixel(n18);
                if (this.wordWrap) {
                    textLayout = this.renderer.getTextLayout(n18);
                    n15 = n2 - n17;
                    n14 = 0;
                    while (n14 < textLayout.getLineCount()) {
                        rectangle = textLayout.getLineBounds(n14);
                        if (rectangle.contains(rectangle.x, n15)) {
                            n2 = n17 + rectangle.y + rectangle.height;
                            break;
                        }
                        ++n14;
                    }
                    this.renderer.disposeTextLayout(textLayout);
                } else {
                    n2 = n17 + this.renderer.getLineHeight(n18);
                }
            }
            n17 = n2;
            if (this.wordWrap) {
                textLayout = this.renderer.getTextLayout(n19);
                n15 = this.caretOffset - this.content.getOffsetAtLine(n19);
                n18 = this.getVisualLineIndex(textLayout, n15);
                n17 += textLayout.getLineBounds((int)n18).y;
                this.renderer.disposeTextLayout(textLayout);
            }
            n18 = n19;
            n16 = this.renderer.getLineHeight(n18);
            while (n17 - n16 >= 0 && n18 < n3 - 1) {
                n17 -= n16;
                n16 = this.renderer.getLineHeight(++n18);
            }
            this.caretOffset = this.getOffsetAtPoint(this.columnX, n17, n18);
            if (bl2) {
                this.doSelection(0x1000004);
            }
            n2 = this.getAvailableHeightBellow(n2);
            this.scrollVertical(n2, true);
            if (n2 == 0) {
                this.setCaretLocation();
            }
        }
        this.showCaret();
        n3 = n5 - this.horizontalScrollOffset;
        this.columnX = n4 + n3;
    }

    void doPageEnd() {
        if (this.isSingleLine()) {
            this.doLineEnd();
        } else {
            int n2;
            if (this.wordWrap) {
                int n3 = this.getPartialBottomIndex();
                TextLayout textLayout = this.renderer.getTextLayout(n3);
                int n4 = this.clientAreaHeight - this.bottomMargin - this.getLinePixel(n3);
                int n5 = textLayout.getLineCount() - 1;
                while (n5 >= 0) {
                    Rectangle rectangle = textLayout.getLineBounds(n5);
                    if (n4 >= rectangle.y + rectangle.height) break;
                    --n5;
                }
                n2 = n5 == -1 && n3 > 0 ? this.content.getOffsetAtLine(n3 - 1) + this.content.getLine(n3 - 1).length() : this.content.getOffsetAtLine(n3) + Math.max(0, textLayout.getLineOffsets()[n5 + 1] - 1);
                this.renderer.disposeTextLayout(textLayout);
            } else {
                int n6 = this.getBottomIndex();
                n2 = this.content.getOffsetAtLine(n6) + this.content.getLine(n6).length();
            }
            if (this.caretOffset < n2) {
                this.caretOffset = n2;
                this.caretAlignment = 1;
                this.showCaret();
            }
        }
    }

    void doPageStart() {
        int n2;
        if (this.wordWrap) {
            int n3;
            int n4;
            if (this.topIndexY > 0) {
                n4 = this.topIndex - 1;
                n3 = this.renderer.getLineHeight(n4) - this.topIndexY;
            } else {
                n4 = this.topIndex;
                n3 = -this.topIndexY;
            }
            TextLayout textLayout = this.renderer.getTextLayout(n4);
            int n5 = 0;
            int n6 = textLayout.getLineCount();
            while (n5 < n6) {
                Rectangle rectangle = textLayout.getLineBounds(n5);
                if (n3 <= rectangle.y) break;
                ++n5;
            }
            n2 = n5 == n6 ? this.content.getOffsetAtLine(n4 + 1) : this.content.getOffsetAtLine(n4) + textLayout.getLineOffsets()[n5];
            this.renderer.disposeTextLayout(textLayout);
        } else {
            n2 = this.content.getOffsetAtLine(this.topIndex);
        }
        if (this.caretOffset > n2) {
            this.caretOffset = n2;
            this.caretAlignment = 1;
            this.showCaret();
        }
    }

    void doPageUp(boolean bl2, int n2) {
        int n3;
        if (this.isSingleLine()) {
            return;
        }
        int n4 = this.horizontalScrollOffset;
        int n5 = this.columnX;
        if (this.isFixedLineHeight()) {
            n3 = this.getCaretLine();
            if (n3 > 0) {
                int n6;
                int n7;
                int n8 = this.renderer.getLineHeight();
                int n9 = (n2 == -1 ? this.clientAreaHeight : n2) / n8;
                int n10 = Math.max(1, Math.min(n3, n9));
                this.caretOffset = this.getOffsetAtPoint(this.columnX, this.getLinePixel(n3 -= n10));
                if (bl2) {
                    this.doSelection(0x1000003);
                }
                if ((n7 = Math.max(0, (n6 = this.getVerticalScrollOffset()) - n10 * this.getVerticalIncrement())) < n6) {
                    this.scrollVertical(n7 - n6, true);
                }
            }
        } else {
            int n11;
            TextLayout textLayout;
            int n12;
            int n13;
            int n14;
            n3 = this.getCaretLine();
            if (n2 == -1) {
                if (this.topIndexY == 0) {
                    n2 = this.clientAreaHeight;
                } else {
                    if (this.topIndex > 0) {
                        n14 = this.topIndex - 1;
                        n13 = this.renderer.getLineHeight(n14);
                        n2 = this.clientAreaHeight - this.topIndexY;
                        n12 = n13 - this.topIndexY;
                    } else {
                        n14 = this.topIndex;
                        n13 = this.renderer.getLineHeight(n14);
                        n2 = this.clientAreaHeight - (n13 + this.topIndexY);
                        n12 = -this.topIndexY;
                    }
                    if (this.wordWrap) {
                        textLayout = this.renderer.getTextLayout(n14);
                        n11 = 0;
                        while (n11 < textLayout.getLineCount()) {
                            Rectangle rectangle = textLayout.getLineBounds(n11);
                            if (rectangle.contains(rectangle.x, n12)) {
                                n2 += n13 - (rectangle.y + rectangle.height);
                                break;
                            }
                            ++n11;
                        }
                        this.renderer.disposeTextLayout(textLayout);
                    }
                }
            } else {
                n14 = this.getLineIndex(this.clientAreaHeight - n2);
                n12 = this.getLinePixel(n14);
                if (this.wordWrap) {
                    textLayout = this.renderer.getTextLayout(n14);
                    n11 = n12;
                    int n15 = 0;
                    while (n15 < textLayout.getLineCount()) {
                        Rectangle rectangle = textLayout.getLineBounds(n15);
                        if (rectangle.contains(rectangle.x, n11)) {
                            n2 = this.clientAreaHeight - (n12 + rectangle.y);
                            break;
                        }
                        ++n15;
                    }
                    this.renderer.disposeTextLayout(textLayout);
                } else {
                    n2 = this.clientAreaHeight - n12;
                }
            }
            n12 = n2;
            if (this.wordWrap) {
                textLayout = this.renderer.getTextLayout(n3);
                n11 = this.caretOffset - this.content.getOffsetAtLine(n3);
                n14 = this.getVisualLineIndex(textLayout, n11);
                n12 += textLayout.getBounds().height - textLayout.getLineBounds((int)n14).y;
                this.renderer.disposeTextLayout(textLayout);
            }
            n14 = n3;
            n13 = this.renderer.getLineHeight(n14);
            while (n12 - n13 >= 0 && n14 > 0) {
                n12 -= n13;
                n13 = this.renderer.getLineHeight(--n14);
            }
            n13 = this.renderer.getLineHeight(n14);
            this.caretOffset = this.getOffsetAtPoint(this.columnX, n13 - n12, n14);
            if (bl2) {
                this.doSelection(0x1000003);
            }
            n2 = this.getAvailableHeightAbove(n2);
            this.scrollVertical(-n2, true);
            if (n2 == 0) {
                this.setCaretLocation();
            }
        }
        this.showCaret();
        n3 = n4 - this.horizontalScrollOffset;
        this.columnX = n5 + n3;
    }

    void doSelection(int n2) {
        int n3 = -1;
        int n4 = -1;
        if (this.selectionAnchor == -1) {
            this.selectionAnchor = this.selection.x;
        }
        if (n2 == 0x1000003) {
            if (this.caretOffset < this.selection.x) {
                n4 = this.selection.x;
                n3 = this.selection.x = this.caretOffset;
                if (this.selection.y != this.selectionAnchor) {
                    n4 = this.selection.y;
                    this.selection.y = this.selectionAnchor;
                }
            } else if (this.selectionAnchor == this.selection.x && this.caretOffset < this.selection.y) {
                n4 = this.selection.y;
                n3 = this.selection.y = this.caretOffset;
            }
        } else if (this.caretOffset > this.selection.y) {
            n3 = this.selection.y;
            n4 = this.selection.y = this.caretOffset;
            if (this.selection.x != this.selectionAnchor) {
                n3 = this.selection.x;
                this.selection.x = this.selectionAnchor;
            }
        } else if (this.selectionAnchor == this.selection.y && this.caretOffset > this.selection.x) {
            n3 = this.selection.x;
            n4 = this.selection.x = this.caretOffset;
        }
        if (n3 != -1 && n4 != -1) {
            this.internalRedrawRange(n3, n4 - n3);
            this.sendSelectionEvent();
        }
    }

    void doSelectionCursorNext() {
        int n2 = this.getCaretLine();
        int n3 = this.content.getOffsetAtLine(n2);
        int n4 = this.caretOffset - n3;
        if (n4 < this.content.getLine(n2).length()) {
            TextLayout textLayout = this.renderer.getTextLayout(n2);
            n4 = textLayout.getNextOffset(n4, 2);
            int n5 = textLayout.getLineOffsets()[textLayout.getLineIndex(n4)];
            this.renderer.disposeTextLayout(textLayout);
            this.caretOffset = n4 + n3;
            this.caretAlignment = n4 == n5 ? 1 : 0;
            this.showCaret();
        } else if (n2 < this.content.getLineCount() - 1 && !this.isSingleLine()) {
            this.caretOffset = this.content.getOffsetAtLine(++n2);
            this.caretAlignment = 0;
            this.showCaret();
        }
    }

    void doSelectionCursorPrevious() {
        int n2 = this.getCaretLine();
        int n3 = this.content.getOffsetAtLine(n2);
        int n4 = this.caretOffset - n3;
        this.caretAlignment = 1;
        if (n4 > 0) {
            this.caretOffset = this.getClusterPrevious(this.caretOffset, n2);
            this.showCaret();
        } else if (n2 > 0) {
            n3 = this.content.getOffsetAtLine(--n2);
            this.caretOffset = n3 + this.content.getLine(n2).length();
            this.showCaret();
        }
    }

    void doSelectionLineDown() {
        int n2 = this.columnX = this.getPointAtOffset((int)this.caretOffset).x;
        this.doLineDown(true);
        this.columnX = n2;
    }

    void doSelectionLineUp() {
        int n2 = this.columnX = this.getPointAtOffset((int)this.caretOffset).x;
        this.doLineUp(true);
        this.columnX = n2;
    }

    void doSelectionPageDown(int n2) {
        int n3 = this.columnX = this.getPointAtOffset((int)this.caretOffset).x;
        this.doPageDown(true, n2);
        this.columnX = n3;
    }

    void doSelectionPageUp(int n2) {
        int n3 = this.columnX = this.getPointAtOffset((int)this.caretOffset).x;
        this.doPageUp(true, n2);
        this.columnX = n3;
    }

    void doSelectionWordNext() {
        int n2 = this.getWordNext(this.caretOffset, 4);
        this.caretAlignment = 1;
        if (!this.isSingleLine() || this.content.getLineAtOffset(this.caretOffset) == this.content.getLineAtOffset(n2)) {
            this.caretOffset = n2;
            this.showCaret();
        }
    }

    void doSelectionWordPrevious() {
        this.caretAlignment = 1;
        this.caretOffset = this.getWordPrevious(this.caretOffset, 4);
        int n2 = this.content.getLineAtOffset(this.caretOffset);
        if (this.wordWrap && n2 < this.content.getLineCount() - 1 && this.caretOffset == this.content.getOffsetAtLine(n2 + 1)) {
            ++n2;
        }
        this.showCaret();
    }

    void doVisualPrevious() {
        this.caretOffset = this.getClusterPrevious(this.caretOffset, this.getCaretLine());
        this.showCaret();
    }

    void doVisualNext() {
        this.caretOffset = this.getClusterNext(this.caretOffset, this.getCaretLine());
        this.showCaret();
    }

    void doWordNext() {
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.y;
            this.showCaret();
        } else {
            this.doSelectionWordNext();
        }
    }

    void doWordPrevious() {
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.x;
            this.showCaret();
        } else {
            this.doSelectionWordPrevious();
        }
    }

    void endAutoScroll() {
        this.autoScrollDirection = 0;
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.background == null) {
            return this.getDisplay().getSystemColor(25);
        }
        return this.background;
    }

    public int getBaseline() {
        this.checkWidget();
        return this.renderer.getBaseline();
    }

    public int getBaseline(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.content.getCharCount()) {
            SWT.error(6);
        }
        if (this.isFixedLineHeight()) {
            return this.renderer.getBaseline();
        }
        int n3 = this.content.getLineAtOffset(n2);
        int n4 = this.content.getOffsetAtLine(n3);
        TextLayout textLayout = this.renderer.getTextLayout(n3);
        int n5 = textLayout.getLineIndex(Math.min(n2 - n4, textLayout.getText().length()));
        FontMetrics fontMetrics = textLayout.getLineMetrics(n5);
        this.renderer.disposeTextLayout(textLayout);
        return fontMetrics.getAscent() + fontMetrics.getLeading();
    }

    public boolean getBidiColoring() {
        this.checkWidget();
        return this.bidiColoring;
    }

    int getBottomIndex() {
        int n2;
        if (this.isFixedLineHeight()) {
            int n3 = 1;
            int n4 = this.renderer.getLineHeight();
            if (n4 != 0) {
                int n5 = this.topIndex * n4 - this.getVerticalScrollOffset();
                n3 = (this.clientAreaHeight - n5) / n4;
            }
            n2 = Math.min(this.content.getLineCount() - 1, this.topIndex + Math.max(0, n3 - 1));
        } else {
            int n6;
            int n7;
            int n8 = this.clientAreaHeight - this.bottomMargin;
            n2 = this.getLineIndex(n8);
            if (n2 > 0 && (n7 = this.getLinePixel(n2)) + (n6 = this.renderer.getLineHeight(n2)) > n8 && this.getLinePixel(n2 - 1) >= this.topMargin) {
                --n2;
            }
        }
        return n2;
    }

    Rectangle getBoundsAtOffset(int n2) {
        Rectangle rectangle;
        int n3 = this.content.getLineAtOffset(n2);
        String string = this.content.getLine(n3);
        if (string.length() != 0) {
            int n4 = n2 - this.content.getOffsetAtLine(n3);
            TextLayout textLayout = this.renderer.getTextLayout(n3);
            rectangle = textLayout.getBounds(n4, n4);
            this.renderer.disposeTextLayout(textLayout);
        } else {
            rectangle = new Rectangle(0, 0, 0, this.renderer.getLineHeight());
        }
        rectangle.x += this.leftMargin - this.horizontalScrollOffset;
        rectangle.y += this.getLinePixel(n3);
        return rectangle;
    }

    public int getCaretOffset() {
        this.checkWidget();
        return this.caretOffset;
    }

    int getCaretWidth() {
        Caret caret = this.getCaret();
        if (caret == null) {
            return 0;
        }
        return caret.getSize().x;
    }

    Object getClipboardContent(int n2) {
        TextTransfer textTransfer = TextTransfer.getInstance();
        return this.clipboard.getContents(textTransfer, n2);
    }

    int getClusterNext(int n2, int n3) {
        int n4 = this.content.getOffsetAtLine(n3);
        TextLayout textLayout = this.renderer.getTextLayout(n3);
        n2 -= n4;
        n2 = textLayout.getNextOffset(n2, 2);
        this.renderer.disposeTextLayout(textLayout);
        return n2 += n4;
    }

    int getClusterPrevious(int n2, int n3) {
        int n4 = this.content.getOffsetAtLine(n3);
        TextLayout textLayout = this.renderer.getTextLayout(n3);
        n2 -= n4;
        n2 = textLayout.getPreviousOffset(n2, 2);
        this.renderer.disposeTextLayout(textLayout);
        return n2 += n4;
    }

    public StyledTextContent getContent() {
        this.checkWidget();
        return this.content;
    }

    public boolean getDragDetect() {
        this.checkWidget();
        return this.dragDetect;
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClickEnabled;
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.editable;
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.foreground == null) {
            return this.getDisplay().getSystemColor(24);
        }
        return this.foreground;
    }

    int getHorizontalIncrement() {
        return this.renderer.averageCharWidth;
    }

    public int getHorizontalIndex() {
        this.checkWidget();
        return this.horizontalScrollOffset / this.getHorizontalIncrement();
    }

    public int getHorizontalPixel() {
        this.checkWidget();
        return this.horizontalScrollOffset;
    }

    public int getIndent() {
        this.checkWidget();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkWidget();
        return this.justify;
    }

    public int getKeyBinding(int n2) {
        this.checkWidget();
        Integer n3 = (Integer)this.keyActionMap.get(new Integer(n2));
        return n3 == null ? 0 : n3;
    }

    public int getCharCount() {
        this.checkWidget();
        return this.content.getCharCount();
    }

    public int getLineAlignment(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.renderer.getLineAlignment(n2, this.alignment);
    }

    public int getLineAtOffset(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.getCharCount()) {
            SWT.error(6);
        }
        return this.content.getLineAtOffset(n2);
    }

    public Color getLineBackground(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.isListening(3001) ? null : this.renderer.getLineBackground(n2, null);
    }

    public Bullet getLineBullet(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.isListening(3002) ? null : this.renderer.getLineBullet(n2, null);
    }

    StyledTextEvent getLineBackgroundData(int n2, String string) {
        return this.sendLineEvent(3001, n2, string);
    }

    public int getLineCount() {
        this.checkWidget();
        return this.content.getLineCount();
    }

    int getLineCountWhole() {
        if (this.isFixedLineHeight()) {
            int n2 = this.renderer.getLineHeight();
            return n2 != 0 ? this.clientAreaHeight / n2 : 1;
        }
        return this.getBottomIndex() - this.topIndex + 1;
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return this.content.getLineDelimiter();
    }

    public int getLineHeight() {
        this.checkWidget();
        return this.renderer.getLineHeight();
    }

    public int getLineHeight(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.content.getCharCount()) {
            SWT.error(6);
        }
        if (this.isFixedLineHeight()) {
            return this.renderer.getLineHeight();
        }
        int n3 = this.content.getLineAtOffset(n2);
        int n4 = this.content.getOffsetAtLine(n3);
        TextLayout textLayout = this.renderer.getTextLayout(n3);
        int n5 = textLayout.getLineIndex(Math.min(n2 - n4, textLayout.getText().length()));
        int n6 = textLayout.getLineBounds((int)n5).height;
        this.renderer.disposeTextLayout(textLayout);
        return n6;
    }

    public int getLineIndent(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.isListening(3002) ? 0 : this.renderer.getLineIndent(n2, this.indent);
    }

    public boolean getLineJustify(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.isListening(3002) ? false : this.renderer.getLineJustify(n2, this.justify);
    }

    public int getLineSpacing() {
        this.checkWidget();
        return this.lineSpacing;
    }

    StyledTextEvent getLineStyleData(int n2, String string) {
        return this.sendLineEvent(3002, n2, string);
    }

    public int getLinePixel(int n2) {
        this.checkWidget();
        int n3 = this.content.getLineCount();
        n2 = Math.max(0, Math.min(n3, n2));
        if (this.isFixedLineHeight()) {
            int n4 = this.renderer.getLineHeight();
            return n2 * n4 - this.getVerticalScrollOffset() + this.topMargin;
        }
        if (n2 == this.topIndex) {
            return this.topIndexY + this.topMargin;
        }
        int n5 = this.topIndexY;
        if (n2 > this.topIndex) {
            int n6 = this.topIndex;
            while (n6 < n2) {
                n5 += this.renderer.getLineHeight(n6);
                ++n6;
            }
        } else {
            int n7 = this.topIndex - 1;
            while (n7 >= n2) {
                n5 -= this.renderer.getLineHeight(n7);
                --n7;
            }
        }
        return n5 + this.topMargin;
    }

    public int getLineIndex(int n2) {
        this.checkWidget();
        n2 -= this.topMargin;
        if (this.isFixedLineHeight()) {
            int n3 = this.renderer.getLineHeight();
            int n4 = (n2 + this.getVerticalScrollOffset()) / n3;
            int n5 = this.content.getLineCount();
            n4 = Math.max(0, Math.min(n5 - 1, n4));
            return n4;
        }
        if (n2 == this.topIndexY) {
            return this.topIndex;
        }
        int n6 = this.topIndex;
        if (n2 < this.topIndexY) {
            while (n2 < this.topIndexY && n6 > 0) {
                n2 += this.renderer.getLineHeight(--n6);
            }
        } else {
            int n7 = this.content.getLineCount();
            int n8 = this.renderer.getLineHeight(n6);
            while (n2 - n8 >= this.topIndexY && n6 < n7 - 1) {
                n2 -= n8;
                n8 = this.renderer.getLineHeight(++n6);
            }
        }
        return n6;
    }

    public Point getLocationAtOffset(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.getCharCount()) {
            SWT.error(6);
        }
        return this.getPointAtOffset(n2);
    }

    public int getOffsetAtLine(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > 0 && n2 >= this.content.getLineCount()) {
            SWT.error(6);
        }
        return this.content.getOffsetAtLine(n2);
    }

    public int getOffsetAtLocation(Point point) {
        String string;
        int n2;
        int n3;
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        if (point.y + this.getVerticalScrollOffset() < 0 || point.x + this.horizontalScrollOffset < 0) {
            SWT.error(5);
        }
        if (point.y > (n3 = this.getLinePixel(n2 = this.getLineIndex(this.clientAreaHeight)) + this.renderer.getLineHeight(n2))) {
            SWT.error(5);
        }
        int n4 = this.getLineIndex(point.y);
        int n5 = this.content.getOffsetAtLine(n4);
        TextLayout textLayout = this.renderer.getTextLayout(n4);
        int[] nArray = new int[1];
        int n6 = point.x + this.horizontalScrollOffset - this.leftMargin;
        int n7 = point.y - this.getLinePixel(n4);
        int n8 = textLayout.getOffset(n6, n7, nArray);
        if (n8 != (string = this.content.getLine(n4)).length() - 1) {
            n8 = Math.min(string.length(), n8 + nArray[0]);
        }
        Rectangle rectangle = textLayout.getLineBounds(textLayout.getLineIndex(n8));
        this.renderer.disposeTextLayout(textLayout);
        if (n6 > rectangle.x + rectangle.width) {
            SWT.error(5);
        }
        return n5 + n8;
    }

    int getOffsetAtPoint(int n2, int n3) {
        int n4 = this.getLineIndex(n3);
        return this.getOffsetAtPoint(n2, n3 -= this.getLinePixel(n4), n4);
    }

    int getOffsetAtPoint(int n2, int n3, int n4) {
        TextLayout textLayout = this.renderer.getTextLayout(n4);
        int[] nArray = new int[1];
        int n5 = textLayout.getOffset(n2 += this.horizontalScrollOffset - this.leftMargin, n3, nArray);
        this.caretAlignment = 1;
        if (nArray[0] != 0) {
            int n6 = textLayout.getLineIndex(n5 + nArray[0]);
            int n7 = textLayout.getLineOffsets()[n6];
            if (n5 + nArray[0] == n7) {
                n5 += nArray[0];
                this.caretAlignment = 0;
            } else {
                String string = this.content.getLine(n4);
                int n8 = n5;
                while (n8 > 0 && Character.isDigit(string.charAt(n8))) {
                    --n8;
                }
                int n9 = n8 == 0 && Character.isDigit(string.charAt(n8)) ? (this.isMirrored() ? 1 : 0) : textLayout.getLevel(n8) & 1;
                int n10 = textLayout.getLevel(n5 += nArray[0]) & 1;
                this.caretAlignment = (n9 ^ n10) != 0 ? 0 : 1;
            }
        }
        this.renderer.disposeTextLayout(textLayout);
        return n5 + this.content.getOffsetAtLine(n4);
    }

    public int getOrientation() {
        this.checkWidget();
        return this.isMirrored() ? 0x4000000 : 0x2000000;
    }

    int getPartialBottomIndex() {
        if (this.isFixedLineHeight()) {
            int n2 = this.renderer.getLineHeight();
            int n3 = Compatibility.ceil(this.clientAreaHeight, n2);
            return Math.min(this.content.getLineCount(), this.topIndex + n3) - 1;
        }
        return this.getLineIndex(this.clientAreaHeight - this.bottomMargin);
    }

    int getPartialTopIndex() {
        if (this.isFixedLineHeight()) {
            int n2 = this.renderer.getLineHeight();
            return this.getVerticalScrollOffset() / n2;
        }
        return this.topIndexY <= 0 ? this.topIndex : this.topIndex - 1;
    }

    String getPlatformDelimitedText(TextWriter textWriter) {
        int n2 = textWriter.getStart() + textWriter.getCharCount();
        int n3 = this.content.getLineAtOffset(textWriter.getStart());
        int n4 = this.content.getLineAtOffset(n2);
        String string = this.content.getLine(n4);
        int n5 = this.content.getOffsetAtLine(n4);
        int n6 = n3;
        while (n6 <= n4) {
            textWriter.writeLine(this.content.getLine(n6), this.content.getOffsetAtLine(n6));
            if (n6 < n4) {
                textWriter.writeLineDelimiter(PlatformLineDelimiter);
            }
            ++n6;
        }
        if (n2 > n5 + string.length()) {
            textWriter.writeLineDelimiter(PlatformLineDelimiter);
        }
        textWriter.close();
        return textWriter.toString();
    }

    public int[] getRanges() {
        int[] nArray;
        this.checkWidget();
        if (!this.isListening(3002) && (nArray = this.renderer.getRanges(0, this.content.getCharCount())) != null) {
            return nArray;
        }
        return new int[0];
    }

    public int[] getRanges(int n2, int n3) {
        int[] nArray;
        this.checkWidget();
        int n4 = this.getCharCount();
        int n5 = n2 + n3;
        if (n2 > n5 || n2 < 0 || n5 > n4) {
            SWT.error(6);
        }
        if (!this.isListening(3002) && (nArray = this.renderer.getRanges(n2, n3)) != null) {
            return nArray;
        }
        return new int[0];
    }

    public Point getSelection() {
        this.checkWidget();
        return new Point(this.selection.x, this.selection.y);
    }

    public Point getSelectionRange() {
        this.checkWidget();
        return new Point(this.selection.x, this.selection.y - this.selection.x);
    }

    public Color getSelectionBackground() {
        this.checkWidget();
        if (this.selectionBackground == null) {
            return this.getDisplay().getSystemColor(26);
        }
        return this.selectionBackground;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.getSelectionRange().y;
    }

    public Color getSelectionForeground() {
        this.checkWidget();
        if (this.selectionForeground == null) {
            return this.getDisplay().getSystemColor(27);
        }
        return this.selectionForeground;
    }

    public String getSelectionText() {
        this.checkWidget();
        return this.content.getTextRange(this.selection.x, this.selection.y - this.selection.x);
    }

    public int getStyle() {
        int n2 = super.getStyle();
        n2 &= 0xF1FFFFFF;
        n2 = this.isMirrored() ? (n2 |= 0xC000000) : (n2 |= 0x2000000);
        return n2;
    }

    int[] getBidiSegments(int n2, String string) {
        int[] nArray;
        if (!this.isBidi()) {
            return null;
        }
        if (!this.isListening(3007)) {
            return this.getBidiSegmentsCompatibility(string, n2);
        }
        StyledTextEvent styledTextEvent = this.sendLineEvent(3007, n2, string);
        int n3 = string.length();
        if (styledTextEvent == null || styledTextEvent.segments == null || styledTextEvent.segments.length == 0) {
            int[] nArray2 = new int[2];
            nArray2[1] = n3;
            nArray = nArray2;
        } else {
            int n4 = styledTextEvent.segments.length;
            if (styledTextEvent.segments[0] != 0) {
                SWT.error(5);
            }
            int n5 = 1;
            while (n5 < n4) {
                if (styledTextEvent.segments[n5] <= styledTextEvent.segments[n5 - 1] || styledTextEvent.segments[n5] > n3) {
                    SWT.error(5);
                }
                ++n5;
            }
            if (styledTextEvent.segments[n4 - 1] != n3) {
                nArray = new int[n4 + 1];
                System.arraycopy(styledTextEvent.segments, 0, nArray, 0, n4);
                nArray[n4] = n3;
            } else {
                nArray = styledTextEvent.segments;
            }
        }
        return nArray;
    }

    int[] getBidiSegmentsCompatibility(String string, int n2) {
        int n3 = string.length();
        if (!this.bidiColoring) {
            int[] nArray = new int[2];
            nArray[1] = n3;
            return nArray;
        }
        StyleRange[] styleRangeArray = null;
        StyledTextEvent styledTextEvent = this.getLineStyleData(n2, string);
        styleRangeArray = styledTextEvent != null ? styledTextEvent.styles : this.renderer.getStyleRanges(n2, n3, true);
        if (styleRangeArray == null || styleRangeArray.length == 0) {
            int[] nArray = new int[2];
            nArray[1] = n3;
            return nArray;
        }
        int n4 = 0;
        int n5 = 1;
        while (n4 < styleRangeArray.length && styleRangeArray[n4].start == 0 && styleRangeArray[n4].length == n3) {
            ++n4;
        }
        int[] nArray = new int[(styleRangeArray.length - n4) * 2 + 2];
        int n6 = n4;
        while (n6 < styleRangeArray.length) {
            StyleRange styleRange = styleRangeArray[n6];
            int n7 = Math.max(styleRange.start - n2, 0);
            int n8 = Math.max(styleRange.start + styleRange.length - n2, n7);
            n8 = Math.min(n8, string.length());
            if (n6 > 0 && n5 > 1 && (n7 >= nArray[n5 - 2] && n7 <= nArray[n5 - 1] || n8 >= nArray[n5 - 2] && n8 <= nArray[n5 - 1]) && styleRange.similarTo(styleRangeArray[n6 - 1])) {
                nArray[n5 - 2] = Math.min(nArray[n5 - 2], n7);
                nArray[n5 - 1] = Math.max(nArray[n5 - 1], n8);
            } else {
                if (n7 > nArray[n5 - 1]) {
                    nArray[n5] = n7;
                    ++n5;
                }
                nArray[n5] = n8;
                ++n5;
            }
            ++n6;
        }
        if (n3 > nArray[n5 - 1]) {
            nArray[n5] = n3;
            ++n5;
        }
        if (n5 == nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n5];
        System.arraycopy(nArray, 0, nArray2, 0, n5);
        return nArray2;
    }

    public StyleRange getStyleRangeAtOffset(int n2) {
        StyleRange[] styleRangeArray;
        this.checkWidget();
        if (n2 < 0 || n2 >= this.getCharCount()) {
            SWT.error(5);
        }
        if (!this.isListening(3002) && (styleRangeArray = this.renderer.getStyleRanges(n2, 1, true)) != null) {
            return styleRangeArray[0];
        }
        return null;
    }

    public StyleRange[] getStyleRanges() {
        this.checkWidget();
        return this.getStyleRanges(0, this.content.getCharCount(), true);
    }

    public StyleRange[] getStyleRanges(boolean bl2) {
        this.checkWidget();
        return this.getStyleRanges(0, this.content.getCharCount(), bl2);
    }

    public StyleRange[] getStyleRanges(int n2, int n3) {
        this.checkWidget();
        return this.getStyleRanges(n2, n3, true);
    }

    public StyleRange[] getStyleRanges(int n2, int n3, boolean bl2) {
        StyleRange[] styleRangeArray;
        this.checkWidget();
        int n4 = this.getCharCount();
        int n5 = n2 + n3;
        if (n2 > n5 || n2 < 0 || n5 > n4) {
            SWT.error(6);
        }
        if (!this.isListening(3002) && (styleRangeArray = this.renderer.getStyleRanges(n2, n3, bl2)) != null) {
            return styleRangeArray;
        }
        return new StyleRange[0];
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabLength;
    }

    public String getText() {
        this.checkWidget();
        return this.content.getTextRange(0, this.getCharCount());
    }

    public String getText(int n2, int n3) {
        this.checkWidget();
        int n4 = this.getCharCount();
        if (n2 < 0 || n2 >= n4 || n3 < 0 || n3 >= n4 || n2 > n3) {
            SWT.error(6);
        }
        return this.content.getTextRange(n2, n3 - n2 + 1);
    }

    public Rectangle getTextBounds(int n2, int n3) {
        Rectangle rectangle;
        this.checkWidget();
        int n4 = this.getCharCount();
        if (n2 < 0 || n2 >= n4 || n3 < 0 || n3 >= n4 || n2 > n3) {
            SWT.error(6);
        }
        int n5 = this.content.getLineAtOffset(n2);
        int n6 = this.content.getLineAtOffset(n3);
        int n7 = this.getLinePixel(n5);
        int n8 = 0;
        int n9 = Integer.MAX_VALUE;
        int n10 = 0;
        int n11 = n5;
        while (n11 <= n6) {
            int n12 = this.content.getOffsetAtLine(n11);
            TextLayout textLayout = this.renderer.getTextLayout(n11);
            if (textLayout.getText().length() > 0) {
                if (n11 == n5 && n11 == n6) {
                    rectangle = textLayout.getBounds(n2 - n12, n3 - n12);
                } else if (n11 == n5) {
                    String string = this.content.getLine(n11);
                    rectangle = textLayout.getBounds(n2 - n12, string.length());
                } else {
                    rectangle = n11 == n6 ? textLayout.getBounds(0, n3 - n12) : textLayout.getBounds();
                }
                n9 = Math.min(n9, rectangle.x);
                n10 = Math.max(n10, rectangle.x + rectangle.width);
                n8 += rectangle.height;
            } else {
                n8 += this.renderer.getLineHeight();
            }
            this.renderer.disposeTextLayout(textLayout);
            ++n11;
        }
        rectangle = new Rectangle(n9, n7, n10 - n9, n8);
        rectangle.x += this.leftMargin - this.horizontalScrollOffset;
        return rectangle;
    }

    public String getTextRange(int n2, int n3) {
        this.checkWidget();
        int n4 = this.getCharCount();
        int n5 = n2 + n3;
        if (n2 > n5 || n2 < 0 || n5 > n4) {
            SWT.error(6);
        }
        return this.content.getTextRange(n2, n3);
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getTopIndex() {
        this.checkWidget();
        return this.topIndex;
    }

    public int getTopPixel() {
        this.checkWidget();
        return this.getVerticalScrollOffset();
    }

    int getVerticalIncrement() {
        return this.renderer.getLineHeight();
    }

    int getVerticalScrollOffset() {
        if (this.verticalScrollOffset == -1) {
            this.renderer.calculate(0, this.topIndex);
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.topIndex) {
                n2 += this.renderer.getLineHeight(n3);
                ++n3;
            }
            this.verticalScrollOffset = n2 -= this.topIndexY;
        }
        return this.verticalScrollOffset;
    }

    int getVisualLineIndex(TextLayout textLayout, int n2) {
        int n3;
        int n4;
        int n5 = textLayout.getLineIndex(n2);
        int[] nArray = textLayout.getLineOffsets();
        if (n5 != 0 && n2 == nArray[n5] && (n4 = textLayout.getLineBounds((int)n5).y) > (n3 = this.getCaret().getLocation().y - this.topMargin - this.getLinePixel(this.getCaretLine()))) {
            --n5;
        }
        return n5;
    }

    int getCaretDirection() {
        if (!this.isBidiCaret()) {
            return -1;
        }
        if (!this.updateCaretDirection && this.caretDirection != 0) {
            return this.caretDirection;
        }
        this.updateCaretDirection = false;
        int n2 = this.getCaretLine();
        int n3 = this.content.getOffsetAtLine(n2);
        String string = this.content.getLine(n2);
        int n4 = this.caretOffset - n3;
        int n5 = string.length();
        if (n5 == 0) {
            return this.isMirrored() ? 131072 : 16384;
        }
        if (this.caretAlignment == 0 && n4 > 0) {
            --n4;
        }
        if (n4 == n5 && n4 > 0) {
            --n4;
        }
        while (n4 > 0 && Character.isDigit(string.charAt(n4))) {
            --n4;
        }
        if (n4 == 0 && Character.isDigit(string.charAt(n4))) {
            return this.isMirrored() ? 131072 : 16384;
        }
        TextLayout textLayout = this.renderer.getTextLayout(n2);
        int n6 = textLayout.getLevel(n4);
        this.renderer.disposeTextLayout(textLayout);
        return (n6 & 1) != 0 ? 131072 : 16384;
    }

    int getCaretLine() {
        return this.content.getLineAtOffset(this.caretOffset);
    }

    int getWrapWidth() {
        if (this.wordWrap && !this.isSingleLine()) {
            int n2 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
            return n2 > 0 ? n2 : 1;
        }
        return -1;
    }

    int getWordNext(int n2, int n3) {
        String string;
        int n4;
        int n5;
        if (n2 >= this.getCharCount()) {
            n5 = n2;
            int n6 = this.content.getLineCount() - 1;
            n4 = this.content.getOffsetAtLine(n6);
            string = this.content.getLine(n6);
        } else {
            int n7;
            int n8 = this.content.getLineAtOffset(n2);
            n4 = this.content.getOffsetAtLine(n8);
            if (n2 == n4 + (n7 = (string = this.content.getLine(n8)).length())) {
                n5 = this.content.getOffsetAtLine(n8 + 1);
            } else {
                TextLayout textLayout = this.renderer.getTextLayout(n8);
                n5 = n4 + textLayout.getNextOffset(n2 - n4, n3);
                this.renderer.disposeTextLayout(textLayout);
            }
        }
        return this.sendWordBoundaryEvent(3009, n3, n2, n5, string, n4);
    }

    int getWordPrevious(int n2, int n3) {
        String string;
        int n4;
        int n5;
        if (n2 <= 0) {
            n5 = 0;
            int n6 = this.content.getLineAtOffset(n5);
            n4 = this.content.getOffsetAtLine(n6);
            string = this.content.getLine(n6);
        } else {
            int n7 = this.content.getLineAtOffset(n2);
            n4 = this.content.getOffsetAtLine(n7);
            string = this.content.getLine(n7);
            if (n2 == n4) {
                String string2 = this.content.getLine(n7 - 1);
                int n8 = this.content.getOffsetAtLine(n7 - 1);
                n5 = n8 + string2.length();
            } else {
                TextLayout textLayout = this.renderer.getTextLayout(n7);
                n5 = n4 + textLayout.getPreviousOffset(n2 - n4, n3);
                this.renderer.disposeTextLayout(textLayout);
            }
        }
        return this.sendWordBoundaryEvent(3010, n3, n2, n5, string, n4);
    }

    public boolean getWordWrap() {
        this.checkWidget();
        return this.wordWrap;
    }

    Point getPointAtOffset(int n2) {
        Point point;
        int n3 = this.content.getLineAtOffset(n2);
        String string = this.content.getLine(n3);
        int n4 = this.content.getOffsetAtLine(n3);
        int n5 = n2 - n4;
        int n6 = string.length();
        if (n3 < this.content.getLineCount() - 1) {
            int n7 = this.content.getOffsetAtLine(n3 + 1) - 1;
            if (n6 < n5 && n5 <= n7) {
                n5 = n6;
            }
        }
        TextLayout textLayout = this.renderer.getTextLayout(n3);
        if (n6 != 0 && n5 <= n6) {
            if (n5 == n6) {
                point = textLayout.getLocation(n5 - 1, true);
            } else {
                switch (this.caretAlignment) {
                    case 1: {
                        point = textLayout.getLocation(n5, false);
                        break;
                    }
                    default: {
                        if (n5 == 0) {
                            point = textLayout.getLocation(n5, false);
                            break;
                        }
                        point = textLayout.getLocation(n5 - 1, true);
                        break;
                    }
                }
            }
        } else {
            point = new Point(textLayout.getIndent(), 0);
        }
        this.renderer.disposeTextLayout(textLayout);
        point.x += this.leftMargin - this.horizontalScrollOffset;
        point.y += this.getLinePixel(n3);
        return point;
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        Point point = this.getSelectionRange();
        this.replaceTextRange(point.x, point.y, string);
    }

    void installDefaultContent() {
        this.textChangeListener = new TextChangeListener(){

            public void textChanging(TextChangingEvent textChangingEvent) {
                StyledText.this.handleTextChanging(textChangingEvent);
            }

            public void textChanged(TextChangedEvent textChangedEvent) {
                StyledText.this.handleTextChanged(textChangedEvent);
            }

            public void textSet(TextChangedEvent textChangedEvent) {
                StyledText.this.handleTextSet(textChangedEvent);
            }
        };
        this.content = new DefaultContent();
        this.content.addTextChangeListener(this.textChangeListener);
    }

    void installListeners() {
        ScrollBar scrollBar = this.getVerticalBar();
        ScrollBar scrollBar2 = this.getHorizontalBar();
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        StyledText.this.handleDispose(event);
                        break;
                    }
                    case 1: {
                        StyledText.this.handleKeyDown(event);
                        break;
                    }
                    case 2: {
                        StyledText.this.handleKeyUp(event);
                        break;
                    }
                    case 3: {
                        StyledText.this.handleMouseDown(event);
                        break;
                    }
                    case 4: {
                        StyledText.this.handleMouseUp(event);
                        break;
                    }
                    case 5: {
                        StyledText.this.handleMouseMove(event);
                        break;
                    }
                    case 9: {
                        StyledText.this.handlePaint(event);
                        break;
                    }
                    case 11: {
                        StyledText.this.handleResize(event);
                        break;
                    }
                    case 31: {
                        StyledText.this.handleTraverse(event);
                    }
                }
            }
        };
        this.addListener(12, this.listener);
        this.addListener(1, this.listener);
        this.addListener(2, this.listener);
        this.addListener(3, this.listener);
        this.addListener(4, this.listener);
        this.addListener(5, this.listener);
        this.addListener(9, this.listener);
        this.addListener(11, this.listener);
        this.addListener(31, this.listener);
        if (scrollBar != null) {
            scrollBar.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    StyledText.this.handleVerticalScroll(event);
                }
            });
        }
        if (scrollBar2 != null) {
            scrollBar2.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    StyledText.this.handleHorizontalScroll(event);
                }
            });
        }
    }

    void internalRedrawRange(int n2, int n3) {
        int n4;
        Rectangle rectangle;
        if (n3 <= 0) {
            return;
        }
        int n5 = n2 + n3;
        int n6 = this.content.getLineAtOffset(n2);
        int n7 = this.content.getLineAtOffset(n5);
        int n8 = this.getPartialBottomIndex();
        int n9 = this.getPartialTopIndex();
        if (n6 > n8 || n7 < n9) {
            return;
        }
        if (n9 > n6) {
            n6 = n9;
            n2 = 0;
        } else {
            n2 -= this.content.getOffsetAtLine(n6);
        }
        if (n8 < n7) {
            n7 = n8 + 1;
            n5 = 0;
        } else {
            n5 -= this.content.getOffsetAtLine(n7);
        }
        TextLayout textLayout = this.renderer.getTextLayout(n6);
        int n10 = this.leftMargin - this.horizontalScrollOffset;
        int n11 = this.getLinePixel(n6);
        int[] nArray = textLayout.getLineOffsets();
        int n12 = textLayout.getLineIndex(Math.min(n2, textLayout.getText().length()));
        if (this.wordWrap && n12 > 0 && nArray[n12] == n2) {
            rectangle = textLayout.getLineBounds(n12 - 1);
            rectangle.x = rectangle.width;
            rectangle.width = this.clientAreaWidth - this.rightMargin - rectangle.x;
            rectangle.x += n10;
            rectangle.y += n11;
            super.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        }
        if (n6 == n7 && n12 == (n4 = textLayout.getLineIndex(Math.min(n5, textLayout.getText().length())))) {
            Rectangle rectangle2 = textLayout.getBounds(n2, n5 - 1);
            rectangle2.x += n10;
            rectangle2.y += n11;
            super.redraw(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, false);
            this.renderer.disposeTextLayout(textLayout);
            return;
        }
        rectangle = textLayout.getBounds(n2, nArray[n12 + 1] - 1);
        if (rectangle.height == 0) {
            Rectangle rectangle3 = textLayout.getLineBounds(n12);
            rectangle.x = rectangle3.width;
            rectangle.y = rectangle3.y;
            rectangle.height = rectangle3.height;
        }
        rectangle.x += n10;
        rectangle.y += n11;
        rectangle.width = this.clientAreaWidth - this.rightMargin - rectangle.x;
        super.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        if (n6 != n7) {
            this.renderer.disposeTextLayout(textLayout);
            textLayout = this.renderer.getTextLayout(n7);
            nArray = textLayout.getLineOffsets();
        }
        int n13 = textLayout.getLineIndex(Math.min(n5, textLayout.getText().length()));
        Rectangle rectangle4 = textLayout.getBounds(nArray[n13], n5 - 1);
        if (rectangle4.height == 0) {
            Rectangle rectangle5 = textLayout.getLineBounds(n13);
            rectangle4.y = rectangle5.y;
            rectangle4.height = rectangle5.height;
        }
        rectangle4.x += n10;
        rectangle4.y += this.getLinePixel(n7);
        super.redraw(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, false);
        this.renderer.disposeTextLayout(textLayout);
        int n14 = rectangle.y + rectangle.height;
        if (rectangle4.y > n14) {
            super.redraw(this.leftMargin, n14, this.clientAreaWidth - this.rightMargin - this.leftMargin, rectangle4.y - n14, false);
        }
    }

    void handleDispose(Event event) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.clipboard.dispose();
        if (this.renderer != null) {
            this.renderer.dispose();
            this.renderer = null;
        }
        if (this.content != null) {
            this.content.removeTextChangeListener(this.textChangeListener);
            this.content = null;
        }
        if (this.defaultCaret != null) {
            this.defaultCaret.dispose();
            this.defaultCaret = null;
        }
        if (this.leftCaretBitmap != null) {
            this.leftCaretBitmap.dispose();
            this.leftCaretBitmap = null;
        }
        if (this.rightCaretBitmap != null) {
            this.rightCaretBitmap.dispose();
            this.rightCaretBitmap = null;
        }
        if (this.isBidiCaret()) {
            BidiUtil.removeLanguageListener(this.handle);
        }
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.textChangeListener = null;
        this.selection = null;
        this.doubleClickSelection = null;
        this.keyActionMap = null;
        this.background = null;
        this.foreground = null;
        this.clipboard = null;
    }

    void handleHorizontalScroll(Event event) {
        int n2 = this.getHorizontalBar().getSelection() - this.horizontalScrollOffset;
        this.scrollHorizontal(n2, false);
    }

    void handleKey(Event event) {
        int n2;
        int n3;
        this.caretAlignment = 0;
        if (event.keyCode != 0) {
            n3 = this.getKeyBinding(event.keyCode | event.stateMask);
        } else {
            n3 = this.getKeyBinding(event.character | event.stateMask);
            if (n3 == 0 && (event.stateMask & 0x40000) != 0 && event.character >= '\u0000' && event.character <= '\u001f') {
                n2 = event.character + 64;
                n3 = this.getKeyBinding(n2 | event.stateMask);
            }
        }
        if (n3 == 0) {
            n2 = 0;
            if (IS_CARBON) {
                n2 = (event.stateMask ^ 0x400000) != 0 && (event.stateMask ^ 0x420000) != 0 ? 0 : 1;
            } else if (IS_MOTIF) {
                n2 = (event.stateMask ^ 0x40000) != 0 && (event.stateMask ^ 0x60000) != 0 ? 0 : 1;
            } else {
                int n4 = n2 = (event.stateMask ^ 0x10000) != 0 && (event.stateMask ^ 0x40000) != 0 && (event.stateMask ^ 0x30000) != 0 && (event.stateMask ^ 0x60000) != 0 ? 0 : 1;
            }
            if (n2 == 0 && event.character > '\u001f' && event.character != '\u007f' || event.character == '\r' || event.character == '\n' || event.character == '\t') {
                this.doContent(event.character);
                this.update();
            }
        } else {
            this.invokeAction(n3);
        }
    }

    void handleKeyDown(Event event) {
        if (this.clipboardSelection == null) {
            this.clipboardSelection = new Point(this.selection.x, this.selection.y);
        }
        Event event2 = new Event();
        event2.character = event.character;
        event2.keyCode = event.keyCode;
        event2.stateMask = event.stateMask;
        event2.doit = true;
        this.notifyListeners(3005, event2);
        if (event2.doit) {
            this.handleKey(event);
        }
    }

    void handleKeyUp(Event event) {
        block4: {
            if (this.clipboardSelection != null && (this.clipboardSelection.x != this.selection.x || this.clipboardSelection.y != this.selection.y)) {
                try {
                    if (this.selection.y - this.selection.x > 0) {
                        this.setClipboardContent(this.selection.x, this.selection.y - this.selection.x, 2);
                    }
                }
                catch (SWTError sWTError) {
                    if (sWTError.code == 2002) break block4;
                    throw sWTError;
                }
            }
        }
        this.clipboardSelection = null;
    }

    void handleMouseDown(Event event) {
        String string;
        this.forceFocus();
        if (this.dragDetect && this.checkDragDetect(event)) {
            return;
        }
        if (event.button == 2 && (string = (String)this.getClipboardContent(2)) != null && string.length() > 0) {
            this.doMouseLocationChange(event.x, event.y, false);
            Event event2 = new Event();
            event2.start = this.selection.x;
            event2.end = this.selection.y;
            event2.text = this.getModelDelimitedText(string);
            this.sendKeyEvent(event2);
        }
        if (event.button != 1 || IS_CARBON && (event.stateMask & SWT.MOD4) != 0) {
            return;
        }
        this.clickCount = event.count;
        if (this.clickCount == 1) {
            boolean bl2 = (event.stateMask & SWT.MOD2) != 0;
            this.doMouseLocationChange(event.x, event.y, bl2);
        } else if (this.doubleClickEnabled) {
            int n2;
            int n3;
            this.clearSelection(false);
            int n4 = this.getOffsetAtPoint(event.x, event.y);
            int n5 = this.content.getLineAtOffset(n4);
            int n6 = this.content.getOffsetAtLine(n5);
            int n7 = this.content.getCharCount();
            if (n5 + 1 < this.content.getLineCount()) {
                n7 = this.content.getOffsetAtLine(n5 + 1);
            }
            if ((this.clickCount & 1) == 0) {
                n3 = Math.max(0, this.getWordPrevious(n4, 16));
                n2 = Math.min(this.content.getCharCount(), this.getWordNext(n3, 8));
            } else {
                n3 = n6;
                n2 = n7;
            }
            this.selection.x = this.selection.y = n3;
            this.selectionAnchor = -1;
            this.caretOffset = n2;
            this.showCaret();
            this.doMouseSelection();
            this.doubleClickSelection = new Point(this.selection.x, this.selection.y);
        }
    }

    void handleMouseMove(Event event) {
        if (this.clickCount == 0) {
            return;
        }
        this.doMouseLocationChange(event.x, event.y, true);
        this.update();
        this.doAutoScroll(event);
    }

    void handleMouseUp(Event event) {
        block4: {
            this.clickCount = 0;
            this.endAutoScroll();
            if (event.button == 1) {
                try {
                    if (this.selection.y - this.selection.x > 0) {
                        this.setClipboardContent(this.selection.x, this.selection.y - this.selection.x, 2);
                    }
                }
                catch (SWTError sWTError) {
                    if (sWTError.code == 2002) break block4;
                    throw sWTError;
                }
            }
        }
    }

    void handlePaint(Event event) {
        if (event.width == 0 || event.height == 0) {
            return;
        }
        if (this.clientAreaWidth == 0 || this.clientAreaHeight == 0) {
            return;
        }
        int n2 = this.getLineIndex(event.y);
        int n3 = this.getLinePixel(n2);
        int n4 = event.y + event.height;
        GC gC = event.gc;
        Color color = this.getBackground();
        Color color2 = this.getForeground();
        if (n4 > 0) {
            int n5 = this.isSingleLine() ? 1 : this.content.getLineCount();
            int n6 = this.leftMargin - this.horizontalScrollOffset;
            int n7 = n2;
            while (n3 < n4 && n7 < n5) {
                n3 += this.renderer.drawLine(n7, n6, n3, gC, color, color2);
                ++n7;
            }
            if (n3 < n4) {
                gC.setBackground(color);
                this.drawBackground(gC, 0, n3, this.clientAreaWidth, n4 - n3);
            }
        }
        gC.setBackground(color);
        if (this.topMargin > 0) {
            this.drawBackground(gC, 0, 0, this.clientAreaWidth, this.topMargin);
        }
        if (this.bottomMargin > 0) {
            this.drawBackground(gC, 0, this.clientAreaHeight - this.bottomMargin, this.clientAreaWidth, this.bottomMargin);
        }
        if (this.leftMargin > 0) {
            this.drawBackground(gC, 0, 0, this.leftMargin, this.clientAreaHeight);
        }
        if (this.rightMargin > 0) {
            this.drawBackground(gC, this.clientAreaWidth - this.rightMargin, 0, this.rightMargin, this.clientAreaHeight);
        }
    }

    void handleResize(Event event) {
        int n2;
        int n3 = this.clientAreaHeight;
        int n4 = this.clientAreaWidth;
        Rectangle rectangle = this.getClientArea();
        this.clientAreaHeight = rectangle.height;
        this.clientAreaWidth = rectangle.width;
        if (n4 != this.clientAreaWidth && this.rightMargin > 0) {
            n2 = (n4 < this.clientAreaWidth ? n4 : this.clientAreaWidth) - this.rightMargin;
            super.redraw(n2, 0, this.rightMargin, n3, false);
        }
        if (n3 != this.clientAreaHeight && this.bottomMargin > 0) {
            n2 = (n3 < this.clientAreaHeight ? n3 : this.clientAreaHeight) - this.bottomMargin;
            super.redraw(0, n2, n4, this.bottomMargin, false);
        }
        if (this.wordWrap) {
            if (n4 != this.clientAreaWidth) {
                this.renderer.reset(0, this.content.getLineCount());
                this.verticalScrollOffset = -1;
                this.renderer.calculateIdle();
                super.redraw();
            }
            if (n3 != this.clientAreaHeight) {
                if (n3 == 0) {
                    this.topIndexY = 0;
                }
                this.setScrollBars(true);
            }
            this.setCaretLocation();
        } else {
            ScrollBar scrollBar;
            this.renderer.calculateClientArea();
            this.setScrollBars(true);
            this.claimRightFreeSpace();
            if (this.clientAreaWidth != 0 && (scrollBar = this.getHorizontalBar()) != null && scrollBar.getVisible() && this.horizontalScrollOffset != scrollBar.getSelection()) {
                scrollBar.setSelection(this.horizontalScrollOffset);
                this.horizontalScrollOffset = scrollBar.getSelection();
            }
        }
        this.claimBottomFreeSpace();
    }

    void handleTextChanged(TextChangedEvent textChangedEvent) {
        int n2 = this.content.getLineAtOffset(this.lastTextChangeStart);
        this.resetCache(n2, 0);
        if (!this.isFixedLineHeight() && this.topIndex > n2) {
            this.topIndex = n2;
            this.topIndexY = 0;
            super.redraw();
        } else {
            int n3 = n2 + this.lastTextChangeNewLineCount;
            int n4 = this.getLinePixel(n2);
            int n5 = this.getLinePixel(n3 + 1);
            if (this.lastLineBottom != n5) {
                super.redraw();
                if (this.wordWrap) {
                    this.setCaretLocation();
                }
            } else {
                super.redraw(0, n4, this.clientAreaWidth, n5 - n4, false);
                this.redrawLinesBullet(this.renderer.redrawLines);
            }
        }
        this.renderer.redrawLines = null;
        this.updateSelection(this.lastTextChangeStart, this.lastTextChangeReplaceCharCount, this.lastTextChangeNewCharCount);
        if (this.lastTextChangeReplaceLineCount > 0 || this.wordWrap) {
            this.claimBottomFreeSpace();
        }
        if (this.lastTextChangeReplaceCharCount > 0) {
            this.claimRightFreeSpace();
        }
    }

    void handleTextChanging(TextChangingEvent textChangingEvent) {
        int n2;
        if (textChangingEvent.replaceCharCount < 0) {
            textChangingEvent.start += textChangingEvent.replaceCharCount;
            textChangingEvent.replaceCharCount *= -1;
        }
        this.lastTextChangeStart = textChangingEvent.start;
        this.lastTextChangeNewLineCount = textChangingEvent.newLineCount;
        this.lastTextChangeNewCharCount = textChangingEvent.newCharCount;
        this.lastTextChangeReplaceLineCount = textChangingEvent.replaceLineCount;
        this.lastTextChangeReplaceCharCount = textChangingEvent.replaceCharCount;
        int n3 = this.content.getLineAtOffset(textChangingEvent.start);
        int n4 = this.getLinePixel(n3 + textChangingEvent.replaceLineCount + 1);
        this.lastLineBottom = n2 = this.getLinePixel(n3 + 1) + textChangingEvent.newLineCount * this.renderer.getLineHeight();
        if (n4 < 0 && n2 < 0) {
            this.lastLineBottom += n4 - n2;
            this.verticalScrollOffset += n2 - n4;
            this.calculateTopIndex(n2 - n4);
            this.setScrollBars(true);
        } else {
            this.scrollText(n4, n2);
        }
        this.renderer.textChanging(textChangingEvent);
        int n5 = this.content.getCharCount() - textChangingEvent.replaceCharCount + textChangingEvent.newCharCount;
        if (this.caretOffset > n5) {
            this.caretOffset = n5;
        }
    }

    void handleTextSet(TextChangedEvent textChangedEvent) {
        this.reset();
    }

    void handleTraverse(Event event) {
        switch (event.detail) {
            case 2: 
            case 256: 
            case 512: {
                event.doit = true;
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                if ((this.getStyle() & 4) != 0) {
                    event.doit = true;
                    break;
                }
                if (this.editable && (event.stateMask & SWT.MODIFIER_MASK) == 0) break;
                event.doit = true;
            }
        }
    }

    void handleVerticalScroll(Event event) {
        int n2 = this.getVerticalBar().getSelection() - this.getVerticalScrollOffset();
        this.scrollVertical(n2, false);
    }

    void initializeAccessible() {
        final Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                String string = null;
                Label label = StyledText.this.getAssociatedLabel();
                if (label != null) {
                    string = StyledText.this.stripMnemonic(label.getText());
                }
                accessibleEvent.result = string;
            }

            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = StyledText.this.getToolTipText();
            }

            public void getKeyboardShortcut(AccessibleEvent accessibleEvent) {
                char c2;
                String string;
                String string2 = null;
                Label label = StyledText.this.getAssociatedLabel();
                if (label != null && (string = label.getText()) != null && (c2 = StyledText.this._findMnemonic(string)) != '\u0000') {
                    string2 = "Alt+" + c2;
                }
                accessibleEvent.result = string2;
            }
        });
        accessible.addAccessibleTextListener(new AccessibleTextAdapter(){

            public void getCaretOffset(AccessibleTextEvent accessibleTextEvent) {
                accessibleTextEvent.offset = StyledText.this.getCaretOffset();
            }

            public void getSelectionRange(AccessibleTextEvent accessibleTextEvent) {
                Point point = StyledText.this.getSelectionRange();
                accessibleTextEvent.offset = point.x;
                accessibleTextEvent.length = point.y;
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 42;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                int n2 = 0;
                if (StyledText.this.isEnabled()) {
                    n2 |= 0x100000;
                }
                if (StyledText.this.isFocusControl()) {
                    n2 |= 4;
                }
                if (!StyledText.this.isVisible()) {
                    n2 |= 0x8000;
                }
                if (!StyledText.this.getEditable()) {
                    n2 |= 0x40;
                }
                accessibleControlEvent.detail = n2;
            }

            public void getValue(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.result = StyledText.this.getText();
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                accessible.setFocus(-1);
            }
        });
    }

    Label getAssociatedLabel() {
        Control[] controlArray = this.getParent().getChildren();
        int n2 = 0;
        while (n2 < controlArray.length) {
            if (controlArray[n2] == this && n2 > 0 && controlArray[n2 - 1] instanceof Label) {
                return (Label)controlArray[n2 - 1];
            }
            ++n2;
        }
        return null;
    }

    String stripMnemonic(String string) {
        int n2 = 0;
        int n3 = string.length();
        while (true) {
            if (n2 < n3 && string.charAt(n2) != '&') {
                ++n2;
                continue;
            }
            if (++n2 >= n3) {
                return string;
            }
            if (string.charAt(n2) != '&') {
                return String.valueOf(string.substring(0, n2 - 1)) + string.substring(n2, n3);
            }
            if (++n2 >= n3) break;
        }
        return string;
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int n2 = 0;
        int n3 = string.length();
        while (true) {
            if (n2 < n3 && string.charAt(n2) != '&') {
                ++n2;
                continue;
            }
            if (++n2 >= n3) {
                return '\u0000';
            }
            if (string.charAt(n2) != '&') {
                return Character.toLowerCase(string.charAt(n2));
            }
            if (++n2 >= n3) break;
        }
        return '\u0000';
    }

    public void invokeAction(int n2) {
        this.checkWidget();
        this.updateCaretDirection = true;
        switch (n2) {
            case 0x1000001: {
                this.doLineUp(false);
                this.clearSelection(true);
                break;
            }
            case 0x1000002: {
                this.doLineDown(false);
                this.clearSelection(true);
                break;
            }
            case 0x1000007: {
                this.doLineStart();
                this.clearSelection(true);
                break;
            }
            case 0x1000008: {
                this.doLineEnd();
                this.clearSelection(true);
                break;
            }
            case 0x1000003: {
                this.doCursorPrevious();
                this.clearSelection(true);
                break;
            }
            case 0x1000004: {
                this.doCursorNext();
                this.clearSelection(true);
                break;
            }
            case 0x1000005: {
                this.doPageUp(false, -1);
                this.clearSelection(true);
                break;
            }
            case 0x1000006: {
                this.doPageDown(false, -1);
                this.clearSelection(true);
                break;
            }
            case 17039363: {
                this.doWordPrevious();
                this.clearSelection(true);
                break;
            }
            case 0x1040004: {
                this.doWordNext();
                this.clearSelection(true);
                break;
            }
            case 17039367: {
                this.doContentStart();
                this.clearSelection(true);
                break;
            }
            case 17039368: {
                this.doContentEnd();
                this.clearSelection(true);
                break;
            }
            case 17039365: {
                this.doPageStart();
                this.clearSelection(true);
                break;
            }
            case 17039366: {
                this.doPageEnd();
                this.clearSelection(true);
                break;
            }
            case 0x1020001: {
                this.doSelectionLineUp();
                break;
            }
            case 262209: {
                this.selectAll();
                break;
            }
            case 0x1020002: {
                this.doSelectionLineDown();
                break;
            }
            case 16908295: {
                this.doLineStart();
                this.doSelection(0x1000003);
                break;
            }
            case 16908296: {
                this.doLineEnd();
                this.doSelection(0x1000004);
                break;
            }
            case 16908291: {
                this.doSelectionCursorPrevious();
                this.doSelection(0x1000003);
                break;
            }
            case 16908292: {
                this.doSelectionCursorNext();
                this.doSelection(0x1000004);
                break;
            }
            case 16908293: {
                this.doSelectionPageUp(-1);
                break;
            }
            case 16908294: {
                this.doSelectionPageDown(-1);
                break;
            }
            case 17170435: {
                this.doSelectionWordPrevious();
                this.doSelection(0x1000003);
                break;
            }
            case 17170436: {
                this.doSelectionWordNext();
                this.doSelection(0x1000004);
                break;
            }
            case 17170439: {
                this.doContentStart();
                this.doSelection(0x1000003);
                break;
            }
            case 17170440: {
                this.doContentEnd();
                this.doSelection(0x1000004);
                break;
            }
            case 17170437: {
                this.doPageStart();
                this.doSelection(0x1000003);
                break;
            }
            case 0x1060006: {
                this.doPageEnd();
                this.doSelection(0x1000004);
                break;
            }
            case 131199: {
                this.cut();
                break;
            }
            case 17039369: {
                this.copy();
                break;
            }
            case 16908297: {
                this.paste();
                break;
            }
            case 8: {
                this.doBackspace();
                break;
            }
            case 127: {
                this.doDelete();
                break;
            }
            case 262152: {
                this.doDeleteWordPrevious();
                break;
            }
            case 262271: {
                this.doDeleteWordNext();
                break;
            }
            case 0x1000009: {
                this.overwrite = !this.overwrite;
            }
        }
    }

    boolean isBidi() {
        return IS_GTK || BidiUtil.isBidiPlatform() || this.isMirrored;
    }

    boolean isBidiCaret() {
        return BidiUtil.isBidiPlatform();
    }

    boolean isFixedLineHeight() {
        return this.fixedLineHeight;
    }

    boolean isLineDelimiter(int n2) {
        int n3 = this.content.getLineAtOffset(n2);
        int n4 = this.content.getOffsetAtLine(n3);
        int n5 = n2 - n4;
        return n5 > this.content.getLine(n3).length();
    }

    boolean isMirrored() {
        return this.isMirrored;
    }

    boolean isSingleLine() {
        return (this.getStyle() & 4) != 0;
    }

    void modifyContent(Event event, boolean bl2) {
        event.doit = true;
        this.notifyListeners(25, event);
        if (event.doit) {
            StyledTextEvent styledTextEvent = null;
            int n2 = event.end - event.start;
            if (this.isListening(3000)) {
                styledTextEvent = new StyledTextEvent(this.content);
                styledTextEvent.start = event.start;
                styledTextEvent.end = event.start + event.text.length();
                styledTextEvent.text = this.content.getTextRange(event.start, n2);
            }
            if (bl2 && event.text.length() == 0) {
                int n3 = this.content.getLineAtOffset(event.start);
                int n4 = this.content.getOffsetAtLine(n3);
                TextLayout textLayout = this.renderer.getTextLayout(n3);
                int n5 = textLayout.getLevel(event.start - n4);
                int n6 = this.content.getLineAtOffset(event.end);
                if (n3 != n6) {
                    this.renderer.disposeTextLayout(textLayout);
                    n4 = this.content.getOffsetAtLine(n6);
                    textLayout = this.renderer.getTextLayout(n6);
                }
                int n7 = textLayout.getLevel(event.end - n4);
                this.renderer.disposeTextLayout(textLayout);
                this.caretAlignment = n5 != n7 ? 0 : 1;
            }
            this.content.replaceTextRange(event.start, n2, event.text);
            if (bl2) {
                this.setSelection(event.start + event.text.length(), 0, true);
                this.showCaret();
            }
            this.sendModifyEvent(event);
            if (this.isListening(3000)) {
                this.notifyListeners(3000, styledTextEvent);
            }
        }
    }

    void paintObject(GC gC, int n2, int n3, int n4, int n5, StyleRange styleRange, Bullet bullet, int n6) {
        if (this.isListening(3008)) {
            StyledTextEvent styledTextEvent = new StyledTextEvent(this.content);
            styledTextEvent.gc = gC;
            styledTextEvent.x = n2;
            styledTextEvent.y = n3;
            styledTextEvent.ascent = n4;
            styledTextEvent.descent = n5;
            styledTextEvent.style = styleRange;
            styledTextEvent.bullet = bullet;
            styledTextEvent.bulletIndex = n6;
            this.notifyListeners(3008, styledTextEvent);
        }
    }

    public void paste() {
        this.checkWidget();
        String string = (String)this.getClipboardContent(1);
        if (string != null && string.length() > 0) {
            Event event = new Event();
            event.start = this.selection.x;
            event.end = this.selection.y;
            event.text = this.getModelDelimitedText(string);
            this.sendKeyEvent(event);
        }
    }

    public void print() {
        this.checkWidget();
        Printer printer = new Printer();
        StyledTextPrintOptions styledTextPrintOptions = new StyledTextPrintOptions();
        styledTextPrintOptions.printTextForeground = true;
        styledTextPrintOptions.printTextBackground = true;
        styledTextPrintOptions.printTextFontStyle = true;
        styledTextPrintOptions.printLineBackground = true;
        new Printing(this, printer, styledTextPrintOptions).run();
        printer.dispose();
    }

    public Runnable print(Printer printer) {
        this.checkWidget();
        if (printer == null) {
            SWT.error(4);
        }
        StyledTextPrintOptions styledTextPrintOptions = new StyledTextPrintOptions();
        styledTextPrintOptions.printTextForeground = true;
        styledTextPrintOptions.printTextBackground = true;
        styledTextPrintOptions.printTextFontStyle = true;
        styledTextPrintOptions.printLineBackground = true;
        return this.print(printer, styledTextPrintOptions);
    }

    public Runnable print(Printer printer, StyledTextPrintOptions styledTextPrintOptions) {
        this.checkWidget();
        if (printer == null || styledTextPrintOptions == null) {
            SWT.error(4);
        }
        return new Printing(this, printer, styledTextPrintOptions);
    }

    public void redraw() {
        super.redraw();
        int n2 = this.getPartialBottomIndex() - this.topIndex + 1;
        this.renderer.reset(this.topIndex, n2);
        this.renderer.calculate(this.topIndex, n2);
        this.setScrollBars(false);
    }

    public void redraw(int n2, int n3, int n4, int n5, boolean bl2) {
        super.redraw(n2, n3, n4, n5, bl2);
        if (n5 > 0) {
            int n6 = this.getLineIndex(n3);
            int n7 = this.getLineIndex(n3 + n5);
            this.resetCache(n6, n7 - n6 + 1);
        }
    }

    void redrawLines(int n2, int n3) {
        int n4 = this.getPartialBottomIndex();
        if (n2 > n4 || n2 + n3 - 1 < this.topIndex) {
            return;
        }
        if (n2 < this.topIndex) {
            n3 -= this.topIndex - n2;
            n2 = this.topIndex;
        }
        if (n2 + n3 - 1 > n4) {
            n3 = n4 - n2 + 1;
        }
        int n5 = this.getLinePixel(n2 -= this.topIndex);
        int n6 = this.getLinePixel(n2 + n3);
        int n7 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
        super.redraw(this.leftMargin, n5, n7, n6 - n5, true);
    }

    void redrawLinesBullet(int[] nArray) {
        if (nArray == null) {
            return;
        }
        int n2 = this.getPartialTopIndex();
        int n3 = this.getPartialBottomIndex();
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5 = nArray[n4];
            if (n2 <= n5 && n5 <= n3) {
                int n6 = -1;
                Bullet bullet = this.renderer.getLineBullet(n5, null);
                if (bullet != null) {
                    StyleRange styleRange = bullet.style;
                    GlyphMetrics glyphMetrics = styleRange.metrics;
                    n6 = glyphMetrics.width;
                }
                if (n6 == -1) {
                    n6 = this.getClientArea().width;
                }
                int n7 = this.renderer.getLineHeight(n5);
                int n8 = this.getLinePixel(n5);
                super.redraw(0, n8, n6, n7, false);
            }
            ++n4;
        }
    }

    public void redrawRange(int n2, int n3, boolean bl2) {
        this.checkWidget();
        int n4 = n2 + n3;
        int n5 = this.content.getCharCount();
        if (n2 > n4 || n2 < 0 || n4 > n5) {
            SWT.error(6);
        }
        int n6 = this.content.getLineAtOffset(n2);
        int n7 = this.content.getLineAtOffset(n4);
        this.resetCache(n6, n7 - n6 + 1);
        this.internalRedrawRange(n2, n3);
    }

    public void removeBidiSegmentListener(BidiSegmentListener bidiSegmentListener) {
        this.checkWidget();
        if (bidiSegmentListener == null) {
            SWT.error(4);
        }
        this.removeListener(3007, bidiSegmentListener);
    }

    public void removeExtendedModifyListener(ExtendedModifyListener extendedModifyListener) {
        this.checkWidget();
        if (extendedModifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(3000, extendedModifyListener);
    }

    public void removeLineBackgroundListener(LineBackgroundListener lineBackgroundListener) {
        this.checkWidget();
        if (lineBackgroundListener == null) {
            SWT.error(4);
        }
        this.removeListener(3001, lineBackgroundListener);
    }

    public void removeLineStyleListener(LineStyleListener lineStyleListener) {
        this.checkWidget();
        if (lineStyleListener == null) {
            SWT.error(4);
        }
        this.removeListener(3002, lineStyleListener);
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(24, modifyListener);
    }

    public void removePaintObjectListener(PaintObjectListener paintObjectListener) {
        this.checkWidget();
        if (paintObjectListener == null) {
            SWT.error(4);
        }
        this.removeListener(3008, paintObjectListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.removeListener(13, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(25, verifyListener);
    }

    public void removeVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        if (verifyKeyListener == null) {
            SWT.error(4);
        }
        this.removeListener(3005, verifyKeyListener);
    }

    public void removeWordMovementListener(MovementListener movementListener) {
        this.checkWidget();
        if (movementListener == null) {
            SWT.error(4);
        }
        this.removeListener(3009, movementListener);
        this.removeListener(3010, movementListener);
    }

    public void replaceStyleRanges(int n2, int n3, StyleRange[] styleRangeArray) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (styleRangeArray == null) {
            SWT.error(4);
        }
        this.setStyleRanges(n2, n3, null, styleRangeArray, false);
    }

    public void replaceTextRange(int n2, int n3, String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        int n4 = this.getCharCount();
        int n5 = n2 + n3;
        if (n2 > n5 || n2 < 0 || n5 > n4) {
            SWT.error(6);
        }
        Event event = new Event();
        event.start = n2;
        event.end = n5;
        event.text = string;
        this.modifyContent(event, false);
    }

    void reset() {
        ScrollBar scrollBar = this.getVerticalBar();
        ScrollBar scrollBar2 = this.getHorizontalBar();
        this.caretOffset = 0;
        this.topIndex = 0;
        this.topIndexY = 0;
        this.verticalScrollOffset = 0;
        this.horizontalScrollOffset = 0;
        this.resetSelection();
        this.renderer.setContent(this.content);
        if (scrollBar != null) {
            scrollBar.setSelection(0);
        }
        if (scrollBar2 != null) {
            scrollBar2.setSelection(0);
        }
        this.resetCache(0, 0);
        this.setCaretLocation();
        super.redraw();
    }

    void resetCache(int n2, int n3) {
        int n4 = this.renderer.maxWidthLineIndex;
        this.renderer.reset(n2, n3);
        this.renderer.calculateClientArea();
        if (n4 >= 0 && n4 < this.content.getLineCount()) {
            this.renderer.calculate(n4, 1);
        }
        this.setScrollBars(true);
        if (!this.isFixedLineHeight()) {
            if (this.topIndex > n2) {
                this.verticalScrollOffset = -1;
            }
            this.renderer.calculateIdle();
        }
    }

    void resetSelection() {
        this.selection.x = this.selection.y = this.caretOffset;
        this.selectionAnchor = -1;
    }

    public void scroll(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        super.scroll(n2, n3, n4, n5, n6, n7, false);
        if (bl2) {
            int n8 = n2 - n4;
            int n9 = n3 - n5;
            Control[] controlArray = this.getChildren();
            int n10 = 0;
            while (n10 < controlArray.length) {
                Control control = controlArray[n10];
                Rectangle rectangle = control.getBounds();
                control.setLocation(rectangle.x + n8, rectangle.y + n9);
                ++n10;
            }
        }
    }

    boolean scrollHorizontal(int n2, boolean bl2) {
        int n3;
        if (n2 == 0) {
            return false;
        }
        ScrollBar scrollBar = this.getHorizontalBar();
        if (scrollBar != null && bl2) {
            scrollBar.setSelection(this.horizontalScrollOffset + n2);
        }
        int n4 = this.clientAreaHeight - this.topMargin - this.bottomMargin;
        if (n2 > 0) {
            n3 = this.leftMargin + n2;
            int n5 = this.clientAreaWidth - n3 - this.rightMargin;
            if (n5 > 0) {
                this.scroll(this.leftMargin, this.topMargin, n3, this.topMargin, n5, n4, true);
            }
            if (n3 > n5) {
                super.redraw(this.leftMargin + n5, this.topMargin, n2 - n5, n4, true);
            }
        } else {
            n3 = this.leftMargin - n2;
            int n6 = this.clientAreaWidth - n3 - this.rightMargin;
            if (n6 > 0) {
                this.scroll(n3, this.topMargin, this.leftMargin, this.topMargin, n6, n4, true);
            }
            if (n3 > n6) {
                super.redraw(this.leftMargin + n6, this.topMargin, -n2 - n6, n4, true);
            }
        }
        this.horizontalScrollOffset += n2;
        n3 = this.columnX;
        this.setCaretLocation();
        this.columnX = n3;
        return true;
    }

    boolean scrollVertical(int n2, boolean bl2) {
        if (n2 == 0) {
            return false;
        }
        if (this.verticalScrollOffset != -1) {
            ScrollBar scrollBar = this.getVerticalBar();
            if (scrollBar != null && bl2) {
                scrollBar.setSelection(this.verticalScrollOffset + n2);
            }
            int n3 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
            if (n2 > 0) {
                int n4 = this.topMargin + n2;
                int n5 = this.clientAreaHeight - n4 - this.bottomMargin;
                if (n5 > 0) {
                    this.scroll(this.leftMargin, this.topMargin, this.leftMargin, n4, n3, n5, true);
                }
                if (n4 > n5) {
                    int n6 = Math.max(0, this.topMargin + n5);
                    int n7 = Math.min(this.clientAreaHeight, n2 - n5);
                    super.redraw(this.leftMargin, n6, n3, n7, true);
                }
            } else {
                int n8 = this.topMargin - n2;
                int n9 = this.clientAreaHeight - n8 - this.bottomMargin;
                if (n9 > 0) {
                    this.scroll(this.leftMargin, n8, this.leftMargin, this.topMargin, n3, n9, true);
                }
                if (n8 > n9) {
                    int n10 = Math.max(0, this.topMargin + n9);
                    int n11 = Math.min(this.clientAreaHeight, -n2 - n9);
                    super.redraw(this.leftMargin, n10, n3, n11, true);
                }
            }
            this.verticalScrollOffset += n2;
            this.calculateTopIndex(n2);
        } else {
            this.calculateTopIndex(n2);
            super.redraw();
        }
        int n12 = this.columnX;
        this.setCaretLocation();
        this.columnX = n12;
        return true;
    }

    void scrollText(int n2, int n3) {
        if (n2 == n3) {
            return;
        }
        int n4 = n3 - n2;
        int n5 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
        int n6 = n4 > 0 ? this.clientAreaHeight - n2 - this.bottomMargin : this.clientAreaHeight - n3 - this.bottomMargin;
        this.scroll(this.leftMargin, n3, this.leftMargin, n2, n5, n6, true);
        if (n2 + n6 > 0 && this.topMargin > n2) {
            super.redraw(this.leftMargin, n4, n5, this.topMargin, false);
        }
        if (n3 + n6 > 0 && this.topMargin > n3) {
            super.redraw(this.leftMargin, 0, n5, this.topMargin, false);
        }
        if (this.clientAreaHeight - this.bottomMargin < n2 + n6 && this.clientAreaHeight > n2) {
            super.redraw(this.leftMargin, this.clientAreaHeight - this.bottomMargin + n4, n5, this.bottomMargin, false);
        }
        if (this.clientAreaHeight - this.bottomMargin < n3 + n6 && this.clientAreaHeight > n3) {
            super.redraw(this.leftMargin, this.clientAreaHeight - this.bottomMargin, n5, this.bottomMargin, false);
        }
    }

    public void selectAll() {
        this.checkWidget();
        this.setSelection(0, Math.max(this.getCharCount(), 0));
    }

    void sendKeyEvent(Event event) {
        if (this.editable) {
            this.modifyContent(event, true);
        }
    }

    StyledTextEvent sendLineEvent(int n2, int n3, String string) {
        StyledTextEvent styledTextEvent = null;
        if (this.isListening(n2)) {
            styledTextEvent = new StyledTextEvent(this.content);
            styledTextEvent.detail = n3;
            styledTextEvent.text = string;
            styledTextEvent.alignment = this.alignment;
            styledTextEvent.indent = this.indent;
            styledTextEvent.justify = this.justify;
            this.notifyListeners(n2, styledTextEvent);
        }
        return styledTextEvent;
    }

    void sendModifyEvent(Event event) {
        Accessible accessible = this.getAccessible();
        if (event.text.length() == 0) {
            accessible.textChanged(1, event.start, event.end - event.start);
        } else if (event.start == event.end) {
            accessible.textChanged(0, event.start, event.text.length());
        } else {
            accessible.textChanged(1, event.start, event.end - event.start);
            accessible.textChanged(0, event.start, event.text.length());
        }
        this.notifyListeners(24, event);
    }

    void sendSelectionEvent() {
        this.getAccessible().textSelectionChanged();
        Event event = new Event();
        event.x = this.selection.x;
        event.y = this.selection.y;
        this.notifyListeners(13, event);
    }

    int sendWordBoundaryEvent(int n2, int n3, int n4, int n5, String string, int n6) {
        if (this.isListening(n2)) {
            StyledTextEvent styledTextEvent = new StyledTextEvent(this.content);
            styledTextEvent.detail = n6;
            styledTextEvent.text = string;
            styledTextEvent.count = n3;
            styledTextEvent.start = n4;
            styledTextEvent.end = n5;
            this.notifyListeners(n2, styledTextEvent);
            n4 = styledTextEvent.end;
            if (n4 != n5) {
                int n7 = this.getCharCount();
                if (n4 < 0) {
                    n4 = 0;
                } else if (n4 > n7) {
                    n4 = n7;
                } else if (this.isLineDelimiter(n4)) {
                    SWT.error(5);
                }
            }
            return n4;
        }
        return n5;
    }

    public void setAlignment(int n2) {
        this.checkWidget();
        if ((n2 &= 0x1024000) == 0 || this.alignment == n2) {
            return;
        }
        this.alignment = n2;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setBackground(Color color) {
        this.checkWidget();
        this.background = color;
        super.redraw();
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        super.setCaret(caret);
        this.caretDirection = 0;
        if (caret != null) {
            this.setCaretLocation();
        }
    }

    public void setBidiColoring(boolean bl2) {
        this.checkWidget();
        this.bidiColoring = bl2;
    }

    void setCaretLocation() {
        Point point = this.getPointAtOffset(this.caretOffset);
        this.setCaretLocation(point, this.getCaretDirection());
    }

    void setCaretLocation(Point point, int n2) {
        Caret caret = this.getCaret();
        if (caret != null) {
            int n3;
            boolean bl2 = caret == this.defaultCaret;
            int n4 = n3 = this.renderer.getLineHeight();
            if (!this.isFixedLineHeight() && bl2 && (n4 = this.getBoundsAtOffset((int)this.caretOffset).height) != n3) {
                n2 = -1;
            }
            int n5 = n2;
            if (this.isMirrored()) {
                if (n5 == 16384) {
                    n5 = 131072;
                } else if (n5 == 131072) {
                    n5 = 16384;
                }
            }
            if (bl2 && n5 == 131072) {
                point.x -= caret.getSize().x - 1;
            }
            if (bl2) {
                caret.setBounds(point.x, point.y, 0, n4);
            } else {
                caret.setLocation(point);
            }
            this.getAccessible().textCaretMoved(this.getCaretOffset());
            if (n2 != this.caretDirection) {
                this.caretDirection = n2;
                if (bl2) {
                    if (n5 == -1) {
                        this.defaultCaret.setImage(null);
                    } else if (n5 == 16384) {
                        this.defaultCaret.setImage(this.leftCaretBitmap);
                    } else if (n5 == 131072) {
                        this.defaultCaret.setImage(this.rightCaretBitmap);
                    }
                }
                if (this.caretDirection == 16384) {
                    BidiUtil.setKeyboardLanguage(0);
                } else if (this.caretDirection == 131072) {
                    BidiUtil.setKeyboardLanguage(1);
                }
            }
        }
        this.columnX = point.x;
    }

    public void setCaretOffset(int n2) {
        this.checkWidget();
        int n3 = this.getCharCount();
        if (n3 > 0 && n2 != this.caretOffset) {
            if (n2 < 0) {
                this.caretOffset = 0;
            } else if (n2 > n3) {
                this.caretOffset = n3;
            } else {
                if (this.isLineDelimiter(n2)) {
                    SWT.error(5);
                }
                this.caretOffset = n2;
            }
            this.clearSelection(false);
        }
        this.setCaretLocation();
    }

    void setClipboardContent(int n2, int n3, int n4) throws SWTError {
        Transfer[] transferArray;
        Object[] objectArray;
        if (n4 == 2 && !IS_MOTIF && !IS_GTK) {
            return;
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        TextWriter textWriter = new TextWriter(n2, n3);
        String string = this.getPlatformDelimitedText(textWriter);
        if (n4 == 2) {
            objectArray = new Object[]{string};
            transferArray = new Transfer[]{textTransfer};
        } else {
            RTFTransfer rTFTransfer = RTFTransfer.getInstance();
            RTFWriter rTFWriter = new RTFWriter(n2, n3);
            String string2 = this.getPlatformDelimitedText(rTFWriter);
            objectArray = new Object[]{string2, string};
            transferArray = new Transfer[]{rTFTransfer, textTransfer};
        }
        this.clipboard.setContents(objectArray, transferArray, n4);
    }

    public void setContent(StyledTextContent styledTextContent) {
        this.checkWidget();
        if (styledTextContent == null) {
            SWT.error(4);
        }
        if (this.content != null) {
            this.content.removeTextChangeListener(this.textChangeListener);
        }
        this.content = styledTextContent;
        this.content.addTextChangeListener(this.textChangeListener);
        this.reset();
    }

    public void setCursor(Cursor cursor) {
        if (cursor == null) {
            Display display = this.getDisplay();
            super.setCursor(display.getSystemCursor(19));
        } else {
            super.setCursor(cursor);
        }
    }

    public void setDoubleClickEnabled(boolean bl2) {
        this.checkWidget();
        this.doubleClickEnabled = bl2;
    }

    public void setDragDetect(boolean bl2) {
        this.checkWidget();
        this.dragDetect = bl2;
    }

    public void setEditable(boolean bl2) {
        this.checkWidget();
        this.editable = bl2;
    }

    public void setFont(Font font) {
        int n2;
        this.checkWidget();
        int n3 = this.renderer.getLineHeight();
        super.setFont(font);
        this.renderer.setFont(this.getFont(), this.tabLength);
        if (this.isFixedLineHeight() && (n2 = this.renderer.getLineHeight()) != n3) {
            int n4 = this.getVerticalScrollOffset() * n2 / n3 - this.getVerticalScrollOffset();
            this.scrollVertical(n4, true);
        }
        this.resetCache(0, this.content.getLineCount());
        this.claimBottomFreeSpace();
        this.calculateScrollBars();
        if (this.isBidiCaret()) {
            this.createCaretBitmaps();
        }
        this.caretDirection = 0;
        this.setCaretLocation();
        super.redraw();
    }

    public void setForeground(Color color) {
        this.checkWidget();
        this.foreground = color;
        super.setForeground(this.getForeground());
        super.redraw();
    }

    public void setHorizontalIndex(int n2) {
        int n3;
        this.checkWidget();
        if (this.getCharCount() == 0) {
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (this.clientAreaWidth > 0 && (n2 *= this.getHorizontalIncrement()) > (n3 = this.renderer.getWidth()) - this.clientAreaWidth) {
            n2 = Math.max(0, n3 - this.clientAreaWidth);
        }
        this.scrollHorizontal(n2 - this.horizontalScrollOffset, true);
    }

    public void setHorizontalPixel(int n2) {
        int n3;
        this.checkWidget();
        if (this.getCharCount() == 0) {
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (this.clientAreaWidth > 0 && n2 > (n3 = this.renderer.getWidth()) - this.clientAreaWidth) {
            n2 = Math.max(0, n3 - this.clientAreaWidth);
        }
        this.scrollHorizontal(n2 - this.horizontalScrollOffset, true);
    }

    public void setIndent(int n2) {
        this.checkWidget();
        if (this.indent == n2 || n2 < 0) {
            return;
        }
        this.indent = n2;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setJustify(boolean bl2) {
        this.checkWidget();
        if (this.justify == bl2) {
            return;
        }
        this.justify = bl2;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setKeyBinding(int n2, int n3) {
        this.checkWidget();
        int n4 = n2 & SWT.MODIFIER_MASK;
        char c2 = (char)(n2 & 0x100FFFF);
        if (Compatibility.isLetter(c2)) {
            char c3 = Character.toUpperCase(c2);
            int n5 = c3 | n4;
            if (n3 == 0) {
                this.keyActionMap.remove(new Integer(n5));
            } else {
                this.keyActionMap.put(new Integer(n5), new Integer(n3));
            }
            c3 = Character.toLowerCase(c2);
            n5 = c3 | n4;
            if (n3 == 0) {
                this.keyActionMap.remove(new Integer(n5));
            } else {
                this.keyActionMap.put(new Integer(n5), new Integer(n3));
            }
        } else if (n3 == 0) {
            this.keyActionMap.remove(new Integer(n2));
        } else {
            this.keyActionMap.put(new Integer(n2), new Integer(n3));
        }
    }

    public void setLineAlignment(int n2, int n3, int n4) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n2 < 0 || n2 + n3 > this.content.getLineCount()) {
            SWT.error(5);
        }
        this.renderer.setLineAlignment(n2, n3, n4);
        this.resetCache(n2, n3);
        this.redrawLines(n2, n3);
        int n5 = this.getCaretLine();
        if (n2 <= n5 && n5 < n2 + n3) {
            this.setCaretLocation();
        }
    }

    public void setLineBackground(int n2, int n3, Color color) {
        this.checkWidget();
        if (this.isListening(3001)) {
            return;
        }
        if (n2 < 0 || n2 + n3 > this.content.getLineCount()) {
            SWT.error(5);
        }
        if (color != null) {
            this.renderer.setLineBackground(n2, n3, color);
        } else {
            this.renderer.clearLineBackground(n2, n3);
        }
        this.redrawLines(n2, n3);
    }

    public void setLineBullet(int n2, int n3, Bullet bullet) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n2 < 0 || n2 + n3 > this.content.getLineCount()) {
            SWT.error(5);
        }
        this.renderer.setLineBullet(n2, n3, bullet);
        this.resetCache(n2, n3);
        this.redrawLines(n2, n3);
        int n4 = this.getCaretLine();
        if (n2 <= n4 && n4 < n2 + n3) {
            this.setCaretLocation();
        }
    }

    void setVariableLineHeight() {
        if (!this.fixedLineHeight) {
            return;
        }
        this.fixedLineHeight = false;
        this.renderer.calculateIdle();
    }

    public void setLineIndent(int n2, int n3, int n4) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n2 < 0 || n2 + n3 > this.content.getLineCount()) {
            SWT.error(5);
        }
        this.renderer.setLineIndent(n2, n3, n4);
        this.resetCache(n2, n3);
        this.redrawLines(n2, n3);
        int n5 = this.getCaretLine();
        if (n2 <= n5 && n5 < n2 + n3) {
            this.setCaretLocation();
        }
    }

    public void setLineJustify(int n2, int n3, boolean bl2) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n2 < 0 || n2 + n3 > this.content.getLineCount()) {
            SWT.error(5);
        }
        this.renderer.setLineJustify(n2, n3, bl2);
        this.resetCache(n2, n3);
        this.redrawLines(n2, n3);
        int n4 = this.getCaretLine();
        if (n2 <= n4 && n4 < n2 + n3) {
            this.setCaretLocation();
        }
    }

    public void setLineSpacing(int n2) {
        this.checkWidget();
        if (this.lineSpacing == n2 || n2 < 0) {
            return;
        }
        this.lineSpacing = n2;
        this.setVariableLineHeight();
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    void setMargins(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        this.leftMargin = n2;
        this.topMargin = n3;
        this.rightMargin = n4;
        this.bottomMargin = n5;
        this.setCaretLocation();
    }

    void setMouseWordSelectionAnchor() {
        if (this.clickCount > 1) {
            if (this.caretOffset < this.doubleClickSelection.x) {
                this.selectionAnchor = this.doubleClickSelection.y;
            } else if (this.caretOffset > this.doubleClickSelection.y) {
                this.selectionAnchor = this.doubleClickSelection.x;
            }
        }
    }

    public void setOrientation(int n2) {
        if ((n2 & 0x6000000) == 0) {
            return;
        }
        if ((n2 & 0x4000000) != 0 && (n2 & 0x2000000) != 0) {
            return;
        }
        if ((n2 & 0x4000000) != 0 && this.isMirrored()) {
            return;
        }
        if ((n2 & 0x2000000) != 0 && !this.isMirrored()) {
            return;
        }
        if (!BidiUtil.setOrientation(this.handle, n2)) {
            return;
        }
        this.isMirrored = (n2 & 0x4000000) != 0;
        this.caretDirection = 0;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        this.keyActionMap.clear();
        this.createKeyBindings();
        super.redraw();
    }

    void setScrollBars(boolean bl2) {
        int n2;
        ScrollBar scrollBar;
        int n3 = 1;
        if ((bl2 || !this.isFixedLineHeight()) && (scrollBar = this.getVerticalBar()) != null) {
            n2 = this.renderer.getHeight();
            if (this.clientAreaHeight < n2) {
                scrollBar.setMaximum(n2);
                scrollBar.setThumb(this.clientAreaHeight);
                scrollBar.setPageIncrement(this.clientAreaHeight);
            } else if (scrollBar.getThumb() != n3 || scrollBar.getMaximum() != n3) {
                scrollBar.setValues(scrollBar.getSelection(), scrollBar.getMinimum(), n3, n3, scrollBar.getIncrement(), n3);
            }
        }
        if ((scrollBar = this.getHorizontalBar()) != null && scrollBar.getVisible()) {
            n2 = this.renderer.getWidth();
            if (this.clientAreaWidth < n2) {
                scrollBar.setMaximum(n2);
                scrollBar.setThumb(this.clientAreaWidth - this.leftMargin - this.rightMargin);
                scrollBar.setPageIncrement(this.clientAreaWidth - this.leftMargin - this.rightMargin);
            } else if (scrollBar.getThumb() != n3 || scrollBar.getMaximum() != n3) {
                scrollBar.setValues(scrollBar.getSelection(), scrollBar.getMinimum(), n3, n3, scrollBar.getIncrement(), n3);
            }
        }
    }

    public void setSelection(int n2) {
        this.setSelection(n2, n2);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        this.setSelection(point.x, point.y);
    }

    public void setSelectionBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.selectionBackground = color;
        super.redraw();
    }

    public void setSelectionForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.selectionForeground = color;
        super.redraw();
    }

    public void setSelection(int n2, int n3) {
        this.setSelectionRange(n2, n3 - n2);
        this.showSelection();
    }

    void setSelection(int n2, int n3, boolean bl2) {
        int n4 = n2 + n3;
        if (n2 > n4) {
            int n5 = n4;
            n4 = n2;
            n2 = n5;
        }
        if (this.selection.x != n2 || this.selection.y != n4 || n3 > 0 && this.selectionAnchor != this.selection.x || n3 < 0 && this.selectionAnchor != this.selection.y) {
            this.clearSelection(bl2);
            if (n3 < 0) {
                this.selectionAnchor = this.selection.y = n4;
                this.caretOffset = this.selection.x = n2;
            } else {
                this.selectionAnchor = this.selection.x = n2;
                this.caretOffset = this.selection.y = n4;
            }
            this.internalRedrawRange(this.selection.x, this.selection.y - this.selection.x);
        }
    }

    public void setSelectionRange(int n2, int n3) {
        this.checkWidget();
        int n4 = this.getCharCount();
        n2 = Math.max(0, Math.min(n2, n4));
        int n5 = n2 + n3;
        if (n5 < 0) {
            n3 = -n2;
        } else if (n5 > n4) {
            n3 = n4 - n2;
        }
        if (this.isLineDelimiter(n2) || this.isLineDelimiter(n2 + n3)) {
            SWT.error(5);
        }
        this.setSelection(n2, n3, false);
        this.setCaretLocation();
    }

    public void setStyleRange(StyleRange styleRange) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (styleRange != null) {
            if (styleRange.isUnstyled()) {
                this.setStyleRanges(styleRange.start, styleRange.length, null, null, false);
            } else {
                this.setStyleRanges(styleRange.start, 0, null, new StyleRange[]{styleRange}, false);
            }
        } else {
            this.setStyleRanges(0, 0, null, null, true);
        }
    }

    public void setStyleRanges(int n2, int n3, int[] nArray, StyleRange[] styleRangeArray) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (nArray == null || styleRangeArray == null) {
            this.setStyleRanges(n2, n3, null, null, false);
        } else {
            this.setStyleRanges(n2, n3, nArray, styleRangeArray, false);
        }
    }

    public void setStyleRanges(int[] nArray, StyleRange[] styleRangeArray) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (nArray == null || styleRangeArray == null) {
            this.setStyleRanges(0, 0, null, null, true);
        } else {
            this.setStyleRanges(0, 0, nArray, styleRangeArray, true);
        }
    }

    void setStyleRanges(int n2, int n3, int[] nArray, StyleRange[] styleRangeArray, boolean bl2) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = this.content.getCharCount();
        int n11 = n2 + n3;
        if (n2 > n11 || n2 < 0) {
            SWT.error(6);
        }
        if (styleRangeArray != null) {
            if (n11 > n10) {
                SWT.error(6);
            }
            if (nArray != null && nArray.length != styleRangeArray.length << 1) {
                SWT.error(5);
            }
            n9 = 0;
            n8 = 0;
            n7 = 0;
            while (n7 < styleRangeArray.length) {
                if (styleRangeArray[n7] == null) {
                    SWT.error(5);
                }
                if (nArray != null) {
                    n6 = nArray[n7 << 1];
                    n5 = nArray[(n7 << 1) + 1];
                } else {
                    n6 = styleRangeArray[n7].start;
                    n5 = styleRangeArray[n7].length;
                }
                if (n5 < 0) {
                    SWT.error(5);
                }
                if (n6 < 0 || n6 + n5 > n10) {
                    SWT.error(5);
                }
                if (n9 > n6) {
                    SWT.error(5);
                }
                n8 |= styleRangeArray[n7].isVariableHeight();
                n9 = n6 + n5;
                ++n7;
            }
            if (n8 != 0) {
                this.setVariableLineHeight();
            }
        }
        n9 = n2;
        n8 = n11;
        if (styleRangeArray != null && styleRangeArray.length > 0) {
            if (nArray != null) {
                n9 = nArray[0];
                n8 = nArray[nArray.length - 2] + nArray[nArray.length - 1];
            } else {
                n9 = styleRangeArray[0].start;
                n8 = styleRangeArray[styleRangeArray.length - 1].start + styleRangeArray[styleRangeArray.length - 1].length;
            }
        }
        n7 = 0;
        if (!this.isFixedLineHeight() && !bl2) {
            n6 = this.content.getLineAtOffset(Math.max(n11, n8));
            n5 = this.getPartialTopIndex();
            n4 = this.getPartialBottomIndex();
            if (n5 <= n6 && n6 <= n4) {
                n7 = this.getLinePixel(n6 + 1);
            }
        }
        if (bl2) {
            this.renderer.setStyleRanges(null, null);
        } else {
            this.renderer.updateRanges(n2, n3, n3);
        }
        if (styleRangeArray != null && styleRangeArray.length > 0) {
            this.renderer.setStyleRanges(nArray, styleRangeArray);
        }
        if (bl2) {
            this.resetCache(0, this.content.getLineCount());
            super.redraw();
        } else {
            n6 = this.content.getLineAtOffset(Math.min(n2, n9));
            n5 = this.content.getLineAtOffset(Math.max(n11, n8));
            this.resetCache(n6, n5 - n6 + 1);
            n4 = this.getPartialTopIndex();
            int n12 = this.getPartialBottomIndex();
            if (n6 <= n12 && n5 >= n4) {
                int n13;
                int n14 = 0;
                int n15 = this.clientAreaHeight;
                if (n4 <= n6 && n6 <= n12) {
                    n14 = n13 = Math.max(n14, this.getLinePixel(n6));
                    n15 -= n13;
                }
                if (n4 <= n5 && n5 <= n12) {
                    n13 = this.getLinePixel(n5 + 1);
                    if (!this.isFixedLineHeight()) {
                        this.scrollText(n7, n13);
                    }
                    n15 = n13 - n14;
                }
                super.redraw(0, n14, this.clientAreaWidth, n15, false);
            }
        }
        this.setCaretLocation();
    }

    public void setStyleRanges(StyleRange[] styleRangeArray) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (styleRangeArray == null) {
            SWT.error(4);
        }
        this.setStyleRanges(0, 0, null, styleRangeArray, true);
    }

    public void setTabs(int n2) {
        this.checkWidget();
        this.tabLength = n2;
        this.renderer.setFont(null, n2);
        if (this.caretOffset > 0) {
            this.caretOffset = 0;
            this.showCaret();
            this.clearSelection(false);
        }
        this.resetCache(0, this.content.getLineCount());
        super.redraw();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        Event event = new Event();
        event.start = 0;
        event.end = this.getCharCount();
        event.text = string;
        event.doit = true;
        this.notifyListeners(25, event);
        if (event.doit) {
            StyledTextEvent styledTextEvent = null;
            if (this.isListening(3000)) {
                styledTextEvent = new StyledTextEvent(this.content);
                styledTextEvent.start = event.start;
                styledTextEvent.end = event.start + event.text.length();
                styledTextEvent.text = this.content.getTextRange(event.start, event.end - event.start);
            }
            this.content.setText(event.text);
            this.sendModifyEvent(event);
            if (styledTextEvent != null) {
                this.notifyListeners(3000, styledTextEvent);
            }
        }
    }

    public void setTextLimit(int n2) {
        this.checkWidget();
        if (n2 == 0) {
            SWT.error(7);
        }
        this.textLimit = n2;
    }

    public void setTopIndex(int n2) {
        int n3;
        this.checkWidget();
        if (this.getCharCount() == 0) {
            return;
        }
        int n4 = this.content.getLineCount();
        if (this.isFixedLineHeight()) {
            int n5 = Math.max(1, Math.min(n4, this.getLineCountWhole()));
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > n4 - n5) {
                n2 = n4 - n5;
            }
            n3 = this.getLinePixel(n2);
        } else {
            n3 = this.getLinePixel(n2 = Math.max(0, Math.min(n4 - 1, n2)));
            n3 = n3 > 0 ? this.getAvailableHeightBellow(n3) : this.getAvailableHeightAbove(n3);
        }
        this.scrollVertical(n3, true);
    }

    public void setTopPixel(int n2) {
        this.checkWidget();
        if (this.getCharCount() == 0) {
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = this.content.getLineCount();
        int n4 = this.clientAreaHeight - this.topMargin - this.bottomMargin;
        int n5 = this.getVerticalScrollOffset();
        if (this.isFixedLineHeight()) {
            int n6 = Math.max(0, n3 * this.getVerticalIncrement() - n4);
            if (n2 > n6) {
                n2 = n6;
            }
            n2 -= n5;
        } else if ((n2 -= n5) > 0) {
            n2 = this.getAvailableHeightBellow(n2);
        }
        this.scrollVertical(n2, true);
    }

    public void setWordWrap(boolean bl2) {
        this.checkWidget();
        if ((this.getStyle() & 4) != 0) {
            return;
        }
        if (this.wordWrap == bl2) {
            return;
        }
        this.wordWrap = bl2;
        this.setVariableLineHeight();
        this.resetCache(0, this.content.getLineCount());
        this.horizontalScrollOffset = 0;
        ScrollBar scrollBar = this.getHorizontalBar();
        if (scrollBar != null) {
            scrollBar.setVisible(!this.wordWrap);
        }
        this.setScrollBars(true);
        this.setCaretLocation();
        super.redraw();
    }

    boolean showLocation(Rectangle rectangle, boolean bl2) {
        int n2 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
        int n3 = this.clientAreaHeight - this.topMargin - this.bottomMargin;
        boolean bl3 = false;
        if (rectangle.y <= this.topMargin) {
            bl3 = this.scrollVertical(rectangle.y - this.topMargin, true);
        } else if (rectangle.y + rectangle.height > n3) {
            bl3 = n3 == 0 ? this.scrollVertical(rectangle.y, true) : this.scrollVertical(rectangle.y + rectangle.height - n3, true);
        }
        if (n2 > 0) {
            int n4;
            int n5 = n4 = bl2 ? n2 / 4 : 0;
            if (rectangle.x < this.leftMargin) {
                int n6 = Math.max(this.leftMargin - rectangle.x, n4);
                int n7 = this.horizontalScrollOffset;
                bl3 = this.scrollHorizontal(-Math.min(n7, n6), true);
            } else if (rectangle.x + rectangle.width > n2) {
                int n8 = Math.max(rectangle.x + rectangle.width - n2, n4);
                int n9 = this.renderer.getWidth() - this.horizontalScrollOffset - this.clientAreaWidth;
                bl3 = this.scrollHorizontal(Math.min(n9, n8), true);
            }
        }
        return bl3;
    }

    void showCaret() {
        Rectangle rectangle = this.getBoundsAtOffset(this.caretOffset);
        if (!this.showLocation(rectangle, true)) {
            this.setCaretLocation();
        }
    }

    public void showSelection() {
        boolean bl2;
        int n2;
        int n3;
        boolean bl3;
        this.checkWidget();
        boolean bl4 = bl3 = this.caretOffset == this.selection.x;
        if (bl3) {
            n3 = this.selection.y;
            n2 = this.selection.x;
        } else {
            n3 = this.selection.x;
            n2 = this.selection.y;
        }
        Rectangle rectangle = this.getBoundsAtOffset(n3);
        Rectangle rectangle2 = this.getBoundsAtOffset(n2);
        int n4 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
        boolean bl5 = bl3 ? rectangle.x - rectangle2.x <= n4 : (bl2 = rectangle2.x - rectangle.x <= n4);
        if (bl2) {
            if (this.showLocation(rectangle, false)) {
                rectangle2 = this.getBoundsAtOffset(n2);
            }
            rectangle2.width = 0;
            this.showLocation(rectangle2, false);
        } else {
            this.showLocation(rectangle2, true);
        }
    }

    void updateSelection(int n2, int n3, int n4) {
        if (this.selection.y <= n2) {
            return;
        }
        if (this.selection.x < n2) {
            this.internalRedrawRange(this.selection.x, n2 - this.selection.x);
        }
        if (this.selection.y > n2 + n3 && this.selection.x < n2 + n3) {
            int n5 = n4 - n3;
            int n6 = n2 + n4;
            this.internalRedrawRange(n6, this.selection.y + n5 - n6);
        }
        if (this.selection.y > n2 && this.selection.x < n2 + n3) {
            this.setSelection(n2 + n4, 0, true);
        } else {
            this.setSelection(this.selection.x + n4 - n3, this.selection.y - this.selection.x, true);
        }
        this.setCaretLocation();
    }

    static class Printing
    implements Runnable {
        static final int LEFT = 0;
        static final int CENTER = 1;
        static final int RIGHT = 2;
        Printer printer;
        StyledTextRenderer printerRenderer;
        StyledTextPrintOptions printOptions;
        Rectangle clientArea;
        FontData fontData;
        Font printerFont;
        Hashtable resources;
        int tabLength;
        GC gc;
        int pageWidth;
        int startPage;
        int endPage;
        int startLine;
        int endLine;
        boolean singleLine;
        Point selection = null;
        boolean mirrored;
        int lineSpacing;
        int printMargin;

        Printing(StyledText styledText, Printer printer, StyledTextPrintOptions styledTextPrintOptions) {
            this.printer = printer;
            this.printOptions = styledTextPrintOptions;
            this.mirrored = (styledText.getStyle() & 0x8000000) != 0;
            this.singleLine = styledText.isSingleLine();
            this.startPage = 1;
            this.endPage = Integer.MAX_VALUE;
            PrinterData printerData = printer.getPrinterData();
            if (printerData.scope == 1) {
                this.startPage = printerData.startPage;
                this.endPage = printerData.endPage;
                if (this.endPage < this.startPage) {
                    int n2 = this.endPage;
                    this.endPage = this.startPage;
                    this.startPage = n2;
                }
            } else if (printerData.scope == 2) {
                this.selection = styledText.getSelectionRange();
            }
            this.printerRenderer = new StyledTextRenderer(printer, null);
            this.printerRenderer.setContent(this.copyContent(styledText.getContent()));
            this.cacheLineData(styledText);
        }

        void cacheLineData(StyledText styledText) {
            Object object;
            int n2;
            Object object2;
            StyledTextRenderer styledTextRenderer = styledText.renderer;
            styledTextRenderer.copyInto(this.printerRenderer);
            this.fontData = styledText.getFont().getFontData()[0];
            this.tabLength = styledText.tabLength;
            int n3 = this.printerRenderer.lineCount;
            if (styledText.isListening(3001) || styledText.isBidi() && styledText.isListening(3007) || styledText.isListening(3002)) {
                object2 = this.printerRenderer.content;
                int n4 = 0;
                while (n4 < n3) {
                    String string = object2.getLine(n4);
                    n2 = object2.getOffsetAtLine(n4);
                    StyledTextEvent styledTextEvent = styledText.getLineBackgroundData(n2, string);
                    if (styledTextEvent != null && styledTextEvent.lineBackground != null) {
                        this.printerRenderer.setLineBackground(n4, 1, styledTextEvent.lineBackground);
                    }
                    if (styledText.isBidi()) {
                        object = styledText.getBidiSegments(n2, string);
                        this.printerRenderer.setLineSegments(n4, 1, (int[])object);
                    }
                    if ((styledTextEvent = styledText.getLineStyleData(n2, string)) != null) {
                        this.printerRenderer.setLineIndent(n4, 1, styledTextEvent.indent);
                        this.printerRenderer.setLineAlignment(n4, 1, styledTextEvent.alignment);
                        this.printerRenderer.setLineJustify(n4, 1, styledTextEvent.justify);
                        this.printerRenderer.setLineBullet(n4, 1, styledTextEvent.bullet);
                        object = styledTextEvent.styles;
                        if (object != null && ((Object)object).length > 0) {
                            this.printerRenderer.setStyleRanges(styledTextEvent.ranges, (StyleRange[])object);
                        }
                    }
                    ++n4;
                }
            }
            object2 = styledText.getDisplay().getDPI();
            Point point = this.printer.getDPI();
            this.resources = new Hashtable();
            int n5 = 0;
            while (n5 < n3) {
                int n6;
                Color color = this.printerRenderer.getLineBackground(n5, null);
                if (color != null) {
                    if (this.printOptions.printLineBackground) {
                        Color color2 = (Color)this.resources.get(color);
                        if (color2 == null) {
                            color2 = new Color(this.printer, color.getRGB());
                            this.resources.put(color, color2);
                        }
                        this.printerRenderer.setLineBackground(n5, 1, color2);
                    } else {
                        this.printerRenderer.setLineBackground(n5, 1, null);
                    }
                }
                if ((n6 = this.printerRenderer.getLineIndent(n5, 0)) != 0) {
                    this.printerRenderer.setLineIndent(n5, 1, n6 * point.x / ((Point)object2).x);
                }
                ++n5;
            }
            StyleRange[] styleRangeArray = this.printerRenderer.styles;
            n2 = 0;
            while (n2 < this.printerRenderer.styleCount) {
                Object object3;
                Resource resource;
                StyleRange styleRange = styleRangeArray[n2];
                object = styleRange.font;
                if (styleRange.font != null) {
                    resource = (Font)this.resources.get(object);
                    if (resource == null) {
                        resource = new Font((Device)this.printer, ((Font)object).getFontData());
                        this.resources.put(object, resource);
                    }
                    styleRange.font = resource;
                }
                if ((resource = styleRange.foreground) != null) {
                    object3 = (Color)this.resources.get(resource);
                    if (this.printOptions.printTextForeground) {
                        if (object3 == null) {
                            object3 = new Color(this.printer, ((Color)resource).getRGB());
                            this.resources.put(resource, object3);
                        }
                        styleRange.foreground = object3;
                    } else {
                        styleRange.foreground = null;
                    }
                }
                if ((resource = styleRange.background) != null) {
                    object3 = (Color)this.resources.get(resource);
                    if (this.printOptions.printTextBackground) {
                        if (object3 == null) {
                            object3 = new Color(this.printer, ((Color)resource).getRGB());
                            this.resources.put(resource, object3);
                        }
                        styleRange.background = object3;
                    } else {
                        styleRange.background = null;
                    }
                }
                if (!this.printOptions.printTextFontStyle) {
                    styleRange.fontStyle = 0;
                }
                styleRange.rise = styleRange.rise * point.y / ((Point)object2).y;
                object3 = styleRange.metrics;
                if (object3 != null) {
                    ((GlyphMetrics)object3).ascent = ((GlyphMetrics)object3).ascent * point.y / ((Point)object2).y;
                    ((GlyphMetrics)object3).descent = ((GlyphMetrics)object3).descent * point.y / ((Point)object2).y;
                    ((GlyphMetrics)object3).width = ((GlyphMetrics)object3).width * point.x / ((Point)object2).x;
                }
                ++n2;
            }
            this.lineSpacing = styledText.lineSpacing * point.y / ((Point)object2).y;
            if (this.printOptions.printLineNumbers) {
                this.printMargin = 3 * point.x / ((Point)object2).x;
            }
        }

        StyledTextContent copyContent(StyledTextContent styledTextContent) {
            DefaultContent defaultContent = new DefaultContent();
            int n2 = 0;
            int n3 = 0;
            while (n3 < styledTextContent.getLineCount()) {
                int n4 = n3 < styledTextContent.getLineCount() - 1 ? styledTextContent.getOffsetAtLine(n3 + 1) : styledTextContent.getCharCount();
                defaultContent.replaceTextRange(n2, 0, styledTextContent.getTextRange(n2, n4 - n2));
                n2 = n4;
                ++n3;
            }
            return defaultContent;
        }

        void dispose() {
            if (this.gc != null) {
                this.gc.dispose();
                this.gc = null;
            }
            if (this.resources != null) {
                Enumeration enumeration = this.resources.elements();
                while (enumeration.hasMoreElements()) {
                    Resource resource = (Resource)enumeration.nextElement();
                    resource.dispose();
                }
                this.resources = null;
            }
            if (this.printerFont != null) {
                this.printerFont.dispose();
                this.printerFont = null;
            }
            if (this.printerRenderer != null) {
                this.printerRenderer.dispose();
                this.printerRenderer = null;
            }
        }

        void init() {
            Rectangle rectangle = this.printer.computeTrim(0, 0, 0, 0);
            Point point = this.printer.getDPI();
            this.printerFont = new Font((Device)this.printer, this.fontData.getName(), this.fontData.getHeight(), 0);
            this.clientArea = this.printer.getClientArea();
            this.pageWidth = this.clientArea.width;
            this.clientArea.x = point.x + rectangle.x;
            this.clientArea.y = point.y + rectangle.y;
            this.clientArea.width -= this.clientArea.x + rectangle.width;
            this.clientArea.height -= this.clientArea.y + rectangle.height;
            int n2 = this.mirrored ? 0x4000000 : 0x2000000;
            this.gc = new GC(this.printer, n2);
            this.gc.setFont(this.printerFont);
            this.printerRenderer.setFont(this.printerFont, this.tabLength);
            int n3 = this.printerRenderer.getLineHeight();
            if (this.printOptions.header != null) {
                this.clientArea.y += n3 * 2;
                this.clientArea.height -= n3 * 2;
            }
            if (this.printOptions.footer != null) {
                this.clientArea.height -= n3 * 2;
            }
            StyledTextContent styledTextContent = this.printerRenderer.content;
            this.startLine = 0;
            this.endLine = this.singleLine ? 0 : styledTextContent.getLineCount() - 1;
            PrinterData printerData = this.printer.getPrinterData();
            if (printerData.scope == 1) {
                int n4 = this.clientArea.height / n3;
                this.startLine = (this.startPage - 1) * n4;
            } else if (printerData.scope == 2) {
                this.startLine = styledTextContent.getLineAtOffset(this.selection.x);
                this.endLine = this.selection.y > 0 ? styledTextContent.getLineAtOffset(this.selection.x + this.selection.y - 1) : this.startLine - 1;
            }
        }

        void print() {
            Object object;
            int n2;
            Color color = this.gc.getBackground();
            Color color2 = this.gc.getForeground();
            int n3 = this.clientArea.y;
            int n4 = this.clientArea.x;
            int n5 = this.clientArea.width;
            int n6 = this.startPage;
            int n7 = this.clientArea.y + this.clientArea.height;
            int n8 = this.gc.getStyle() & 0x6000000;
            TextLayout textLayout = null;
            if (this.printOptions.printLineNumbers || this.printOptions.header != null || this.printOptions.footer != null) {
                textLayout = new TextLayout(this.printer);
                textLayout.setFont(this.printerFont);
            }
            if (this.printOptions.printLineNumbers) {
                n2 = this.endLine - this.startLine + 1;
                object = new StringBuffer("0");
                while ((n2 /= 10) > 0) {
                    ((StringBuffer)object).append("0");
                }
                textLayout.setText(((StringBuffer)object).toString());
                int n9 = textLayout.getBounds().width + this.printMargin;
                if (n9 > n5) {
                    n9 = n5;
                }
                n4 += n9;
                n5 -= n9;
            }
            n2 = this.startLine;
            while (n2 <= this.endLine && n6 <= this.endPage) {
                if (n3 == this.clientArea.y) {
                    this.printer.startPage();
                    this.printDecoration(n6, true, textLayout);
                }
                object = this.printerRenderer.getTextLayout(n2, n8, n5, this.lineSpacing);
                Color color3 = this.printerRenderer.getLineBackground(n2, color);
                int n10 = n3 + ((TextLayout)object).getBounds().height;
                if (n10 <= n7) {
                    this.printLine(n4, n3, this.gc, color2, color3, (TextLayout)object, textLayout, n2);
                    n3 = n10;
                } else {
                    int n11 = ((TextLayout)object).getLineCount();
                    while (n10 > n7 && n11 > 0) {
                        n10 -= ((TextLayout)object).getLineBounds((int)(--n11)).height + ((TextLayout)object).getSpacing();
                    }
                    if (n11 == 0) {
                        this.printDecoration(n6, false, textLayout);
                        this.printer.endPage();
                        if (++n6 <= this.endPage) {
                            this.printer.startPage();
                            this.printDecoration(n6, true, textLayout);
                            n3 = this.clientArea.y;
                            this.printLine(n4, n3, this.gc, color2, color3, (TextLayout)object, textLayout, n2);
                            n3 += ((TextLayout)object).getBounds().height;
                        }
                    } else {
                        int n12 = n10 - n3;
                        this.gc.setClipping(n4, n3, n5, n12);
                        this.printLine(n4, n3, this.gc, color2, color3, (TextLayout)object, textLayout, n2);
                        this.printDecoration(n6, false, textLayout);
                        this.printer.endPage();
                        if (++n6 <= this.endPage) {
                            this.printer.startPage();
                            this.printDecoration(n6, true, textLayout);
                            n3 = this.clientArea.y - n12;
                            int n13 = ((TextLayout)object).getBounds().height;
                            this.gc.setClipping(n4, this.clientArea.y, n5, n13 - n12);
                            this.printLine(n4, n3, this.gc, color2, color3, (TextLayout)object, textLayout, n2);
                            n3 += n13;
                        }
                        this.gc.setClipping((Rectangle)null);
                    }
                }
                this.printerRenderer.disposeTextLayout((TextLayout)object);
                ++n2;
            }
            if (n3 > this.clientArea.y) {
                this.printDecoration(n6, false, textLayout);
                this.printer.endPage();
            }
            if (textLayout != null) {
                textLayout.dispose();
            }
        }

        void printDecoration(int n2, boolean bl2, TextLayout textLayout) {
            String string;
            String string2 = string = bl2 ? this.printOptions.header : this.printOptions.footer;
            if (string == null) {
                return;
            }
            int n3 = 0;
            int n4 = 0;
            while (n4 < 3) {
                String string3;
                int n5 = string.indexOf("\t", n3);
                if (n5 == -1) {
                    string3 = string.substring(n3);
                    this.printDecorationSegment(string3, n4, n2, bl2, textLayout);
                    break;
                }
                string3 = string.substring(n3, n5);
                this.printDecorationSegment(string3, n4, n2, bl2, textLayout);
                n3 = n5 + "\t".length();
                ++n4;
            }
        }

        void printDecorationSegment(String string, int n2, int n3, boolean bl2, TextLayout textLayout) {
            int n4;
            int n5 = string.indexOf("<page>");
            if (n5 != -1) {
                n4 = "<page>".length();
                StringBuffer stringBuffer = new StringBuffer(string.substring(0, n5));
                stringBuffer.append(n3);
                stringBuffer.append(string.substring(n5 + n4));
                string = stringBuffer.toString();
            }
            if (string.length() > 0) {
                textLayout.setText(string);
                n4 = textLayout.getBounds().width;
                int n6 = this.printerRenderer.getLineHeight();
                int n7 = 0;
                if (n2 == 0) {
                    n7 = this.clientArea.x;
                } else if (n2 == 1) {
                    n7 = (this.pageWidth - n4) / 2;
                } else if (n2 == 2) {
                    n7 = this.clientArea.x + this.clientArea.width - n4;
                }
                int n8 = bl2 ? this.clientArea.y - n6 * 2 : this.clientArea.y + this.clientArea.height + n6;
                textLayout.draw(this.gc, n7, n8);
            }
        }

        void printLine(int n2, int n3, GC gC, Color color, Color color2, TextLayout textLayout, TextLayout textLayout2, int n4) {
            Object object;
            if (color2 != null) {
                object = textLayout.getBounds();
                gC.setBackground(color2);
                gC.fillRectangle(n2, n3, ((Rectangle)object).width, ((Rectangle)object).height);
            }
            if (this.printOptions.printLineNumbers) {
                object = textLayout.getLineMetrics(0);
                textLayout2.setAscent(((FontMetrics)object).getAscent() + ((FontMetrics)object).getDescent());
                textLayout2.setDescent(((FontMetrics)object).getDescent());
                textLayout2.setText(String.valueOf(n4));
                int n5 = n2 - this.printMargin - textLayout2.getBounds().width;
                textLayout2.draw(gC, n5, n3);
                textLayout2.setAscent(-1);
                textLayout2.setDescent(-1);
            }
            gC.setForeground(color);
            textLayout.draw(gC, n2, n3);
        }

        public void run() {
            String string = this.printOptions.jobName;
            if (string == null) {
                string = "Printing";
            }
            if (this.printer.startJob(string)) {
                this.init();
                this.print();
                this.dispose();
                this.printer.endJob();
            }
        }
    }

    class RTFWriter
    extends TextWriter {
        static final int DEFAULT_FOREGROUND = 0;
        static final int DEFAULT_BACKGROUND = 1;
        Vector colorTable = new Vector();
        Vector fontTable = new Vector();
        boolean WriteUnicode;

        public RTFWriter(int n2, int n3) {
            super(n2, n3);
            this.colorTable.addElement(StyledText.this.getForeground());
            this.colorTable.addElement(StyledText.this.getBackground());
            this.fontTable.addElement(StyledText.this.getFont());
            this.setUnicode();
        }

        public void close() {
            if (!this.isClosed()) {
                this.writeHeader();
                this.write("\n}}\u0000");
                super.close();
            }
        }

        int getColorIndex(Color color, int n2) {
            if (color == null) {
                return n2;
            }
            int n3 = this.colorTable.indexOf(color);
            if (n3 == -1) {
                n3 = this.colorTable.size();
                this.colorTable.addElement(color);
            }
            return n3;
        }

        int getFontIndex(Font font) {
            int n2 = this.fontTable.indexOf(font);
            if (n2 == -1) {
                n2 = this.fontTable.size();
                this.fontTable.addElement(font);
            }
            return n2;
        }

        void setUnicode() {
            int n2;
            String string = System.getProperty("os.name").toLowerCase();
            String string2 = System.getProperty("os.version");
            int n3 = 0;
            if (string.startsWith("windows nt") && string2 != null && (n2 = string2.indexOf(46)) != -1) {
                string2 = string2.substring(0, n2);
                try {
                    n3 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.WriteUnicode = !string.startsWith("windows 95") && !string.startsWith("windows 98") && !string.startsWith("windows me") && (!string.startsWith("windows nt") || n3 > 4);
        }

        void write(String string, int n2, int n3) {
            int n4 = n2;
            while (n4 < n3) {
                char c2 = string.charAt(n4);
                if (c2 > '\u00ff' && this.WriteUnicode) {
                    if (n4 > n2) {
                        this.write(string.substring(n2, n4));
                    }
                    this.write("\\u");
                    this.write(Integer.toString((short)c2));
                    this.write(' ');
                    n2 = n4 + 1;
                } else if (c2 == '}' || c2 == '{' || c2 == '\\') {
                    if (n4 > n2) {
                        this.write(string.substring(n2, n4));
                    }
                    this.write('\\');
                    this.write(c2);
                    n2 = n4 + 1;
                }
                ++n4;
            }
            if (n2 < n3) {
                this.write(string.substring(n2, n3));
            }
        }

        void writeHeader() {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            FontData fontData = StyledText.this.getFont().getFontData()[0];
            stringBuffer.append("{\\rtf1\\ansi");
            String string = System.getProperty("file.encoding").toLowerCase();
            if (string.startsWith("cp") || string.startsWith("ms")) {
                string = string.substring(2, string.length());
                stringBuffer.append("\\ansicpg");
                stringBuffer.append(string);
            }
            stringBuffer.append("\\uc0\\deff0{\\fonttbl{\\f0\\fnil ");
            stringBuffer.append(fontData.getName());
            stringBuffer.append(";");
            int n2 = 1;
            while (n2 < this.fontTable.size()) {
                stringBuffer.append("\\f");
                stringBuffer.append(n2);
                stringBuffer.append(" ");
                object = ((Font)this.fontTable.elementAt(n2)).getFontData()[0];
                stringBuffer.append(((FontData)object).getName());
                stringBuffer.append(";");
                ++n2;
            }
            stringBuffer.append("}}\n{\\colortbl");
            n2 = 0;
            while (n2 < this.colorTable.size()) {
                object = (Color)this.colorTable.elementAt(n2);
                stringBuffer.append("\\red");
                stringBuffer.append(((Color)object).getRed());
                stringBuffer.append("\\green");
                stringBuffer.append(((Color)object).getGreen());
                stringBuffer.append("\\blue");
                stringBuffer.append(((Color)object).getBlue());
                stringBuffer.append(";");
                ++n2;
            }
            stringBuffer.append("}\n{\\f0\\fs");
            stringBuffer.append(fontData.getHeight() * 2);
            stringBuffer.append(" ");
            this.write(stringBuffer.toString(), 0);
        }

        public void writeLine(String string, int n2) {
            StyleRange[] styleRangeArray;
            int[] nArray;
            boolean bl2;
            int n3;
            int n4;
            if (this.isClosed()) {
                SWT.error(39);
            }
            int n5 = StyledText.this.content.getLineAtOffset(n2);
            StyledTextEvent styledTextEvent = StyledText.this.getLineStyleData(n2, string);
            if (styledTextEvent != null) {
                n4 = styledTextEvent.alignment;
                n3 = styledTextEvent.indent;
                bl2 = styledTextEvent.justify;
                nArray = styledTextEvent.ranges;
                styleRangeArray = styledTextEvent.styles;
            } else {
                n4 = StyledText.this.renderer.getLineAlignment(n5, StyledText.this.alignment);
                n3 = StyledText.this.renderer.getLineIndent(n5, StyledText.this.indent);
                bl2 = StyledText.this.renderer.getLineJustify(n5, StyledText.this.justify);
                nArray = StyledText.this.renderer.getRanges(n2, string.length());
                styleRangeArray = StyledText.this.renderer.getStyleRanges(n2, string.length(), false);
            }
            if (styleRangeArray == null) {
                styleRangeArray = new StyleRange[]{};
            }
            Color color = StyledText.this.renderer.getLineBackground(n5, null);
            styledTextEvent = StyledText.this.getLineBackgroundData(n2, string);
            if (styledTextEvent != null && styledTextEvent.lineBackground != null) {
                color = styledTextEvent.lineBackground;
            }
            this.writeStyledLine(string, n2, nArray, styleRangeArray, color, n3, n4, bl2);
        }

        public void writeLineDelimiter(String string) {
            if (this.isClosed()) {
                SWT.error(39);
            }
            this.write(string, 0, string.length());
            this.write("\\par ");
        }

        void writeStyledLine(String string, int n2, int[] nArray, StyleRange[] styleRangeArray, Color color, int n3, int n4, boolean bl2) {
            int n5 = string.length();
            int n6 = this.getStart();
            int n7 = n6 - n2;
            if (n7 >= n5) {
                return;
            }
            int n8 = Math.max(0, n7);
            this.write("\\fi");
            this.write(n3);
            switch (n4) {
                case 16384: {
                    this.write("\\ql");
                    break;
                }
                case 0x1000000: {
                    this.write("\\qc");
                    break;
                }
                case 131072: {
                    this.write("\\qr");
                }
            }
            if (bl2) {
                this.write("\\qj");
            }
            this.write(" ");
            if (color != null) {
                this.write("{\\highlight");
                this.write(this.getColorIndex(color, 1));
                this.write(" ");
            }
            int n9 = n6 + super.getCharCount();
            int n10 = Math.min(n5, n9 - n2);
            int n11 = 0;
            while (n11 < styleRangeArray.length) {
                int n12;
                int n13;
                StyleRange styleRange = styleRangeArray[n11];
                if (nArray != null) {
                    n13 = nArray[n11 << 1] - n2;
                    n12 = n13 + nArray[(n11 << 1) + 1];
                } else {
                    n13 = styleRange.start - n2;
                    n12 = n13 + styleRange.length;
                }
                if (n12 >= n7) {
                    int n14;
                    Font font;
                    if (n13 >= n10) break;
                    if (n8 < n13) {
                        this.write(string, n8, n13);
                        n8 = n13;
                    }
                    this.write("{\\cf");
                    this.write(this.getColorIndex(styleRange.foreground, 0));
                    int n15 = this.getColorIndex(styleRange.background, 1);
                    if (n15 != 1) {
                        this.write("\\highlight");
                        this.write(n15);
                    }
                    if ((font = styleRange.font) != null) {
                        n14 = this.getFontIndex(font);
                        this.write("\\f");
                        this.write(n14);
                        FontData fontData = font.getFontData()[0];
                        this.write("\\fs");
                        this.write(fontData.getHeight() * 2);
                    } else {
                        if ((styleRange.fontStyle & 1) != 0) {
                            this.write("\\b");
                        }
                        if ((styleRange.fontStyle & 2) != 0) {
                            this.write("\\i");
                        }
                    }
                    if (styleRange.underline) {
                        this.write("\\ul");
                    }
                    if (styleRange.strikeout) {
                        this.write("\\strike");
                    }
                    this.write(" ");
                    n14 = Math.min(n12, n10);
                    n14 = Math.max(n14, n8);
                    this.write(string, n8, n14);
                    if (font == null) {
                        if ((styleRange.fontStyle & 1) != 0) {
                            this.write("\\b0");
                        }
                        if ((styleRange.fontStyle & 2) != 0) {
                            this.write("\\i0");
                        }
                    }
                    if (styleRange.underline) {
                        this.write("\\ul0");
                    }
                    if (styleRange.strikeout) {
                        this.write("\\strike0");
                    }
                    this.write("}");
                    n8 = n14;
                }
                ++n11;
            }
            if (n8 < n10) {
                this.write(string, n8, n10);
            }
            if (color != null) {
                this.write("}");
            }
        }
    }

    class TextWriter {
        private StringBuffer buffer;
        private int startOffset;
        private int endOffset;
        private boolean isClosed = false;

        public TextWriter(int n2, int n3) {
            this.buffer = new StringBuffer(n3);
            this.startOffset = n2;
            this.endOffset = n2 + n3;
        }

        public void close() {
            if (!this.isClosed) {
                this.isClosed = true;
            }
        }

        public int getCharCount() {
            return this.endOffset - this.startOffset;
        }

        public int getStart() {
            return this.startOffset;
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public String toString() {
            return this.buffer.toString();
        }

        void write(String string) {
            this.buffer.append(string);
        }

        void write(String string, int n2) {
            if (n2 < 0 || n2 > this.buffer.length()) {
                return;
            }
            this.buffer.insert(n2, string);
        }

        void write(int n2) {
            this.buffer.append(n2);
        }

        void write(char c2) {
            this.buffer.append(c2);
        }

        public void writeLine(String string, int n2) {
            int n3;
            int n4;
            int n5;
            if (this.isClosed) {
                SWT.error(39);
            }
            if ((n5 = this.startOffset - n2) >= (n4 = string.length())) {
                return;
            }
            int n6 = n5 > 0 ? n5 : 0;
            if (n6 < (n3 = Math.min(n4, this.endOffset - n2))) {
                this.write(string.substring(n6, n3));
            }
        }

        public void writeLineDelimiter(String string) {
            if (this.isClosed) {
                SWT.error(39);
            }
            this.write(string);
        }
    }
}

