/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;

class ScrolledCompositeLayout
extends Layout {
    boolean inLayout = false;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;

    ScrolledCompositeLayout() {
    }

    protected Point computeSize(Composite composite, int n2, int n3, boolean bl2) {
        ScrolledComposite scrolledComposite = (ScrolledComposite)composite;
        Point point = new Point(64, 64);
        if (scrolledComposite.content != null) {
            Point point2 = scrolledComposite.content.computeSize(n2, n3, bl2);
            Point point3 = scrolledComposite.content.getSize();
            point.x = scrolledComposite.getExpandHorizontal() ? point2.x : point3.x;
            point.y = scrolledComposite.getExpandVertical() ? point2.y : point3.y;
        }
        point.x = Math.max(point.x, scrolledComposite.minWidth);
        point.y = Math.max(point.y, scrolledComposite.minHeight);
        if (n2 != -1) {
            point.x = n2;
        }
        if (n3 != -1) {
            point.y = n3;
        }
        return point;
    }

    protected boolean flushCache(Control control) {
        return true;
    }

    protected void layout(Composite composite, boolean bl2) {
        int n2;
        int n3;
        if (this.inLayout) {
            return;
        }
        ScrolledComposite scrolledComposite = (ScrolledComposite)composite;
        if (scrolledComposite.content == null) {
            return;
        }
        ScrollBar scrollBar = scrolledComposite.getHorizontalBar();
        ScrollBar scrollBar2 = scrolledComposite.getVerticalBar();
        if (scrollBar != null && scrollBar.getSize().y >= scrolledComposite.getSize().y) {
            return;
        }
        if (scrollBar2 != null && scrollBar2.getSize().x >= scrolledComposite.getSize().x) {
            return;
        }
        this.inLayout = true;
        Rectangle rectangle = scrolledComposite.content.getBounds();
        if (!scrolledComposite.alwaysShowScroll) {
            boolean bl3 = scrolledComposite.needHScroll(rectangle, false);
            n3 = scrolledComposite.needVScroll(rectangle, bl3);
            if (!bl3 && n3 != 0) {
                bl3 = scrolledComposite.needHScroll(rectangle, n3 != 0);
            }
            if (scrollBar != null) {
                scrollBar.setVisible(bl3);
            }
            if (scrollBar2 != null) {
                scrollBar2.setVisible(n3 != 0);
            }
        }
        Rectangle rectangle2 = scrolledComposite.getClientArea();
        if (scrolledComposite.expandHorizontal) {
            rectangle.width = Math.max(scrolledComposite.minWidth, rectangle2.width);
        }
        if (scrolledComposite.expandVertical) {
            rectangle.height = Math.max(scrolledComposite.minHeight, rectangle2.height);
        }
        if (scrollBar != null) {
            scrollBar.setMaximum(rectangle.width);
            scrollBar.setThumb(Math.min(rectangle.width, rectangle2.width));
            n3 = rectangle.width - rectangle2.width;
            n2 = scrollBar.getSelection();
            if (n2 >= n3) {
                if (n3 <= 0) {
                    n2 = 0;
                    scrollBar.setSelection(0);
                }
                rectangle.x = -n2;
            }
        }
        if (scrollBar2 != null) {
            scrollBar2.setMaximum(rectangle.height);
            scrollBar2.setThumb(Math.min(rectangle.height, rectangle2.height));
            n3 = rectangle.height - rectangle2.height;
            n2 = scrollBar2.getSelection();
            if (n2 >= n3) {
                if (n3 <= 0) {
                    n2 = 0;
                    scrollBar2.setSelection(0);
                }
                rectangle.y = -n2;
            }
        }
        scrolledComposite.content.setBounds(rectangle);
        this.inLayout = false;
    }
}

