/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.core.internal.runtime.CommonMessages;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public final class SafeRunner {
    public static void run(ISafeRunnable code) {
        Assert.isNotNull(code);
        try {
            code.run();
        }
        catch (Exception e2) {
            SafeRunner.handleException(code, e2);
        }
        catch (LinkageError e3) {
            SafeRunner.handleException(code, e3);
        }
        catch (AssertionError e4) {
            SafeRunner.handleException(code, (Throwable)((Object)e4));
        }
    }

    private static void handleException(ISafeRunnable code, Throwable e2) {
        if (!(e2 instanceof OperationCanceledException)) {
            Status status;
            Activator activator = Activator.getDefault();
            String pluginId = null;
            if (activator != null) {
                pluginId = activator.getBundleId(code);
            }
            if (pluginId == null) {
                pluginId = "org.eclipse.equinox.common";
            }
            String message = NLS.bind((String)CommonMessages.meta_pluginProblems, (Object)pluginId);
            if (e2 instanceof CoreException) {
                status = new MultiStatus(pluginId, 2, message, e2);
                status.merge(((CoreException)e2).getStatus());
            } else {
                status = new Status(4, pluginId, 2, message, e2);
            }
            if (!RuntimeLog.isEmpty()) {
                RuntimeLog.log(status);
            } else {
                e2.printStackTrace();
            }
        }
        code.handleException(e2);
    }
}

