/*
 * Decompiled with CFR 0.152.
 */
package com.crack.me.active.ui.replace;

import com.crack.me.active.ui.Loggable;
import com.crack.me.active.ui.replace.JarReplacer;
import com.crack.me.active.ui.replace.PublicKeyBytesReplacer;
import com.crack.me.active.ui.replace.SignatureVerifierReplacer;
import com.crack.me.active.ui.replace.SpecialSignatureVerifierReplacer;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeReplacerHandler {
    private Loggable logger = null;
    private List<JarReplacer> replacers = new ArrayList<JarReplacer>(5);

    public MeReplacerHandler(Loggable logger) {
        this.logger = logger;
        this.initReplacers();
    }

    public void initReplacers() {
        this.replacers.clear();
        this.addReplacer(new SignatureVerifierReplacer(this.logger));
        this.addReplacer(new PublicKeyBytesReplacer(this.logger));
        this.addReplacer(new SpecialSignatureVerifierReplacer(this.logger));
    }

    public void addReplacer(JarReplacer replacer) {
        if (replacer != null) {
            this.replacers.add(replacer);
        }
    }

    public boolean replace(File fileFolder) {
        List<File> allFiles = this.findJarFiles(fileFolder);
        return this.replace(allFiles);
    }

    private boolean replace(List<File> allFiles) {
        if (this.replacers == null || allFiles == null) {
            return false;
        }
        boolean success = true;
        for (JarReplacer rp : this.replacers) {
            this.logger.log(rp.getProcessInfo());
            rp.setJarFileList(allFiles);
            success &= rp.replace();
            this.logger.log("Done.");
        }
        return success;
    }

    public List<File> findJarFiles(File file) {
        this.logger.log("find files in [" + file.getAbsolutePath() + "]");
        return this.getAllFiles(file, JarReplacer.jarFileFilter);
    }

    public List<File> getAllFiles(File FileTemp, FileFilter fileFilter) {
        ArrayList<File> allFiles = new ArrayList<File>();
        if (FileTemp != null) {
            if (!FileTemp.isDirectory()) {
                allFiles.add(FileTemp);
            } else {
                File[] files = FileTemp.listFiles(fileFilter);
                if (files != null && files.length != 0) {
                    File[] fileArray = files;
                    int n2 = files.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        File file = fileArray[n3];
                        if (file != null) {
                            if (file.isDirectory()) {
                                List<File> tmpFiles = this.getAllFiles(file, fileFilter);
                                if (tmpFiles != null) {
                                    allFiles.addAll(tmpFiles);
                                }
                            } else {
                                allFiles.add(file);
                            }
                        }
                        ++n3;
                    }
                }
            }
        }
        return allFiles;
    }
}

