/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.util;

import com.googlecode.dex2jar.Field;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.util.ASMifierAnnotationV;
import com.googlecode.dex2jar.util.ASMifierCodeV;
import com.googlecode.dex2jar.util.ArrayOut;
import com.googlecode.dex2jar.util.Escape;
import com.googlecode.dex2jar.util.Utf8Utils;
import com.googlecode.dex2jar.visitors.DexAnnotationAble;
import com.googlecode.dex2jar.visitors.DexAnnotationVisitor;
import com.googlecode.dex2jar.visitors.DexClassVisitor;
import com.googlecode.dex2jar.visitors.DexCodeVisitor;
import com.googlecode.dex2jar.visitors.DexFieldVisitor;
import com.googlecode.dex2jar.visitors.DexMethodVisitor;
import java.util.ArrayList;
import java.util.List;

public class ASMifierClassV
implements DexClassVisitor {
    ArrayOut out = new ArrayOut();
    List<ArrayOut> methodOuts = new ArrayList<ArrayOut>();
    List<ArrayOut> fieldOuts = new ArrayList<ArrayOut>();
    int fCount = 0;
    int mCount = 0;

    public ASMifierClassV(String pkgName, String javaClassName, int access_flags, String className, String superClass, String[] interfaceNames) {
        this.out.s("package %s;", pkgName);
        this.out.s("import com.googlecode.dex2jar.*;");
        this.out.s("import com.googlecode.dex2jar.visitors.*;");
        this.out.s("import static com.googlecode.dex2jar.DexOpcodes.*;");
        this.out.s("import static com.googlecode.dex2jar.util.Hex.*;");
        this.out.s("public class %s {", javaClassName);
        this.out.push();
        this.out.s("public static void accept(DexFileVisitor v) {");
        this.out.push();
        this.out.s("DexClassVisitor cv=v.visit(%s,%s,%s,%s);", Escape.classAcc(access_flags), Escape.v(className), Escape.v(superClass), Escape.v(interfaceNames));
        this.out.s("if(cv!=null) {");
        this.out.push();
        this.out.s("accept(cv);");
        this.out.pop();
        this.out.s("}");
        this.out.pop();
        this.out.s("}");
        this.out.s("public static void accept(DexClassVisitor cv) {");
        this.out.push();
    }

    @Override
    public DexAnnotationVisitor visitAnnotation(String name, boolean visible) {
        return new ASMifierAnnotationV("cv", this.out, name, visible);
    }

    @Override
    public void visitSource(String file) {
        this.out.s("cv.visitSource(\"%s\");", Utf8Utils.escapeString(file));
    }

    @Override
    public DexFieldVisitor visitField(int accessFlags, Field field, Object value) {
        String fieldName = String.format("f%03d_%s", this.fCount++, field.getName());
        this.out.s("%s(cv);", fieldName);
        final ArrayOut f = new ArrayOut();
        this.fieldOuts.add(f);
        f.s("public static void %s(DexClassVisitor cv) {", fieldName);
        f.push();
        f.s("DexFieldVisitor fv=cv.visitField(%s, %s, %s);", Escape.fieldAcc(accessFlags), Escape.v(field), Escape.v(value));
        f.s("if(fv != null) {");
        f.push();
        return new DexFieldVisitor(){

            @Override
            public DexAnnotationVisitor visitAnnotation(String name, boolean visible) {
                return new ASMifierAnnotationV("fv", f, name, visible);
            }

            @Override
            public void visitEnd() {
                f.s("fv.visitEnd();");
                f.pop();
                f.s("}");
                f.pop();
                f.s("}");
            }
        };
    }

    @Override
    public DexMethodVisitor visitMethod(int accessFlags, Method method) {
        String methodName = String.format("m%03d_%s", this.mCount++, method.getName().replace('<', '_').replace('>', '_'));
        this.out.s("%s(cv);", methodName);
        final ArrayOut m = new ArrayOut();
        this.methodOuts.add(m);
        m.s("public static void %s(DexClassVisitor cv) {", methodName);
        m.push();
        m.s("DexMethodVisitor mv=cv.visitMethod(%s, %s);", Escape.methodAcc(accessFlags), Escape.v(method));
        m.s("if(mv != null) {");
        m.push();
        return new DexMethodVisitor(){

            @Override
            public DexAnnotationVisitor visitAnnotation(String name, boolean visible) {
                return new ASMifierAnnotationV("mv", m, name, visible);
            }

            @Override
            public DexAnnotationAble visitParameterAnnotation(final int index) {
                m.s("DexAnnotationAble pv%02d = mv.visitParameterAnnotation(%s);", index, index);
                return new DexAnnotationAble(){

                    @Override
                    public DexAnnotationVisitor visitAnnotation(String name, boolean visible) {
                        return new ASMifierAnnotationV(String.format("pv%02d", index), m, name, visible);
                    }
                };
            }

            @Override
            public DexCodeVisitor visitCode() {
                m.s("DexCodeVisitor code=mv.visitCode();");
                m.s("if(code != null) {");
                m.push();
                return new ASMifierCodeV(m){

                    @Override
                    public void visitEnd() {
                        super.visitEnd();
                        this.m.pop();
                        this.m.s("}");
                    }
                };
            }

            @Override
            public void visitEnd() {
                m.s("mv.visitEnd();");
                m.pop();
                m.s("}");
                m.pop();
                m.s("}");
            }
        };
    }

    @Override
    public void visitEnd() {
        this.out.s("cv.visitEnd();");
        this.out.pop();
        this.out.s("}");
        for (ArrayOut o : this.fieldOuts) {
            this.out.array.addAll(o.array);
            for (int i : o.is) {
                this.out.is.add(this.out.i + i);
            }
        }
        this.fieldOuts = null;
        for (ArrayOut o : this.methodOuts) {
            this.out.array.addAll(o.array);
            for (int i : o.is) {
                this.out.is.add(this.out.i + i);
            }
        }
        this.methodOuts = null;
        this.out.pop();
        this.out.s("}");
    }
}

