/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.reader;

import com.googlecode.dex2jar.Field;
import com.googlecode.dex2jar.reader.Annotation;
import com.googlecode.dex2jar.reader.Constant;
import com.googlecode.dex2jar.reader.DexFileReader;
import com.googlecode.dex2jar.reader.io.DataIn;
import com.googlecode.dex2jar.visitors.DexAnnotationAble;
import com.googlecode.dex2jar.visitors.DexAnnotationVisitor;

class DexAnnotationReader {
    private static final int VISIBILITY_BUILD = 0;

    DexAnnotationReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void accept(DexFileReader dex, DataIn in, DexAnnotationAble daa) {
        int size = in.readUIntx();
        for (int j = 0; j < size; ++j) {
            int annotation_off = in.readUIntx();
            in.pushMove(annotation_off);
            try {
                int visible_i = in.readUByte();
                int type_idx = (int)in.readULeb128();
                String type = dex.getType(type_idx);
                DexAnnotationVisitor dav = daa.visitAnnotation(type, visible_i != 0);
                if (dav == null) continue;
                long sizex = in.readULeb128();
                int k = 0;
                while ((long)k < sizex) {
                    int name_idx = (int)in.readULeb128();
                    String name = dex.getString(name_idx);
                    Object o = Constant.ReadConstant(dex, in);
                    DexAnnotationReader.doAccept(dav, name, o);
                    ++k;
                }
                dav.visitEnd();
                continue;
            }
            finally {
                in.pop();
            }
        }
    }

    private static void doAccept(DexAnnotationVisitor dav, String name, Object o) {
        if (o instanceof Object[]) {
            DexAnnotationVisitor arrayVisitor = dav.visitArray(name);
            if (arrayVisitor != null) {
                Object[] array;
                for (Object e : array = (Object[])o) {
                    DexAnnotationReader.doAccept(arrayVisitor, null, e);
                }
                arrayVisitor.visitEnd();
            }
        } else if (o instanceof Annotation) {
            Annotation ann = (Annotation)o;
            DexAnnotationVisitor av = dav.visitAnnotation(name, ann.type);
            if (av != null) {
                for (Annotation.Item item : ann.items) {
                    DexAnnotationReader.doAccept(av, item.name, item.value);
                }
                av.visitEnd();
            }
        } else if (o instanceof Field) {
            Field f = (Field)o;
            dav.visitEnum(name, f.getType(), f.getName());
        } else {
            dav.visit(name, o);
        }
    }
}

