/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Local;
import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.ValueBox;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.ts.Cfg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LiveAnalyze {
    protected IrMethod method;
    protected int localSize;

    private static void doAddUsed(Phi r, Set<Phi> regs) {
        if (r.used && !regs.contains(r)) {
            regs.add(r);
            for (Phi p : r.sets) {
                p.used = true;
                LiveAnalyze.doAddUsed(p, regs);
            }
        }
    }

    private static Phi trim(Phi phi) {
        while (phi.tag != null) {
            phi = phi.tag;
        }
        return phi;
    }

    public LiveAnalyze(IrMethod method) {
        this.method = method;
        this.localSize = method.locals.size();
    }

    public List<Phi> analyze() {
        this.init();
        return this.analyze0();
    }

    protected List<Phi> analyze0() {
        final ArrayList<Phi> phis = new ArrayList<Phi>();
        Cfg.createCfgForLiveAnalyze(this.method);
        Cfg.Forward(this.method, new Cfg.FrameVisitor<Phi[]>(){

            @Override
            public Phi[] exec(Stmt stmt) {
                Phi[] frame = (Phi[])stmt._ls_forward_frame;
                if (frame == null) {
                    stmt._ls_forward_frame = frame = new Phi[LiveAnalyze.this.localSize];
                }
                Phi[] result = frame;
                switch (stmt.et) {
                    case E0: {
                        break;
                    }
                    case E1: {
                        this.use(((Stmt.E1Stmt)stmt).op, result);
                        break;
                    }
                    case E2: {
                        Stmt.E2Stmt e2 = (Stmt.E2Stmt)stmt;
                        if ((e2.st == Stmt.ST.ASSIGN || e2.st == Stmt.ST.IDENTITY) && ((AssignStmt)stmt).op1.value.vt == Value.VT.LOCAL) {
                            Local local = (Local)((AssignStmt)stmt).op1.value;
                            this.use(e2.op2, result);
                            result = new Phi[LiveAnalyze.this.localSize];
                            System.arraycopy(frame, 0, result, 0, LiveAnalyze.this.localSize);
                            Phi phi = new Phi();
                            phis.add(phi);
                            result[local._ls_index] = phi;
                            break;
                        }
                        this.use(e2.op1, result);
                        this.use(e2.op2, result);
                        break;
                    }
                    case En: {
                        Stmt.EnStmt en = (Stmt.EnStmt)stmt;
                        for (ValueBox vb : en.ops) {
                            this.use(vb, result);
                        }
                        break;
                    }
                }
                return result;
            }

            @Override
            public void merge(Phi[] frame, Stmt dist) {
                Phi[] distFrame = (Phi[])dist._ls_forward_frame;
                if (distFrame == null) {
                    dist._ls_forward_frame = distFrame = new Phi[LiveAnalyze.this.localSize];
                }
                for (int i = 0; i < LiveAnalyze.this.localSize; ++i) {
                    Phi srcPhi = frame[i];
                    if (srcPhi == null) continue;
                    Phi distPhi = distFrame[i];
                    if (distPhi == null) {
                        if (dist._cfg_visited) continue;
                        distPhi = new Phi();
                        phis.add(distPhi);
                        distFrame[i] = distPhi;
                        distPhi.sets.add(srcPhi);
                        continue;
                    }
                    distPhi.sets.add(srcPhi);
                }
            }

            private void use(ValueBox op, Phi[] frame) {
                if (op == null) {
                    return;
                }
                Value v = op.value;
                switch (v.et) {
                    case E0: {
                        if (v.vt != Value.VT.LOCAL) break;
                        Local local = (Local)v;
                        frame[local._ls_index].used = true;
                        frame[local._ls_index].local = local;
                        break;
                    }
                    case E1: {
                        this.use(((Value.E1Expr)v).op, frame);
                        break;
                    }
                    case E2: {
                        Value.E2Expr e2 = (Value.E2Expr)v;
                        this.use(e2.op1, frame);
                        this.use(e2.op2, frame);
                        break;
                    }
                    case En: {
                        Value.EnExpr en = (Value.EnExpr)v;
                        for (ValueBox vb : en.ops) {
                            this.use(vb, frame);
                        }
                        break;
                    }
                }
            }
        });
        HashSet<Phi> used = new HashSet<Phi>(phis.size() / 2);
        for (Phi reg : phis) {
            LiveAnalyze.doAddUsed(reg, used);
        }
        for (Phi reg : used) {
            Phi a = LiveAnalyze.trim(reg);
            if (a != reg && reg.local != null) {
                a.local = reg.local;
            }
            if (reg.sets.size() <= 0) continue;
            for (Phi r : reg.sets) {
                Phi b = LiveAnalyze.trim(r);
                if (a == b) continue;
                b.tag = a;
                if (b.local == null) continue;
                a.local = b.local;
            }
        }
        for (Stmt p = this.method.stmts.getFirst(); p != null; p = p.getNext()) {
            Phi[] frame = (Phi[])p._ls_forward_frame;
            if (frame == null) continue;
            for (int i = 0; i < frame.length; ++i) {
                Phi r = frame[i];
                if (r == null) continue;
                frame[i] = r.used ? LiveAnalyze.trim(r) : null;
            }
        }
        phis.clear();
        for (Phi r : used) {
            if (!r.used || r.tag != null) continue;
            r.sets.clear();
            phis.add(r);
        }
        used.clear();
        ArrayList<Phi> nPhis = new ArrayList<Phi>(phis);
        Collections.sort(nPhis, new Comparator<Phi>(){

            @Override
            public int compare(Phi o1, Phi o2) {
                return o1.local._ls_index - o2.local._ls_index;
            }
        });
        return nPhis;
    }

    protected void init() {
        int index = 0;
        for (Local local : this.method.locals) {
            local._ls_index = index++;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Stmt stmt = this.method.stmts.getFirst(); stmt != null; stmt = stmt.getNext()) {
            Phi[] frame = (Phi[])stmt._ls_forward_frame;
            if (frame != null) {
                for (Phi p : frame) {
                    if (p == null) {
                        sb.append('.');
                        continue;
                    }
                    if (p.used) {
                        sb.append('x');
                        continue;
                    }
                    sb.append('?');
                }
                sb.append(" | ");
            }
            sb.append(stmt.toString()).append('\n');
        }
        return sb.toString();
    }

    public static class Phi {
        public Local local;
        public Phi tag;
        public boolean used;
        public Set<Phi> sets = new HashSet<Phi>(3);

        public String toString() {
            if (this.tag != null) {
                return this.tag.toString();
            }
            if (this.local != null) {
                return this.local.toString();
            }
            return "?";
        }
    }
}

