/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.stmt;

import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.ValueBox;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import java.util.Map;

public class TableSwitchStmt
extends Stmt.E1Stmt {
    public LabelStmt defaultTarget;
    public int lowIndex;
    public int highIndex;
    public LabelStmt[] targets;

    public TableSwitchStmt() {
        super(Stmt.ST.TABLE_SWITCH, (ValueBox)null);
    }

    public TableSwitchStmt(Value key, int lowIndex, int highIndex, LabelStmt[] targets, LabelStmt defaultTarget) {
        super(Stmt.ST.TABLE_SWITCH, new ValueBox(key));
        this.lowIndex = lowIndex;
        this.highIndex = highIndex;
        this.targets = targets;
        this.defaultTarget = defaultTarget;
    }

    @Override
    public Stmt clone(Map<LabelStmt, LabelStmt> map) {
        LabelStmt[] nTargets = new LabelStmt[this.targets.length];
        for (int i = 0; i < nTargets.length; ++i) {
            nTargets[i] = this.cloneLabel(map, this.targets[i]);
        }
        return new TableSwitchStmt(this.op.value.clone(), this.lowIndex, this.highIndex, nTargets, this.cloneLabel(map, this.defaultTarget));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("switch(").append(this.op).append(") {");
        for (int i = 0; i < this.targets.length; ++i) {
            sb.append("\n case ").append(this.lowIndex + i).append(": GOTO ").append(this.targets[i].getDisplayName()).append(";");
        }
        sb.append("\n default : GOTO ").append(this.defaultTarget.getDisplayName()).append(";");
        sb.append("\n}");
        return sb.toString();
    }
}

